/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesImpl;

public class PortalPreferencesImpl
implements PortalPreferences {
    private static final String _RANDOM_KEY = "r";
    private static Log _log = LogFactoryUtil.getLog(PortalPreferences.class);
    private PortletPreferencesImpl _preferences;
    private boolean _signedIn;

    public PortalPreferencesImpl(PortletPreferencesImpl preferences, boolean signedIn) {
        this._preferences = preferences;
        this._signedIn = signedIn;
    }

    public String getValue(String namespace, String key) {
        return this.getValue(namespace, key, null);
    }

    public String getValue(String namespace, String key, String defaultValue) {
        key = this._encodeKey(namespace, key);
        return this._preferences.getValue(key, defaultValue);
    }

    public String[] getValues(String namespace, String key) {
        return this.getValues(namespace, key, null);
    }

    public String[] getValues(String namespace, String key, String[] defaultValue) {
        key = this._encodeKey(namespace, key);
        return this._preferences.getValues(key, defaultValue);
    }

    public void setValue(String namespace, String key, String value) {
        if (Validator.isNull((String)key) || key.equals(_RANDOM_KEY)) {
            return;
        }
        key = this._encodeKey(namespace, key);
        try {
            if (value != null) {
                this._preferences.setValue(key, value);
            } else {
                this._preferences.reset(key);
            }
            if (this._signedIn) {
                this._preferences.store();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void setValues(String namespace, String key, String[] values) {
        if (Validator.isNull((String)key) || key.equals(_RANDOM_KEY)) {
            return;
        }
        key = this._encodeKey(namespace, key);
        try {
            if (values != null) {
                this._preferences.setValues(key, values);
            } else {
                this._preferences.reset(key);
            }
            if (this._signedIn) {
                this._preferences.store();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private String _encodeKey(String namespace, String key) {
        return String.valueOf(namespace) + "#" + key;
    }
}

