/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ContactLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.util.Date;
import java.util.List;

public class VerifyUser
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyUser.class);

    protected void doVerify() throws Exception {
        List users = UserLocalServiceUtil.getNoContacts();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + users.size() + " users with no contacts"));
        }
        Date now = new Date();
        for (User user : users) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Creating contact for user " + user.getUserId()));
            }
            long contactId = CounterLocalServiceUtil.increment();
            Contact contact = ContactLocalServiceUtil.createContact((long)contactId);
            Company company = CompanyLocalServiceUtil.getCompanyById((long)user.getCompanyId());
            contact.setCompanyId(user.getCompanyId());
            contact.setUserId(user.getUserId());
            contact.setUserName("");
            contact.setCreateDate(now);
            contact.setModifiedDate(now);
            contact.setAccountId(company.getAccountId());
            contact.setParentContactId(0L);
            contact.setFirstName(user.getFirstName());
            contact.setMiddleName(user.getMiddleName());
            contact.setLastName(user.getLastName());
            contact.setPrefixId(0);
            contact.setSuffixId(0);
            contact.setJobTitle(user.getJobTitle());
            ContactLocalServiceUtil.updateContact((Contact)contact);
            user.setContactId(contactId);
            UserLocalServiceUtil.updateUser((User)user);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Contacts verified for users");
        }
        users = UserLocalServiceUtil.getNoGroups();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + users.size() + " users with no groups"));
        }
        for (User user : users) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Creating group for user " + user.getUserId()));
            }
            GroupLocalServiceUtil.addGroup((long)user.getUserId(), (String)User.class.getName(), (long)user.getUserId(), null, null, (int)0, (String)("/" + user.getScreenName()), (boolean)true, null);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Groups verified for users");
        }
    }
}

