/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v4_3_0.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.util.BaseUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;

public class ImageTextUpgradeColumnImpl
extends BaseUpgradeColumnImpl {
    private static Log _log = LogFactoryUtil.getLog(ImageTextUpgradeColumnImpl.class);
    private UpgradeColumn _imageIdColumn;
    private String _type;
    private Integer _height;
    private Integer _width;
    private Integer _size;

    public ImageTextUpgradeColumnImpl(UpgradeColumn imageIdColumn) {
        super("text_");
        this._imageIdColumn = imageIdColumn;
    }

    public Object getNewValue(Object oldValue) throws Exception {
        this._type = null;
        this._height = null;
        this._width = null;
        this._size = null;
        String text = (String)oldValue;
        byte[] bytes = (byte[])Base64.stringToObject((String)text);
        try {
            Image image = ImageLocalServiceUtil.getImage((byte[])bytes);
            this._type = image.getType();
            this._height = new Integer(image.getHeight());
            this._width = new Integer(image.getWidth());
            this._size = new Integer(image.getSize());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                String imageId = (String)this._imageIdColumn.getOldValue();
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get image data for " + imageId + ": " + e.getMessage()));
                }
            }
            this._type = "na";
            this._height = null;
            this._width = null;
            this._size = new Integer(bytes.length);
        }
        return oldValue;
    }

    public String getType() {
        return this._type;
    }

    public Integer getHeight() {
        return this._height;
    }

    public Integer getWidth() {
        return this._width;
    }

    public Integer getSize() {
        return this._size;
    }
}

