/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v4_3_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.upgrade.util.ValueMapper;
import com.liferay.portal.kernel.upgrade.util.ValueMapperFactoryUtil;
import com.liferay.portal.model.Account;
import com.liferay.portal.upgrade.v4_3_0.util.AvailableMappersUtil;
import com.liferay.portal.upgrade.v4_3_0.util.CompanyTable;
import com.liferay.portal.upgrade.v4_3_0.util.WebIdUtil;

public class UpgradeCompany
extends UpgradeProcess {
    private static final String[] _TABLES = new String[]{"Account_", "Address", "BlogsEntry", "BookmarksEntry", "BookmarksFolder", "CalEvent", "Company", "Contact_", "DLFileRank", "DLFileShortcut", "DLFileVersion", "DLFolder", "EmailAddress", "Group_", "IGFolder", "Layout", "LayoutSet", "MBCategory", "Organization_", "Permission_", "Phone", "PollsQuestion", "Portlet", "RatingsEntry", "Resource_", "Role_", "ShoppingCart", "ShoppingCategory", "ShoppingCoupon", "ShoppingItem", "ShoppingOrder", "Subscription", "UserGroup", "User_", "Website", "WikiNode", "WikiPage"};
    private static Log _log = LogFactoryUtil.getLog(UpgradeCompany.class);

    protected void doUpgrade() throws Exception {
        ValueMapper companyIdMapper = ValueMapperFactoryUtil.getValueMapper();
        AvailableMappersUtil.setCompanyIdMapper(companyIdMapper);
        String[] webIds = WebIdUtil.getWebIds();
        long[] companyIds = new long[webIds.length];
        int i = 0;
        while (i < webIds.length) {
            long companyId;
            String webId = webIds[i];
            companyIds[i] = companyId = this.upgradeWebId(webId);
            companyIdMapper.mapValue((Object)webId, (Object)new Long(companyId));
            ++i;
        }
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)CompanyTable.TABLE_NAME, (Object[][])CompanyTable.TABLE_COLUMNS, (UpgradeColumn[])new UpgradeColumn[0]);
        upgradeTable.setCreateSQL(CompanyTable.TABLE_SQL_CREATE);
        upgradeTable.updateTable();
        this.runSQL("update PortletPreferences set ownerId = '0', ownerType = 1 where ownerId = 'COMPANY.LIFERAY_PORTAL'");
    }

    protected String getUpdateSQL(String tableName, long companyId, String webId) {
        String updateSQL = "update " + tableName + " set companyId = '" + companyId + "' where companyId = '" + webId + "'";
        if (_log.isDebugEnabled()) {
            _log.debug((Object)updateSQL);
        }
        return updateSQL;
    }

    protected long upgradeWebId(String webId) throws Exception {
        long companyId = this.increment();
        int j = 0;
        while (j < _TABLES.length) {
            this.runSQL(this.getUpdateSQL(_TABLES[j], companyId, webId));
            ++j;
        }
        long accountId = this.increment();
        this.runSQL("update Account_ set accountId = '" + accountId + "', companyId = '" + companyId + "' where accountId = '" + webId + "'");
        this.runSQL("update Address set classPK = '" + accountId + "' where classNameId = '" + Account.class.getName() + "' and classPK = '" + webId + "'");
        ValueMapper imageIdMapper = AvailableMappersUtil.getImageIdMapper();
        Long logoId = (Long)imageIdMapper.getNewValue((Object)webId);
        this.runSQL("update Company set accountId = " + accountId + ", logoId = " + logoId + " where webId = '" + webId + "'");
        this.runSQL("update Contact_ set companyId = '" + companyId + "', accountId = '" + accountId + "' where contactId = '" + webId + ".default'");
        this.runSQL("update Contact_ set accountId = '" + accountId + "' where accountId = '" + webId + "'");
        this.runSQL("update EmailAddress set classPK = '" + accountId + "' where classNameId = '" + Account.class.getName() + "' and classPK = '" + webId + "'");
        this.runSQL("update Phone set classPK = '" + accountId + "' where classNameId = '" + Account.class.getName() + "' and classPK = '" + webId + "'");
        this.runSQL("update Resource_ set primKey = '" + companyId + "' where scope = 'company' and primKey = '" + webId + "'");
        this.runSQL("update User_ set companyId = '" + companyId + "', defaultUser = TRUE where userId = '" + webId + ".default'");
        this.runSQL("update Website set classPK = '" + accountId + "' where classNameId = '" + Account.class.getName() + "' and classPK = '" + webId + "'");
        return companyId;
    }
}

