/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.cache.transactional.TransactionalPortalCacheHelper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class TransactionInterceptor
extends TransactionAspectSupport
implements MethodInterceptor {
    private static Log _log = LogFactoryUtil.getLog(TransactionInterceptor.class);

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        TransactionAspectSupport.TransactionInfo transactionInfo;
        TransactionStatus transactionStatus;
        boolean newTransaction;
        Method method = methodInvocation.getMethod();
        Class<?> targetClass = null;
        Object thisObject = methodInvocation.getThis();
        if (thisObject != null) {
            targetClass = thisObject.getClass();
        }
        TransactionAttributeSource transactionAttributeSource = this.getTransactionAttributeSource();
        TransactionAttribute transactionAttribute = transactionAttributeSource.getTransactionAttribute(method, targetClass);
        Class<?> declaringClass = method.getDeclaringClass();
        String joinPointIdentification = "";
        if (_log.isDebugEnabled()) {
            joinPointIdentification = declaringClass.getName().concat(".").concat(method.getName());
        }
        if (newTransaction = (transactionStatus = (transactionInfo = this.createTransactionIfNecessary(this.getTransactionManager(), transactionAttribute, joinPointIdentification)).getTransactionStatus()).isNewTransaction()) {
            TransactionalPortalCacheHelper.begin();
        }
        Object returnValue = null;
        try {
            try {
                returnValue = methodInvocation.proceed();
            }
            catch (Throwable throwable) {
                if (newTransaction) {
                    TransactionalPortalCacheHelper.rollback();
                }
                this.completeTransactionAfterThrowing(transactionInfo, throwable);
                throw throwable;
            }
        }
        finally {
            this.cleanupTransactionInfo(transactionInfo);
        }
        this.commitTransactionAfterReturning(transactionInfo);
        if (newTransaction) {
            TransactionalPortalCacheHelper.commit();
        }
        return returnValue;
    }
}

