/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.servlet.PortletSessionTracker;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.servlet.PortalSessionContext;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

public class PortalSessionDestroyer
extends BasePortalLifecycle {
    private static Log _log = LogFactoryUtil.getLog(PortalSessionDestroyer.class);
    private HttpSessionEvent _httpSessionEvent;

    public PortalSessionDestroyer(HttpSessionEvent httpSessionEvent) {
        this._httpSessionEvent = httpSessionEvent;
        this.registerPortalLifecycle();
    }

    protected void doPortalDestroy() {
    }

    protected void doPortalInit() {
        HttpSession session;
        block13: {
            if (PropsValues.SESSION_DISABLED) {
                return;
            }
            session = this._httpSessionEvent.getSession();
            PortalSessionContext.remove(session.getId());
            try {
                Long userIdObj = (Long)session.getAttribute("USER_ID");
                if (userIdObj == null && _log.isWarnEnabled()) {
                    _log.warn((Object)"User id is not in the session");
                }
                if (userIdObj == null) {
                    return;
                }
                session.removeAttribute("org.apache.struts.action.LOCALE");
                if (PropsValues.LIVE_USERS_ENABLED) {
                    long userId = userIdObj;
                    long companyId = this.getCompanyId(userId);
                    String sessionId = session.getId();
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                    jsonObject.put("command", "signOut");
                    jsonObject.put("companyId", companyId);
                    jsonObject.put("userId", userId);
                    jsonObject.put("sessionId", sessionId);
                    MessageBusUtil.sendMessage((String)"liferay/live_users", (Object)jsonObject.toString());
                }
            }
            catch (IllegalStateException illegalStateException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Please upgrade to a Servlet 2.4 compliant container");
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            try {
                PortletSessionTracker portletSessionTracker = (PortletSessionTracker)session.getAttribute("PORTLET_SESSION_TRACKER");
                if (portletSessionTracker != null) {
                    PortletSessionTracker.invalidate((HttpSession)session);
                    session.removeAttribute("PORTLET_SESSION_TRACKER");
                }
            }
            catch (IllegalStateException ise) {
                if (!_log.isWarnEnabled()) break block13;
                _log.warn((Object)ise, (Throwable)ise);
            }
        }
        try {
            EventsProcessorUtil.process("servlet.session.destroy.events", PropsValues.SERVLET_SESSION_DESTROY_EVENTS, session);
        }
        catch (ActionException ae) {
            _log.error((Object)ae, (Throwable)ae);
        }
    }

    protected long getCompanyId(long userId) throws Exception {
        long companyId;
        block5: {
            long[] companyIds = PortalInstances.getCompanyIds();
            companyId = 0L;
            if (companyIds.length == 1) {
                companyId = companyIds[0];
            } else if (companyIds.length > 1) {
                try {
                    User user = UserLocalServiceUtil.getUserById((long)userId);
                    companyId = user.getCompanyId();
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)("Unable to set the company id for user " + userId), (Throwable)e);
                }
            }
        }
        return companyId;
    }
}

