/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.servlet.PortalSessionContext;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

public class PortalSessionCreator
extends BasePortalLifecycle {
    private static Log _log = LogFactoryUtil.getLog(PortalSessionCreator.class);
    private HttpSessionEvent _httpSessionEvent;

    public PortalSessionCreator(HttpSessionEvent httpSessionEvent) {
        this._httpSessionEvent = httpSessionEvent;
        this.registerPortalLifecycle();
    }

    protected void doPortalDestroy() {
    }

    protected void doPortalInit() {
        HttpSession session;
        block5: {
            if (PropsValues.SESSION_DISABLED) {
                return;
            }
            session = this._httpSessionEvent.getSession();
            try {
                PortalSessionContext.put(session.getId(), session);
            }
            catch (IllegalStateException ise) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)ise, (Throwable)ise);
            }
        }
        try {
            EventsProcessorUtil.process("servlet.session.create.events", PropsValues.SERVLET_SESSION_CREATE_EVENTS, session);
        }
        catch (ActionException ae) {
            _log.error((Object)ae, (Throwable)ae);
        }
    }
}

