/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.ImageServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Date;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ImageServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(ImageServlet.class);
    private boolean _lastModified = true;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._lastModified = GetterUtil.getBoolean((String)servletConfig.getInitParameter("last_modified"), (boolean)true);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            User user = PortalUtil.getUser((HttpServletRequest)request);
            if (user == null) {
                Company company = CompanyLocalServiceUtil.getCompany((long)companyId);
                user = company.getDefaultUser();
            }
            PrincipalThreadLocal.setName((long)user.getUserId());
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            if (this._lastModified) {
                long ifModifiedSince;
                long lastModified = this.getLastModified(request);
                if (lastModified > 0L && (ifModifiedSince = request.getDateHeader("If-Modified-Since")) > 0L && ifModifiedSince == lastModified) {
                    response.setStatus(304);
                    return;
                }
                if (lastModified > 0L) {
                    response.setDateHeader("Last-Modified", lastModified);
                }
            }
            this.writeImage(request, response);
        }
        catch (Exception e) {
            PortalUtil.sendError((int)404, (Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected boolean checkIGImageThumbnailMaxDimensions(Image image, long igImageId) throws PortalException, SystemException {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences();
        long igThumbnailMaxDimension = GetterUtil.getLong((String)preferences.getValue("ig.image.thumbnail.max.dimension", null));
        if ((long)image.getHeight() > igThumbnailMaxDimension || (long)image.getWidth() > igThumbnailMaxDimension) {
            IGImage igImage = IGImageLocalServiceUtil.getImage((long)igImageId);
            IGImageLocalServiceUtil.updateSmallImage((long)igImage.getSmallImageId(), (long)igImage.getLargeImageId());
            return true;
        }
        return false;
    }

    protected boolean checkUserImageMaxDimensions(Image image, long imageId) throws PortalException, SystemException {
        if (image.getHeight() > PropsValues.USERS_IMAGE_MAX_HEIGHT || image.getWidth() > PropsValues.USERS_IMAGE_MAX_WIDTH) {
            User user = UserLocalServiceUtil.getUserByPortraitId((long)imageId);
            UserLocalServiceUtil.updatePortrait((long)user.getUserId(), (byte[])image.getTextObj());
            return true;
        }
        return false;
    }

    protected Image getDefaultImage(HttpServletRequest request, long imageId) throws NoSuchImageException {
        String path = GetterUtil.getString((String)request.getPathInfo());
        if (path.startsWith("/company_logo")) {
            return ImageLocalServiceUtil.getDefaultCompanyLogo();
        }
        if (path.startsWith("/organization_logo")) {
            return ImageLocalServiceUtil.getDefaultOrganizationLogo();
        }
        if (path.startsWith("/user_female_portrait")) {
            return ImageLocalServiceUtil.getDefaultUserFemalePortrait();
        }
        if (path.startsWith("/user_male_portrait")) {
            return ImageLocalServiceUtil.getDefaultUserMalePortrait();
        }
        if (path.startsWith("/user_portrait")) {
            return ImageLocalServiceUtil.getDefaultUserMalePortrait();
        }
        throw new NoSuchImageException("No default image exists for " + imageId);
    }

    protected Image getImage(HttpServletRequest request, boolean getDefault) throws PortalException, SystemException {
        long imageId = this.getImageId(request);
        Image image = null;
        if (imageId > 0L) {
            image = ImageServiceUtil.getImage((long)imageId);
            String path = GetterUtil.getString((String)request.getPathInfo());
            if (path.startsWith("/user_female_portrait") || path.startsWith("/user_male_portrait") || path.startsWith("/user_portrait")) {
                if (this.checkUserImageMaxDimensions(image, imageId)) {
                    image = ImageLocalServiceUtil.getImage((long)imageId);
                }
            } else {
                long igImageId = ParamUtil.getLong((HttpServletRequest)request, (String)"igImageId");
                boolean igSmallImage = ParamUtil.getBoolean((HttpServletRequest)request, (String)"igSmallImage");
                if (igImageId > 0L && igSmallImage && this.checkIGImageThumbnailMaxDimensions(image, igImageId)) {
                    image = ImageLocalServiceUtil.getImage((long)imageId);
                }
            }
        } else {
            String uuid = ParamUtil.getString((HttpServletRequest)request, (String)"uuid");
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            try {
                if (Validator.isNotNull((String)uuid) && groupId > 0L) {
                    IGImage igImage = IGImageLocalServiceUtil.getImageByUuidAndGroupId((String)uuid, (long)groupId);
                    image = ImageLocalServiceUtil.getImage((long)igImage.getLargeImageId());
                }
            }
            catch (Exception exception) {}
        }
        if (getDefault && image == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Get a default image for " + imageId));
            }
            image = this.getDefaultImage(request, imageId);
        }
        return image;
    }

    protected byte[] getImageBytes(HttpServletRequest request, Image image) {
        int height = ParamUtil.getInteger((HttpServletRequest)request, (String)"height", (int)image.getHeight());
        int width = ParamUtil.getInteger((HttpServletRequest)request, (String)"width", (int)image.getWidth());
        if (height >= image.getHeight() && width >= image.getWidth()) {
            return image.getTextObj();
        }
        try {
            ImageBag imageBag = ImageProcessorUtil.read((byte[])image.getTextObj());
            RenderedImage renderedImage = ImageProcessorUtil.scale((RenderedImage)imageBag.getRenderedImage(), (int)height, (int)width);
            return ImageProcessorUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Error scaling image " + image.getImageId()), (Throwable)e);
            }
            return image.getTextObj();
        }
    }

    protected long getImageId(HttpServletRequest request) {
        long imageId = ParamUtil.getLong((HttpServletRequest)request, (String)"image_id");
        if (imageId <= 0L) {
            imageId = ParamUtil.getLong((HttpServletRequest)request, (String)"img_id");
        }
        if (imageId <= 0L) {
            imageId = ParamUtil.getLong((HttpServletRequest)request, (String)"i_id");
        }
        if (imageId <= 0L) {
            long companyId = ParamUtil.getLong((HttpServletRequest)request, (String)"companyId");
            String screenName = ParamUtil.getString((HttpServletRequest)request, (String)"screenName");
            try {
                if (companyId > 0L && Validator.isNotNull((String)screenName)) {
                    User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
                    imageId = user.getPortraitId();
                }
            }
            catch (Exception exception) {}
        }
        return imageId;
    }

    protected long getLastModified(HttpServletRequest request) {
        Image image;
        block6: {
            image = this.getImage(request, false);
            if (image != null) break block6;
            return -1L;
        }
        try {
            Date modifiedDate = image.getModifiedDate();
            if (modifiedDate == null) {
                modifiedDate = PortalUtil.getUptime();
            }
            return modifiedDate.getTime() / 1000L * 1000L;
        }
        catch (PrincipalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)pe, (Throwable)pe);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return -1L;
    }

    protected void writeImage(HttpServletRequest request, HttpServletResponse response) throws PortalException, SystemException {
        block6: {
            Image image = this.getImage(request, true);
            if (image == null) {
                throw new NoSuchImageException("Image is null");
            }
            String contentType = null;
            if (!image.getType().equals("na")) {
                contentType = MimeTypesUtil.getContentType((String)image.getType());
                response.setContentType(contentType);
            }
            String fileName = ParamUtil.getString((HttpServletRequest)request, (String)"fileName");
            try {
                byte[] bytes = this.getImageBytes(request, image);
                if (Validator.isNotNull((String)fileName)) {
                    ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (byte[])bytes, (String)contentType);
                } else {
                    ServletResponseUtil.write((HttpServletResponse)response, (byte[])bytes);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }
}

