/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.CompanyMaxUsersException;
import com.liferay.portal.ContactBirthdayException;
import com.liferay.portal.ContactFirstNameException;
import com.liferay.portal.ContactFullNameException;
import com.liferay.portal.ContactLastNameException;
import com.liferay.portal.DuplicateUserEmailAddressException;
import com.liferay.portal.DuplicateUserScreenNameException;
import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.ModelListenerException;
import com.liferay.portal.NoSuchContactException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.PasswordExpiredException;
import com.liferay.portal.RequiredUserException;
import com.liferay.portal.ReservedUserEmailAddressException;
import com.liferay.portal.ReservedUserScreenNameException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserIdException;
import com.liferay.portal.UserLockoutException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.UserPortraitSizeException;
import com.liferay.portal.UserPortraitTypeException;
import com.liferay.portal.UserReminderQueryException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.UserSmsException;
import com.liferay.portal.kernel.annotation.Propagation;
import com.liferay.portal.kernel.annotation.Transactional;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageProcessorUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Ticket;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.security.auth.AuthPipeline;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.security.auth.FullNameValidator;
import com.liferay.portal.security.auth.FullNameValidatorFactory;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.security.auth.ScreenNameValidator;
import com.liferay.portal.security.auth.ScreenNameValidatorFactory;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.pwd.PwdAuthenticator;
import com.liferay.portal.security.pwd.PwdEncryptor;
import com.liferay.portal.security.pwd.PwdToolkitUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.PrincipalBean;
import com.liferay.portal.service.base.UserLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import com.liferay.portlet.imagegallery.ImageSizeException;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserLocalServiceImpl
extends UserLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(UserLocalServiceImpl.class);
    private static Map<Long, User> _defaultUsers = new ConcurrentHashMap<Long, User>();

    public void addDefaultGroups(long userId) throws PortalException, SystemException {
        String[] defaultGroupNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> groupIdsSet = new HashSet<Long>();
        String[] stringArray = defaultGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.group.names", "\n", PropsValues.ADMIN_DEFAULT_GROUP_NAMES);
        int n = defaultGroupNames.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultGroupName = stringArray[n2];
            try {
                Group group = this.groupPersistence.findByC_N(user.getCompanyId(), defaultGroupName);
                if (!this.userPersistence.containsGroup(userId, group.getGroupId())) {
                    groupIdsSet.add(group.getGroupId());
                }
            }
            catch (NoSuchGroupException noSuchGroupException) {}
            ++n2;
        }
        long[] groupIds = ArrayUtil.toArray((Long[])groupIdsSet.toArray(new Long[groupIdsSet.size()]));
        this.groupLocalService.addUserGroups(userId, groupIds);
    }

    public void addDefaultRoles(long userId) throws PortalException, SystemException {
        String[] defaultRoleNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> roleIdSet = new HashSet<Long>();
        String[] stringArray = defaultRoleNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.role.names", "\n", PropsValues.ADMIN_DEFAULT_ROLE_NAMES);
        int n = defaultRoleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultRoleName = stringArray[n2];
            try {
                Role role = this.rolePersistence.findByC_N(user.getCompanyId(), defaultRoleName);
                if (!this.userPersistence.containsRole(userId, role.getRoleId())) {
                    roleIdSet.add(role.getRoleId());
                }
            }
            catch (NoSuchRoleException noSuchRoleException) {}
            ++n2;
        }
        long[] roleIds = ArrayUtil.toArray((Long[])roleIdSet.toArray(new Long[roleIdSet.size()]));
        roleIds = EnterpriseAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
        this.userPersistence.addRoles(userId, roleIds);
    }

    public void addDefaultUserGroups(long userId) throws PortalException, SystemException {
        long[] userGroupIds;
        String[] defaultUserGroupNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> userGroupIdSet = new HashSet<Long>();
        String[] stringArray = defaultUserGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.user.group.names", "\n", PropsValues.ADMIN_DEFAULT_USER_GROUP_NAMES);
        int n = defaultUserGroupNames.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultUserGroupName = stringArray[n2];
            try {
                UserGroup userGroup = this.userGroupPersistence.findByC_N(user.getCompanyId(), defaultUserGroupName);
                if (!this.userPersistence.containsUserGroup(userId, userGroup.getUserGroupId())) {
                    userGroupIdSet.add(userGroup.getUserGroupId());
                }
            }
            catch (NoSuchUserGroupException noSuchUserGroupException) {}
            ++n2;
        }
        long[] lArray = userGroupIds = ArrayUtil.toArray((Long[])userGroupIdSet.toArray(new Long[userGroupIdSet.size()]));
        int n3 = userGroupIds.length;
        int n4 = 0;
        while (n4 < n3) {
            long userGroupId = lArray[n4];
            this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userId);
            ++n4;
        }
        this.userPersistence.addUserGroups(userId, userGroupIds);
    }

    public void addGroupUsers(long groupId, long[] userIds) throws PortalException, SystemException {
        this.groupPersistence.addUsers(groupId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void addOrganizationUsers(long organizationId, long[] userIds) throws PortalException, SystemException {
        this.organizationPersistence.addUsers(organizationId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void addPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws SystemException {
        this.passwordPolicyRelLocalService.addPasswordPolicyRels(passwordPolicyId, User.class.getName(), userIds);
    }

    public void addRoleUsers(long roleId, long[] userIds) throws PortalException, SystemException {
        this.rolePersistence.addUsers(roleId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void addTeamUsers(long teamId, long[] userIds) throws PortalException, SystemException {
        this.teamPersistence.addUsers(teamId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public User addUser(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        screenName = this.getScreenName(screenName);
        emailAddress = emailAddress.trim().toLowerCase();
        openId = openId.trim();
        Date now = new Date();
        if (PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate")) {
            autoScreenName = true;
        }
        long userId = this.counterLocalService.increment();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isGenerated(emailAddress)) {
            emailAddress = "";
        }
        if (!PropsValues.USERS_EMAIL_ADDRESS_REQUIRED && Validator.isNull((String)emailAddress)) {
            emailAddress = emailAddressGenerator.generate(companyId, userId);
        }
        this.validate(companyId, userId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, firstName, middleName, lastName, organizationIds);
        if (autoPassword) {
            PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicy(companyId, organizationIds);
            password1 = PwdToolkitUtil.generate(passwordPolicy);
        } else if (Validator.isNull((String)password1) || Validator.isNull((String)password2)) {
            throw new UserPasswordException(3);
        }
        if (autoScreenName) {
            ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
            try {
                screenName = screenNameGenerator.generate(companyId, userId, emailAddress);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        User defaultUser = this.getDefaultUser(companyId);
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        String fullName = fullNameGenerator.getFullName(firstName, middleName, lastName);
        String greeting = LanguageUtil.format((Locale)locale, (String)"welcome-x", (Object)(" " + fullName), (boolean)false);
        User user = this.userPersistence.create(userId);
        user.setCompanyId(companyId);
        user.setCreateDate(now);
        user.setModifiedDate(now);
        user.setDefaultUser(false);
        user.setContactId(this.counterLocalService.increment());
        user.setPassword(PwdEncryptor.encrypt(password1));
        user.setPasswordUnencrypted(password1);
        user.setPasswordEncrypted(true);
        user.setPasswordReset(false);
        user.setScreenName(screenName);
        user.setEmailAddress(emailAddress);
        user.setFacebookId(facebookId);
        user.setOpenId(openId);
        user.setLanguageId(locale.toString());
        user.setTimeZoneId(defaultUser.getTimeZoneId());
        user.setGreeting(greeting);
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        user.setActive(true);
        this.userPersistence.update((BaseModel)user, false, serviceContext);
        String creatorUserName = "";
        if (creatorUserId <= 0L) {
            creatorUserId = user.getUserId();
        } else {
            User creatorUser = this.userPersistence.findByPrimaryKey(creatorUserId);
            creatorUserName = creatorUser.getFullName();
        }
        this.resourceLocalService.addResources(companyId, 0L, creatorUserId, User.class.getName(), user.getUserId(), false, false, false);
        if (user.hasCompanyMx()) {
            this.mailService.addUser(companyId, userId, password1, firstName, middleName, lastName, emailAddress);
        }
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (PortalException)new ContactBirthdayException());
        Contact contact = this.contactPersistence.create(user.getContactId());
        contact.setCompanyId(user.getCompanyId());
        contact.setUserId(creatorUserId);
        contact.setUserName(creatorUserName);
        contact.setCreateDate(now);
        contact.setModifiedDate(now);
        contact.setAccountId(company.getAccountId());
        contact.setParentContactId(0L);
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact, false, serviceContext);
        this.groupLocalService.addGroup(user.getUserId(), User.class.getName(), user.getUserId(), null, null, 0, "/" + screenName, true, null);
        if (groupIds != null) {
            this.groupLocalService.addUserGroups(userId, groupIds);
        }
        this.addDefaultGroups(userId);
        this.updateOrganizations(userId, organizationIds);
        if (roleIds != null) {
            roleIds = EnterpriseAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
            this.userPersistence.setRoles(userId, roleIds);
        }
        this.addDefaultRoles(userId);
        if (userGroupIds != null) {
            long[] lArray = userGroupIds;
            int n = userGroupIds.length;
            int n2 = 0;
            while (n2 < n) {
                long userGroupId = lArray[n2];
                this.userGroupLocalService.copyUserGroupLayouts(userGroupId, new long[]{userId});
                ++n2;
            }
            this.userPersistence.setUserGroups(userId, userGroupIds);
        }
        this.addDefaultUserGroups(userId);
        if (serviceContext != null) {
            this.updateAsset(creatorUserId, user, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        user.setExpandoBridgeAttributes(serviceContext);
        if (sendEmail) {
            try {
                this.sendEmail(user, password1);
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)user);
        return user;
    }

    public void addUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userIds);
        this.userGroupPersistence.addUsers(userGroupId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public int authenticateByEmailAddress(long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        return this.authenticate(companyId, emailAddress, password, "emailAddress", headerMap, parameterMap);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public int authenticateByScreenName(long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        return this.authenticate(companyId, screenName, password, "screenName", headerMap, parameterMap);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public int authenticateByUserId(long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        return this.authenticate(companyId, String.valueOf(userId), password, "userId", headerMap, parameterMap);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public long authenticateForBasic(long companyId, String authType, String login, String password) throws PortalException, SystemException {
        try {
            User user = null;
            if (authType.equals("emailAddress")) {
                user = this.getUserByEmailAddress(companyId, login);
            } else if (authType.equals("screenName")) {
                user = this.getUserByScreenName(companyId, login);
            } else if (authType.equals("userId")) {
                user = this.getUserById(companyId, GetterUtil.getLong((String)login));
            }
            if (!PropsValues.BASIC_AUTH_PASSWORD_REQUIRED) {
                return user.getUserId();
            }
            String userPassword = user.getPassword();
            if (!user.isPasswordEncrypted()) {
                userPassword = PwdEncryptor.encrypt(userPassword);
            }
            String encPassword = PwdEncryptor.encrypt(password);
            if (userPassword.equals(password) || userPassword.equals(encPassword)) {
                return user.getUserId();
            }
        }
        catch (NoSuchUserException noSuchUserException) {}
        return 0L;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public long authenticateForDigest(long companyId, String username, String realm, String nonce, String method, String uri, String response) throws PortalException, SystemException {
        String[] digestArray;
        long userId = 0L;
        User user = null;
        try {
            user = this.getUserByEmailAddress(companyId, username);
        }
        catch (NoSuchUserException noSuchUserException) {
            try {
                user = this.getUserByScreenName(companyId, username);
            }
            catch (NoSuchUserException noSuchUserException2) {
                try {
                    user = this.getUserById(Long.parseLong(username));
                }
                catch (NoSuchUserException noSuchUserException3) {
                    return userId;
                }
            }
        }
        String digest = user.getDigest();
        if (Validator.isNull((String)digest)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("User must first log in through the portal " + user.getUserId()));
            }
            return userId;
        }
        String[] stringArray = digestArray = StringUtil.split((String)user.getDigest());
        int n = digestArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ha1 = stringArray[n2];
            String ha2 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{method, uri});
            String myresponse = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{ha1, nonce, ha2});
            if (myresponse.equals(response)) {
                userId = user.getUserId();
                break;
            }
            ++n2;
        }
        return userId;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean authenticateForJAAS(long userId, String encPassword) {
        String password;
        block11: {
            block9: {
                block10: {
                    User user;
                    block8: {
                        user = this.userPersistence.findByPrimaryKey(userId);
                        if (!user.isDefaultUser()) break block8;
                        _log.error((Object)"The default user should never be allowed to authenticate");
                        return false;
                    }
                    password = user.getPassword();
                    if (!user.isPasswordEncrypted()) break block9;
                    if (!password.equals(encPassword)) break block10;
                    return true;
                }
                if (!PropsValues.PORTAL_JAAS_STRICT_PASSWORD && password.equals(encPassword = PwdEncryptor.encrypt(encPassword, password))) {
                    return true;
                }
            }
            if (PropsValues.PORTAL_JAAS_STRICT_PASSWORD || !password.equals(encPassword)) break block11;
            return true;
        }
        try {
            password = PwdEncryptor.encrypt(password);
            if (password.equals(encPassword)) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        return false;
    }

    public void checkLockout(User user) throws PortalException, SystemException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
            return;
        }
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy.isLockout()) {
            long requiredElapsedTime;
            long elapsedTime;
            Date now = new Date();
            int failedLoginAttempts = user.getFailedLoginAttempts();
            if (failedLoginAttempts > 0) {
                long failedLoginTime = user.getLastFailedLoginDate().getTime();
                elapsedTime = now.getTime() - failedLoginTime;
                requiredElapsedTime = passwordPolicy.getResetFailureCount() * 1000L;
                if (requiredElapsedTime != 0L && elapsedTime > requiredElapsedTime) {
                    user.setLastFailedLoginDate(null);
                    user.setFailedLoginAttempts(0);
                    this.userPersistence.update((BaseModel)user, false);
                }
            }
            if (user.isLockout()) {
                long lockoutTime = user.getLockoutDate().getTime();
                elapsedTime = now.getTime() - lockoutTime;
                requiredElapsedTime = passwordPolicy.getLockoutDuration() * 1000L;
                if (requiredElapsedTime != 0L && elapsedTime > requiredElapsedTime) {
                    user.setLockout(false);
                    user.setLockoutDate(null);
                    this.userPersistence.update((BaseModel)user, false);
                }
            }
            if (user.isLockout()) {
                throw new UserLockoutException();
            }
        }
    }

    public void checkLoginFailure(User user) throws SystemException {
        Date now = new Date();
        int failedLoginAttempts = user.getFailedLoginAttempts();
        user.setLastFailedLoginDate(now);
        user.setFailedLoginAttempts(++failedLoginAttempts);
        this.userPersistence.update((BaseModel)user, false);
    }

    public void checkLoginFailureByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        this.checkLoginFailure(user);
    }

    public void checkLoginFailureById(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.checkLoginFailure(user);
    }

    public void checkLoginFailureByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        User user = this.getUserByScreenName(companyId, screenName);
        this.checkLoginFailure(user);
    }

    public void checkPasswordExpired(User user) throws PortalException, SystemException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
            return;
        }
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (this.isPasswordExpired(user)) {
            int graceLoginCount = user.getGraceLoginCount();
            if (graceLoginCount < passwordPolicy.getGraceLimit()) {
                user.setGraceLoginCount(++graceLoginCount);
                this.userPersistence.update((BaseModel)user, false);
            } else {
                throw new PasswordExpiredException();
            }
        }
        if (this.isPasswordExpiringSoon(user)) {
            user.setPasswordReset(true);
            this.userPersistence.update((BaseModel)user, false);
        }
        if (passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired() && user.getLastLoginDate() == null) {
            boolean passwordReset = false;
            if (passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired()) {
                passwordReset = true;
            }
            user.setPasswordReset(passwordReset);
            this.userPersistence.update((BaseModel)user, false);
        }
    }

    public KeyValuePair decryptUserId(long companyId, String name, String password) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        try {
            name = Encryptor.decrypt((Key)company.getKeyObj(), (String)name);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
        long userId = GetterUtil.getLong((String)name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        try {
            password = Encryptor.decrypt((Key)company.getKeyObj(), (String)password);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
        String encPassword = PwdEncryptor.encrypt(password);
        if (user.getPassword().equals(encPassword)) {
            if (this.isPasswordExpired(user)) {
                user.setPasswordReset(true);
                this.userPersistence.update((BaseModel)user, false);
            }
            return new KeyValuePair(name, password);
        }
        throw new PrincipalException();
    }

    public void deletePortrait(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long portraitId = user.getPortraitId();
        if (portraitId > 0L) {
            user.setPortraitId(0L);
            this.userPersistence.update((BaseModel)user, false);
            this.imageLocalService.deleteImage(portraitId);
        }
    }

    public void deleteRoleUser(long roleId, long userId) throws PortalException, SystemException {
        this.rolePersistence.removeUser(roleId, userId);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userId);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void deleteUser(long userId) throws PortalException, SystemException {
        if (!PropsValues.USERS_DELETE) {
            throw new RequiredUserException();
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.delete((Object)user);
        this.browserTrackerLocalService.deleteUserBrowserTracker(userId);
        Group group = user.getGroup();
        if (group != null) {
            this.groupLocalService.deleteGroup(group.getGroupId());
        }
        this.imageLocalService.deleteImage(user.getPortraitId());
        this.passwordPolicyRelLocalService.deletePasswordPolicyRel(User.class.getName(), userId);
        this.passwordTrackerLocalService.deletePasswordTrackers(userId);
        this.subscriptionLocalService.deleteSubscriptions(userId);
        this.userIdMapperLocalService.deleteUserIdMappers(userId);
        this.announcementsDeliveryLocalService.deleteDeliveries(userId);
        this.assetEntryLocalService.deleteEntry(User.class.getName(), userId);
        this.blogsStatsUserLocalService.deleteStatsUserByUserId(userId);
        this.dlFileRankLocalService.deleteFileRanks(userId);
        this.expandoValueLocalService.deleteValues(User.class.getName(), userId);
        this.mbBanLocalService.deleteBansByBanUserId(userId);
        this.mbMessageFlagLocalService.deleteFlags(userId);
        this.mbStatsUserLocalService.deleteStatsUsersByUserId(userId);
        this.shoppingCartLocalService.deleteUserCarts(userId);
        this.socialActivityLocalService.deleteUserActivities(userId);
        this.socialRequestLocalService.deleteReceiverUserRequests(userId);
        this.socialRequestLocalService.deleteUserRequests(userId);
        this.mailService.deleteUser(user.getCompanyId(), userId);
        try {
            this.contactLocalService.deleteContact(user.getContactId());
        }
        catch (NoSuchContactException noSuchContactException) {}
        this.resourceLocalService.deleteResource(user.getCompanyId(), User.class.getName(), 4, user.getUserId());
        this.userGroupRoleLocalService.deleteUserGroupRolesByUserId(userId);
        this.userPersistence.remove(userId);
        PermissionCacheUtil.clearCache();
    }

    public String encryptUserId(String name) throws PortalException, SystemException {
        long userId = GetterUtil.getLong((String)name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        try {
            return Encryptor.encrypt((Key)company.getKeyObj(), (String)name);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
    }

    public List<User> getCompanyUsers(long companyId, int start, int end) throws SystemException {
        return this.userPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyUsersCount(long companyId) throws SystemException {
        return this.userPersistence.countByCompanyId(companyId);
    }

    public User getDefaultUser(long companyId) throws PortalException, SystemException {
        User userModel = _defaultUsers.get(companyId);
        if (userModel == null) {
            userModel = this.userPersistence.findByC_DU(companyId, true);
            _defaultUsers.put(companyId, userModel);
        }
        return userModel;
    }

    public long getDefaultUserId(long companyId) throws PortalException, SystemException {
        User user = this.getDefaultUser(companyId);
        return user.getUserId();
    }

    public long[] getGroupUserIds(long groupId) throws SystemException {
        return this.getUserIds(this.getGroupUsers(groupId));
    }

    public List<User> getGroupUsers(long groupId) throws SystemException {
        return this.groupPersistence.getUsers(groupId);
    }

    public int getGroupUsersCount(long groupId) throws SystemException {
        return this.groupPersistence.getUsersSize(groupId);
    }

    public int getGroupUsersCount(long groupId, boolean active) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersGroups", new Long(groupId));
        return this.searchCount(group.getCompanyId(), null, active, params);
    }

    public List<User> getNoAnnouncementsDeliveries(String type) throws SystemException {
        return this.userFinder.findByNoAnnouncementsDeliveries(type);
    }

    public List<User> getNoContacts() throws SystemException {
        return this.userFinder.findByNoContacts();
    }

    public List<User> getNoGroups() throws SystemException {
        return this.userFinder.findByNoGroups();
    }

    public long[] getOrganizationUserIds(long organizationId) throws SystemException {
        return this.getUserIds(this.getOrganizationUsers(organizationId));
    }

    public List<User> getOrganizationUsers(long organizationId) throws SystemException {
        return this.organizationPersistence.getUsers(organizationId);
    }

    public int getOrganizationUsersCount(long organizationId) throws SystemException {
        return this.organizationPersistence.getUsersSize(organizationId);
    }

    public int getOrganizationUsersCount(long organizationId, boolean active) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersOrgs", new Long(organizationId));
        return this.searchCount(organization.getCompanyId(), null, active, params);
    }

    public long[] getRoleUserIds(long roleId) throws SystemException {
        return this.getUserIds(this.getRoleUsers(roleId));
    }

    public List<User> getRoleUsers(long roleId) throws SystemException {
        return this.rolePersistence.getUsers(roleId);
    }

    public List<User> getRoleUsers(long roleId, int start, int end) throws SystemException {
        return this.rolePersistence.getUsers(roleId, start, end);
    }

    public int getRoleUsersCount(long roleId) throws SystemException {
        return this.rolePersistence.getUsersSize(roleId);
    }

    public int getRoleUsersCount(long roleId, boolean active) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersRoles", new Long(roleId));
        return this.searchCount(role.getCompanyId(), null, active, params);
    }

    public List<User> getSocialUsers(long userId, int type, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelationType", new Long[]{userId, new Long(type)});
        return this.search(user.getCompanyId(), null, (Boolean)true, params, start, end, obc);
    }

    public List<User> getSocialUsers(long userId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelation", new Long[]{userId});
        return this.search(user.getCompanyId(), null, (Boolean)true, params, start, end, obc);
    }

    public List<User> getSocialUsers(long userId1, long userId2, int type, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelationType", new Long[]{userId1, new Long(type), userId2, new Long(type)});
        return this.search(user1.getCompanyId(), null, (Boolean)true, params, start, end, obc);
    }

    public List<User> getSocialUsers(long userId1, long userId2, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelation", new Long[]{userId1, userId2});
        return this.search(user1.getCompanyId(), null, (Boolean)true, params, start, end, obc);
    }

    public int getSocialUsersCount(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelation", new Long[]{userId});
        return this.searchCount(user.getCompanyId(), null, true, params);
    }

    public int getSocialUsersCount(long userId, int type) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelationType", new Long[]{userId, new Long(type)});
        return this.searchCount(user.getCompanyId(), null, true, params);
    }

    public int getSocialUsersCount(long userId1, long userId2) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelation", new Long[]{userId1, userId2});
        return this.searchCount(user1.getCompanyId(), null, true, params);
    }

    public int getSocialUsersCount(long userId1, long userId2, int type) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelationType", new Long[]{userId1, new Long(type), userId2, new Long(type)});
        return this.searchCount(user1.getCompanyId(), null, true, params);
    }

    public User getUserByContactId(long contactId) throws PortalException, SystemException {
        return this.userPersistence.findByContactId(contactId);
    }

    public User getUserByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        emailAddress = emailAddress.trim().toLowerCase();
        return this.userPersistence.findByC_EA(companyId, emailAddress);
    }

    public User getUserByFacebookId(long companyId, long facebookId) throws PortalException, SystemException {
        return this.userPersistence.findByC_FID(companyId, facebookId);
    }

    public User getUserById(long userId) throws PortalException, SystemException {
        return this.userPersistence.findByPrimaryKey(userId);
    }

    public User getUserById(long companyId, long userId) throws PortalException, SystemException {
        return this.userPersistence.findByC_U(companyId, userId);
    }

    public User getUserByOpenId(long companyId, String openId) throws PortalException, SystemException {
        return this.userPersistence.findByC_O(companyId, openId);
    }

    public User getUserByPortraitId(long portraitId) throws PortalException, SystemException {
        return this.userPersistence.findByPortraitId(portraitId);
    }

    public User getUserByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        screenName = this.getScreenName(screenName);
        return this.userPersistence.findByC_SN(companyId, screenName);
    }

    public User getUserByUuid(String uuid) throws PortalException, SystemException {
        List users = this.userPersistence.findByUuid(uuid);
        if (users.isEmpty()) {
            throw new NoSuchUserException();
        }
        return (User)users.get(0);
    }

    public List<User> getUserGroupUsers(long userGroupId) throws SystemException {
        return this.userGroupPersistence.getUsers(userGroupId);
    }

    public int getUserGroupUsersCount(long userGroupId) throws SystemException {
        return this.userGroupPersistence.getUsersSize(userGroupId);
    }

    public int getUserGroupUsersCount(long userGroupId, boolean active) throws PortalException, SystemException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersUserGroups", new Long(userGroupId));
        return this.searchCount(userGroup.getCompanyId(), null, active, params);
    }

    public long getUserIdByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        emailAddress = emailAddress.trim().toLowerCase();
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        return user.getUserId();
    }

    public long getUserIdByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        screenName = this.getScreenName(screenName);
        User user = this.userPersistence.findByC_SN(companyId, screenName);
        return user.getUserId();
    }

    public boolean hasGroupUser(long groupId, long userId) throws SystemException {
        return this.groupPersistence.containsUser(groupId, userId);
    }

    public boolean hasOrganizationUser(long organizationId, long userId) throws SystemException {
        return this.organizationPersistence.containsUser(organizationId, userId);
    }

    public boolean hasPasswordPolicyUser(long passwordPolicyId, long userId) throws SystemException {
        return this.passwordPolicyRelLocalService.hasPasswordPolicyRel(passwordPolicyId, User.class.getName(), userId);
    }

    public boolean hasRoleUser(long roleId, long userId) throws SystemException {
        return this.rolePersistence.containsUser(roleId, userId);
    }

    public boolean hasRoleUser(long companyId, String name, long userId, boolean inherited) throws PortalException, SystemException {
        return this.roleLocalService.hasUserRole(userId, companyId, name, inherited);
    }

    public boolean hasTeamUser(long teamId, long userId) throws SystemException {
        return this.teamPersistence.containsUser(teamId, userId);
    }

    public boolean hasUserGroupUser(long userGroupId, long userId) throws SystemException {
        return this.userGroupPersistence.containsUser(userGroupId, userId);
    }

    public boolean isPasswordExpired(User user) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy.getExpireable()) {
            Date now = new Date();
            if (user.getPasswordModifiedDate() == null) {
                user.setPasswordModifiedDate(now);
                this.userLocalService.updateUser(user, false);
            }
            long passwordStartTime = user.getPasswordModifiedDate().getTime();
            long elapsedTime = now.getTime() - passwordStartTime;
            return elapsedTime > passwordPolicy.getMaxAge() * 1000L;
        }
        return false;
    }

    public boolean isPasswordExpiringSoon(User user) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy.isExpireable()) {
            Date now = new Date();
            if (user.getPasswordModifiedDate() == null) {
                user.setPasswordModifiedDate(now);
                this.userLocalService.updateUser(user, false);
            }
            long timeModified = user.getPasswordModifiedDate().getTime();
            long passwordExpiresOn = passwordPolicy.getMaxAge() * 1000L + timeModified;
            long timeStartWarning = passwordExpiresOn - passwordPolicy.getWarningTime() * 1000L;
            return now.getTime() > timeStartWarning;
        }
        return false;
    }

    public List<User> search(long companyId, String keywords, Boolean active, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.userFinder.findByKeywords(companyId, keywords, active, params, start, end, obc);
    }

    public Hits search(long companyId, String keywords, Boolean active, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws SystemException {
        String firstName = null;
        String middleName = null;
        String lastName = null;
        String screenName = null;
        String emailAddress = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            firstName = keywords;
            middleName = keywords;
            lastName = keywords;
            screenName = keywords;
            emailAddress = keywords;
        } else {
            andOperator = true;
        }
        return this.search(companyId, firstName, middleName, lastName, screenName, emailAddress, active, params, andOperator, start, end, sort);
    }

    public List<User> search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, Boolean active, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, OrderByComparator obc) throws SystemException {
        return this.userFinder.findByC_FN_MN_LN_SN_EA_A(companyId, firstName, middleName, lastName, screenName, emailAddress, active, params, andSearch, start, end, obc);
    }

    public Hits search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, Boolean active, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws SystemException {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("active", active);
            attributes.put("emailAddress", emailAddress);
            attributes.put("firstName", firstName);
            attributes.put("lastName", lastName);
            attributes.put("middleName", middleName);
            attributes.put("params", params);
            attributes.put("screenName", screenName);
            SearchContext searchContext = new SearchContext();
            searchContext.setAndSearch(andSearch);
            searchContext.setAttributes(attributes);
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setSorts(new Sort[]{sort});
            searchContext.setStart(start);
            Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public int searchCount(long companyId, String keywords, Boolean active, LinkedHashMap<String, Object> params) throws SystemException {
        return this.userFinder.countByKeywords(companyId, keywords, active, params);
    }

    public int searchCount(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, Boolean active, LinkedHashMap<String, Object> params, boolean andSearch) throws SystemException {
        return this.userFinder.countByC_FN_MN_LN_SN_EA_A(companyId, firstName, middleName, lastName, screenName, emailAddress, active, params, andSearch);
    }

    public void sendPassword(long companyId, String emailAddress, String remoteAddr, String remoteHost, String userAgent, String fromName, String fromAddress, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            this.doSendPassword(companyId, emailAddress, remoteAddr, remoteHost, userAgent, fromName, fromAddress, subject, body, serviceContext);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void setRoleUsers(long roleId, long[] userIds) throws PortalException, SystemException {
        this.rolePersistence.setUsers(roleId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void setUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userIds);
        this.userGroupPersistence.setUsers(userGroupId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetGroupUsers(long groupId, long[] userIds) throws PortalException, SystemException {
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId);
        this.groupPersistence.removeUsers(groupId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetOrganizationUsers(long organizationId, long[] userIds) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        Group group = organization.getGroup();
        long groupId = group.getGroupId();
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId);
        this.organizationPersistence.removeUsers(organizationId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws SystemException {
        this.passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicyId, User.class.getName(), userIds);
    }

    public void unsetRoleUsers(long roleId, List<User> users) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        if (role.getName().equals("User")) {
            return;
        }
        this.rolePersistence.removeUsers(roleId, users);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex(users);
        PermissionCacheUtil.clearCache();
    }

    public void unsetRoleUsers(long roleId, long[] userIds) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        if (role.getName().equals("User")) {
            return;
        }
        this.rolePersistence.removeUsers(roleId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetTeamUsers(long teamId, long[] userIds) throws PortalException, SystemException {
        this.teamPersistence.removeUsers(teamId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        this.userGroupPersistence.removeUsers(userGroupId, userIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public User updateActive(long userId, boolean active) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setActive(active);
        this.userPersistence.update((BaseModel)user, false);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)user);
        return user;
    }

    public User updateAgreedToTermsOfUse(long userId, boolean agreedToTermsOfUse) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setAgreedToTermsOfUse(agreedToTermsOfUse);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public void updateAsset(long userId, User user, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        User owner = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(owner.getCompanyId());
        Group companyGroup = company.getGroup();
        this.assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), User.class.getName(), user.getUserId(), user.getUuid(), assetCategoryIds, assetTagNames, false, null, null, null, null, null, user.getFullName(), null, null, null, 0, 0, null, false);
    }

    public User updateCreateDate(long userId, Date createDate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setCreateDate(createDate);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2) throws PortalException, SystemException {
        if (!(emailAddress1 = emailAddress1.trim().toLowerCase()).equals(emailAddress2 = emailAddress2.trim().toLowerCase())) {
            throw new UserEmailAddressException();
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateEmailAddress(user.getCompanyId(), emailAddress1);
        this.validateEmailAddress(user.getCompanyId(), emailAddress2);
        if (!user.getEmailAddress().equalsIgnoreCase(emailAddress1) && this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress1) != null) {
            throw new DuplicateUserEmailAddressException();
        }
        this.setEmailAddress(user, password, user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress1);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public void updateGroups(long userId, long[] newGroupIds) throws PortalException, SystemException {
        if (newGroupIds == null) {
            return;
        }
        List oldGroups = this.userPersistence.getGroups(userId);
        ArrayList<Long> oldGroupIds = new ArrayList<Long>(oldGroups.size());
        for (Group oldGroup : oldGroups) {
            long oldGroupId = oldGroup.getGroupId();
            oldGroupIds.add(oldGroupId);
            if (ArrayUtil.contains((long[])newGroupIds, (long)oldGroupId)) continue;
            this.unsetGroupUsers(oldGroupId, new long[]{userId});
        }
        long[] lArray = newGroupIds;
        int n = newGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long newGroupId = lArray[n2];
            if (!oldGroupIds.contains(newGroupId)) {
                this.addGroupUsers(newGroupId, new long[]{userId});
            }
            ++n2;
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)new long[]{userId});
        PermissionCacheUtil.clearCache();
    }

    public User updateLastLogin(long userId, String loginIP) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date lastLoginDate = user.getLoginDate();
        if (lastLoginDate == null) {
            lastLoginDate = new Date();
        }
        user.setLoginDate(new Date());
        user.setLoginIP(loginIP);
        user.setLastLoginDate(lastLoginDate);
        user.setLastLoginIP(user.getLoginIP());
        user.setLastFailedLoginDate(null);
        user.setFailedLoginAttempts(0);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public User updateLockout(User user, boolean lockout) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy == null || !passwordPolicy.isLockout()) {
            return user;
        }
        Date lockoutDate = null;
        if (lockout) {
            lockoutDate = new Date();
        }
        user.setLockout(lockout);
        user.setLockoutDate(lockoutDate);
        if (!lockout) {
            user.setLastFailedLoginDate(lockoutDate);
            user.setFailedLoginAttempts(0);
        }
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public User updateLockoutByEmailAddress(long companyId, String emailAddress, boolean lockout) throws PortalException, SystemException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        return this.updateLockout(user, lockout);
    }

    public User updateLockoutById(long userId, boolean lockout) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.updateLockout(user, lockout);
    }

    public User updateLockoutByScreenName(long companyId, String screenName, boolean lockout) throws PortalException, SystemException {
        User user = this.getUserByScreenName(companyId, screenName);
        return this.updateLockout(user, lockout);
    }

    public User updateModifiedDate(long userId, Date modifiedDate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setModifiedDate(modifiedDate);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public void updateOpenId(long userId, String openId) throws PortalException, SystemException {
        openId = openId.trim();
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setOpenId(openId);
        this.userPersistence.update((BaseModel)user, false);
    }

    public void updateOrganizations(long userId, long[] newOrganizationIds) throws PortalException, SystemException {
        if (newOrganizationIds == null) {
            return;
        }
        List oldOrganizations = this.userPersistence.getOrganizations(userId);
        ArrayList<Long> oldOrganizationIds = new ArrayList<Long>(oldOrganizations.size());
        for (Organization oldOrganization : oldOrganizations) {
            long oldOrganizationId = oldOrganization.getOrganizationId();
            oldOrganizationIds.add(oldOrganizationId);
            if (ArrayUtil.contains((long[])newOrganizationIds, (long)oldOrganizationId)) continue;
            this.unsetOrganizationUsers(oldOrganizationId, new long[]{userId});
        }
        long[] lArray = newOrganizationIds;
        int n = newOrganizationIds.length;
        int n2 = 0;
        while (n2 < n) {
            long newOrganizationId = lArray[n2];
            if (!oldOrganizationIds.contains(newOrganizationId)) {
                this.addOrganizationUsers(newOrganizationId, new long[]{userId});
            }
            ++n2;
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)new long[]{userId});
        PermissionCacheUtil.clearCache();
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset) throws PortalException, SystemException {
        return this.updatePassword(userId, password1, password2, passwordReset, false);
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset, boolean silentUpdate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!silentUpdate) {
            this.validatePassword(user.getCompanyId(), userId, password1, password2);
        }
        String oldEncPwd = user.getPassword();
        if (!user.isPasswordEncrypted()) {
            oldEncPwd = PwdEncryptor.encrypt(user.getPassword());
        }
        String newEncPwd = PwdEncryptor.encrypt(password1);
        if (user.hasCompanyMx()) {
            this.mailService.updatePassword(user.getCompanyId(), userId, password1);
        }
        user.setPassword(newEncPwd);
        user.setPasswordUnencrypted(password1);
        user.setPasswordEncrypted(true);
        user.setPasswordReset(passwordReset);
        user.setPasswordModifiedDate(new Date());
        user.setGraceLoginCount(0);
        if (!silentUpdate) {
            user.setPasswordModified(true);
        }
        try {
            this.userPersistence.update((BaseModel)user, false);
        }
        catch (ModelListenerException mle) {
            String passwordHistory;
            String msg = GetterUtil.getString((String)mle.getCause().getMessage());
            if (LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId()) && msg.indexOf(passwordHistory = PrefsPropsUtil.getString(user.getCompanyId(), "ldap.error.password.history")) != -1) {
                throw new UserPasswordException(1);
            }
            throw new UserPasswordException(3);
        }
        if (!silentUpdate) {
            user.setPasswordModified(false);
            this.passwordTrackerLocalService.trackPassword(userId, oldEncPwd);
        }
        return user;
    }

    public User updatePasswordManually(long userId, String password, boolean passwordEncrypted, boolean passwordReset, Date passwordModifiedDate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setPassword(password);
        user.setPasswordEncrypted(passwordEncrypted);
        user.setPasswordReset(passwordReset);
        user.setPasswordModifiedDate(passwordModifiedDate);
        this.userPersistence.update((BaseModel)user, false);
        return user;
    }

    public void updatePasswordReset(long userId, boolean passwordReset) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setPasswordReset(passwordReset);
        this.userPersistence.update((BaseModel)user, false);
    }

    public void updatePortrait(long userId, byte[] bytes) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long imageMaxSize = PrefsPropsUtil.getLong("users.image.max.size");
        if (imageMaxSize > 0L && (bytes == null || (long)bytes.length > imageMaxSize)) {
            throw new UserPortraitSizeException();
        }
        long portraitId = user.getPortraitId();
        if (portraitId <= 0L) {
            portraitId = this.counterLocalService.increment();
            user.setPortraitId(portraitId);
            this.userPersistence.update((BaseModel)user, false);
        }
        try {
            ImageBag imageBag = ImageProcessorUtil.read((byte[])bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            if (renderedImage == null) {
                throw new UserPortraitTypeException();
            }
            renderedImage = ImageProcessorUtil.scale((RenderedImage)renderedImage, (int)PropsValues.USERS_IMAGE_MAX_HEIGHT, (int)PropsValues.USERS_IMAGE_MAX_WIDTH);
            String contentType = imageBag.getType();
            this.imageLocalService.updateImage(portraitId, ImageProcessorUtil.getBytes((RenderedImage)renderedImage, (String)contentType));
        }
        catch (IOException ioe) {
            throw new ImageSizeException((Throwable)ioe);
        }
    }

    public void updateReminderQuery(long userId, String question, String answer) throws PortalException, SystemException {
        this.validateReminderQuery(question, answer);
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setReminderQueryQuestion(question);
        user.setReminderQueryAnswer(answer);
        this.userPersistence.update((BaseModel)user, false);
    }

    public void updateScreenName(long userId, String screenName) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        screenName = this.getScreenName(screenName);
        this.validateScreenName(user.getCompanyId(), userId, screenName);
        user.setScreenName(screenName);
        this.userPersistence.update((BaseModel)user, false);
        Group group = this.groupLocalService.getUserGroup(user.getCompanyId(), userId);
        group.setFriendlyURL("/" + screenName);
        this.groupPersistence.update((BaseModel)group, false);
    }

    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String aimSn, String facebookSn, String icqSn, String jabberSn, String msnSn, String mySpaceSn, String skypeSn, String twitterSn, String ymSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        String password = oldPassword;
        screenName = this.getScreenName(screenName);
        emailAddress = emailAddress.trim().toLowerCase();
        openId = openId.trim();
        String oldFullName = user.getFullName();
        aimSn = aimSn.trim().toLowerCase();
        facebookSn = facebookSn.trim().toLowerCase();
        icqSn = icqSn.trim().toLowerCase();
        jabberSn = jabberSn.trim().toLowerCase();
        msnSn = msnSn.trim().toLowerCase();
        mySpaceSn = mySpaceSn.trim().toLowerCase();
        skypeSn = skypeSn.trim().toLowerCase();
        twitterSn = twitterSn.trim().toLowerCase();
        ymSn = ymSn.trim().toLowerCase();
        Date now = new Date();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isGenerated(emailAddress)) {
            emailAddress = "";
        }
        if (!PropsValues.USERS_EMAIL_ADDRESS_REQUIRED && Validator.isNull((String)emailAddress)) {
            emailAddress = emailAddressGenerator.generate(user.getCompanyId(), userId);
        }
        this.validate(userId, screenName, emailAddress, firstName, middleName, lastName, smsSn);
        if (Validator.isNotNull((String)newPassword1) || Validator.isNotNull((String)newPassword2)) {
            user = this.updatePassword(userId, newPassword1, newPassword2, passwordReset);
            password = newPassword1;
        }
        user.setModifiedDate(now);
        if (user.getContactId() <= 0L) {
            user.setContactId(this.counterLocalService.increment());
        }
        user.setPasswordReset(passwordReset);
        if (Validator.isNotNull((String)reminderQueryQuestion) && Validator.isNotNull((String)reminderQueryAnswer)) {
            user.setReminderQueryQuestion(reminderQueryQuestion);
            user.setReminderQueryAnswer(reminderQueryAnswer);
        }
        user.setScreenName(screenName);
        this.setEmailAddress(user, password, firstName, middleName, lastName, emailAddress);
        user.setOpenId(openId);
        user.setLanguageId(languageId);
        user.setTimeZoneId(timeZoneId);
        user.setGreeting(greeting);
        user.setComments(comments);
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        this.userPersistence.update((BaseModel)user, false, serviceContext);
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (PortalException)new ContactBirthdayException());
        long contactId = user.getContactId();
        Contact contact = this.contactPersistence.fetchByPrimaryKey(contactId);
        if (contact == null) {
            contact = this.contactPersistence.create(contactId);
            contact.setCompanyId(user.getCompanyId());
            contact.setUserName("");
            contact.setCreateDate(now);
            contact.setAccountId(company.getAccountId());
            contact.setParentContactId(0L);
        }
        contact.setModifiedDate(now);
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setSmsSn(smsSn);
        contact.setAimSn(aimSn);
        contact.setFacebookSn(facebookSn);
        contact.setIcqSn(icqSn);
        contact.setJabberSn(jabberSn);
        contact.setMsnSn(msnSn);
        contact.setMySpaceSn(mySpaceSn);
        contact.setSkypeSn(skypeSn);
        contact.setTwitterSn(twitterSn);
        contact.setYmSn(ymSn);
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact, false, serviceContext);
        Group group = this.groupLocalService.getUserGroup(user.getCompanyId(), userId);
        group.setFriendlyURL("/" + screenName);
        this.groupPersistence.update((BaseModel)group, false);
        this.updateGroups(userId, groupIds);
        this.updateOrganizations(userId, organizationIds);
        if (roleIds != null) {
            roleIds = EnterpriseAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
            this.userPersistence.setRoles(userId, roleIds);
        }
        this.updateUserGroupRoles(user, groupIds, organizationIds, userGroupRoles);
        if (userGroupIds != null) {
            this.userGroupLocalService.copyUserGroupLayouts(userGroupIds, userId);
            this.userPersistence.setUserGroups(userId, userGroupIds);
        }
        this.announcementsDeliveryLocalService.getUserDeliveries(user.getUserId());
        if (serviceContext != null) {
            this.updateAsset(userId, user, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        user.setExpandoBridgeAttributes(serviceContext);
        if (GetterUtil.getBoolean((String)("users.update.user.name." + MBMessage.class.getName())) && !oldFullName.equals(user.getFullName())) {
            this.mbMessageLocalService.updateUserName(userId, user.getFullName());
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)user);
        PermissionCacheUtil.clearCache();
        return user;
    }

    protected int authenticate(long companyId, String login, String password, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        login = login.trim().toLowerCase();
        long userId = GetterUtil.getLong((String)login);
        if (authType.equals("emailAddress")) {
            if (!Validator.isEmailAddress((String)login)) {
                throw new UserEmailAddressException();
            }
        } else if (authType.equals("screenName")) {
            if (Validator.isNull((String)login)) {
                throw new UserScreenNameException();
            }
        } else if (authType.equals("userId") && Validator.isNull((String)login)) {
            throw new UserIdException();
        }
        if (Validator.isNull((String)password)) {
            throw new UserPasswordException(3);
        }
        int authResult = -1;
        if (authType.equals("emailAddress")) {
            authResult = AuthPipeline.authenticateByEmailAddress("auth.pipeline.pre", companyId, login, password, headerMap, parameterMap);
        } else if (authType.equals("screenName")) {
            authResult = AuthPipeline.authenticateByScreenName("auth.pipeline.pre", companyId, login, password, headerMap, parameterMap);
        } else if (authType.equals("userId")) {
            authResult = AuthPipeline.authenticateByUserId("auth.pipeline.pre", companyId, userId, password, headerMap, parameterMap);
        }
        User user = null;
        try {
            if (authType.equals("emailAddress")) {
                user = this.userPersistence.findByC_EA(companyId, login);
            } else if (authType.equals("screenName")) {
                user = this.userPersistence.findByC_SN(companyId, login);
            } else if (authType.equals("userId")) {
                user = this.userPersistence.findByC_U(companyId, GetterUtil.getLong((String)login));
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            return 0;
        }
        if (user.isDefaultUser()) {
            _log.error((Object)"The default user should never be allowed to authenticate");
            return 0;
        }
        if (!user.isPasswordEncrypted()) {
            user.setPassword(PwdEncryptor.encrypt(user.getPassword()));
            user.setPasswordEncrypted(true);
            this.userPersistence.update((BaseModel)user, false);
        }
        this.checkLockout(user);
        this.checkPasswordExpired(user);
        if (authResult == 1 && PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK) {
            boolean authenticated = PwdAuthenticator.authenticate(login, password, user.getPassword());
            authResult = authenticated ? 1 : -1;
        }
        if (authResult == 1) {
            String digest = user.getDigest(password);
            user.setDigest(digest);
            this.userPersistence.update((BaseModel)user, false);
        }
        if (authResult == 1) {
            if (authType.equals("emailAddress")) {
                authResult = AuthPipeline.authenticateByEmailAddress("auth.pipeline.post", companyId, login, password, headerMap, parameterMap);
            } else if (authType.equals("screenName")) {
                authResult = AuthPipeline.authenticateByScreenName("auth.pipeline.post", companyId, login, password, headerMap, parameterMap);
            } else if (authType.equals("userId")) {
                authResult = AuthPipeline.authenticateByUserId("auth.pipeline.post", companyId, userId, password, headerMap, parameterMap);
            }
        }
        if (authResult == -1) {
            try {
                if (authType.equals("emailAddress")) {
                    AuthPipeline.onFailureByEmailAddress("auth.failure", companyId, login, headerMap, parameterMap);
                } else if (authType.equals("screenName")) {
                    AuthPipeline.onFailureByScreenName("auth.failure", companyId, login, headerMap, parameterMap);
                } else if (authType.equals("userId")) {
                    AuthPipeline.onFailureByUserId("auth.failure", companyId, userId, headerMap, parameterMap);
                }
                if (!LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
                    int maxFailures;
                    PasswordPolicy passwordPolicy = user.getPasswordPolicy();
                    int failedLoginAttempts = user.getFailedLoginAttempts();
                    if (failedLoginAttempts >= (maxFailures = passwordPolicy.getMaxFailure()) && maxFailures != 0) {
                        if (authType.equals("emailAddress")) {
                            AuthPipeline.onMaxFailuresByEmailAddress("auth.max.failures", companyId, login, headerMap, parameterMap);
                        } else if (authType.equals("screenName")) {
                            AuthPipeline.onMaxFailuresByScreenName("auth.max.failures", companyId, login, headerMap, parameterMap);
                        } else if (authType.equals("userId")) {
                            AuthPipeline.onMaxFailuresByUserId("auth.max.failures", companyId, userId, headerMap, parameterMap);
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return authResult;
    }

    protected void doSendPassword(long companyId, String emailAddress, String remoteAddr, String remoteHost, String userAgent, String fromName, String fromAddress, String subject, String body, ServiceContext serviceContext) throws IOException, PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (!company.isSendPassword() && !company.isSendPasswordResetLink()) {
            return;
        }
        if (!Validator.isEmailAddress((String)(emailAddress = emailAddress.trim().toLowerCase()))) {
            throw new UserEmailAddressException();
        }
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        String newPassword = "";
        String passwordResetURL = "";
        if (company.isSendPasswordResetLink()) {
            Date expirationDate = new Date(System.currentTimeMillis() + passwordPolicy.getResetTicketMaxAge() * 1000L);
            Ticket ticket = this.ticketLocalService.addTicket(companyId, User.class.getName(), user.getUserId(), expirationDate, serviceContext);
            passwordResetURL = String.valueOf(serviceContext.getPortalURL()) + serviceContext.getPathMain() + "/portal/update_password?p_l_id=" + serviceContext.getPlid() + "&ticket=" + ticket.getKey();
        } else if (!PwdEncryptor.PASSWORDS_ENCRYPTION_ALGORITHM.equals("NONE")) {
            newPassword = PwdToolkitUtil.generate(passwordPolicy);
            boolean passwordReset = false;
            if (passwordPolicy.getChangeable() && passwordPolicy.getChangeRequired()) {
                passwordReset = true;
            }
            user.setPassword(PwdEncryptor.encrypt(newPassword));
            user.setPasswordUnencrypted(newPassword);
            user.setPasswordEncrypted(true);
            user.setPasswordReset(passwordReset);
            user.setPasswordModified(true);
            user.setPasswordModifiedDate(new Date());
            this.userPersistence.update((BaseModel)user, false);
            user.setPasswordModified(false);
        } else {
            newPassword = user.getPassword();
        }
        if (Validator.isNull((String)fromName)) {
            fromName = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        }
        if (Validator.isNull((String)fromAddress)) {
            fromAddress = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        }
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        if (Validator.isNull((String)subject)) {
            subject = company.isSendPasswordResetLink() ? PrefsPropsUtil.getContent(companyId, "admin.email.password.reset.subject") : PrefsPropsUtil.getContent(companyId, "admin.email.password.sent.subject");
        }
        if (Validator.isNull((String)body)) {
            body = company.isSendPasswordResetLink() ? PrefsPropsUtil.getContent(companyId, "admin.email.password.reset.body") : PrefsPropsUtil.getContent(companyId, "admin.email.password.sent.body");
        }
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PASSWORD_RESET_URL$]", "[$PORTAL_URL$]", "[$REMOTE_ADDRESS$]", "[$REMOTE_HOST$]", "[$TO_ADDRESS$]", "[$TO_NAME$]", "[$USER_AGENT$]", "[$USER_ID$]", "[$USER_PASSWORD$]", "[$USER_SCREENNAME$]"}, (String[])new String[]{fromAddress, fromName, passwordResetURL, company.getVirtualHost(), remoteAddr, remoteHost, toAddress, toName, HtmlUtil.escape((String)userAgent), String.valueOf(user.getUserId()), newPassword, user.getScreenName()});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PASSWORD_RESET_URL$]", "[$PORTAL_URL$]", "[$REMOTE_ADDRESS$]", "[$REMOTE_HOST$]", "[$TO_ADDRESS$]", "[$TO_NAME$]", "[$USER_AGENT$]", "[$USER_ID$]", "[$USER_PASSWORD$]", "[$USER_SCREENNAME$]"}, (String[])new String[]{fromAddress, fromName, passwordResetURL, company.getVirtualHost(), remoteAddr, remoteHost, toAddress, toName, HtmlUtil.escape((String)userAgent), String.valueOf(user.getUserId()), newPassword, user.getScreenName()});
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        InternetAddress to = new InternetAddress(toAddress, toName);
        MailMessage message = new MailMessage(from, to, subject, body, true);
        this.mailService.sendEmail(message);
    }

    protected String getScreenName(String screenName) {
        return StringUtil.lowerCase((String)StringUtil.trim((String)screenName));
    }

    protected long[] getUserIds(List<User> users) {
        long[] userIds = new long[users.size()];
        int i = 0;
        while (i < users.size()) {
            User user = users.get(i);
            userIds[i] = user.getUserId();
            ++i;
        }
        return userIds;
    }

    protected void sendEmail(User user, String password) throws IOException, PortalException, SystemException {
        if (!PrefsPropsUtil.getBoolean(user.getCompanyId(), "admin.email.user.added.enabled")) {
            return;
        }
        long companyId = user.getCompanyId();
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        String fromName = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        String subject = PrefsPropsUtil.getContent(companyId, "admin.email.user.added.subject");
        String body = PrefsPropsUtil.getContent(companyId, "admin.email.user.added.body");
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$TO_ADDRESS$]", "[$TO_NAME$]", "[$USER_ID$]", "[$USER_PASSWORD$]", "[$USER_SCREENNAME$]"}, (String[])new String[]{fromAddress, fromName, company.getVirtualHost(), toAddress, toName, String.valueOf(user.getUserId()), password, user.getScreenName()});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$TO_ADDRESS$]", "[$TO_NAME$]", "[$USER_ID$]", "[$USER_PASSWORD$]", "[$USER_SCREENNAME$]"}, (String[])new String[]{fromAddress, fromName, company.getVirtualHost(), toAddress, toName, String.valueOf(user.getUserId()), password, user.getScreenName()});
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        InternetAddress to = new InternetAddress(toAddress, toName);
        MailMessage message = new MailMessage(from, to, subject, body, true);
        this.mailService.sendEmail(message);
    }

    protected void setEmailAddress(User user, String password, String firstName, String middleName, String lastName, String emailAddress) throws PortalException, SystemException {
        if (emailAddress.equalsIgnoreCase(user.getEmailAddress())) {
            return;
        }
        long userId = user.getUserId();
        if (!user.hasCompanyMx() && user.hasCompanyMx(emailAddress) && Validator.isNotNull((String)password)) {
            this.mailService.addUser(user.getCompanyId(), userId, password, firstName, middleName, lastName, emailAddress);
        } else if (user.hasCompanyMx() && user.hasCompanyMx(emailAddress)) {
            this.mailService.updateEmailAddress(user.getCompanyId(), userId, emailAddress);
        } else if (user.hasCompanyMx() && !user.hasCompanyMx(emailAddress)) {
            this.mailService.deleteEmailAddress(user.getCompanyId(), userId);
        }
        user.setEmailAddress(emailAddress);
    }

    protected void updateUserGroupRoles(User user, long[] groupIds, long[] organizationIds, List<UserGroupRole> userGroupRoles) throws PortalException, SystemException {
        if (userGroupRoles == null) {
            return;
        }
        List previousUserGroupRoles = this.userGroupRolePersistence.findByUserId(user.getUserId());
        for (UserGroupRole userGroupRole : previousUserGroupRoles) {
            if (userGroupRoles.contains(userGroupRole)) {
                userGroupRoles.remove(userGroupRole);
                continue;
            }
            this.userGroupRoleLocalService.deleteUserGroupRole(userGroupRole);
        }
        long[] validGroupIds = null;
        validGroupIds = groupIds != null ? ArrayUtil.clone((long[])groupIds) : user.getGroupIds();
        if (organizationIds == null) {
            organizationIds = user.getOrganizationIds();
        }
        long[] organizationGroupIds = new long[organizationIds.length];
        int i = 0;
        while (i < organizationIds.length) {
            long organizationId = organizationIds[i];
            Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
            Group organizationGroup = organization.getGroup();
            organizationGroupIds[i] = organizationGroup.getGroupId();
            ++i;
        }
        validGroupIds = ArrayUtil.append((long[][])new long[][]{validGroupIds, organizationGroupIds});
        Arrays.sort(validGroupIds);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            if (Arrays.binarySearch(validGroupIds, userGroupRole.getGroupId()) < 0) continue;
            this.userGroupRoleLocalService.addUserGroupRole(userGroupRole);
        }
    }

    protected void validate(long companyId, long userId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, String firstName, String middleName, String lastName, long[] organizationIds) throws PortalException, SystemException {
        User user;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (company.isSystem()) {
            return;
        }
        if (company.getMaxUsers() > 0 && company.getMaxUsers() <= this.searchCount(companyId, null, true, null)) {
            throw new CompanyMaxUsersException();
        }
        if (!autoScreenName) {
            this.validateScreenName(companyId, userId, screenName);
        }
        if (!autoPassword) {
            PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getDefaultPasswordPolicy(companyId);
            PwdToolkitUtil.validate(companyId, 0L, password1, password2, passwordPolicy);
        }
        this.validateEmailAddress(companyId, emailAddress);
        if (Validator.isNotNull((String)emailAddress) && (user = this.userPersistence.fetchByC_EA(companyId, emailAddress)) != null) {
            throw new DuplicateUserEmailAddressException();
        }
        this.validateFullName(companyId, firstName, middleName, lastName);
    }

    protected void validate(long userId, String screenName, String emailAddress, String firstName, String middleName, String lastName, String smsSn) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!user.getScreenName().equalsIgnoreCase(screenName)) {
            this.validateScreenName(user.getCompanyId(), userId, screenName);
        }
        this.validateEmailAddress(user.getCompanyId(), emailAddress);
        if (!user.isDefaultUser()) {
            if (Validator.isNotNull((String)emailAddress) && !user.getEmailAddress().equalsIgnoreCase(emailAddress) && this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress) != null) {
                throw new DuplicateUserEmailAddressException();
            }
            this.validateFullName(user.getCompanyId(), firstName, middleName, lastName);
        }
        if (Validator.isNotNull((String)smsSn) && !Validator.isEmailAddress((String)smsSn)) {
            throw new UserSmsException();
        }
    }

    protected void validateEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        if (Validator.isNull((String)emailAddress) && !PropsValues.USERS_EMAIL_ADDRESS_REQUIRED) {
            return;
        }
        if (!Validator.isEmailAddress((String)emailAddress) || emailAddress.startsWith("root@") || emailAddress.startsWith("postmaster@")) {
            throw new UserEmailAddressException();
        }
        String[] reservedEmailAddresses = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.email.addresses", "\n", PropsValues.ADMIN_RESERVED_EMAIL_ADDRESSES);
        int i = 0;
        while (i < reservedEmailAddresses.length) {
            if (emailAddress.equalsIgnoreCase(reservedEmailAddresses[i])) {
                throw new ReservedUserEmailAddressException();
            }
            ++i;
        }
    }

    protected void validateFullName(long companyId, String firstName, String middleName, String lastName) throws PortalException {
        if (Validator.isNull((String)firstName)) {
            throw new ContactFirstNameException();
        }
        if (Validator.isNull((String)lastName)) {
            throw new ContactLastNameException();
        }
        FullNameValidator fullNameValidator = FullNameValidatorFactory.getInstance();
        if (!fullNameValidator.validate(companyId, firstName, middleName, lastName)) {
            throw new ContactFullNameException();
        }
    }

    protected void validatePassword(long companyId, long userId, String password1, String password2) throws PortalException, SystemException {
        if (Validator.isNull((String)password1) || Validator.isNull((String)password2)) {
            throw new UserPasswordException(3);
        }
        if (!password1.equals(password2)) {
            throw new UserPasswordException(10);
        }
        PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicyByUserId(userId);
        PwdToolkitUtil.validate(companyId, userId, password1, password2, passwordPolicy);
    }

    protected void validateReminderQuery(String question, String answer) throws PortalException {
        if (!PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
            return;
        }
        if (Validator.isNull((String)question)) {
            throw new UserReminderQueryException("Question cannot be null");
        }
        if (Validator.isNull((String)answer)) {
            throw new UserReminderQueryException("Answer cannot be null");
        }
    }

    protected void validateScreenName(long companyId, long userId, String screenName) throws PortalException, SystemException {
        if (Validator.isNull((String)screenName)) {
            throw new UserScreenNameException();
        }
        ScreenNameValidator screenNameValidator = ScreenNameValidatorFactory.getInstance();
        if (!screenNameValidator.validate(companyId, screenName)) {
            throw new UserScreenNameException();
        }
        if (Validator.isNumber((String)screenName) && !screenName.equals(String.valueOf(userId))) {
            if (!PropsValues.USERS_SCREEN_NAME_ALLOW_NUMERIC) {
                throw new UserScreenNameException();
            }
            Group group = this.groupPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)screenName));
            if (group != null) {
                throw new UserScreenNameException();
            }
        }
        char[] cArray = screenName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Validator.isChar((char)c) && !Validator.isDigit((char)c) && c != '-' && c != '.' && c != '_') {
                throw new UserScreenNameException();
            }
            ++n2;
        }
        String[] anonymousNames = PrincipalBean.ANONYMOUS_NAMES;
        int i = 0;
        while (i < anonymousNames.length) {
            if (screenName.equalsIgnoreCase(anonymousNames[i])) {
                throw new UserScreenNameException();
            }
            ++i;
        }
        User user = this.userPersistence.fetchByC_SN(companyId, screenName);
        if (user != null) {
            throw new DuplicateUserScreenNameException();
        }
        String friendlyURL = "/" + screenName;
        Group group = this.groupPersistence.fetchByC_F(companyId, friendlyURL);
        if (group != null) {
            throw new DuplicateUserScreenNameException();
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new UserScreenNameException((Throwable)new GroupFriendlyURLException(exceptionType));
        }
        String[] reservedScreenNames = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.screen.names", "\n", PropsValues.ADMIN_RESERVED_SCREEN_NAMES);
        int i2 = 0;
        while (i2 < reservedScreenNames.length) {
            if (screenName.equalsIgnoreCase(reservedScreenNames[i2])) {
                throw new ReservedUserScreenNameException();
            }
            ++i2;
        }
    }
}

