/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.MembershipRequestCommentsException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.MembershipRequest;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.base.MembershipRequestLocalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.util.UniqueList;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipRequestLocalServiceImpl
extends MembershipRequestLocalServiceBaseImpl {
    public MembershipRequest addMembershipRequest(long userId, long groupId, String comments) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(comments);
        long membershipRequestId = this.counterLocalService.increment();
        MembershipRequest membershipRequest = this.membershipRequestPersistence.create(membershipRequestId);
        membershipRequest.setCompanyId(user.getCompanyId());
        membershipRequest.setUserId(userId);
        membershipRequest.setCreateDate(now);
        membershipRequest.setGroupId(groupId);
        membershipRequest.setComments(comments);
        membershipRequest.setStatusId(0);
        this.membershipRequestPersistence.update((BaseModel)membershipRequest, false);
        try {
            this.notifyCommunityAdministrators(membershipRequest);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return membershipRequest;
    }

    @Override
    public MembershipRequest getMembershipRequest(long membershipRequestId) throws PortalException, SystemException {
        return this.membershipRequestPersistence.findByPrimaryKey(membershipRequestId);
    }

    public void deleteMembershipRequests(long groupId) throws SystemException {
        this.membershipRequestPersistence.removeByGroupId(groupId);
    }

    public void deleteMembershipRequests(long groupId, int statusId) throws SystemException {
        this.membershipRequestPersistence.removeByG_S(groupId, statusId);
    }

    public List<MembershipRequest> search(long groupId, int status, int start, int end) throws SystemException {
        return this.membershipRequestPersistence.findByG_S(groupId, status, start, end);
    }

    public int searchCount(long groupId, int status) throws SystemException {
        return this.membershipRequestPersistence.countByG_S(groupId, status);
    }

    public void updateStatus(long replierUserId, long membershipRequestId, String replyComments, int statusId) throws PortalException, SystemException {
        this.validate(replyComments);
        MembershipRequest membershipRequest = this.membershipRequestPersistence.findByPrimaryKey(membershipRequestId);
        membershipRequest.setReplyComments(replyComments);
        membershipRequest.setReplyDate(new Date());
        membershipRequest.setReplierUserId(replierUserId);
        membershipRequest.setStatusId(statusId);
        this.membershipRequestPersistence.update((BaseModel)membershipRequest, false);
        if (statusId == 1) {
            long[] addUserIds = new long[]{membershipRequest.getUserId()};
            this.userLocalService.addGroupUsers(membershipRequest.getGroupId(), addUserIds);
        }
        try {
            this.notify(membershipRequest.getUserId(), membershipRequest, "communities.email.membership.reply.subject", "communities.email.membership.reply.body");
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected void notify(long userId, MembershipRequest membershipRequest, String subjectProperty, String bodyProperty) throws IOException, PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(membershipRequest.getCompanyId());
        Group group = this.groupPersistence.findByPrimaryKey(membershipRequest.getGroupId());
        User user = this.userPersistence.findByPrimaryKey(userId);
        User requestUser = this.userPersistence.findByPrimaryKey(membershipRequest.getUserId());
        String fromName = PrefsPropsUtil.getString(membershipRequest.getCompanyId(), "communities.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(membershipRequest.getCompanyId(), "communities.email.from.address");
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        String subject = PrefsPropsUtil.getContent(membershipRequest.getCompanyId(), subjectProperty);
        String body = PrefsPropsUtil.getContent(membershipRequest.getCompanyId(), bodyProperty);
        String statusKey = null;
        statusKey = membershipRequest.getStatusId() == 1 ? "approved" : (membershipRequest.getStatusId() == 2 ? "denied" : "pending");
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$COMMUNITY_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$REQUEST_USER_ADDRESS$]", "[$REQUEST_USER_NAME$]", "[$STATUS$]", "[$TO_NAME$]", "[$USER_ADDRESS$]", "[$USER_NAME$]"}, (String[])new String[]{group.getName(), String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), fromAddress, fromName, company.getVirtualHost(), requestUser.getEmailAddress(), requestUser.getFullName(), LanguageUtil.get((Locale)user.getLocale(), (String)statusKey), toName, user.getEmailAddress(), user.getFullName()});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$COMMENTS$]", "[$COMMUNITY_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$REPLY_COMMENTS$]", "[$REQUEST_USER_NAME$]", "[$REQUEST_USER_ADDRESS$]", "[$STATUS$]", "[$TO_NAME$]", "[$USER_ADDRESS$]", "[$USER_NAME$]"}, (String[])new String[]{membershipRequest.getComments(), group.getName(), String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), fromAddress, fromName, company.getVirtualHost(), membershipRequest.getReplyComments(), requestUser.getFullName(), requestUser.getEmailAddress(), LanguageUtil.get((Locale)user.getLocale(), (String)statusKey), toName, user.getEmailAddress(), user.getFullName()});
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        InternetAddress to = new InternetAddress(toAddress, toName);
        MailMessage message = new MailMessage(from, to, subject, body, true);
        this.mailService.sendEmail(message);
    }

    protected void notifyCommunityAdministrators(MembershipRequest membershipRequest) throws IOException, PortalException, SystemException {
        UniqueList admins = new UniqueList();
        Role communityAdminRole = this.roleLocalService.getRole(membershipRequest.getCompanyId(), "Community Administrator");
        List communityAdmins = this.userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(membershipRequest.getGroupId(), communityAdminRole.getRoleId());
        admins.addAll(communityAdmins);
        Role communityOwnerRole = this.rolePersistence.findByC_N(membershipRequest.getCompanyId(), "Community Owner");
        List communityOwners = this.userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(membershipRequest.getGroupId(), communityOwnerRole.getRoleId());
        admins.addAll(communityOwners);
        for (UserGroupRole userGroupRole : admins) {
            this.notify(userGroupRole.getUserId(), membershipRequest, "communities.email.membership.request.subject", "communities.email.membership.request.body");
        }
    }

    protected void validate(String comments) throws PortalException {
        if (Validator.isNull((String)comments) || Validator.isNumber((String)comments)) {
            throw new MembershipRequestCommentsException();
        }
    }
}

