/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.OrgLabor;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.OrganizationServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(OrganizationServiceHttp.class);

    public static void addGroupOrganizations(HttpPrincipal httpPrincipal, long groupId, long[] organizationIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "addGroupOrganizations", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, organizationIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addPasswordPolicyOrganizations(HttpPrincipal httpPrincipal, long passwordPolicyId, long[] organizationIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "addPasswordPolicyOrganizations", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{passwordPolicyId, organizationIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Organization addOrganization(HttpPrincipal httpPrincipal, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "addOrganization", new Class[]{Long.TYPE, String.class, String.class, Boolean.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{parentOrganizationId, name, type, recursable, regionId, countryId, statusId, comments, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Organization)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Organization addOrganization(HttpPrincipal httpPrincipal, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "addOrganization", new Class[]{Long.TYPE, String.class, String.class, Boolean.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, String.class, List.class, List.class, List.class, List.class, List.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{parentOrganizationId, name, type, recursable, regionId, countryId, statusId, comments, addresses, emailAddresses, orgLabors, phones, websites, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Organization)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLogo(HttpPrincipal httpPrincipal, long organizationId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "deleteLogo", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteOrganization(HttpPrincipal httpPrincipal, long organizationId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "deleteOrganization", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Organization> getManageableOrganizations(HttpPrincipal httpPrincipal, String actionId, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "getManageableOrganizations", new Class[]{String.class, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{actionId, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Organization getOrganization(HttpPrincipal httpPrincipal, long organizationId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "getOrganization", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Organization)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long getOrganizationId(HttpPrincipal httpPrincipal, long companyId, String name) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "getOrganizationId", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Organization> getUserOrganizations(HttpPrincipal httpPrincipal, long userId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "getUserOrganizations", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Organization> getUserOrganizations(HttpPrincipal httpPrincipal, long userId, boolean inheritUserGroups) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "getUserOrganizations", new Class[]{Long.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, inheritUserGroups});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setGroupOrganizations(HttpPrincipal httpPrincipal, long groupId, long[] organizationIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "setGroupOrganizations", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, organizationIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetGroupOrganizations(HttpPrincipal httpPrincipal, long groupId, long[] organizationIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "unsetGroupOrganizations", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, organizationIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetPasswordPolicyOrganizations(HttpPrincipal httpPrincipal, long passwordPolicyId, long[] organizationIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "unsetPasswordPolicyOrganizations", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{passwordPolicyId, organizationIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Organization updateOrganization(HttpPrincipal httpPrincipal, long organizationId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "updateOrganization", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Boolean.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId, parentOrganizationId, name, type, recursable, regionId, countryId, statusId, comments, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Organization)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Organization updateOrganization(HttpPrincipal httpPrincipal, long organizationId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(OrganizationServiceUtil.class.getName(), "updateOrganization", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Boolean.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, String.class, List.class, List.class, List.class, List.class, List.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId, parentOrganizationId, name, type, recursable, regionId, countryId, statusId, comments, addresses, emailAddresses, orgLabors, phones, websites, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Organization)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

