/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class PermissionCacheUtil {
    public static final String CACHE_NAME = PermissionCacheUtil.class.getName();
    private static ThreadLocal<LRUMap> _localCache;
    private static boolean _localCacheAvailable;
    private static PortalCache _portalCache;

    static {
        _portalCache = MultiVMPoolUtil.getCache((String)CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
        if (PropsValues.PERMISSIONS_THREAD_LOCAL_CACHE_MAX_SIZE > 0) {
            _localCache = new AutoResetThreadLocal(PermissionCacheUtil.class + "._localCache", (Object)new LRUMap(PropsValues.PERMISSIONS_THREAD_LOCAL_CACHE_MAX_SIZE));
            _localCacheAvailable = true;
        }
    }

    public static void clearCache() {
        PermissionCacheUtil.clearLocalCache();
        _portalCache.removeAll();
    }

    public static void clearLocalCache() {
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            localCache.clear();
        }
    }

    public static PermissionCheckerBag getBag(long userId, long groupId) {
        PermissionCheckerBag bag = null;
        String key = PermissionCacheUtil._encodeKey(userId, groupId);
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            bag = (PermissionCheckerBag)localCache.get(key);
        }
        if (bag == null) {
            bag = (PermissionCheckerBag)_portalCache.get(key);
        }
        return bag;
    }

    public static Boolean getPermission(long userId, long groupId, String name, String primKey, String actionId) {
        Boolean value = null;
        String key = PermissionCacheUtil._encodeKey(userId, groupId, name, primKey, actionId);
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            value = (Boolean)localCache.get(key);
        }
        if (value == null) {
            value = (Boolean)_portalCache.get(key);
        }
        return value;
    }

    public static PermissionCheckerBag putBag(long userId, long groupId, PermissionCheckerBag bag) {
        if (bag != null) {
            String key = PermissionCacheUtil._encodeKey(userId, groupId);
            if (_localCacheAvailable) {
                Map localCache = (Map)_localCache.get();
                localCache.put(key, bag);
            }
            _portalCache.put(key, (Serializable)bag);
        }
        return bag;
    }

    public static Boolean putPermission(long userId, long groupId, String name, String primKey, String actionId, Boolean value) {
        if (value != null) {
            String key = PermissionCacheUtil._encodeKey(userId, groupId, name, primKey, actionId);
            if (_localCacheAvailable) {
                Map localCache = (Map)_localCache.get();
                localCache.put(key, value);
            }
            _portalCache.put(key, (Serializable)value);
        }
        return value;
    }

    private static String _encodeKey(long userId, long groupId) {
        StringBundler sb = new StringBundler(5);
        sb.append(CACHE_NAME);
        sb.append("#");
        sb.append(userId);
        sb.append("#");
        sb.append(groupId);
        return sb.toString();
    }

    private static String _encodeKey(long userId, long groupId, String name, String primKey, String actionId) {
        StringBundler sb = new StringBundler(11);
        sb.append(CACHE_NAME);
        sb.append("#");
        sb.append(userId);
        sb.append("#");
        sb.append(groupId);
        sb.append("#");
        sb.append(name);
        sb.append("#");
        sb.append(primKey);
        sb.append("#");
        sb.append(actionId);
        return sb.toString();
    }
}

