/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.servlet.filters.sso.opensso.OpenSSOUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.PwdGenerator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OpenSSOAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(OpenSSOAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) {
        String[] credentials = null;
        try {
            String redirect;
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            if (!PrefsPropsUtil.getBoolean(companyId, "open.sso.auth.enabled", PropsValues.OPEN_SSO_AUTH_ENABLED)) {
                return credentials;
            }
            String serviceUrl = PrefsPropsUtil.getString(companyId, "open.sso.service.url");
            if (!OpenSSOUtil.isAuthenticated(request, serviceUrl)) {
                return credentials;
            }
            boolean ldapImportEnabled = PrefsPropsUtil.getBoolean(companyId, "open.sso.ldap.import.enabled", PropsValues.OPEN_SSO_LDAP_IMPORT_ENABLED);
            String screenNameAttr = PrefsPropsUtil.getString(companyId, "open.sso.screen.name.attr", PropsValues.OPEN_SSO_SCREEN_NAME_ATTR);
            String emailAddressAttr = PrefsPropsUtil.getString(companyId, "open.sso.email.address.attr", PropsValues.OPEN_SSO_EMAIL_ADDRESS_ATTR);
            String firstNameAttr = PrefsPropsUtil.getString(companyId, "open.sso.first.name.attr", PropsValues.OPEN_SSO_FIRST_NAME_ATTR);
            String lastNameAttr = PrefsPropsUtil.getString(companyId, "open.sso.last.name.attr", PropsValues.OPEN_SSO_LAST_NAME_ATTR);
            Map<String, String> nameValues = OpenSSOUtil.getAttributes(request, serviceUrl);
            String screenName = nameValues.get(screenNameAttr);
            String emailAddress = nameValues.get(emailAddressAttr);
            String firstName = nameValues.get(firstNameAttr);
            String lastName = nameValues.get(lastNameAttr);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Validating user information for " + firstName + " " + lastName + " with screen name " + screenName + " and email address " + emailAddress));
            }
            User user = null;
            if (ldapImportEnabled) {
                user = PortalLDAPImporterUtil.importLDAPUserByScreenName(companyId, screenName);
            } else {
                if (Validator.isNull((String)emailAddress)) {
                    throw new AutoLoginException("Email address is null");
                }
                try {
                    user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
                }
                catch (NoSuchUserException noSuchUserException) {}
            }
            if (user == null) {
                ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
                Locale locale = LocaleUtil.getDefault();
                if (themeDisplay != null) {
                    locale = themeDisplay.getLocale();
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding user " + screenName));
                }
                user = this.addUser(companyId, firstName, lastName, emailAddress, screenName, locale);
            }
            if (Validator.isNotNull((String)(redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect")))) {
                request.setAttribute("AUTO_LOGIN_REDIRECT", (Object)redirect);
            }
            credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return credentials;
    }

    protected User addUser(long companyId, String firstName, String lastName, String emailAddress, String screenName, Locale locale) throws Exception {
        String password1;
        long creatorUserId = 0L;
        boolean autoPassword = false;
        String password2 = password1 = PwdGenerator.getPassword();
        boolean autoScreenName = false;
        long facebookId = 0L;
        String openId = "";
        String middleName = "";
        int prefixId = 0;
        int suffixId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        return UserLocalServiceUtil.addUser((long)creatorUserId, (long)companyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (long)facebookId, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, (long[])groupIds, (long[])organizationIds, (long[])roleIds, (long[])userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
    }
}

