/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.search.lucene.IndexAccessor;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.dialect.Dialect;
import org.apache.lucene.store.jdbc.lock.JdbcLock;
import org.apache.lucene.store.jdbc.support.JdbcTemplate;

public class IndexAccessorImpl
implements IndexAccessor {
    private static final String _LUCENE_STORE_TYPE_FILE = "file";
    private static final String _LUCENE_STORE_TYPE_JDBC = "jdbc";
    private static final String _LUCENE_STORE_TYPE_RAM = "ram";
    private static final String _LUCENE_TABLE_PREFIX = "LUCENE_";
    private static Log _log = LogFactoryUtil.getLog(IndexAccessorImpl.class);
    private int _batchCount;
    private long _companyId;
    private Dialect _dialect;
    private IndexWriter _indexWriter;
    private Map<String, Directory> _jdbcDirectories = new ConcurrentHashMap<String, Directory>();
    private int _optimizeCount;
    private Map<String, Directory> _ramDirectories = new ConcurrentHashMap<String, Directory>();

    public IndexAccessorImpl(long companyId) {
        this._companyId = companyId;
        this._initDialect();
        this._checkLuceneDir();
        this._initIndexWriter();
        this._initCommitScheduler();
    }

    public void addDocument(Document document) throws IOException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        this._write(null, document);
    }

    public void close() {
        try {
            this._indexWriter.close();
        }
        catch (Exception e) {
            _log.error((Object)("Closing Lucene writer failed for " + this._companyId), (Throwable)e);
        }
    }

    public void delete() {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        this.close();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Lucene store type " + PropsValues.LUCENE_STORE_TYPE));
        }
        if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_FILE)) {
            this._deleteFile();
        } else if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_JDBC)) {
            this._deleteJdbc();
        } else if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_RAM)) {
            this._deleteRam();
        } else {
            throw new RuntimeException("Invalid store type " + PropsValues.LUCENE_STORE_TYPE);
        }
        this._initIndexWriter();
    }

    public void deleteDocuments(Term term) throws IOException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        try {
            this._indexWriter.deleteDocuments(term);
            ++this._batchCount;
        }
        finally {
            this._commit();
        }
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public Directory getLuceneDir() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Lucene store type " + PropsValues.LUCENE_STORE_TYPE));
        }
        if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_FILE)) {
            return this._getLuceneDirFile();
        }
        if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_JDBC)) {
            return this._getLuceneDirJdbc();
        }
        if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_RAM)) {
            return this._getLuceneDirRam();
        }
        throw new RuntimeException("Invalid store type " + PropsValues.LUCENE_STORE_TYPE);
    }

    public void updateDocument(Term term, Document document) throws IOException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        this._write(term, document);
    }

    private void _checkLuceneDir() {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        try {
            Directory directory = this.getLuceneDir();
            if (IndexWriter.isLocked((Directory)directory)) {
                IndexWriter.unlock((Directory)directory);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Check Lucene directory failed for " + this._companyId), (Throwable)e);
        }
    }

    private void _commit() throws IOException {
        if (PropsValues.LUCENE_COMMIT_BATCH_SIZE == 0 || PropsValues.LUCENE_COMMIT_BATCH_SIZE <= this._batchCount) {
            this._doCommit();
        }
    }

    private void _deleteFile() {
        String path;
        block2: {
            path = this._getPath();
            try {
                FSDirectory directory = this._getDirectory(path);
                directory.close();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Could not close directory " + path));
            }
        }
        FileUtil.deltree((String)path);
    }

    private void _deleteJdbc() {
        block10: {
            String tableName;
            block8: {
                tableName = this._getTableName();
                try {
                    Directory directory = this._jdbcDirectories.remove(tableName);
                    if (directory != null) {
                        directory.close();
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)("Could not close directory " + tableName));
                }
            }
            Connection con = null;
            Statement s = null;
            try {
                try {
                    con = DataAccess.getConnection();
                    s = con.createStatement();
                    s.executeUpdate("DELETE FROM " + tableName);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Could not truncate " + tableName));
                    }
                    DataAccess.cleanUp((Connection)con, (Statement)s);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, s);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)s);
        }
    }

    private void _deleteRam() {
    }

    private void _doCommit() throws IOException {
        if (this._indexWriter != null) {
            this._indexWriter.commit();
        }
        this._batchCount = 0;
    }

    private FSDirectory _getDirectory(String path) throws IOException {
        return FSDirectory.open((File)new File(path));
    }

    private Directory _getLuceneDirFile() {
        FSDirectory directory;
        block4: {
            directory = null;
            String path = this._getPath();
            try {
                directory = this._getDirectory(path);
            }
            catch (IOException iOException) {
                if (directory == null) break block4;
                try {
                    directory.close();
                }
                catch (Exception exception) {}
            }
        }
        return directory;
    }

    private Directory _getLuceneDirJdbc() {
        JdbcDirectory jdbcDirectory = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            String tableName = this._getTableName();
            jdbcDirectory = (JdbcDirectory)this._jdbcDirectories.get(tableName);
            if (jdbcDirectory != null) {
                JdbcDirectory jdbcDirectory2 = jdbcDirectory;
                return jdbcDirectory2;
            }
            try {
                DataSource dataSource = InfrastructureUtil.getDataSource();
                jdbcDirectory = new JdbcDirectory(dataSource, this._dialect, tableName);
                this._jdbcDirectories.put(tableName, (Directory)jdbcDirectory);
                if (!jdbcDirectory.tableExists()) {
                    jdbcDirectory.create();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Database doesn't support the ability to check whether a table exists");
                }
                this._manuallyCreateJdbcDirectory(jdbcDirectory, tableName);
            }
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
        return jdbcDirectory;
    }

    private Directory _getLuceneDirRam() {
        String path = this._getPath();
        Directory directory = this._ramDirectories.get(path);
        if (directory == null) {
            directory = new RAMDirectory();
            this._ramDirectories.put(path, directory);
        }
        return directory;
    }

    private String _getPath() {
        return PropsValues.LUCENE_DIR.concat(String.valueOf(this._companyId)).concat("/");
    }

    private String _getTableName() {
        return _LUCENE_TABLE_PREFIX + this._companyId;
    }

    private void _initCommitScheduler() {
        if (PropsValues.LUCENE_COMMIT_BATCH_SIZE <= 0 || PropsValues.LUCENE_COMMIT_TIME_INTERVAL <= 0) {
            return;
        }
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    IndexAccessorImpl.this._doCommit();
                }
                catch (IOException ioe) {
                    _log.error((Object)"Could not run scheduled commit", (Throwable)ioe);
                }
            }
        };
        scheduledExecutorService.scheduleWithFixedDelay(runnable, 0L, PropsValues.LUCENE_COMMIT_TIME_INTERVAL, TimeUnit.MILLISECONDS);
    }

    private void _initDialect() {
        block12: {
            if (!PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_JDBC)) {
                return;
            }
            Connection con = null;
            try {
                try {
                    con = DataAccess.getConnection();
                    String url = con.getMetaData().getURL();
                    int x = url.indexOf(58);
                    int y = url.indexOf(58, x + 1);
                    String urlPrefix = url.substring(x + 1, y);
                    String dialectClass = PropsUtil.get("lucene.store.jdbc.dialect." + urlPrefix);
                    if (dialectClass != null) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("JDBC class implementation " + dialectClass));
                        }
                    } else if (_log.isDebugEnabled()) {
                        _log.debug((Object)"JDBC class implementation is null");
                    }
                    if (dialectClass != null) {
                        this._dialect = (Dialect)Class.forName(dialectClass).newInstance();
                    }
                }
                catch (Exception e) {
                    _log.error((Throwable)e);
                    DataAccess.cleanUp((Connection)con);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con);
        }
        if (this._dialect == null) {
            _log.error((Object)"No JDBC dialect found");
        }
    }

    private void _initIndexWriter() {
        try {
            this._indexWriter = new IndexWriter(this.getLuceneDir(), LuceneHelperUtil.getAnalyzer(), IndexWriter.MaxFieldLength.LIMITED);
            this._indexWriter.setMergeFactor(PropsValues.LUCENE_MERGE_FACTOR);
            this._indexWriter.setRAMBufferSizeMB((double)PropsValues.LUCENE_BUFFER_SIZE);
        }
        catch (Exception e) {
            _log.error((Object)("Initializing Lucene writer failed for " + this._companyId), (Throwable)e);
        }
    }

    private void _manuallyCreateJdbcDirectory(JdbcDirectory jdbcDirectory, String tableName) {
        block8: {
            ResultSet rs;
            Connection con;
            block7: {
                con = null;
                rs = null;
                try {
                    try {
                        con = DataAccess.getConnection();
                        DatabaseMetaData metaData = con.getMetaData();
                        rs = metaData.getTables(null, null, tableName, null);
                        if (rs.next()) break block7;
                        JdbcTemplate jdbcTemplate = jdbcDirectory.getJdbcTemplate();
                        jdbcTemplate.executeUpdate(jdbcDirectory.getTable().sqlCreate());
                        Class lockClass = jdbcDirectory.getSettings().getLockClass();
                        JdbcLock jdbcLock = null;
                        try {
                            jdbcLock = (JdbcLock)lockClass.newInstance();
                        }
                        catch (Exception exception) {
                            throw new JdbcStoreException("Could not create lock class " + lockClass);
                        }
                        jdbcLock.initializeDatabase(jdbcDirectory);
                    }
                    catch (Exception exception) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Could not create " + tableName));
                        }
                        DataAccess.cleanUp((Connection)con, null, rs);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DataAccess.cleanUp((Connection)con, null, rs);
                    throw throwable;
                }
            }
            DataAccess.cleanUp((Connection)con, null, (ResultSet)rs);
        }
    }

    private void _write(Term term, Document document) throws IOException {
        try {
            if (term != null) {
                this._indexWriter.updateDocument(term, document);
            } else {
                this._indexWriter.addDocument(document);
            }
            ++this._optimizeCount;
            if (PropsValues.LUCENE_OPTIMIZE_INTERVAL == 0 || this._optimizeCount >= PropsValues.LUCENE_OPTIMIZE_INTERVAL) {
                this._indexWriter.optimize();
                this._optimizeCount = 0;
            }
            ++this._batchCount;
        }
        finally {
            this._commit();
        }
    }
}

