/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.proxy;

import com.liferay.portal.kernel.messaging.proxy.BaseProxyBean;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.messaging.proxy.ProxyResponse;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationSynchronousMessageSender;
import com.liferay.util.aspectj.AspectJUtil;
import org.aspectj.lang.ProceedingJoinPoint;

public class MessagingProxyAdvice {
    public Object invoke(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        ProxyRequest proxyRequest = this.createProxyRequest(proceedingJoinPoint);
        BaseProxyBean baseProxyBean = (BaseProxyBean)proceedingJoinPoint.getTarget();
        if (proxyRequest.isSynchronous()) {
            return this.doInvokeSynchronous(proxyRequest, baseProxyBean);
        }
        this.doInvokeAsynchronous(proxyRequest, baseProxyBean);
        return null;
    }

    protected ProxyRequest createProxyRequest(ProceedingJoinPoint proceedingJoinPoint) throws Exception {
        return new ProxyRequest(AspectJUtil.getMethod((ProceedingJoinPoint)proceedingJoinPoint), proceedingJoinPoint.getArgs());
    }

    protected void doInvokeAsynchronous(ProxyRequest proxyRequest, BaseProxyBean baseProxyBean) {
        SingleDestinationMessageSender messageSender = baseProxyBean.getSingleDestinationMessageSender();
        if (messageSender == null) {
            throw new IllegalStateException("Asynchronous message sender was not configured properly for " + baseProxyBean.getClass().getName());
        }
        messageSender.send((Object)proxyRequest);
    }

    protected Object doInvokeSynchronous(ProxyRequest proxyRequest, BaseProxyBean baseProxyBean) throws Exception {
        SingleDestinationSynchronousMessageSender messageSender = baseProxyBean.getSingleDestinationSynchronousMessageSender();
        if (messageSender == null) {
            throw new IllegalStateException("Synchronous message sender was not configured properly for " + baseProxyBean.getClass().getName());
        }
        ProxyResponse proxyResponse = (ProxyResponse)messageSender.send((Object)proxyRequest);
        if (proxyResponse == null) {
            return null;
        }
        if (proxyResponse.hasError()) {
            throw proxyResponse.getException();
        }
        return proxyResponse.getResult();
    }
}

