/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.language.LanguageWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletConfigFactoryUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

public class LanguageImpl
implements Language {
    private static Log _log = LogFactoryUtil.getLog(LanguageImpl.class);
    private static Map<Long, LanguageImpl> _instances = new ConcurrentHashMap<Long, LanguageImpl>();
    private Map<String, String> _charEncodings;
    private Set<String> _duplicateLanguageCodes;
    private Locale[] _locales;
    private Map<String, Locale> _localesMap;
    private Set<Locale> _localesSet;

    public String format(Locale locale, String pattern, Object argument) {
        return this.format(locale, pattern, new Object[]{argument}, true);
    }

    public String format(Locale locale, String pattern, Object argument, boolean translateArguments) {
        return this.format(locale, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(Locale locale, String pattern, Object[] arguments) {
        return this.format(locale, pattern, arguments, true);
    }

    public String format(Locale locale, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block5: {
            value = null;
            try {
                pattern = this.get(locale, pattern);
                if (arguments != null) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    int i = 0;
                    while (i < arguments.length) {
                        formattedArguments[i] = translateArguments ? this.get(locale, arguments[i].toString()) : arguments[i];
                        ++i;
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String format(PageContext pageContext, String pattern, Object argument) {
        return this.format(pageContext, pattern, new Object[]{argument}, true);
    }

    public String format(PageContext pageContext, String pattern, Object argument, boolean translateArguments) {
        return this.format(pageContext, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(PageContext pageContext, String pattern, Object[] arguments) {
        return this.format(pageContext, pattern, arguments, true);
    }

    public String format(PageContext pageContext, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block5: {
            value = null;
            try {
                pattern = this.get(pageContext, pattern);
                if (arguments != null) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    int i = 0;
                    while (i < arguments.length) {
                        formattedArguments[i] = translateArguments ? this.get(pageContext, arguments[i].toString()) : arguments[i];
                        ++i;
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String format(PageContext pageContext, String pattern, LanguageWrapper argument) {
        return this.format(pageContext, pattern, new LanguageWrapper[]{argument}, true);
    }

    public String format(PageContext pageContext, String pattern, LanguageWrapper argument, boolean translateArguments) {
        return this.format(pageContext, pattern, new LanguageWrapper[]{argument}, translateArguments);
    }

    public String format(PageContext pageContext, String pattern, LanguageWrapper[] arguments) {
        return this.format(pageContext, pattern, arguments, true);
    }

    public String format(PageContext pageContext, String pattern, LanguageWrapper[] arguments, boolean translateArguments) {
        String value;
        block5: {
            value = null;
            try {
                pattern = this.get(pageContext, pattern);
                if (arguments != null) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    int i = 0;
                    while (i < arguments.length) {
                        formattedArguments[i] = translateArguments ? String.valueOf(arguments[i].getBefore()) + this.get(pageContext, arguments[i].getText()) + arguments[i].getAfter() : String.valueOf(arguments[i].getBefore()) + arguments[i].getText() + arguments[i].getAfter();
                        ++i;
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String format(PortletConfig portletConfig, Locale locale, String pattern, Object argument) {
        return this.format(portletConfig, locale, pattern, new Object[]{argument}, true);
    }

    public String format(PortletConfig portletConfig, Locale locale, String pattern, Object argument, boolean translateArguments) {
        return this.format(portletConfig, locale, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(PortletConfig portletConfig, Locale locale, String pattern, Object[] arguments) {
        return this.format(portletConfig, locale, pattern, arguments, true);
    }

    public String format(PortletConfig portletConfig, Locale locale, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block5: {
            value = null;
            try {
                pattern = this.get(portletConfig, locale, pattern);
                if (arguments != null) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    int i = 0;
                    while (i < arguments.length) {
                        formattedArguments[i] = translateArguments ? this.get(locale, arguments[i].toString()) : arguments[i];
                        ++i;
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public void init() {
        _instances.clear();
    }

    public String get(Locale locale, String key) {
        return this.get(locale, key, key);
    }

    public String get(Locale locale, String key, String defaultValue) {
        try {
            return this._get(null, null, locale, key, defaultValue);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return defaultValue;
        }
    }

    public String get(PageContext pageContext, String key) {
        return this.get(pageContext, key, key);
    }

    public String get(PageContext pageContext, String key, String defaultValue) {
        try {
            return this._get(pageContext, null, null, key, defaultValue);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return defaultValue;
        }
    }

    public String get(PortletConfig portletConfig, Locale locale, String key) {
        return this.get(portletConfig, locale, key, key);
    }

    public String get(PortletConfig portletConfig, Locale locale, String key, String defaultValue) {
        try {
            return this._get(null, portletConfig, locale, key, defaultValue);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return defaultValue;
        }
    }

    public Locale[] getAvailableLocales() {
        return LanguageImpl._getInstance()._locales;
    }

    public String getCharset(Locale locale) {
        return LanguageImpl._getInstance()._getCharset(locale);
    }

    public String getLanguageId(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.getLanguageId(request);
    }

    public String getLanguageId(HttpServletRequest request) {
        String languageId = ParamUtil.getString((HttpServletRequest)request, (String)"languageId");
        if (Validator.isNotNull((String)languageId) && (this._localesMap.containsKey(languageId) || this._charEncodings.containsKey(languageId))) {
            return languageId;
        }
        Locale locale = PortalUtil.getLocale((HttpServletRequest)request);
        return this.getLanguageId(locale);
    }

    public String getLanguageId(Locale locale) {
        return LocaleUtil.toLanguageId((Locale)locale);
    }

    public Locale getLocale(String languageCode) {
        return LanguageImpl._getInstance()._getLocale(languageCode);
    }

    public String getTimeDescription(PageContext pageContext, Long milliseconds) {
        return this.getTimeDescription(pageContext, (long)milliseconds);
    }

    public String getTimeDescription(PageContext pageContext, long milliseconds) {
        String value;
        block2: {
            String desc = Time.getDescription((long)milliseconds);
            value = null;
            try {
                int pos = desc.indexOf(32);
                int x = GetterUtil.getInteger((String)desc.substring(0, pos));
                value = String.valueOf(x) + " " + this.get(pageContext, desc.substring(pos + 1, desc.length()).toLowerCase());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public boolean isAvailableLocale(Locale locale) {
        return LanguageImpl._getInstance()._localesSet.contains(locale);
    }

    public boolean isDuplicateLanguageCode(String languageCode) {
        return LanguageImpl._getInstance()._duplicateLanguageCodes.contains(languageCode);
    }

    public void resetAvailableLocales(long companyId) {
        this._resetAvailableLocales(companyId);
    }

    public void updateCookie(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        Cookie languageIdCookie = new Cookie("GUEST_LANGUAGE_ID", languageId);
        languageIdCookie.setPath("/");
        languageIdCookie.setMaxAge(31536000);
        CookieKeys.addCookie(request, response, languageIdCookie);
    }

    private static LanguageImpl _getInstance() {
        long companyId = CompanyThreadLocal.getCompanyId();
        LanguageImpl instance = _instances.get(companyId);
        if (instance == null) {
            instance = new LanguageImpl(companyId);
            _instances.put(companyId, instance);
        }
        return instance;
    }

    private LanguageImpl() {
        this(0L);
    }

    private LanguageImpl(long companyId) {
        String[] localesArray = PropsValues.LOCALES;
        if (companyId != 0L) {
            try {
                localesArray = PrefsPropsUtil.getStringArray(companyId, "locales", ",", PropsValues.LOCALES);
            }
            catch (SystemException systemException) {
                localesArray = PropsValues.LOCALES;
            }
        }
        this._charEncodings = new HashMap<String, String>();
        this._duplicateLanguageCodes = new HashSet<String>();
        this._locales = new Locale[localesArray.length];
        this._localesMap = new HashMap<String, Locale>(localesArray.length);
        this._localesSet = new HashSet<Locale>(localesArray.length);
        int i = 0;
        while (i < localesArray.length) {
            String languageId = localesArray[i];
            int pos = languageId.indexOf(95);
            String language = languageId.substring(0, pos);
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            this._charEncodings.put(locale.toString(), "UTF-8");
            if (this._localesMap.containsKey(language)) {
                this._duplicateLanguageCodes.add(language);
            }
            this._locales[i] = locale;
            if (!this._localesMap.containsKey(language)) {
                this._localesMap.put(language, locale);
            }
            this._localesSet.add(locale);
            ++i;
        }
    }

    private String _escapePattern(String pattern) {
        return StringUtil.replace((String)pattern, (String)"'", (String)"''");
    }

    private String _get(PageContext pageContext, PortletConfig portletConfig, Locale locale, String key, String defaultValue) throws Exception {
        int pos;
        if (key == null) {
            return null;
        }
        String value = null;
        if (pageContext != null) {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            locale = themeDisplay.getLocale();
            portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        }
        if (portletConfig != null) {
            ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
            try {
                value = resourceBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
            if ((value == null || value.equals(defaultValue)) && portletConfig.getPortletName().equals("86")) {
                try {
                    value = this._getPortletConfigurationValue(pageContext, locale, key);
                }
                catch (MissingResourceException missingResourceException) {}
            }
        }
        if (value == null || value.equals(defaultValue)) {
            value = LanguageResources.getMessage(locale, key);
        }
        if ((value == null || value.equals(defaultValue)) && key.endsWith("]") && (pos = key.lastIndexOf(91)) != -1) {
            key = key.substring(0, pos);
            return this._get(pageContext, portletConfig, locale, key, defaultValue);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private String _getCharset(Locale locale) {
        return "UTF-8";
    }

    private Locale _getLocale(String languageCode) {
        return this._localesMap.get(languageCode);
    }

    private String _getPortletConfigurationValue(PageContext pageContext, Locale locale, String key) throws Exception {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String portletResource = ParamUtil.getString((HttpServletRequest)request, (String)"portletResource");
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletResource);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)pageContext.getServletContext());
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        return resourceBundle.getString(key);
    }

    private void _resetAvailableLocales(long companyId) {
        _instances.remove(companyId);
    }
}

