/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class SAPDB
extends BaseDB {
    private static String[] _SAP = new String[]{"##", "TRUE", "FALSE", "'1970-01-01 00:00:00.000000'", "timestamp", " long byte", " boolean", " timestamp", " float", " int", " bigint", " varchar", " varchar", " varchar", "", "commit"};
    private static SAPDB _instance = new SAPDB();

    public static DB getInstance() {
        return _instance;
    }

    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        return template;
    }

    protected SAPDB() {
        super("sap");
    }

    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) {
        return null;
    }

    protected String getServerName() {
        return "sap";
    }

    protected String[] getTemplate() {
        return _SAP;
    }

    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBundler sb = new StringBundler();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.startsWith(ALTER_COLUMN_NAME)) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"rename column @table@.@old-column@ to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ modify @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

