/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDB
extends BaseDB {
    private static String[] _ORACLE = new String[]{"--", "1", "0", "to_date('1970-01-01 00:00:00','YYYY-MM-DD HH24:MI:SS')", "sysdate", " blob", " number(1, 0)", " timestamp", " number(30,20)", " number(30,0)", " number(30,0)", " varchar2(4000)", " clob", " varchar2", "", "commit"};
    private static final boolean _SUPPORTS_INLINE_DISTINCT = false;
    private static OracleDB _instance = new OracleDB();
    private static Pattern _varcharPattern = Pattern.compile("VARCHAR(\\(\\d+\\))");

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this._preBuildSQL(template);
        template = this._postBuildSQL(template);
        return template;
    }

    @Override
    public void buildSQLFile(String sqlDir, String fileName) throws IOException {
        String oracle = this.buildTemplate(sqlDir, fileName);
        oracle = this._preBuildSQL(oracle);
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(oracle));
        StringBundler imageSB = new StringBundler();
        StringBundler journalArticleSB = new StringBundler();
        StringBundler journalStructureSB = new StringBundler();
        StringBundler journalTemplateSB = new StringBundler();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("insert into Image")) {
                this._convertToOracleCSV(line, imageSB);
                continue;
            }
            if (line.startsWith("insert into JournalArticle (")) {
                this._convertToOracleCSV(line, journalArticleSB);
                continue;
            }
            if (line.startsWith("insert into JournalStructure (")) {
                this._convertToOracleCSV(line, journalStructureSB);
                continue;
            }
            if (!line.startsWith("insert into JournalTemplate (")) continue;
            this._convertToOracleCSV(line, journalTemplateSB);
        }
        unsyncBufferedReader.close();
        if (imageSB.length() > 0) {
            FileUtil.write((String)(String.valueOf(sqlDir) + "/" + fileName + "/" + fileName + "-oracle-image.csv"), (String)imageSB.toString());
        }
        if (journalArticleSB.length() > 0) {
            FileUtil.write((String)(String.valueOf(sqlDir) + "/" + fileName + "/" + fileName + "-oracle-journalarticle.csv"), (String)journalArticleSB.toString());
        }
        if (journalStructureSB.length() > 0) {
            FileUtil.write((String)(String.valueOf(sqlDir) + "/" + fileName + "/" + fileName + "-oracle-journalstructure.csv"), (String)journalStructureSB.toString());
        }
        if (journalTemplateSB.length() > 0) {
            FileUtil.write((String)(String.valueOf(sqlDir) + "/" + fileName + "/" + fileName + "-oracle-journaltemplate.csv"), (String)journalTemplateSB.toString());
        }
        oracle = this._postBuildSQL(oracle);
        FileUtil.write((String)(String.valueOf(sqlDir) + "/" + fileName + "/" + fileName + "-oracle.sql"), (String)oracle);
    }

    @Override
    public List<Index> getIndexes() throws SQLException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler(3);
            sb.append("select index_name, table_name, uniqueness from ");
            sb.append("user_indexes where index_name like 'LIFERAY_%' or ");
            sb.append("index_name like 'IX_%'");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("index_name");
                String tableName = rs.getString("table_name");
                String uniqueness = rs.getString("uniqueness");
                boolean unique = true;
                if (uniqueness.equalsIgnoreCase("NONUNIQUE")) {
                    unique = false;
                }
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return indexes;
    }

    @Override
    public boolean isSupportsInlineDistinct() {
        return false;
    }

    protected OracleDB() {
        super("oracle");
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBundler sb = new StringBundler(13);
        sb.append("drop user &1 cascade;\n");
        sb.append("create user &1 identified by &2;\n");
        sb.append("grant connect,resource to &1;\n");
        sb.append("connect &1/&2;\n");
        sb.append("set define off;\n");
        sb.append("\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/portal" + suffix + "/portal" + suffix + "-oracle.sql"));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/indexes/indexes-oracle.sql"));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/sequences/sequences-oracle.sql"));
        sb.append("\n");
        sb.append("quit");
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "oracle";
    }

    @Override
    protected String[] getTemplate() {
        return _ORACLE;
    }

    @Override
    protected String replaceTemplate(String template, String[] actual) {
        Matcher matcher = _varcharPattern.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int size = GetterUtil.getInteger((String)matcher.group()) * 4;
            if (size > 4000) {
                size = 4000;
            }
            matcher.appendReplacement(sb, "VARCHAR(" + size + ")");
        }
        matcher.appendTail(sb);
        template = sb.toString();
        return super.replaceTemplate(template, actual);
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBundler sb = new StringBundler();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.startsWith(ALTER_COLUMN_NAME)) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"alter table @table@ rename column @old-column@ to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ modify @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.indexOf(DROP_INDEX) != -1) {
                String[] tokens = StringUtil.split((String)line, (String)" ");
                line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }

    private void _convertToOracleCSV(String line, StringBundler sb) {
        int x = line.indexOf("values (");
        int y = line.lastIndexOf(");");
        line = line.substring(x + 8, y);
        line = StringUtil.replace((String)line, (String)"sysdate, ", (String)"20050101, ");
        sb.append(line);
        sb.append("\n");
    }

    private String _preBuildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String[])new String[]{"\\\\", "\\'", "\\\""}, (String[])new String[]{"\\", "''", "\""});
        return template;
    }

    private String _postBuildSQL(String template) throws IOException {
        template = this.removeLongInserts(template);
        template = StringUtil.replace((String)template, (String)"\\n", (String)"'||CHR(10)||'");
        return template;
    }
}

