/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;

public class FileVersionVersionComparator
extends OrderByComparator {
    public static String ORDER_BY_ASC = "version ASC";
    public static String ORDER_BY_DESC = "version DESC";
    public static String[] ORDER_BY_FIELDS = new String[]{"version"};
    private boolean _ascending;

    public FileVersionVersionComparator() {
        this(false);
    }

    public FileVersionVersionComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(Object obj1, Object obj2) {
        DLFileVersion fileVersion1 = (DLFileVersion)obj1;
        DLFileVersion fileVersion2 = (DLFileVersion)obj2;
        int value = 0;
        int[] versionParts1 = StringUtil.split(fileVersion1.getVersion(), ".", 0);
        int[] versionParts2 = StringUtil.split(fileVersion2.getVersion(), ".", 0);
        if (versionParts1.length != 2 && versionParts2.length != 2) {
            value = 0;
        } else if (versionParts1.length != 2) {
            value = -1;
        } else if (versionParts2.length != 2) {
            value = 1;
        } else if (versionParts1[0] > versionParts2[0]) {
            value = 1;
        } else if (versionParts1[0] < versionParts2[0]) {
            value = -1;
        } else if (versionParts1[1] > versionParts2[1]) {
            value = 1;
        } else if (versionParts1[1] < versionParts2[1]) {
            value = -1;
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

