/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.util;

import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.data.DataLanguage;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.cache.factories.GenericResourceCacheEntryFactory;
import org.gcube.application.framework.core.genericresources.model.ISGenericResource;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.PresentableFieldInfo;
import org.gcube.application.framework.search.library.model.SearchableFieldInfo;
import org.gcube.application.framework.search.library.util.ArraysComparison;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FindFieldsInfo {
    public static final String ALL = "ALL";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String LOCAL_EXCLUDED_FIELDS_PROP_FILEPATH = "/excluded_fields.properties";
    public static final String CATALINA_EXCLUDED_FIELDS_PROP_FILEPATH = String.valueOf(System.getProperty("catalina.base")) + "/conf" + "/excluded_fields.properties";
    public static final String EXCLUDED_BROWSABLE_FIELD_NAMES_PROP = "excluded_browsable_field_names";
    private static final Logger logger = LoggerFactory.getLogger(FindFieldsInfo.class);
    public static final DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
    public static List<String> excludedBrowsableFieldNames = new ArrayList<String>();

    static {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = new FileInputStream(CATALINA_EXCLUDED_FIELDS_PROP_FILEPATH);
            props.load(in);
        }
        catch (Exception e) {
            logger.debug("Couldn't access property file " + CATALINA_EXCLUDED_FIELDS_PROP_FILEPATH + ", parsing local file " + LOCAL_EXCLUDED_FIELDS_PROP_FILEPATH);
            in = FindFieldsInfo.class.getResourceAsStream(LOCAL_EXCLUDED_FIELDS_PROP_FILEPATH);
            try {
                props.load(in);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (props.getProperty(EXCLUDED_BROWSABLE_FIELD_NAMES_PROP) != null) {
            excludedBrowsableFieldNames = Arrays.asList(props.getProperty(EXCLUDED_BROWSABLE_FIELD_NAMES_PROP).split(","));
        }
        int i = 0;
        while (i < excludedBrowsableFieldNames.size()) {
            excludedBrowsableFieldNames.set(i, excludedBrowsableFieldNames.get(i).trim());
            ++i;
        }
        logger.debug("Excluding " + excludedBrowsableFieldNames.size() + " browsable fields");
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HashMap<CollectionInfo, ArrayList<CollectionInfo>> joinDynamicAndStaticConfiguration(String scope, boolean refresh) throws InitialBridgingNotCompleteException, InternalErrorException {
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> collectionHierarchy = new HashMap<CollectionInfo, ArrayList<CollectionInfo>>();
        ArrayList<CollectionInfo> allCollections = FindFieldsInfo.retrieveCollectionsFieldsInfos(scope);
        if (allCollections == null || allCollections.size() == 0) {
            logger.debug("No available collections returned from Registry!");
            return collectionHierarchy;
        }
        try {
            HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = FindFieldsInfo.retrieveCollectionsInformation(scope, allCollections, refresh);
            colHierarchy = ArraysComparison.getSortedHashMap(colHierarchy);
            return colHierarchy;
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            return null;
        }
    }

    public static ArrayList<CollectionInfo> retrieveCollectionsFieldsInfos(String scope) throws InitialBridgingNotCompleteException, InternalErrorException {
        try {
            logger.debug("Bridging is about to start...");
            ResourceRegistry.startBridging();
        }
        catch (ResourceRegistryException e1) {
            logger.error("Exception:", (Throwable)e1);
            throw new InternalErrorException(e1.getCause());
        }
        List flds = null;
        try {
            flds = DataCollection.getCollectionsOfScope((boolean)true, (String)scope);
            logger.debug("Got " + flds.size() + " collections for scope " + scope + " from registy");
            String parentScope = new ScopeBean(scope).enclosingScope().toString();
            Map allSearchable = QueryHelper.getAllSearchableCollections((String)parentScope);
            Set allSearchableIDs = allSearchable.keySet();
            logger.debug("Got " + allSearchableIDs.size() + " surely searchable fields. Doing an intersection...");
            Iterator iter = flds.iterator();
            while (iter.hasNext()) {
                DataCollection dc = (DataCollection)iter.next();
                if (allSearchableIDs.contains(dc.getID())) continue;
                iter.remove();
            }
        }
        catch (ResourceRegistryException e1) {
            try {
                logger.error("Exception:", (Throwable)e1);
                if (!ResourceRegistry.isInitialBridgingComplete()) {
                    throw new InitialBridgingNotCompleteException(e1.getCause());
                }
                throw new InternalErrorException(e1.getCause());
            }
            catch (ResourceRegistryException rre) {
                logger.error("Exception:", (Throwable)rre);
                throw new InternalErrorException(rre.getCause());
            }
        }
        ArrayList<CollectionInfo> colInfos = new ArrayList<CollectionInfo>();
        logger.debug("Finding collection infos - number of collections: " + flds.size());
        int c = 0;
        while (c < flds.size()) {
            block33: {
                block32: {
                    DataCollection myCollection = (DataCollection)flds.get(c);
                    boolean fts = false;
                    boolean geospatial = false;
                    boolean searchable = true;
                    boolean language = false;
                    boolean sortable = false;
                    String ftsId = "";
                    Vector languages = new Vector();
                    logger.debug("******************************************** START PROCEDURE *******************************" + c);
                    logger.debug("Name of collection: " + myCollection.getName() + " id: " + myCollection.getID());
                    try {
                        HashSet<String> capabilities = new HashSet<String>();
                        capabilities.add("=");
                        capabilities.add("=");
                        logger.debug("Trying to find searchable fields- id: " + myCollection.getID());
                        List fs = Field.getSearchableFieldsOfCollectionByCapabilities((boolean)true, (String)myCollection.getID(), capabilities);
                        logger.debug("Finding Field Infos - number of searchable fields: " + fs.size());
                        ArrayList<org.gcube.application.framework.search.library.model.Field> fields = new ArrayList<org.gcube.application.framework.search.library.model.Field>();
                        int i = 0;
                        while (i < fs.size()) {
                            sortable = false;
                            logger.debug("Name of Field: " + ((Field)fs.get(i)).getName());
                            org.gcube.application.framework.search.library.model.Field inField = new org.gcube.application.framework.search.library.model.Field();
                            inField.setDescription(((Field)fs.get(i)).getDescription());
                            inField.setId(((Field)fs.get(i)).getID());
                            inField.setLabel(((Field)fs.get(i)).getName());
                            inField.setName(((Field)fs.get(i)).getName());
                            if (((Field)fs.get(i)).getName().equals("allIndexes")) {
                                ftsId = ((Field)fs.get(i)).getID();
                                logger.debug(": " + ((Field)fs.get(i)).getID());
                                inField.setName("Any");
                                fts = true;
                            }
                            Set searchables = ((Field)fs.get(i)).getSearchables();
                            for (Searchable se : searchables) {
                                SearchableFieldInfo sfi = new SearchableFieldInfo();
                                sfi.setCollectionId(se.getCollection());
                                sfi.setFieldName(se.getField());
                                sfi.setId(se.getID());
                                sfi.setSortable(se.isOrder());
                                Set caps = se.getCapabilities();
                                sfi.setIndexCapabilities(caps);
                                inField.addSearchable(sfi);
                                if (!sfi.getCollectionId().equals(((Field)fs.get(i)).getID()) || !sfi.isSortable()) continue;
                                sortable = true;
                            }
                            Set presentables = ((Field)fs.get(i)).getPresentables();
                            for (Presentable pr : presentables) {
                                PresentableFieldInfo pfi = new PresentableFieldInfo();
                                pfi.setCollectionId(pr.getCollection());
                                pfi.setFieldName(pr.getField());
                                pfi.setId(pr.getID());
                                pfi.setSortable(pr.isOrder());
                                Set pres = pr.getPresentationInfo();
                                pfi.setPresentationInfo(pres);
                                inField.addPresentable(pfi);
                            }
                            inField.setSearchable(searchable);
                            inField.setSortable(sortable);
                            ArrayList<String> commonCaps = new ArrayList<String>();
                            if (inField.getSearchableFields() != null && inField.getSearchableFields().size() > 0) {
                                commonCaps.addAll(inField.getSearchableFields().get(0).getIndexCapabilities());
                            }
                            ArrayList<String> duplicated = commonCaps;
                            int s = 1;
                            while (s < inField.getSearchableFields().size()) {
                                int cc = 0;
                                while (cc < commonCaps.size()) {
                                    if (!inField.getSearchableFields().get(s).getIndexCapabilities().contains(commonCaps.get(cc)) && duplicated.contains(commonCaps.get(cc))) {
                                        int ind = commonCaps.indexOf(commonCaps.get(cc));
                                        duplicated.remove(ind);
                                    }
                                    ++cc;
                                }
                                ++s;
                            }
                            commonCaps = duplicated;
                            inField.setIndexCapabilities(commonCaps);
                            fields.add(inField);
                            ++i;
                        }
                        capabilities = new HashSet();
                        capabilities.add("geosearch");
                        logger.debug("Trying to find Geo relation- id: " + myCollection.getID());
                        List geoF = Field.getSearchableFieldsOfCollectionByCapabilities((boolean)true, (String)myCollection.getID(), capabilities);
                        org.gcube.application.framework.search.library.model.Field geoField = new org.gcube.application.framework.search.library.model.Field();
                        if (geoF != null && geoF.size() != 0) {
                            language = true;
                            geospatial = true;
                            geoField.setId(((Field)geoF.get(0)).getID());
                            geoField.setDescription(((Field)geoF.get(0)).getDescription());
                            geoField.setLabel(((Field)geoF.get(0)).getName());
                            geoField.setName(((Field)geoF.get(0)).getName());
                        } else {
                            logger.debug("No geo!- id: " + myCollection.getID());
                        }
                        ArrayList<String> allLanguages = new ArrayList<String>();
                        logger.debug("getting languages - id: " + myCollection.getID());
                        logger.debug(myCollection.getID());
                        DataLanguage dataLanguage = DataLanguage.getLanguages((String)myCollection.getID());
                        if (dataLanguage != null) {
                            logger.debug("dataLangs " + myCollection.getName());
                            HashMap fieldLanguages = dataLanguage.getFieldLanguages();
                            logger.debug("Number of languages: " + fieldLanguages.size() + " " + myCollection.getName() + " " + fields.size());
                            for (String fl : fieldLanguages.keySet()) {
                                logger.debug("KeyIs: " + fl + " " + myCollection.getName());
                            }
                            int i2 = 0;
                            while (i2 < fields.size()) {
                                Set langs = (Set)fieldLanguages.get(((org.gcube.application.framework.search.library.model.Field)fields.get(i2)).getId());
                                if (langs != null) {
                                    logger.debug("field langs: " + langs.size() + " " + ((org.gcube.application.framework.search.library.model.Field)fields.get(i2)).getId() + myCollection.getName());
                                    for (Object lang : langs) {
                                        ((org.gcube.application.framework.search.library.model.Field)fields.get(i2)).addLanguage((String)lang);
                                        if (allLanguages.contains(lang)) continue;
                                        allLanguages.add((String)lang);
                                    }
                                } else {
                                    logger.debug("field langs NO " + ((org.gcube.application.framework.search.library.model.Field)fields.get(i2)).getId() + myCollection.getName());
                                }
                                ++i2;
                            }
                            Set langs = (Set)fieldLanguages.get(geoField.getId());
                            if (langs != null) {
                                Object lang;
                                lang = langs.iterator();
                                while (lang.hasNext()) {
                                    String lang2 = (String)lang.next();
                                    geoField.addLanguage(lang2);
                                    if (allLanguages.contains(lang2)) continue;
                                    allLanguages.add(lang2);
                                }
                            }
                            language = true;
                        } else {
                            logger.debug("DataLanguages map is null! " + myCollection.getID());
                        }
                        logger.debug("Trying to find Presentation Fields - id: " + myCollection.getID());
                        List prFs = Field.getPresentableFieldsOfCollection((boolean)true, (String)myCollection.getID());
                        logger.debug("Finding Presentation Field infor - number of presentation fields: " + prFs.size());
                        ArrayList<org.gcube.application.framework.search.library.model.Field> prFields = new ArrayList<org.gcube.application.framework.search.library.model.Field>();
                        int i3 = 0;
                        while (i3 < prFs.size()) {
                            logger.debug("Name of presentation field: " + ((Field)prFs.get(i3)).getName());
                            org.gcube.application.framework.search.library.model.Field inField = new org.gcube.application.framework.search.library.model.Field();
                            inField.setDescription(((Field)prFs.get(i3)).getDescription());
                            inField.setId(((Field)prFs.get(i3)).getID());
                            inField.setLabel(((Field)prFs.get(i3)).getName());
                            inField.setName(((Field)prFs.get(i3)).getName());
                            prFields.add(inField);
                            ++i3;
                        }
                        logger.debug("Trying to find browsable fields - id: " + myCollection.getID());
                        List<Field> brFs = Field.getBrowsableFieldsOfCollection((boolean)true, (String)myCollection.getID());
                        logger.debug("Number of browsable fields found: " + brFs.size());
                        brFs = FindFieldsInfo.filterOutBrowsableFields(brFs, excludedBrowsableFieldNames);
                        logger.debug("Removed the not allowed browsable fields, new number of browsable fields: " + brFs.size());
                        ArrayList<org.gcube.application.framework.search.library.model.Field> brFields = new ArrayList<org.gcube.application.framework.search.library.model.Field>();
                        int i4 = 0;
                        while (i4 < brFs.size()) {
                            logger.debug("Name of browsable field: " + brFs.get(i4).getName());
                            org.gcube.application.framework.search.library.model.Field inField = new org.gcube.application.framework.search.library.model.Field();
                            inField.setDescription(brFs.get(i4).getDescription());
                            inField.setId(brFs.get(i4).getID());
                            inField.setLabel(brFs.get(i4).getName());
                            inField.setName(brFs.get(i4).getName());
                            language = true;
                            brFields.add(inField);
                            ++i4;
                        }
                        if (!language) break block32;
                        CollectionInfo colInfo = new CollectionInfo();
                        colInfo.setCollectionGroup(false);
                        colInfo.setDescription(myCollection.getDescription());
                        colInfo.setName(myCollection.getName());
                        logger.debug("Item name: " + myCollection.getName());
                        colInfo.setId(myCollection.getID());
                        logger.debug("Item id: " + myCollection.getID());
                        colInfo.setIndices(fields);
                        logger.debug("Supports fts: " + fts);
                        colInfo.setFts(fts);
                        colInfo.setCollectionType(myCollection.getCollectionType());
                        colInfo.setGeospatial(geospatial);
                        colInfo.setLanguages(allLanguages);
                        colInfo.setPresentationFields(prFields);
                        colInfo.setBrowsableFields(brFields);
                        colInfo.setFtsId(ftsId);
                        colInfo.setGeospatialField(geoField);
                        logger.debug("Set fts id: " + ftsId);
                        logger.debug("Adding COLLECTION: " + colInfo.getName());
                        colInfos.add(colInfo);
                    }
                    catch (ResourceRegistryException e) {
                        logger.error("Exception:", (Throwable)e);
                        break block33;
                    }
                }
                logger.debug("******************************************** END PROCEDURE *******************************");
            }
            ++c;
        }
        logger.debug("Number of colINFOS: " + colInfos.size());
        return colInfos;
    }

    protected static List<Field> filterOutBrowsableFields(List<Field> initialList, List<String> notAllowedFieldNames) {
        ArrayList<Field> filteredList = new ArrayList<Field>();
        int i = 0;
        while (i < initialList.size()) {
            if (!notAllowedFieldNames.contains(initialList.get(i).getName())) {
                filteredList.add(initialList.get(i));
            }
            ++i;
        }
        return filteredList;
    }

    protected static HashMap<CollectionInfo, ArrayList<CollectionInfo>> retrieveCollectionsInformation(String vre, List<CollectionInfo> collections, boolean refresh) throws Exception {
        List scenarioSchemaInfo;
        logger.debug("About to retrieve the static configuration");
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)vre);
        query.put((Object)"name", (Object)"ScenarioCollectionInfo");
        if (refresh) {
            CachesManager.getInstance().getGenericResourceCache().remove((Serializable)query);
        }
        if ((scenarioSchemaInfo = (List)((Object)CachesManager.getInstance().getEhcache("genericResources", (CacheEntryFactory)new GenericResourceCacheEntryFactory()).get((Serializable)query).getValue())) == null || scenarioSchemaInfo.size() == 0) {
            logger.debug("The scenarioCollectionInfo is null");
            HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = new HashMap<CollectionInfo, ArrayList<CollectionInfo>>();
            return colHierarchy;
        }
        logger.debug("Printing the static configuration");
        logger.debug("scenarioSchemaInfo.size()" + scenarioSchemaInfo.size());
        for (ISGenericResource gr : scenarioSchemaInfo) {
            logger.debug("gr.getBody():" + gr.getBody());
            logger.debug("gr.getDescription():" + gr.getDescription());
            logger.debug("gr.getId():" + gr.getId());
            logger.debug("gr.getName():" + gr.getName());
            logger.debug("gr.getSecondaryType():" + gr.getSecondaryType());
        }
        logger.debug(((ISGenericResource)scenarioSchemaInfo.get(0)).getBody());
        InputSource in = new InputSource(new StringReader(((ISGenericResource)scenarioSchemaInfo.get(0)).getBody()));
        Document doc = dfactory.newDocumentBuilder().parse(in);
        FindFieldsInfo.retrieveCollections(doc, collections);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = FindFieldsInfo.retrieveCollectionHierarchy(vre, doc, collections);
        return colHierarchy;
    }

    public static String findCollectionName(String id, String scope) {
        try {
            List collections = DataCollection.getCollectionsOfScope((boolean)true, (String)scope);
            int i = 0;
            while (i < collections.size()) {
                if (((DataCollection)collections.get(i)).getID().equals(id)) {
                    return ((DataCollection)collections.get(i)).getName();
                }
                ++i;
            }
        }
        catch (ResourceRegistryException e) {
            logger.error("Exception:", (Throwable)e);
        }
        return null;
    }

    protected static void retrieveCollections(Document doc, List<CollectionInfo> collections) {
        Object colInfo;
        ArrayList<Object> availableCollections = new ArrayList<Object>();
        NodeList res = doc.getElementsByTagName("collection");
        int n = res.getLength();
        logger.debug("Retrieving Static Configuration: The number of collections is: " + n);
        int i = 0;
        while (i < n) {
            String string = res.item(i).getAttributes().getNamedItem("id").getNodeValue();
            logger.debug("The id of the collection read is: " + string);
            colInfo = null;
            colInfo = FindFieldsInfo.getCollectionInfoById(string, collections);
            if (colInfo == null) {
                logger.debug("Not available collection - omitting it");
            } else {
                logger.debug("Printing collection Information gathered: ");
                logger.debug(((CollectionInfo)colInfo).getName());
                logger.debug(((CollectionInfo)colInfo).getId());
                logger.debug("end");
                String string2 = res.item(i).getAttributes().getNamedItem("description").getNodeValue();
                ((CollectionInfo)colInfo).setDescription(string2);
                String string3 = res.item(i).getAttributes().getNamedItem("recno").getNodeValue();
                ((CollectionInfo)colInfo).setRecno(string3);
                String string4 = res.item(i).getAttributes().getNamedItem("creationDate").getNodeValue();
                ((CollectionInfo)colInfo).setCreationDate(string4);
                availableCollections.add(colInfo);
            }
            ++i;
        }
        collections.clear();
        for (CollectionInfo collectionInfo : availableCollections) {
            collections.add(collectionInfo);
        }
        res = doc.getElementsByTagName("collectionsGroup");
        logger.debug("CollectionsGroup size: " + n);
        n = res.getLength();
        i = 0;
        while (i < n) {
            colInfo = new CollectionInfo();
            try {
                String string = res.item(i).getAttributes().getNamedItem("id").getNodeValue();
                ((CollectionInfo)colInfo).setId(string);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
            }
            try {
                String string = res.item(i).getAttributes().getNamedItem("name").getNodeValue();
                ((CollectionInfo)colInfo).setName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String string = res.item(i).getAttributes().getNamedItem("description").getNodeValue();
                ((CollectionInfo)colInfo).setDescription(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((CollectionInfo)colInfo).setCollectionGroup(true);
            collections.add((CollectionInfo)colInfo);
            ++i;
        }
        logger.debug("***Number of collections:" + collections.size());
    }

    protected static HashMap<CollectionInfo, ArrayList<CollectionInfo>> retrieveCollectionHierarchy(String VREname, Document doc, List<CollectionInfo> collections) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//collectionsGroup");
        NodeList res = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        int n = res.getLength();
        logger.debug("***** number of collection groups:" + n + "*******");
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = new HashMap<CollectionInfo, ArrayList<CollectionInfo>>();
        HashMap<String, ArrayList<CollectionInfo>> groupIDsCollections = new HashMap<String, ArrayList<CollectionInfo>>();
        int i = 0;
        while (i < n) {
            String val = res.item(i).getAttributes().getNamedItem("id").getNodeValue();
            XPathExpression expr2 = xpath.compile("//collectionsGroup[@id=\"" + val + "\"]/collection");
            NodeList res2 = (NodeList)expr2.evaluate(doc, XPathConstants.NODESET);
            CollectionInfo colInfoGroup = FindFieldsInfo.getCollectionInfoById(val, collections);
            if (colInfoGroup != null) {
                int j = 0;
                while (j < res2.getLength()) {
                    CollectionInfo colInfo = FindFieldsInfo.getCollectionInfoById(res2.item(j).getAttributes().getNamedItem("id").getNodeValue(), collections);
                    if (colInfo != null) {
                        ArrayList<CollectionInfo> groupCollections = (ArrayList<CollectionInfo>)groupIDsCollections.get(colInfoGroup.getId());
                        if (groupCollections == null) {
                            groupCollections = new ArrayList<CollectionInfo>();
                        }
                        groupCollections.add(colInfo);
                        groupIDsCollections.put(colInfoGroup.getId(), groupCollections);
                    }
                    ++j;
                }
                if (groupIDsCollections.get(colInfoGroup.getId()) != null) {
                    colHierarchy.put(colInfoGroup, (ArrayList)groupIDsCollections.get(colInfoGroup.getId()));
                }
            }
            if (groupIDsCollections != null && colInfoGroup != null) {
                if (groupIDsCollections.get(colInfoGroup.getId()) != null) {
                    logger.debug("***collection group " + i + " contains " + ((ArrayList)groupIDsCollections.get(colInfoGroup.getId())).size() + " collections***");
                }
            } else {
                logger.debug("No Available Collections Returned from Registry.");
            }
            ++i;
        }
        return colHierarchy;
    }

    protected static CollectionInfo getCollectionInfoById(String colId, List<CollectionInfo> collections) {
        CollectionInfo colInfo = null;
        int n = collections.size();
        int i = 0;
        while (i < n) {
            logger.debug("*******" + collections.get(i).getId() + " vs. " + colId);
            if (collections.get(i).getId().equals(colId)) {
                colInfo = collections.get(i);
                logger.debug("***collection found****");
                break;
            }
            ++i;
        }
        return colInfo;
    }

    public static ArrayList<org.gcube.application.framework.search.library.model.Field> getCollectionPresentationFields(String colId, ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        SearchHelper sh = new SearchHelper(session);
        CollectionInfo colI = sh.findCollectionInfo(colId);
        ArrayList<org.gcube.application.framework.search.library.model.Field> fields = colI.getPresentationFields();
        return fields;
    }

    public static CollectionInfo findCollectionInfo(String colID, HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections) {
        if (collections != null) {
            for (CollectionInfo colInfo : collections.keySet()) {
                int c2 = 0;
                while (c2 < collections.get(colInfo).size()) {
                    logger.info("compare: " + collections.get(colInfo).get(c2).getId() + " with: " + colID);
                    if (collections.get(colInfo).get(c2).getId().equals(colID)) {
                        logger.info("equal!!");
                        return collections.get(colInfo).get(c2);
                    }
                    ++c2;
                }
            }
        } else {
            logger.info("No collections!!");
            return null;
        }
        logger.info("Null!!");
        return null;
    }

    public static List<CollectionInfo> searchCollectionInfo(String term, String whereToSearch, HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections) {
        term = (term = term.trim().toLowerCase()).startsWith("*") ? term.substring(1) : "(\\s|\\p{Punct})" + term;
        term = term.endsWith("*") ? term.substring(0, term.length() - 1) : String.valueOf(term) + "(\\s|\\p{Punct})";
        term = term.replaceAll("\\x2A", ".*");
        term = term.replaceAll("\\x3F", ".");
        Pattern pattern = Pattern.compile(term);
        boolean name = false;
        boolean descr = false;
        if (whereToSearch.equals(ALL)) {
            name = true;
            descr = true;
        } else if (whereToSearch.equals(NAME)) {
            name = true;
        } else if (whereToSearch.equals(DESCRIPTION)) {
            descr = true;
        }
        ArrayList<CollectionInfo> res = new ArrayList<CollectionInfo>();
        for (CollectionInfo colInfo : collections.keySet()) {
            int c2 = 0;
            while (c2 < collections.get(colInfo).size()) {
                if (name && pattern.matcher(" " + collections.get(colInfo).get(c2).getName().toLowerCase() + " ").find()) {
                    res.add(collections.get(colInfo).get(c2));
                } else if (descr && pattern.matcher(" " + collections.get(colInfo).get(c2).getDescription().toLowerCase() + " ").find()) {
                    res.add(collections.get(colInfo).get(c2));
                }
                ++c2;
            }
        }
        return res;
    }
}

