/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.model;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringEscapeUtils;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.application.framework.accesslogger.model.AdvancedSearchAccessLogEntry;
import org.gcube.application.framework.accesslogger.model.SemanticEnrichmentAccessLogEntry;
import org.gcube.application.framework.accesslogger.model.SimpleSearchAccessLogEntry;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.exception.NoSearchMasterEPRFoundException;
import org.gcube.application.framework.search.library.exception.QuerySyntaxException;
import org.gcube.application.framework.search.library.exception.ReadingUserProfileException;
import org.gcube.application.framework.search.library.exception.gRS2CreationException;
import org.gcube.application.framework.search.library.impl.ResultSetConsumer;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.interfaces.ResultSetConsumerI;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Criterion;
import org.gcube.application.framework.search.library.model.Field;
import org.gcube.application.framework.search.library.model.GeospatialInfo;
import org.gcube.application.framework.search.library.model.ISearchClient;
import org.gcube.application.framework.search.library.model.SearchASLException;
import org.gcube.application.framework.search.library.util.ArraysComparison;
import org.gcube.application.framework.search.library.util.FindFieldsInfo;
import org.gcube.application.framework.search.library.util.Operator;
import org.gcube.application.framework.search.library.util.Order;
import org.gcube.application.framework.search.library.util.Point;
import org.gcube.application.framework.search.library.util.QuerySanitizer;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.exceptions.StreamException;
import org.gcube.data.streams.exceptions.StreamOpenException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLRelation;
import search.library.util.cql.query.tree.GCQLSortNode;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.Modifier;
import search.library.util.cql.query.tree.ModifierSet;

public class Query
implements Cloneable {
    private AccessLogger accessLogger = AccessLogger.getAccessLogger();
    protected List<Field> browsableFields;
    protected List<Criterion> criteria;
    protected List<Criterion> previousCriteria;
    protected boolean distinct = false;
    protected GeospatialInfo geospatialInfo;
    protected Operator operator;
    protected Order order;
    protected String queryDescription;
    protected List<String> languages;
    protected List<Field> searchableFields;
    protected String searchType = "noSearch";
    protected List<String> selectedCollections;
    private String sortBy;
    protected ResultSetConsumerI searchRSC = null;
    protected String queryString;
    protected String genericSearchType = "noSearch";
    private static Logger logger = LoggerFactory.getLogger(Query.class);
    protected boolean setRelation;
    protected String relation;
    ArrayList<String> relationModifiers;
    ArrayList<String> indexModifiers;
    int selectedLanguage;
    private boolean semanticEnrichment = false;
    protected String browseBy;
    private String searchTerm = new String();
    private boolean ftsAvailable;
    List<Field> sortableFields;
    private GCQLNode previousQuery = null;
    private String previousQueryDescription = new String();
    public static final String ENDPOINT_KEY = "resteasy-servlet";
    private String ftsId = new String();
    Field geoField;
    boolean hasResults = true;
    ArrayList<String> selectedPresentationFields;
    ArrayList<String> searchQueryTerms;
    private long searchStartTime;
    private boolean rankingSupport = false;
    private boolean geoAvailable;

    public void setRanking(boolean rankSupport) {
        this.rankingSupport = rankSupport;
    }

    public void setHasResults(boolean existResults) {
        this.hasResults = existResults;
    }

    public boolean hasResults() {
        return this.hasResults;
    }

    public boolean isFtsAvailable() {
        logger.debug("Supports fts? -> " + this.ftsAvailable);
        return this.ftsAvailable;
    }

    public void setFtsAvailable(boolean ftsAvailable) {
        this.ftsAvailable = ftsAvailable;
    }

    public void setSemanticEnrichment(boolean semanticEnrichment) {
        this.semanticEnrichment = semanticEnrichment;
    }

    public boolean getSemanticEnrichment() {
        return this.semanticEnrichment;
    }

    public boolean isGeoAvailable() {
        return this.geoAvailable;
    }

    public void setGeoAvailable(boolean geoAvailable) {
        this.geoAvailable = geoAvailable;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm.startsWith("[") && searchTerm.endsWith("]") ? "\"" + StringEscapeUtils.unescapeHtml((String)QuerySanitizer.sanitizeQuery(searchTerm)) + "\"" : searchTerm;
        logger.debug("this.searchTerm = " + this.searchTerm);
        this.searchQueryTerms.clear();
    }

    public Query() {
        this.criteria = new ArrayList<Criterion>();
        this.previousCriteria = new ArrayList<Criterion>();
        this.operator = Operator.OR;
        this.selectedCollections = new ArrayList<String>();
        this.searchableFields = new ArrayList<Field>();
        this.browsableFields = new ArrayList<Field>();
        this.languages = new ArrayList<String>();
        this.order = Order.ASC;
        this.sortableFields = new ArrayList<Field>();
        this.sortBy = new String();
        this.browseBy = new String();
        this.selectedPresentationFields = new ArrayList();
        this.searchQueryTerms = new ArrayList();
    }

    private void debugQuery() {
        logger.debug("==== Debug Query ===");
        logger.debug("Previous Criteria: ");
        for (Criterion c : this.previousCriteria) {
            logger.debug("id: " + c.getSearchFieldId() + " name: " + c.getSearchFieldName() + " value: " + c.getSearchFieldValue());
        }
        logger.debug("Current Criteria: ");
        for (Criterion c : this.criteria) {
            logger.debug("id: " + c.getSearchFieldId() + " name: " + c.getSearchFieldName() + " value: " + c.getSearchFieldValue());
        }
        logger.debug("Selected collections: ");
        for (String s : this.selectedCollections) {
            logger.debug(s);
        }
        logger.debug("Searchable Fields: ");
        for (Field f : this.searchableFields) {
            logger.debug("id: " + f.id + " label: " + f.label + " name: " + f.name + " value: " + f.value + " description: " + f.description + " datatype: " + f.dataType);
        }
        logger.debug("Browsable Fields: ");
        for (Field f : this.browsableFields) {
            logger.debug("id: " + f.id + " label: " + f.label + " name: " + f.name + " value: " + f.value + " description: " + f.description + " datatype: " + f.dataType);
        }
        logger.debug("Languages: ");
        for (String s : this.languages) {
            logger.debug(s);
        }
        logger.debug("Sortby: " + this.sortBy);
        logger.debug("Browseby: " + this.browseBy);
        logger.debug("Selected Presentation Fields: ");
        for (String s : this.selectedPresentationFields) {
            logger.debug(s);
        }
        logger.debug("Search Query Terms: ");
        for (String s : this.searchQueryTerms) {
            logger.debug(s);
        }
        logger.debug("Semantic enrichment: " + this.semanticEnrichment);
    }

    public void enableEPRCache() {
        if (CacheManager.getInstance().getCache("CachedSearchEPRs") == null) {
            logger.debug("Creating a cache for the EPRs");
            CacheManager.getInstance().addCache(new Cache("CachedSearchEPRs", 100, false, true, 60L, 60L));
        }
    }

    public void addCriterion(Criterion criterion) {
        logger.debug("adding criterion id: " + criterion.getSearchFieldId() + " and value: " + criterion.getSearchFieldValue());
        if (criterion.getSearchFieldValue().startsWith("[") && criterion.getSearchFieldValue().endsWith("]")) {
            this.criteria.add(criterion);
            criterion.setSearchFieldValue("\"" + StringEscapeUtils.unescapeHtml((String)QuerySanitizer.sanitizeQuery(criterion.getSearchFieldValue())) + "\"");
            logger.debug("Sanitized criterion added: " + criterion.getSearchFieldValue());
            return;
        }
        if (!(!criterion.getSearchFieldValue().contains(" ") || criterion.getSearchFieldValue().startsWith("\"") && criterion.getSearchFieldValue().endsWith("\""))) {
            String[] splitted = criterion.getSearchFieldValue().split(" ");
            int i = 0;
            while (i < splitted.length) {
                Criterion crit = new Criterion();
                crit.setSearchFieldId(criterion.getSearchFieldId());
                crit.setSearchFieldName(criterion.getSearchFieldName());
                crit.setSearchFieldValue(splitted[i]);
                this.criteria.add(crit);
                logger.debug("Criterion added: " + crit.getSearchFieldValue());
                ++i;
            }
            return;
        }
        logger.debug("Criterion added: " + criterion.getSearchFieldValue());
        this.criteria.add(criterion);
    }

    public void removeCriterion(int i) {
        logger.debug("Removing Criterion: {name=" + this.criteria.get(i).getSearchFieldName() + ", value=" + this.criteria.get(i).getSearchFieldValue() + "}");
        this.criteria.remove(i);
    }

    /*
     * WARNING - void declaration
     */
    public Query clone(boolean previous) {
        Query q = new Query();
        logger.debug("cloning - previous: " + previous);
        if (!previous) {
            void var3_19;
            String y;
            for (Criterion criterion : this.criteria) {
                q.criteria.add(criterion.clone());
            }
            for (String string : this.searchQueryTerms) {
                q.searchQueryTerms.add(new String(string));
            }
            for (String string : this.selectedCollections) {
                y = new String(string);
                q.selectedCollections.add(y);
            }
            for (Field field : this.searchableFields) {
                q.searchableFields.add(field.clone());
            }
            for (Field field : this.sortableFields) {
                q.sortableFields.add(field.clone());
            }
            for (Field field : this.browsableFields) {
                q.browsableFields.add(field.clone());
            }
            for (String string : this.selectedPresentationFields) {
                y = new String(string);
                q.selectedPresentationFields.add(y);
            }
            q.searchType = "noSearch";
            q.genericSearchType = "noSearch";
            q.ftsAvailable = this.ftsAvailable;
            q.geoAvailable = this.geoAvailable;
            q.semanticEnrichment = this.semanticEnrichment;
            boolean bl = false;
            while (var3_19 < this.languages.size()) {
                q.languages.add(new String(this.languages.get((int)var3_19)));
                ++var3_19;
            }
            q.selectedLanguage = this.selectedLanguage;
            this.previousQuery = null;
            this.previousQueryDescription = new String();
            q.ftsId = this.ftsId;
            q.rankingSupport = this.rankingSupport;
            if (this.geoField != null) {
                q.geoField = this.geoField.clone();
            }
        } else {
            void var3_34;
            String y;
            logger.debug("do i have criteria? : " + this.criteria.size() + " " + this.previousCriteria.size());
            for (Criterion criterion : this.criteria) {
                logger.debug(String.valueOf(criterion.getSearchFieldName()) + " " + criterion.getSearchFieldValue());
                if (criterion.getSearchFieldValue().equals("")) continue;
                q.previousCriteria.add(criterion.clone());
            }
            for (String string : this.selectedCollections) {
                y = new String(string);
                q.selectedCollections.add(y);
            }
            for (String string : this.selectedPresentationFields) {
                y = new String(string);
                q.selectedPresentationFields.add(y);
            }
            q.searchType = "previousSearch";
            q.genericSearchType = this.genericSearchType;
            if (this.searchType.equals("simpleSearch")) {
                Criterion criterion = new Criterion();
                criterion.setSearchFieldId(this.ftsId);
                criterion.setSearchFieldName("Any");
                criterion.setSearchFieldValue(this.searchTerm);
                q.previousCriteria.add(criterion);
            }
            for (Field field : this.searchableFields) {
                q.searchableFields.add(field.clone());
            }
            for (Field field : this.sortableFields) {
                q.sortableFields.add(field.clone());
            }
            for (Field field : this.browsableFields) {
                q.browsableFields.add(field.clone());
            }
            q.ftsAvailable = this.ftsAvailable;
            q.semanticEnrichment = this.semanticEnrichment;
            boolean bl = false;
            while (var3_34 < this.languages.size()) {
                q.languages.add(new String(this.languages.get((int)var3_34)));
                ++var3_34;
            }
            q.selectedLanguage = this.selectedLanguage;
            q.previousQuery = this.previousQuery;
            q.previousQueryDescription = new String(this.previousQueryDescription);
            q.ftsId = this.ftsId;
            if (this.geoField != null) {
                q.geoField = this.geoField.clone();
            }
        }
        q.distinct = this.distinct;
        if (this.geospatialInfo != null && this.geospatialInfo.getBounds() != null) {
            q.geospatialInfo = this.geospatialInfo.clone();
        }
        q.operator = this.operator;
        q.order = this.order;
        q.queryDescription = this.queryDescription;
        q.queryString = this.queryString;
        q.sortBy = new String(this.sortBy);
        q.browseBy = new String(this.browseBy);
        if (this.searchTerm != null) {
            q.searchTerm = new String(this.searchTerm);
        }
        return q;
    }

    public void setLanguage(int language) {
        this.selectedLanguage = language;
    }

    public void setPresentationFields(ArrayList<String> presentationFields) {
        this.selectedPresentationFields = presentationFields;
    }

    private void findAvailableLanguages(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        SearchHelper sh = new SearchHelper(session);
        CollectionInfo firstCol = null;
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
            ArrayList<String> allLanguages = new ArrayList<String>();
            logger.debug("Finding Available Languages");
            logger.debug("The number of selected collections is: " + this.selectedCollections.size());
            List<String> realCollections = this.getSelectedRealCollections(session);
            firstCol = sh.findCollectionInfo(realCollections.get(0));
            allLanguages.addAll(firstCol.getLanguages());
            logger.debug("initially languages are: " + allLanguages.size());
            logger.debug("Real selected Collections: " + realCollections.size());
            CollectionInfo col = null;
            int i = 1;
            while (i < realCollections.size()) {
                col = sh.findCollectionInfo(realCollections.get(i));
                ArrayList<String> colLanguages = col.getLanguages();
                int j = 0;
                while (j < firstCol.getLanguages().size()) {
                    if (!colLanguages.contains(firstCol.getLanguages().get(j))) {
                        int ind = allLanguages.indexOf(firstCol.getLanguages().get(j));
                        if (ind >= 0) {
                            allLanguages.remove(ind);
                        } else {
                            logger.debug("Element: " + firstCol.getLanguages().get(j) + "wasn't found in allLanguages collection!");
                        }
                    }
                    ++j;
                }
                ++i;
            }
            this.languages.clear();
            this.languages = allLanguages;
        } else {
            this.languages.clear();
        }
        logger.debug("Number of languages: " + this.languages.size());
    }

    private void findAvailableSearchFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        logger.debug("Find available search fields");
        if (this.selectedCollections.size() == 0 || this.selectedLanguage == -1 || this.languages.size() == 0) {
            this.searchableFields = new ArrayList<Field>();
            this.browsableFields = new ArrayList<Field>();
            logger.debug("No selected collections or no languages - returning");
            return;
        }
        SearchHelper sh = new SearchHelper(session);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = sh.getAvailableCollections();
        ArrayList<Field> searchableFields = new ArrayList<Field>();
        List<String> realCollections = this.getSelectedRealCollections(session);
        logger.debug("Number of selected real collections: " + realCollections.size());
        CollectionInfo firstCol = sh.findCollectionInfo(realCollections.get(0));
        logger.debug("Found collection - printing info: ");
        logger.debug(firstCol.getName());
        searchableFields.addAll(firstCol.getIndices());
        logger.debug("For collection: " + firstCol.getId() + " adding indices: " + searchableFields.size());
        ArrayList<Field> clone = new ArrayList<Field>();
        int i = 0;
        while (i < searchableFields.size()) {
            clone.add(((Field)searchableFields.get(i)).clone());
            ++i;
        }
        logger.debug("clone has: " + clone.size());
        i = 1;
        while (i < realCollections.size()) {
            int j = 0;
            while (j < searchableFields.size()) {
                logger.debug("Checking or field: " + ((Field)searchableFields.get(j)).getLabel() + " inside collection: " + realCollections.get(i));
                CollectionInfo colInfo = sh.findCollectionInfo(realCollections.get(i));
                boolean found = false;
                int k = 0;
                while (k < colInfo.getIndices().size()) {
                    logger.debug("Comparing fields: " + colInfo.getIndices().get(k).getId() + " " + colInfo.getIndices().get(k).getLabel() + " with " + searchableFields.get(j).getId() + " " + searchableFields.get(j).getLabel());
                    if (colInfo.getIndices().get(k).getId().equals(searchableFields.get(j).getId())) {
                        found = true;
                        logger.debug("FOUND!");
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    k = 0;
                    while (k < clone.size()) {
                        if (((Field)clone.get(k)).getId().equals(searchableFields.get(j).getId())) {
                            logger.debug("REMOVING");
                            clone.remove(k);
                            break;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        logger.debug("clone has now: " + clone.size());
        searchableFields.clear();
        i = 0;
        while (i < clone.size()) {
            ArrayList<String> langs = ((Field)clone.get(i)).getLanguages();
            logger.debug("The number of field languages is: " + langs.size());
            logger.debug("Number of languages: " + this.languages.size());
            logger.debug("Selected language: " + this.selectedLanguage);
            if (!langs.contains(this.languages.get(this.selectedLanguage))) {
                logger.debug("Adding Field");
                searchableFields.add((Field)clone.get(i));
            } else {
                logger.debug("Not adding field");
            }
            ++i;
        }
        this.searchableFields = searchableFields;
        logger.debug("Finally the number is: " + searchableFields.size());
    }

    private void findAvailableBrowseFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        logger.debug("Find available browse fields");
        if (this.selectedCollections.size() == 0 || this.selectedLanguage == -1) {
            this.searchableFields = new ArrayList<Field>();
            this.browsableFields = new ArrayList<Field>();
            return;
        }
        SearchHelper sh = new SearchHelper(session);
        ArrayList<Field> browsableFields = new ArrayList<Field>();
        List<String> realCollections = this.getSelectedRealCollections(session);
        logger.debug("Number of selected real collections: " + realCollections.size());
        CollectionInfo firstCol = sh.findCollectionInfo(realCollections.get(0));
        browsableFields.addAll(firstCol.getBrowsableFields());
        logger.debug("For collection: " + firstCol.getId() + " adding browse fields: " + browsableFields.size());
        ArrayList<Field> clone = new ArrayList<Field>();
        int i = 0;
        while (i < browsableFields.size()) {
            clone.add(((Field)browsableFields.get(i)).clone());
            ++i;
        }
        logger.debug("clone has: " + clone.size());
        i = 1;
        while (i < realCollections.size()) {
            int j = 0;
            while (j < browsableFields.size()) {
                logger.debug("Checking or field: " + ((Field)browsableFields.get(j)).getLabel() + " inside collection: " + realCollections.get(i));
                CollectionInfo colInfo = sh.findCollectionInfo(realCollections.get(i));
                boolean found = false;
                int k = 0;
                while (k < colInfo.getBrowsableFields().size()) {
                    logger.debug("Comparing fields: " + colInfo.getBrowsableFields().get(k).getId() + " " + colInfo.getBrowsableFields().get(k).getLabel() + " with " + browsableFields.get(j).getId() + " " + browsableFields.get(j).getLabel());
                    if (colInfo.getBrowsableFields().get(k).getId().equals(browsableFields.get(j).getId())) {
                        found = true;
                        logger.debug("FOUND!");
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    k = 0;
                    while (k < clone.size()) {
                        if (((Field)clone.get(k)).getId().equals(browsableFields.get(j).getId())) {
                            logger.debug("REMOVING");
                            clone.remove(k);
                            break;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        logger.debug("clone has now: " + clone.size());
        browsableFields.clear();
        browsableFields = clone;
        this.browsableFields = browsableFields;
        logger.debug("Finally the number is: " + this.browsableFields.size());
    }

    private void findAvailableSortFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        if (this.selectedCollections == null || this.selectedCollections.size() == 0) {
            this.searchableFields = new ArrayList<Field>();
            return;
        }
        session.removeAttribute("session_snippet_attr");
        session.removeAttribute("session_title_attr");
        List<String> presentables = null;
        try {
            presentables = this.findPresentableFields(session);
            logger.debug("NIK--presentablesNEWONE:");
            this.printPresentables(presentables);
            for (Field x : this.searchableFields) {
                if (!x.isSortable || !presentables.contains(x.id)) continue;
                this.sortableFields.add(x);
            }
        }
        catch (Exception e) {
            logger.error("******************************************************findpresentableFields method thrown an exception.", (Throwable)e);
        }
    }

    private void printPresentables(List<String> presentables) {
        logger.debug("Printing " + presentables.size() + " presentables");
        for (String field : presentables) {
            logger.debug(field);
        }
    }

    public List<String> getSelectedRealCollections(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        return this.getSelectedRealCollectionsAlt(session);
    }

    public List<String> getSelectedRealCollectionsAlt(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        logger.debug("Inside get selected real collections.");
        ArrayList<String> cols = new ArrayList<String>();
        SearchHelper sh = new SearchHelper(session);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> allCollections = sh.getAvailableCollections();
        Set<CollectionInfo> groups = allCollections.keySet();
        logger.debug("number of selected collections: " + this.selectedCollections.size());
        for (String a : this.selectedCollections) {
            CollectionInfo colInfo = sh.findCollectionInfo(a);
            logger.debug("Collection: " + a);
            if (a.equals("all_collections") || this.selectedCollections.contains("all_collections")) {
                logger.debug("all_collections");
                for (CollectionInfo group : groups) {
                    logger.debug("Iterrating group!: " + group.getName());
                    int i = 0;
                    while (i < allCollections.get(group).size()) {
                        cols.add(allCollections.get(group).get(i).getId());
                        ++i;
                    }
                }
                logger.debug("number of returned collections: " + cols.size());
                return cols;
            }
            if (colInfo.isCollectionGroup) {
                logger.debug("collection group");
                for (CollectionInfo group : groups) {
                    if (!group.getId().equals(colInfo.getId())) continue;
                    ArrayList<CollectionInfo> realCols = allCollections.get(group);
                    int i = 0;
                    while (i < realCols.size()) {
                        cols.add(realCols.get(i).getId());
                        ++i;
                    }
                }
                continue;
            }
            logger.debug("real collection");
            for (CollectionInfo group : groups) {
                int i = 0;
                while (i < allCollections.get(group).size()) {
                    logger.debug("Comparing: " + allCollections.get(group).get(i).getId() + " with " + a);
                    if (allCollections.get(group).get(i).getId().equals(a) && !cols.contains(a)) {
                        cols.add(a);
                    }
                    ++i;
                }
            }
        }
        logger.debug("number of returned collections: " + cols.size());
        return cols;
    }

    public List<Field> getAvailableBrowseFields() {
        return this.browsableFields;
    }

    public List<Field> getAvailableSearchFields() {
        return this.searchableFields;
    }

    public List<Field> getAvailableSortFields() {
        return this.sortableFields;
    }

    public List<String> getAvailableLanguages() {
        return this.languages;
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    public GeospatialInfo getGeosatial() {
        return this.geospatialInfo;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getQueryDescription() {
        return this.queryDescription;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public List<String> getSelectedCollections() {
        return this.selectedCollections;
    }

    public String getSelectedLanguage() {
        return this.languages.get(this.selectedLanguage);
    }

    public void reset() {
        logger.debug("Resetting query values");
        this.criteria.clear();
        this.operator = Operator.OR;
        this.order = Order.ASC;
        this.distinct = false;
        this.searchQueryTerms.clear();
    }

    public void selectCollections(List<String> newCollections, boolean selected, ASLSession session, boolean keepCriteriaAndQuery) {
        this.selectCollections(newCollections, selected, session, false, keepCriteriaAndQuery);
    }

    public void selectCollections(List<String> newCollections, boolean selected, ASLSession session) {
        this.selectCollections(newCollections, selected, session, false, false);
    }

    public void selectCollections(List<String> newCollections, boolean selected, ASLSession session, boolean replaceExistingSelectedCollections, boolean keepCriteriaQueries) {
        try {
            if (replaceExistingSelectedCollections) {
                this.selectedCollections = newCollections;
            } else {
                int i = 0;
                while (i < newCollections.size()) {
                    logger.debug("new collections:**" + newCollections.get(i) + "**");
                    if (selected && !this.selectedCollections.contains(newCollections.get(i))) {
                        logger.debug("adding:**" + newCollections.get(i) + "**");
                        this.selectedCollections.add(newCollections.get(i));
                    } else if (!selected && this.selectedCollections.contains(newCollections.get(i))) {
                        logger.debug("removing:**" + newCollections.get(i) + "**");
                        this.selectedCollections.remove(newCollections.get(i));
                    }
                    ++i;
                }
            }
            if (!keepCriteriaQueries) {
                this.criteria.clear();
                this.searchQueryTerms.clear();
            }
            logger.debug("Going to update the information for the selected collections");
            this.findAvailableFts(session);
            this.findAvailableGeospatial(session);
            this.findAvailableLanguages(session);
            this.findAvailableSearchFields(session);
            this.findAvailableBrowseFields(session);
            this.findAvailableSortFields(session);
            logger.debug("Number of searchable fields found -> " + this.searchableFields.size());
        }
        catch (InitialBridgingNotCompleteException be) {
            logger.debug("Initial bridging has not completed yet", (Throwable)be);
        }
        catch (InternalErrorException e) {
            logger.error("An internal error has occured: ", (Throwable)e);
        }
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setGeospatial(GeospatialInfo geospatial) {
        logger.debug("Setting geospatial info.");
        this.geospatialInfo = geospatial;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public boolean setSelectedLanguage(String lang, ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        this.reset();
        if (!this.languages.contains(lang)) {
            return false;
        }
        this.selectedLanguage = this.languages.indexOf(lang);
        this.findAvailableSearchFields(session);
        return true;
    }

    public void updateCriterionId(int i, String id) {
        logger.debug("Updating criterion: " + i + ", previous id was: " + this.criteria.get(i).getSearchFieldId() + ", new is: " + id);
        this.criteria.get(i).setSearchFieldId(id);
    }

    public void updateCriterionName(int i, String name) {
        logger.debug("Updating criterion: " + i + ", previous name was: " + this.criteria.get(i).getSearchFieldName() + ", new is: " + name);
        this.criteria.get(i).setSearchFieldName(name);
    }

    public void updateCriterionValue(int i, String value) {
        logger.debug("Updating criterion: " + i + ", previous value was: " + this.criteria.get(i).getSearchFieldName() + ", new is: " + value);
        if (value.startsWith("[") && value.endsWith("]")) {
            this.criteria.get(i).setSearchFieldValue("\"" + QuerySanitizer.sanitizeQuery(value) + "\"");
            logger.debug("Sanitized criterion updated: " + this.criteria.get(i).getSearchFieldValue());
            return;
        }
        if (!(!value.contains(" ") || value.startsWith("\"") && value.endsWith("\""))) {
            String[] splitted = value.split(" ");
            this.criteria.get(i).setSearchFieldValue(splitted[0]);
            int j = 1;
            while (j < splitted.length) {
                Criterion crit = new Criterion();
                crit.setSearchFieldId(this.criteria.get(i).getSearchFieldId());
                crit.setSearchFieldName(this.criteria.get(i).getSearchFieldName());
                crit.setSearchFieldValue(splitted[j]);
                this.criteria.add(crit);
                ++j;
            }
            return;
        }
        this.criteria.get(i).setSearchFieldValue(value);
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String getGenericSearchType() {
        return this.genericSearchType;
    }

    public List<String> getSelectedCollectionNames(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> realCollections = this.getSelectedRealCollections(session);
        ArrayList<String> collectionNames = new ArrayList<String>();
        SearchHelper sh = new SearchHelper(session);
        for (String colId : realCollections) {
            CollectionInfo colInf = sh.findCollectionInfo(colId);
            if (colInf == null) continue;
            collectionNames.add(colInf.getName());
        }
        return collectionNames;
    }

    public void setGenericSearchType(String genType) {
        this.genericSearchType = genType;
    }

    public void setSetRelation(boolean set) {
        this.setRelation = set;
    }

    public void setBrowseBy(String browseByField) {
        this.browseBy = browseByField;
    }

    public String getBrowseByField() {
        return this.browseBy;
    }

    public String getBrowseByFieldName() {
        String fieldName;
        try {
            fieldName = QueryHelper.GetFieldNameById((String)this.browseBy);
        }
        catch (Exception e) {
            logger.debug("Couldn't get the name of the last browse by field ID");
            fieldName = "";
        }
        return fieldName;
    }

    public ResultSetConsumerI search(ASLSession session, boolean simple, ISearchClient searchClient) throws QuerySyntaxException, NoSearchMasterEPRFoundException, InitialBridgingNotCompleteException, InternalErrorException, SearchASLException {
        logger.debug("About to create Query");
        logger.info("Time_Counter -- Called search, start counting time.");
        this.searchStartTime = System.currentTimeMillis();
        this.searchType = simple ? "simpleSearch" : "advancedSearch";
        ResultSetConsumer.removeSessionVariables(session);
        logger.info("Time_Counter -- Started creating Search Query " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        String[] query = this.createSearchQuery(session, simple);
        logger.info("Time_Counter -- Finished creating Search Query " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        this.queryDescription = query[1];
        query[0] = query[0].replace(",", " ");
        logger.debug("The Search Query is: ///////////////////////////////////////////////////////");
        logger.debug(query[0]);
        logger.debug("/////////////////////////////////////////////////////////////////////////");
        this.enableEPRCache();
        logger.debug("Checking for cached Search Master EPRs in this scope");
        ArrayList cachedEPRs = null;
        logger.info("Time_Counter -- Started Send Search to cached Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        if (CacheManager.getInstance().getCache("CachedSearchEPRs") != null && CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())) != null && CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())).getObjectValue() != null) {
            cachedEPRs = (ArrayList)CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())).getObjectValue();
        }
        if (cachedEPRs != null && cachedEPRs.size() > 0) {
            int i = 0;
            while (i < cachedEPRs.size()) {
                try {
                    logger.debug("Acquiring result stream from " + (String)cachedEPRs.get(i));
                    logger.info("Time_Counter -- Start submitting search to EPR " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    Stream<GenericRecord> recordsStream = this.submitSearch(searchClient, query[0], (String)cachedEPRs.get(i), session);
                    logger.info("Time_Counter -- Finished submitting search to EPR, got the results stream " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    if (recordsStream != null && !recordsStream.isClosed()) {
                        logger.info("Time_Counter -- Start creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                        this.searchRSC = new ResultSetConsumer(recordsStream, this.searchType, false);
                        logger.info("Time_Counter -- Finished creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                        this.searchRSC.setGenericSearchType(this.genericSearchType);
                        this.searchRSC.setSearchStartTime(this.searchStartTime);
                        logger.info("Time_Counter -- Finished Send Search to cached Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                        return this.searchRSC;
                    }
                    logger.debug("Search service: " + (String)cachedEPRs.get(i) + " returned either a null or a closed records stream.");
                }
                catch (SearchASLException ex) {
                    logger.debug("Using epr: " + (String)cachedEPRs.get(i) + " has failed to execute the search");
                }
                catch (MalformedURLException ex) {
                    logger.debug("Endpoint " + (String)cachedEPRs.get(i) + " for search is not a valid url");
                }
                catch (gRS2CreationException ex) {
                    logger.debug("ResultSetConsumer could not be created");
                }
                ++i;
            }
        }
        CacheManager.getInstance().getCache("CachedSearchEPRs").remove((Serializable)((Object)session.getScope()));
        logger.info("Time_Counter -- Stopped Send Search to cached Search EPRs. No cached EPRs  " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        logger.debug("Cached Search Master EPRs in this scope are either not available or empty. Contacting IS to get new ones");
        String[] foundEPRs = null;
        logger.info("Time_Counter -- Start Searching IS for Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        foundEPRs = this.findSearchMasterEPRFeather(session);
        logger.info("Time_Counter -- Finished Searching IS for Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        ArrayList<String> discoveredEPRs = new ArrayList<String>();
        String[] stringArray = foundEPRs;
        int n = foundEPRs.length;
        int n2 = 0;
        while (n2 < n) {
            String epr = stringArray[n2];
            discoveredEPRs.add(epr);
            ++n2;
        }
        if (foundEPRs == null || foundEPRs.length == 0) {
            logger.debug("No Search Masters Found");
            throw new NoSearchMasterEPRFoundException();
        }
        logger.debug("Number of Search Master EPRs: " + foundEPRs.length);
        CacheManager.getInstance().getCache("CachedSearchEPRs").put(new Element((Serializable)((Object)session.getScope()), discoveredEPRs));
        int i = 0;
        while (i < foundEPRs.length) {
            try {
                logger.debug("////////////////////////Parsing query again!!!///////////////////////////////");
                logger.info("Time_Counter -- Start submitting search to EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                Stream<GenericRecord> recordsStream = this.submitSearch(searchClient, query[0], foundEPRs[i], session);
                logger.info("Time_Counter -- Finished submitting search to EPRs , got results stream " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                if (recordsStream != null && !recordsStream.isClosed()) {
                    logger.info("Time_Counter -- Start creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    this.searchRSC = new ResultSetConsumer(recordsStream, this.searchType, false);
                    logger.info("Time_Counter -- Finished creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    this.searchRSC.setGenericSearchType(this.genericSearchType);
                    this.searchRSC.setSearchStartTime(this.searchStartTime);
                    return this.searchRSC;
                }
                logger.debug("New discovered Search service returned either a null or a closed records stream.");
            }
            catch (SearchASLException ex) {
                logger.debug("Using epr: " + (String)cachedEPRs.get(i) + " has failed to execute the search");
            }
            catch (MalformedURLException ex) {
                logger.debug("Endpoint " + (String)cachedEPRs.get(i) + " for search is not a valid url");
            }
            catch (gRS2CreationException ex) {
                logger.debug("ResultSetConsumer could not be created");
            }
            ++i;
        }
        logger.debug("NONE OF THE CACHED EPRs DID WORK, NEITHER CONTACTING I.S. HAS REVEALED ANY NEW ONES! WILL THROW A SEARCH EXCEPTION");
        throw new SearchASLException(new Exception("Either no available instance of search service exists OR all search instances failed to perform the search."));
    }

    public ResultSetConsumerI genericSearch(ASLSession session, List<String> terms, ISearchClient searchClient) throws QuerySyntaxException, InitialBridgingNotCompleteException, InternalErrorException, SearchASLException {
        return this.genericSearch(session, terms, false, searchClient);
    }

    public ResultSetConsumerI genericSearch(ASLSession session, List<String> terms, boolean onlyTitleSnippet, ISearchClient searchClient) throws QuerySyntaxException, InitialBridgingNotCompleteException, InternalErrorException, SearchASLException {
        logger.debug("About to create Query");
        logger.debug("Generic Search terms: ");
        for (String t : terms) {
            logger.debug(t);
        }
        logger.info("Time_Counter -- Called generic search, start counting time.");
        this.searchStartTime = System.currentTimeMillis();
        this.searchType = "genericSearch";
        ResultSetConsumer.removeSessionVariables(session);
        if (onlyTitleSnippet) {
            this.semanticEnrichment = false;
        }
        logger.info("Time_Counter -- Started creating Generic Search Query " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        String[] query = this.createGenericSearchQuery(session, terms);
        logger.info("Time_Counter -- Finished creating Generic Search Query " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        this.queryDescription = query[1];
        query[0] = query[0].replace(",", " ");
        logger.debug("The Generic Search Query is: ///////////////////////////////////////////////////////");
        logger.debug(query[0]);
        logger.debug("/////////////////////////////////////////////////////////////////////////");
        this.enableEPRCache();
        logger.debug("Checking for cached Search Master EPRs in this scope");
        ArrayList cachedEPRs = null;
        if (CacheManager.getInstance().getCache("CachedSearchEPRs") != null && CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())) != null && CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())).getObjectValue() != null) {
            cachedEPRs = (ArrayList)CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())).getObjectValue();
        }
        if (cachedEPRs != null && cachedEPRs.size() > 0) {
            logger.info("Time_Counter -- Started Sending Generic Search to cached Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
            int i = 0;
            while (i < cachedEPRs.size()) {
                try {
                    logger.debug("Acquiring result stream from " + (String)cachedEPRs.get(i));
                    logger.info("Time_Counter -- Start submitting generic search to an EPR " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    Stream<GenericRecord> recordsStream = this.submitSearch(searchClient, query[0], (String)cachedEPRs.get(i), session);
                    logger.info("Time_Counter -- Finished submitting generic search to an EPR, got the Result Stream " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    if (recordsStream != null && !recordsStream.isClosed()) {
                        logger.info("Time_Counter -- Start creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                        this.searchRSC = new ResultSetConsumer(recordsStream, this.searchType, onlyTitleSnippet);
                        logger.info("Time_Counter -- Finished creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                        this.searchRSC.setGenericSearchType(this.genericSearchType);
                        this.searchRSC.setSearchStartTime(this.searchStartTime);
                        logger.info("Time_Counter -- Finished Sending Generic Search to cached Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                        return this.searchRSC;
                    }
                    logger.debug("Search service: " + (String)cachedEPRs.get(i) + " returned either a null or a closed records stream.");
                }
                catch (SearchASLException ex) {
                    logger.debug("Using epr: " + (String)cachedEPRs.get(i) + " has failed to execute the search");
                }
                catch (MalformedURLException ex) {
                    logger.debug("Endpoint " + (String)cachedEPRs.get(i) + " for search is not a valid url");
                }
                catch (gRS2CreationException ex) {
                    logger.debug("ResultSetConsumer could not be created");
                }
                ++i;
            }
        }
        CacheManager.getInstance().getCache("CachedSearchEPRs").remove((Serializable)((Object)session.getScope()));
        logger.info("Time_Counter -- Stopped Sending Generic Search to cached Search EPRs. No cached EPRs  " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        logger.debug("Cached Search Master EPRs in this scope are either not available or empty. Contacting IS to get new ones");
        String[] foundEPRs = null;
        logger.info("Time_Counter -- Start Searching IS for Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        foundEPRs = this.findSearchMasterEPRFeather(session);
        logger.info("Time_Counter -- Finished Searching IS for Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        ArrayList<String> discoveredEPRs = new ArrayList<String>();
        String[] stringArray = foundEPRs;
        int n = foundEPRs.length;
        int n2 = 0;
        while (n2 < n) {
            String epr = stringArray[n2];
            discoveredEPRs.add(epr);
            ++n2;
        }
        if (foundEPRs == null || foundEPRs.length == 0) {
            logger.debug("No Search Masters Found");
            return null;
        }
        logger.debug("Number of Search Master EPRs: " + foundEPRs.length);
        CacheManager.getInstance().getCache("CachedSearchEPRs").put(new Element((Serializable)((Object)session.getScope()), discoveredEPRs));
        int i = 0;
        while (i < foundEPRs.length) {
            try {
                logger.debug("////////////////////////Parsing query again!!!///////////////////////////////");
                logger.info("Time_Counter -- Start submitting generic search to EPR " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                Stream<GenericRecord> recordsStream = this.submitSearch(searchClient, query[0], foundEPRs[i], session);
                logger.info("Time_Counter -- Finished submitting generic search to EPR, got results stream " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                if (recordsStream != null && !recordsStream.isClosed()) {
                    logger.info("Time_Counter -- Start creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    this.searchRSC = new ResultSetConsumer(recordsStream, this.searchType, onlyTitleSnippet);
                    logger.info("Time_Counter -- Finished creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    this.searchRSC.setGenericSearchType(this.genericSearchType);
                    this.searchRSC.setSearchStartTime(this.searchStartTime);
                    return this.searchRSC;
                }
                logger.debug("New discovered Search service returned either a null or a closed records stream.");
            }
            catch (SearchASLException ex) {
                logger.debug("Using epr: " + (String)cachedEPRs.get(i) + " has failed to execute the search");
            }
            catch (MalformedURLException ex) {
                logger.debug("Endpoint " + (String)cachedEPRs.get(i) + " for search is not a valid url");
            }
            catch (gRS2CreationException ex) {
                logger.debug("ResultSetConsumer could not be created");
            }
            ++i;
        }
        logger.debug("NONE OF THE CACHED EPRs DID WORK, NEITHER CONTACTING I.S. HAS REVEALED ANY NEW ONES! WILL THROW A SEARCH EXCEPTION");
        throw new SearchASLException(new Exception("Either no available instance of search service exists OR all search instances failed to perform the search."));
    }

    public ResultSetConsumerI browse(ASLSession session, ISearchClient searchClient) throws InitialBridgingNotCompleteException, InternalErrorException, SearchASLException {
        logger.info("Time_Counter -- Called browse, start counting time");
        this.searchStartTime = System.currentTimeMillis();
        this.searchType = !this.distinct ? "browse" : "browseFields";
        ResultSetConsumer.removeSessionVariables(session);
        logger.info("Time_Counter -- Started creating browse query " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        String[] query = this.createBrowseQuery(session);
        logger.info("Time_Counter -- Finished creating browse query " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        this.queryDescription = query[1];
        logger.debug("The browse Query is: ///////////////////////////////////////////////////////");
        logger.debug(query[0]);
        logger.debug("/////////////////////////////////////////////////////////////////////////");
        this.enableEPRCache();
        logger.debug("Checking for cached Search Master EPRs in this scope");
        ArrayList cachedEPRs = null;
        logger.info("Time_Counter -- Started Send browse query to cached Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        if (CacheManager.getInstance().getCache("CachedSearchEPRs") != null && CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())) != null && CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())).getObjectValue() != null) {
            cachedEPRs = (ArrayList)CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())).getObjectValue();
        }
        if (cachedEPRs != null && cachedEPRs.size() > 0) {
            int i = 0;
            while (i < cachedEPRs.size()) {
                try {
                    logger.debug("Acquiring result stream from " + (String)cachedEPRs.get(i));
                    logger.info("Time_Counter -- Start submitting browse query to EPR " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    Stream<GenericRecord> recordsStream = this.submitSearch(searchClient, query[0], (String)cachedEPRs.get(i), session);
                    logger.info("Time_Counter -- Finished submitting browse query to EPR, got the Result Stream " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    if (recordsStream != null && !recordsStream.isClosed()) {
                        logger.info("Time_Counter -- Start creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                        this.searchRSC = new ResultSetConsumer(recordsStream, this.searchType, false);
                        logger.info("Time_Counter -- Finished creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                        this.searchRSC.setGenericSearchType(this.genericSearchType);
                        this.searchRSC.setSearchStartTime(this.searchStartTime);
                        logger.info("Time_Counter -- Finished Send browse query to cached Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                        return this.searchRSC;
                    }
                    logger.debug("Search service: " + (String)cachedEPRs.get(i) + " returned either a null or a closed records stream.");
                }
                catch (SearchASLException ex) {
                    logger.debug("Using epr: " + (String)cachedEPRs.get(i) + " has failed to execute the search");
                }
                catch (MalformedURLException ex) {
                    logger.debug("Endpoint " + (String)cachedEPRs.get(i) + " for search is not a valid url");
                }
                catch (gRS2CreationException ex) {
                    logger.debug("ResultSetConsumer could not be created");
                }
                ++i;
            }
        }
        CacheManager.getInstance().getCache("CachedSearchEPRs").remove((Serializable)((Object)session.getScope()));
        logger.info("Time_Counter -- Stopped Send browse query to cached Search EPRs. No cached EPRs  " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        logger.debug("Cached Search Master EPRs in this scope are either not available or empty. Contacting IS to get new ones");
        String[] foundEPRs = null;
        logger.info("Time_Counter -- Start Searching IS for Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        foundEPRs = this.findSearchMasterEPRFeather(session);
        logger.info("Time_Counter -- Finished Searching IS for Search EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
        ArrayList<String> discoveredEPRs = new ArrayList<String>();
        String[] stringArray = foundEPRs;
        int n = foundEPRs.length;
        int n2 = 0;
        while (n2 < n) {
            String epr = stringArray[n2];
            logger.debug("Adding epr: " + epr);
            discoveredEPRs.add(epr);
            ++n2;
        }
        if (foundEPRs == null || foundEPRs.length == 0) {
            logger.debug("No Search Masters Found");
            return null;
        }
        logger.debug("Number of Search Master EPRs: " + foundEPRs.length);
        CacheManager.getInstance().getCache("CachedSearchEPRs").put(new Element((Serializable)((Object)session.getScope()), discoveredEPRs));
        int i = 0;
        while (i < foundEPRs.length) {
            try {
                logger.debug("////////////////////////Parsing query again!!!///////////////////////////////");
                logger.info("Time_Counter -- Start submitting browse to EPRs " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                Stream<GenericRecord> recordsStream = this.submitSearch(searchClient, query[0], foundEPRs[i], session);
                logger.info("Time_Counter -- Finished submitting browse to EPRs , got results stream " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                if (recordsStream != null && !recordsStream.isClosed()) {
                    logger.info("Time_Counter -- Start creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    this.searchRSC = new ResultSetConsumer(recordsStream, this.searchType, false);
                    logger.info("Time_Counter -- Finished creating the Result set consumer " + (double)(System.currentTimeMillis() - this.searchStartTime) / 1000.0 + " sec(s)");
                    this.searchRSC.setGenericSearchType(this.genericSearchType);
                    this.searchRSC.setSearchStartTime(this.searchStartTime);
                    return this.searchRSC;
                }
                logger.debug("New discovered Search service returned either a null or a closed records stream.");
            }
            catch (SearchASLException ex) {
                logger.debug("Using epr: " + (String)cachedEPRs.get(i) + " has failed to execute the search");
            }
            catch (MalformedURLException ex) {
                logger.debug("Endpoint " + (String)cachedEPRs.get(i) + " for search is not a valid url");
            }
            catch (gRS2CreationException ex) {
                logger.debug("ResultSetConsumer could not be created");
            }
            ++i;
        }
        logger.debug("NONE OF THE CACHED EPRs DID WORK, NEITHER CONTACTING I.S. HAS REVEALED ANY NEW ONES! WILL THROW A SEARCH EXCEPTION");
        throw new SearchASLException(new Exception("Either no available instance of search service exists OR all search instances failed to perform the search."));
    }

    public ResultSetConsumerI quickSearch(ASLSession session, String keyword, ISearchClient searchClient) throws SearchASLException {
        this.searchType = "quickSearch";
        this.searchStartTime = System.currentTimeMillis();
        logger.debug("Inside quick search!");
        ResultSetConsumer.removeSessionVariables(session);
        logger.debug("Trying to create quick query");
        String[] query = this.createQuickQuery(session, keyword);
        this.queryDescription = query[1];
        query[0] = query[0].replace(",", " ");
        logger.debug("/////////////////////////////////////////////////////////////////////////");
        logger.debug("Quick Query: " + query[0]);
        logger.debug("/////////////////////////////////////////////////////////////////////////");
        this.enableEPRCache();
        logger.debug("Checking for cached Search Master EPRs in this scope");
        ArrayList cachedEPRs = null;
        if (CacheManager.getInstance().getCache("CachedSearchEPRs") != null && CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())) != null && CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())).getObjectValue() != null) {
            cachedEPRs = (ArrayList)CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())).getObjectValue();
        }
        if (cachedEPRs != null && cachedEPRs.size() > 0) {
            int i = 0;
            while (i < cachedEPRs.size()) {
                try {
                    logger.debug("Acquiring result stream from " + (String)cachedEPRs.get(i));
                    Stream<GenericRecord> recordsStream = this.submitSearch(searchClient, query[0], (String)cachedEPRs.get(i), session);
                    if (recordsStream != null && !recordsStream.isClosed()) {
                        this.searchRSC = new ResultSetConsumer(recordsStream, this.searchType, false);
                        this.searchRSC.setGenericSearchType(this.genericSearchType);
                        this.searchRSC.setSearchStartTime(this.searchStartTime);
                        return this.searchRSC;
                    }
                    logger.debug("Search service: " + (String)cachedEPRs.get(i) + " returned either a null or a closed records stream.");
                }
                catch (SearchASLException ex) {
                    logger.debug("Using epr: " + (String)cachedEPRs.get(i) + " has failed to execute the search");
                }
                catch (MalformedURLException ex) {
                    logger.debug("Endpoint " + (String)cachedEPRs.get(i) + " for search is not a valid url");
                }
                catch (gRS2CreationException ex) {
                    logger.debug("ResultSetConsumer could not be created");
                }
                ++i;
            }
        }
        CacheManager.getInstance().getCache("CachedSearchEPRs").remove((Serializable)((Object)session.getScope()));
        logger.debug("Cached Search Master EPRs in this scope are either not available or empty. Contacting IS to get new ones");
        String[] foundEPRs = null;
        foundEPRs = this.findSearchMasterEPRFeather(session);
        ArrayList<String> discoveredEPRs = new ArrayList<String>();
        String[] stringArray = foundEPRs;
        int n = foundEPRs.length;
        int n2 = 0;
        while (n2 < n) {
            String epr = stringArray[n2];
            discoveredEPRs.add(epr);
            ++n2;
        }
        if (foundEPRs == null || foundEPRs.length == 0) {
            logger.debug("No Search Masters Found, returning null");
            return null;
        }
        logger.debug("Number of Search Master EPRs: " + foundEPRs.length);
        CacheManager.getInstance().getCache("CachedSearchEPRs").put(new Element((Serializable)((Object)session.getScope()), discoveredEPRs));
        int i = 0;
        while (i < foundEPRs.length) {
            try {
                logger.debug("////////////////////////Parsing query again!!!///////////////////////////////");
                Stream<GenericRecord> recordsStream = this.submitSearch(searchClient, query[0], foundEPRs[i], session);
                if (recordsStream != null && !recordsStream.isClosed()) {
                    this.searchRSC = new ResultSetConsumer(recordsStream, this.searchType, false);
                    this.searchRSC.setGenericSearchType(this.genericSearchType);
                    this.searchRSC.setSearchStartTime(this.searchStartTime);
                    return this.searchRSC;
                }
                logger.debug("New discovered Search service returned either a null or a closed records stream.");
            }
            catch (SearchASLException ex) {
                logger.debug("Using epr: " + (String)cachedEPRs.get(i) + " has failed to execute the search");
            }
            catch (MalformedURLException ex) {
                logger.debug("Endpoint " + (String)cachedEPRs.get(i) + " for search is not a valid url");
            }
            catch (gRS2CreationException ex) {
                logger.debug("ResultSetConsumer could not be created");
            }
            ++i;
        }
        logger.debug("NONE OF THE CACHED EPRs DID WORK, NEITHER CONTACTING I.S. HAS REVEALED ANY NEW ONES! WILL THROW A SEARCH EXCEPTION");
        throw new SearchASLException(new Exception("Either no available instance of search service exists OR all search instances failed to perform the search."));
    }

    public String[] testSearchQuery(ASLSession session, boolean simple, boolean browse, String quick, ISearchClient searchClient) throws InitialBridgingNotCompleteException, InternalErrorException {
        logger.debug("About to create Query for testing: ");
        String[] query = new String[2];
        if (!quick.equals("")) {
            query = this.createQuickQuery(session, quick);
        } else if (!browse) {
            try {
                query = this.createSearchQuery(session, simple);
            }
            catch (QuerySyntaxException e) {
                logger.error("Exception:", (Throwable)e);
            }
        } else {
            query = this.createBrowseQuery(session);
        }
        return query;
    }

    public ResultSetConsumerI submitCQLQuery(ASLSession session, String query, ISearchClient searchClient) throws NoSearchMasterEPRFoundException, SearchASLException {
        this.searchStartTime = System.currentTimeMillis();
        logger.debug("inside submitCQLQuery() ");
        this.enableEPRCache();
        logger.debug("Checking for cached Search Master EPRs in this scope");
        ArrayList cachedEPRs = null;
        if (CacheManager.getInstance().getCache("CachedSearchEPRs") != null && CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())) != null && CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())).getObjectValue() != null) {
            cachedEPRs = (ArrayList)CacheManager.getInstance().getCache("CachedSearchEPRs").get((Serializable)((Object)session.getScope())).getObjectValue();
        }
        if (cachedEPRs != null && cachedEPRs.size() > 0) {
            int i = 0;
            while (i < cachedEPRs.size()) {
                try {
                    logger.debug("Acquiring result stream from " + (String)cachedEPRs.get(i));
                    Stream<GenericRecord> recordsStream = this.submitSearch(searchClient, query, (String)cachedEPRs.get(i), session);
                    if (recordsStream != null && !recordsStream.isClosed()) {
                        this.searchRSC = new ResultSetConsumer(recordsStream, this.searchType, false);
                        this.searchRSC.setGenericSearchType(this.genericSearchType);
                        this.searchRSC.setSearchStartTime(this.searchStartTime);
                        return this.searchRSC;
                    }
                    logger.debug("Search service: " + (String)cachedEPRs.get(i) + " returned either a null or a closed records stream.");
                }
                catch (SearchASLException ex) {
                    logger.debug("Using epr: " + (String)cachedEPRs.get(i) + " has failed to execute the search");
                }
                catch (MalformedURLException ex) {
                    logger.debug("Endpoint " + (String)cachedEPRs.get(i) + " for search is not a valid url");
                }
                catch (gRS2CreationException ex) {
                    logger.debug("ResultSetConsumer could not be created");
                }
                ++i;
            }
        }
        CacheManager.getInstance().getCache("CachedSearchEPRs").remove((Serializable)((Object)session.getScope()));
        logger.debug("Cached Search Master EPRs in this scope are either not available or empty. Contacting IS to get new ones");
        String[] foundEPRs = null;
        foundEPRs = this.findSearchMasterEPRFeather(session);
        ArrayList<String> discoveredEPRs = new ArrayList<String>();
        String[] stringArray = foundEPRs;
        int n = foundEPRs.length;
        int n2 = 0;
        while (n2 < n) {
            String epr = stringArray[n2];
            discoveredEPRs.add(epr);
            ++n2;
        }
        if (foundEPRs == null || foundEPRs.length == 0) {
            logger.debug("No Search Masters Found");
            throw new NoSearchMasterEPRFoundException();
        }
        logger.debug("Number of Search Master EPRs: " + foundEPRs.length);
        CacheManager.getInstance().getCache("CachedSearchEPRs").put(new Element((Serializable)((Object)session.getScope()), discoveredEPRs));
        int i = 0;
        while (i < foundEPRs.length) {
            try {
                logger.debug("////////////////////////Parsing query again!!!///////////////////////////////");
                Stream<GenericRecord> recordsStream = this.submitSearch(searchClient, query, foundEPRs[i], session);
                if (recordsStream != null && !recordsStream.isClosed()) {
                    this.searchRSC = new ResultSetConsumer(recordsStream, this.searchType, false);
                    this.searchRSC.setGenericSearchType(this.genericSearchType);
                    this.searchRSC.setSearchStartTime(this.searchStartTime);
                    return this.searchRSC;
                }
                logger.debug("New discovered Search service returned either a null or a closed records stream.");
            }
            catch (SearchASLException ex) {
                logger.debug("Using epr: " + (String)cachedEPRs.get(i) + " has failed to execute the search");
            }
            catch (MalformedURLException ex) {
                logger.debug("Endpoint " + (String)cachedEPRs.get(i) + " for search is not a valid url");
            }
            catch (gRS2CreationException ex) {
                logger.debug("ResultSetConsumer could not be created");
            }
            ++i;
        }
        logger.debug("NONE OF THE CACHED EPRs DID WORK, NEITHER CONTACTING I.S. HAS REVEALED ANY NEW ONES! WILL THROW A SEARCH EXCEPTION");
        throw new SearchASLException(new Exception("Either no available instance of search service exists OR all search instances failed to perform the search."));
    }

    private void findAvailableFts(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        this.ftsAvailable = false;
        if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
            SearchHelper searchH = new SearchHelper(session);
            HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = searchH.getAvailableCollections();
            logger.debug("Inside findAvailableFTS");
            int i = 0;
            while (i < selectedRealCollections.size()) {
                logger.debug("Trying to find collection info");
                CollectionInfo colInfo = FindFieldsInfo.findCollectionInfo(selectedRealCollections.get(i), collections);
                if (colInfo != null) {
                    if (!colInfo.isFts()) {
                        this.ftsAvailable = false;
                        logger.debug("no available fts");
                        break;
                    }
                    this.ftsId = colInfo.getFtsId();
                    logger.debug("Col Info fts!: " + this.ftsId);
                    this.ftsAvailable = true;
                }
                ++i;
            }
        } else {
            this.ftsAvailable = false;
        }
    }

    private void findAvailableGeospatial(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
            SearchHelper searchH = new SearchHelper(session);
            HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = searchH.getAvailableCollections();
            logger.debug("Inside findAvailableGeospatial");
            int i = 0;
            while (i < selectedRealCollections.size()) {
                logger.debug("Trying to find collection info");
                CollectionInfo colInfo = FindFieldsInfo.findCollectionInfo(selectedRealCollections.get(i), collections);
                if (colInfo != null) {
                    if (!colInfo.isGeospatial()) {
                        this.geoAvailable = false;
                        break;
                    }
                    this.geoAvailable = true;
                    this.geoField = colInfo.getGeospatialField();
                }
                ++i;
            }
        } else {
            this.geoAvailable = false;
        }
    }

    protected String[] createSearchQuery(ASLSession session, boolean simple) throws QuerySyntaxException, InitialBridgingNotCompleteException, InternalErrorException {
        GCQLSortNode sort_node;
        GCQLNode termsNode;
        SearchHelper sh = new SearchHelper(session);
        ArrayList<String> externalCollections = sh.getExternalCollections();
        List<String> realCollections = this.getSelectedRealCollections(session);
        String[][] collectionsTable = new String[realCollections.size()][2];
        int c = 0;
        while (c < realCollections.size()) {
            CollectionInfo colInfo = sh.findCollectionInfo(realCollections.get(c));
            if (externalCollections.contains(colInfo.getId())) {
                collectionsTable[c][0] = String.valueOf(colInfo.getName()) + "_externalCollection";
                collectionsTable[c][1] = colInfo.getId();
            } else {
                collectionsTable[c][0] = colInfo.getName();
                collectionsTable[c][1] = colInfo.getId();
            }
            ++c;
        }
        String[] q = new String[2];
        GCQLNode projectionNode = null;
        GCQLNode sortNode = null;
        if (!this.searchType.equals("previousSearch")) {
            projectionNode = this.getPresentationPart(session);
            if (this.sortBy != null && !this.sortBy.equals("")) {
                logger.debug("Sortby node");
                sortNode = this.getSortByPart(session);
            }
        }
        if ((termsNode = this.getCriteriaPart(session, simple)) == null && (this.geospatialInfo == null || this.geospatialInfo.getBounds() == null)) {
            throw new QuerySyntaxException("No criteria specified");
        }
        GCQLNode collectionsPart = this.getCollectionsQueryPart(session);
        if (this.searchType.equals("previousSearch")) {
            GCQLProjectNode projectNode = (GCQLProjectNode)this.previousQuery;
            GCQLNode subtree = projectNode.subtree;
            GCQLSortNode sortInitialNode = null;
            GCQLNode tree = null;
            if (subtree instanceof GCQLSortNode) {
                sortInitialNode = (GCQLSortNode)subtree;
                tree = sortInitialNode.subtree;
            } else {
                tree = subtree;
            }
            GCQLAndNode andNode = new GCQLAndNode();
            andNode.left = tree;
            andNode.right = termsNode;
            if (sortInitialNode != null) {
                sortInitialNode.subtree = andNode;
                projectNode.subtree = sortInitialNode;
            } else {
                projectNode.subtree = andNode;
            }
            this.queryString = projectNode.toCQL();
            this.queryDescription = this.getQueryDescriptionForPreviousQuery(session);
            q[0] = this.queryString;
            q[1] = this.queryDescription;
            return q;
        }
        if (simple) {
            GCQLSortNode sort_node2;
            GCQLAndNode andNode = new GCQLAndNode();
            andNode.left = termsNode;
            andNode.right = collectionsPart;
            GCQLProjectNode projNode = null;
            if (projectionNode != null) {
                projNode = (GCQLProjectNode)projectionNode;
                if (sortNode != null) {
                    logger.debug("Simple sortby");
                    sort_node2 = (GCQLSortNode)sortNode;
                    sort_node2.subtree = andNode;
                    projNode.subtree = sort_node2;
                } else {
                    projNode.subtree = andNode;
                }
            } else if (sortNode != null) {
                logger.debug("Simple sortby");
                sort_node2 = (GCQLSortNode)sortNode;
                sort_node2.subtree = andNode;
            }
            this.queryString = projNode != null ? projNode.toCQL() : (sortNode != null ? sortNode.toCQL() : andNode.toCQL());
            if (this.rankingSupport) {
                String searchTerms = new String();
                int totalSearchTerms = this.searchQueryTerms.size();
                if (totalSearchTerms > 1) {
                    searchTerms = String.valueOf(searchTerms) + "\"";
                }
                int i = 0;
                while (i < totalSearchTerms - 1) {
                    searchTerms = String.valueOf(searchTerms) + this.searchQueryTerms.get(i) + " ";
                    ++i;
                }
                searchTerms = String.valueOf(searchTerms) + this.searchQueryTerms.get(totalSearchTerms - 1);
                if (totalSearchTerms > 1) {
                    searchTerms = String.valueOf(searchTerms) + "\"";
                }
                this.queryString = String.valueOf(this.queryString) + " fuse " + searchTerms;
            }
            this.queryDescription = this.getQueryDescriptionForSimple(session);
            q[0] = this.queryString;
            q[1] = this.queryDescription;
            if (this.semanticEnrichment) {
                SemanticEnrichmentAccessLogEntry enrichedEntry = new SemanticEnrichmentAccessLogEntry(collectionsTable, this.searchTerm);
                this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)enrichedEntry);
            } else {
                SimpleSearchAccessLogEntry simpleEntry = new SimpleSearchAccessLogEntry(collectionsTable, this.searchTerm);
                this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)simpleEntry);
            }
            return q;
        }
        if (this.geospatialInfo == null || this.geospatialInfo.getBounds() == null) {
            GCQLSortNode sort_node3;
            GCQLNode languageNode = this.getLanguageQueryPart(session);
            GCQLAndNode andNode1 = new GCQLAndNode();
            andNode1.left = collectionsPart;
            andNode1.right = languageNode;
            GCQLAndNode andNode2 = new GCQLAndNode();
            andNode2.left = termsNode;
            andNode2.right = andNode1;
            GCQLProjectNode projNode = null;
            if (projectionNode != null) {
                projNode = (GCQLProjectNode)projectionNode;
                if (sortNode != null) {
                    logger.debug("Advanced sortBy");
                    sort_node3 = (GCQLSortNode)sortNode;
                    sort_node3.subtree = andNode2;
                    projNode.subtree = sort_node3;
                } else {
                    projNode.subtree = andNode2;
                }
            } else if (sortNode != null) {
                sort_node3 = (GCQLSortNode)sortNode;
                sort_node3.subtree = andNode2;
            }
            this.queryString = projNode != null ? projNode.toCQL() : (sortNode != null ? sortNode.toCQL() : andNode2.toCQL());
            this.queryDescription = this.getQueryDescriptionForAdvanced(session);
            q[0] = this.queryString;
            q[1] = this.queryDescription;
            String[][] criteriaTable = new String[this.criteria.size()][2];
            int m = 0;
            while (m < this.criteria.size()) {
                criteriaTable[m][0] = this.criteria.get(m).getSearchFieldName();
                criteriaTable[m][1] = this.criteria.get(m).getSearchFieldValue();
                ++m;
            }
            String oper = this.operator == Operator.AND ? "AND" : "OR";
            if (this.semanticEnrichment) {
                SemanticEnrichmentAccessLogEntry enrichedEntry = new SemanticEnrichmentAccessLogEntry(collectionsTable, this.searchTerm);
                this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)enrichedEntry);
            } else {
                AdvancedSearchAccessLogEntry advancedEntry = new AdvancedSearchAccessLogEntry(collectionsTable, criteriaTable, oper);
                this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)advancedEntry);
            }
            return q;
        }
        SearchHelper s_h = new SearchHelper(session);
        CollectionInfo colInfo = null;
        ArrayList<GCQLNode> geoNodes = new ArrayList<GCQLNode>();
        int i = 0;
        while (i < realCollections.size()) {
            colInfo = s_h.findCollectionInfo(realCollections.get(i));
            if (colInfo.isGeospatial()) {
                GCQLNode geoNd = this.getGeoQueryPart(session, colInfo.getId());
                geoNodes.add(geoNd);
            }
            ++i;
        }
        GCQLNode geoQueryPart = null;
        if (geoNodes.size() > 1) {
            GCQLOrNode previousNode = null;
            int i2 = 0;
            while (i2 < geoNodes.size() - 1) {
                if (previousNode == null) {
                    previousNode = new GCQLOrNode();
                    previousNode.left = (GCQLNode)geoNodes.get(i2);
                    previousNode.right = (GCQLNode)geoNodes.get(i2 + 1);
                } else {
                    GCQLOrNode orNd = new GCQLOrNode();
                    orNd.left = previousNode;
                    orNd.right = (GCQLNode)geoNodes.get(i2 + 1);
                    previousNode = orNd;
                }
                ++i2;
            }
            geoQueryPart = previousNode;
        } else {
            geoQueryPart = (GCQLNode)geoNodes.get(0);
        }
        GCQLAndNode andNode3 = null;
        if (this.criteria != null && this.criteria.size() != 0) {
            andNode3 = new GCQLAndNode();
            andNode3.left = geoQueryPart;
            andNode3.right = termsNode;
        }
        GCQLProjectNode projNode = null;
        if (projectionNode != null) {
            projNode = (GCQLProjectNode)projectionNode;
            if (sortNode != null) {
                sort_node = (GCQLSortNode)sortNode;
                sort_node.subtree = andNode3 != null ? andNode3 : geoQueryPart;
                projNode.subtree = sort_node;
            } else {
                projNode.subtree = andNode3 != null ? andNode3 : geoQueryPart;
            }
        } else if (sortNode != null) {
            sort_node = (GCQLSortNode)sortNode;
            sort_node.subtree = andNode3 != null ? andNode3 : geoQueryPart;
        }
        if (projNode != null) {
            this.queryString = projNode.toCQL();
        } else if (sortNode != null) {
            this.queryString = sortNode.toCQL();
        } else if (andNode3 != null) {
            this.queryString = andNode3.toCQL();
        } else if (geoQueryPart != null) {
            this.queryString = geoQueryPart.toCQL();
        }
        this.queryDescription = this.getQueryDescriptionForGeospatial(session);
        q[0] = this.queryString;
        q[1] = this.queryDescription;
        return q;
    }

    public String createIndexVisQuery(ASLSession session, ArrayList<String> searchTerms) throws InitialBridgingNotCompleteException, InternalErrorException, QuerySyntaxException {
        if (session.getScope() == null || session.getScope().isEmpty()) {
            logger.error("Session has stored an empty scope !");
        }
        this.searchType = "advancedSearch";
        boolean simple = false;
        logger.debug("inside createIndexVisQuery");
        SearchHelper sh = new SearchHelper(session);
        ArrayList<String> externalCollections = sh.getExternalCollections();
        List<String> realCollections = this.getSelectedRealCollections(session);
        String[][] collectionsTable = new String[realCollections.size()][2];
        int c = 0;
        while (c < realCollections.size()) {
            CollectionInfo colInfo = sh.findCollectionInfo(realCollections.get(c));
            if (externalCollections.contains(colInfo.getId())) {
                collectionsTable[c][0] = String.valueOf(colInfo.getName()) + "_externalCollection";
                collectionsTable[c][1] = colInfo.getId();
            } else {
                collectionsTable[c][0] = colInfo.getName();
                collectionsTable[c][1] = colInfo.getId();
            }
            ++c;
        }
        String[] q = new String[2];
        Object projectionNode = null;
        Object sortNode = null;
        GCQLNode termsNode = this.getCriteriaPart(session, simple);
        if (termsNode == null && (this.geospatialInfo == null || this.geospatialInfo.getBounds() == null)) {
            throw new QuerySyntaxException("No criteria specified");
        }
        logger.debug("num_collections_before_filtering: " + realCollections.size());
        Iterator<String> iter = realCollections.iterator();
        while (iter.hasNext()) {
            CollectionInfo colInfo = sh.findCollectionInfo(iter.next());
            if ("opensearch".equalsIgnoreCase(colInfo.getCollectionType())) {
                logger.debug("Removed opensearch collection: " + colInfo.getName());
                iter.remove();
                continue;
            }
            logger.debug("Keeping non-opensearch collection: " + colInfo.getName());
        }
        logger.debug("num_collections_after_filtering: " + realCollections.size());
        GCQLRelation colRelation = new GCQLRelation();
        colRelation.setBase("==");
        GCQLTermNode collectionNode = new GCQLTermNode();
        collectionNode.setIndex("gDocCollectionID");
        collectionNode.setRelation(colRelation);
        collectionNode.setTerm(realCollections.get(0));
        if (realCollections.size() == 1) {
            GCQLTermNode gCQLTermNode = collectionNode;
        }
        GCQLOrNode previousOrNode = null;
        int i = 1;
        while (i < realCollections.size()) {
            GCQLTermNode newColNode = new GCQLTermNode();
            newColNode.setIndex("gDocCollectionID");
            newColNode.setRelation(colRelation);
            newColNode.setTerm(realCollections.get(i));
            if (previousOrNode == null) {
                previousOrNode = new GCQLOrNode();
                previousOrNode.left = collectionNode;
                previousOrNode.right = newColNode;
            } else {
                GCQLOrNode newOrNode = new GCQLOrNode();
                newOrNode.right = previousOrNode;
                newOrNode.left = newColNode;
                previousOrNode = newOrNode;
            }
            ++i;
        }
        GCQLOrNode collectionsPart = previousOrNode;
        GCQLNode languageNode = this.getLanguageQueryPart(session);
        GCQLAndNode andNode1 = new GCQLAndNode();
        andNode1.left = collectionsPart;
        andNode1.right = languageNode;
        GCQLAndNode andNode2 = new GCQLAndNode();
        andNode2.left = termsNode;
        andNode2.right = andNode1;
        this.queryString = andNode2.toCQL();
        this.queryDescription = this.getQueryDescriptionForAdvanced(session);
        q[0] = this.queryString;
        q[1] = this.queryDescription;
        String[][] criteriaTable = new String[this.criteria.size()][2];
        int m = 0;
        while (m < this.criteria.size()) {
            criteriaTable[m][0] = this.criteria.get(m).getSearchFieldName();
            criteriaTable[m][1] = this.criteria.get(m).getSearchFieldValue();
            ++m;
        }
        String oper = this.operator == Operator.AND ? "AND" : "OR";
        if (this.semanticEnrichment) {
            SemanticEnrichmentAccessLogEntry enrichedEntry = new SemanticEnrichmentAccessLogEntry(collectionsTable, this.searchTerm);
            this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)enrichedEntry);
        } else {
            AdvancedSearchAccessLogEntry advancedEntry = new AdvancedSearchAccessLogEntry(collectionsTable, criteriaTable, oper);
            this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)advancedEntry);
        }
        return q[0];
    }

    private String[] createGenericSearchQuery(ASLSession session, List<String> terms) throws QuerySyntaxException, InitialBridgingNotCompleteException, InternalErrorException {
        GCQLSortNode sort_node;
        SearchHelper sh = new SearchHelper(session);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> availableCollections = sh.getAvailableCollections();
        logger.debug("genericSearch -> available collections #: " + availableCollections.keySet().size());
        Iterator<Map.Entry<CollectionInfo, ArrayList<CollectionInfo>>> iterator = availableCollections.entrySet().iterator();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        while (iterator.hasNext()) {
            Map.Entry<CollectionInfo, ArrayList<CollectionInfo>> entry = iterator.next();
            for (CollectionInfo collection : entry.getValue()) {
                if (!collection.isFts()) continue;
                names.add(collection.getName());
                ids.add(collection.getId());
                this.ftsId = collection.getFtsId();
            }
        }
        String[][] collectionsTable = new String[names.size()][2];
        int i = 0;
        while (i < names.size()) {
            collectionsTable[i][0] = (String)names.get(i);
            collectionsTable[i][1] = (String)ids.get(i);
            ++i;
        }
        String[] q = new String[2];
        GCQLNode projectionNode = null;
        GCQLNode sortNode = null;
        if (!this.searchType.equals("previousSearch")) {
            logger.debug("getting presentation part");
            projectionNode = this.getGenericSearchPresentationPart(availableCollections, session);
            if (this.sortBy != null && !this.sortBy.equals("")) {
                logger.debug("Sortby node");
                sortNode = this.getSortByPart(session);
            }
        }
        ArrayList<String> sanitizedTerms = new ArrayList<String>();
        for (String st : terms) {
            sanitizedTerms.add(StringEscapeUtils.unescapeHtml((String)QuerySanitizer.sanitizeQuery(st)));
        }
        GCQLNode termsNode = this.getGenericCriterialPart(session, sanitizedTerms);
        if (termsNode == null && (this.geospatialInfo == null || this.geospatialInfo.getBounds() == null)) {
            throw new QuerySyntaxException("No criteria specified");
        }
        GCQLNode collectionsPart = this.getCollectionsGenericQueryPart(session);
        if (this.searchType.equals("previousSearch")) {
            logger.info("There was a previous Generic Search Query ");
            GCQLProjectNode projectNode = (GCQLProjectNode)this.previousQuery;
            GCQLNode subtree = projectNode.subtree;
            GCQLSortNode sortInitialNode = null;
            GCQLNode tree = null;
            if (subtree instanceof GCQLSortNode) {
                sortInitialNode = (GCQLSortNode)subtree;
                tree = sortInitialNode.subtree;
            } else {
                tree = subtree;
            }
            GCQLAndNode andNode = new GCQLAndNode();
            andNode.left = tree;
            andNode.right = termsNode;
            if (sortInitialNode != null) {
                sortInitialNode.subtree = andNode;
                projectNode.subtree = sortInitialNode;
            } else {
                projectNode.subtree = andNode;
            }
            this.queryString = projectNode.toCQL();
            this.queryDescription = this.getQueryDescriptionForPreviousQuery(session);
            q[0] = this.queryString;
            q[1] = this.queryDescription;
            return q;
        }
        GCQLAndNode andNode = new GCQLAndNode();
        andNode.left = termsNode;
        andNode.right = collectionsPart;
        GCQLProjectNode projNode = null;
        if (projectionNode != null) {
            projNode = (GCQLProjectNode)projectionNode;
            if (sortNode != null) {
                logger.debug("Simple sortby");
                sort_node = (GCQLSortNode)sortNode;
                sort_node.subtree = andNode;
                projNode.subtree = sort_node;
            } else {
                projNode.subtree = andNode;
            }
        } else if (sortNode != null) {
            logger.debug("Simple sortby");
            sort_node = (GCQLSortNode)sortNode;
            sort_node.subtree = andNode;
        }
        this.queryString = projNode != null ? projNode.toCQL() : (sortNode != null ? sortNode.toCQL() : andNode.toCQL());
        this.queryDescription = this.getQueryDescriptionForSimple(session);
        q[0] = this.queryString;
        q[1] = this.queryDescription;
        SimpleSearchAccessLogEntry simpleEntry = new SimpleSearchAccessLogEntry(collectionsTable, this.searchTerm);
        this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)simpleEntry);
        return q;
    }

    protected String[] createBrowseQuery(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        String[] q = new String[2];
        GCQLNode projectionNode = null;
        if (this.distinct) {
            logger.debug("getting distinct");
            projectionNode = this.getPresentationPartDistinct(session);
            logger.debug("Got presentation part browse distinct");
        } else {
            projectionNode = this.getPresentationPart(session);
            logger.debug("Got presentation part browse");
        }
        GCQLNode browseNode = this.getBrowseCriteriaPart(session);
        GCQLNode collectionsPart = this.getCollectionsQueryPart(session);
        GCQLAndNode andNode = new GCQLAndNode();
        andNode.left = browseNode;
        andNode.right = collectionsPart;
        if (projectionNode != null) {
            GCQLProjectNode projNode = (GCQLProjectNode)projectionNode;
            projNode.subtree = andNode;
            q[0] = projNode.toCQL();
        } else {
            q[0] = andNode.toCQL();
        }
        q[1] = this.getQueryDescriptionForBrowse(session);
        return q;
    }

    protected String[] createQuickQuery(ASLSession session, String keyword) {
        String[] q = new String[2];
        logger.debug("quick trying to get presentation part keyword is: " + keyword);
        GCQLNode projectionNode = this.getPresentationPart(session);
        logger.debug("Quick got presentation part");
        GCQLNode quickNode = this.getQuickCriterionPart(session, keyword);
        logger.debug("Quick got criteria part");
        if (projectionNode != null) {
            GCQLProjectNode projNode = (GCQLProjectNode)projectionNode;
            projNode.subtree = quickNode;
            q[0] = projNode.toCQL();
        } else {
            q[0] = quickNode.toCQL();
        }
        q[1] = this.getQueryDescriptionForQuick(session, keyword);
        return q;
    }

    protected String getQueryDescriptionForSimple(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        String queryDescr = "\"" + this.searchTerm + "\" in collection(s): ";
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        SearchHelper sh = new SearchHelper(session);
        int i = 0;
        while (i < selectedRealCollections.size()) {
            CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(i));
            queryDescr = String.valueOf(queryDescr) + colInfo.getName() + ", ";
            ++i;
        }
        queryDescr = queryDescr.substring(0, queryDescr.length() - 2);
        if (this.sortBy != null && !this.sortBy.equals("")) {
            logger.debug("The sort by is simple: " + this.sortBy);
            queryDescr = String.valueOf(queryDescr) + ". Sort the results by: " + this.findSortFieldName(this.sortBy);
        }
        return queryDescr;
    }

    protected String getQueryDescriptionForQuick(ASLSession session, String keyword) {
        String queryDescr = "Search for: \"" + keyword + "\"  in all collections";
        return queryDescr;
    }

    private String findSortFieldName(String sortById) {
        for (Field x : this.sortableFields) {
            logger.debug("comparing sortby: " + x.getId() + " with " + sortById);
            if (!x.getId().trim().equals(sortById.trim())) continue;
            return x.getName();
        }
        return "";
    }

    protected String getQueryDescriptionForBrowse(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        String queryDescr = "Browse by: " + this.findSearchFieldName(this.browseBy.trim()) + " in collection(s): ";
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        SearchHelper sh = new SearchHelper(session);
        int i = 0;
        while (i < selectedRealCollections.size()) {
            CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(i));
            queryDescr = String.valueOf(queryDescr) + colInfo.getName() + ", ";
            ++i;
        }
        queryDescr = queryDescr.substring(0, queryDescr.length() - 2);
        return queryDescr;
    }

    protected String getQueryDescriptionForAdvanced(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        String queryDescr = new String();
        int i = 0;
        while (i < this.criteria.size()) {
            logger.debug("Criterion name: " + this.criteria.get(i).getSearchFieldId());
            queryDescr = String.valueOf(queryDescr) + this.findSearchFieldName(this.criteria.get(i).getSearchFieldId());
            queryDescr = String.valueOf(queryDescr) + " = \"" + this.criteria.get(i).getSearchFieldValue();
            queryDescr = this.operator == Operator.OR ? String.valueOf(queryDescr) + "\" or " : String.valueOf(queryDescr) + "\" and ";
            ++i;
        }
        logger.debug(queryDescr);
        queryDescr = this.operator == Operator.OR ? queryDescr.substring(0, queryDescr.length() - 4) : queryDescr.substring(0, queryDescr.length() - 5);
        queryDescr = String.valueOf(queryDescr) + " in collection(s): ";
        SearchHelper sh = new SearchHelper(session);
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        int i2 = 0;
        while (i2 < selectedRealCollections.size()) {
            CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(i2));
            queryDescr = String.valueOf(queryDescr) + colInfo.getName() + ", ";
            ++i2;
        }
        queryDescr = String.valueOf(queryDescr) + "in " + this.languages.get(this.selectedLanguage) + " language.";
        if (this.sortBy != null && !this.sortBy.equals("")) {
            logger.debug("The sortby field is: " + this.sortBy);
            queryDescr = String.valueOf(queryDescr) + " Sort the results by: " + this.findSortFieldName(this.sortBy);
        }
        return queryDescr;
    }

    protected String getQueryDescriptionForGeospatial(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        if (this.criteria != null && this.criteria.size() != 0) {
            return this.getQueryDescriptionForAdvanced(session);
        }
        return "GeospatialSearch";
    }

    protected String getQueryDescriptionForPreviousQuery(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        String queryDescr = String.valueOf(this.previousQueryDescription) + ", and" + this.getQueryDescriptionForAdvanced(session);
        return queryDescr;
    }

    private String findSearchFieldName(String sfId) {
        for (Field x : this.searchableFields) {
            logger.debug("Compare criterion: " + x.getId().trim() + " with  " + sfId.trim());
            if (x.getId().trim().equals(sfId.trim())) {
                logger.debug("The name is: " + x.getName() + " and the label: " + x.getLabel());
                return x.getName();
            }
            logger.debug("Not equal!");
        }
        return "";
    }

    protected GCQLNode getCollectionsQueryPart(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> realCollections = this.getSelectedRealCollections(session);
        GCQLRelation colRelation = new GCQLRelation();
        colRelation.setBase("==");
        GCQLTermNode collectionNode = new GCQLTermNode();
        collectionNode.setIndex("gDocCollectionID");
        collectionNode.setRelation(colRelation);
        collectionNode.setTerm(realCollections.get(0));
        if (realCollections.size() == 1) {
            return collectionNode;
        }
        GCQLOrNode previousOrNode = null;
        int i = 1;
        while (i < realCollections.size()) {
            GCQLTermNode newColNode = new GCQLTermNode();
            newColNode.setIndex("gDocCollectionID");
            newColNode.setRelation(colRelation);
            newColNode.setTerm(realCollections.get(i));
            if (previousOrNode == null) {
                previousOrNode = new GCQLOrNode();
                previousOrNode.left = collectionNode;
                previousOrNode.right = newColNode;
            } else {
                GCQLOrNode newOrNode = new GCQLOrNode();
                newOrNode.right = previousOrNode;
                newOrNode.left = newColNode;
                previousOrNode = newOrNode;
            }
            ++i;
        }
        return previousOrNode;
    }

    protected GCQLNode getCollectionsGenericQueryPart(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        SearchHelper sh = new SearchHelper(session);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> availableCollections = sh.getAvailableCollections();
        ArrayList<String> allCollections = new ArrayList<String>();
        Iterator<CollectionInfo> iter = availableCollections.keySet().iterator();
        while (iter.hasNext()) {
            ArrayList<CollectionInfo> group = availableCollections.get(iter.next());
            int i = 0;
            while (i < group.size()) {
                if (group.get(i).isFts()) {
                    allCollections.add(group.get(i).getId());
                }
                ++i;
            }
        }
        GCQLRelation colRelation = new GCQLRelation();
        colRelation.setBase("==");
        GCQLTermNode collectionNode = new GCQLTermNode();
        if (allCollections.isEmpty()) {
            return collectionNode;
        }
        collectionNode.setIndex("gDocCollectionID");
        collectionNode.setRelation(colRelation);
        collectionNode.setTerm((String)allCollections.get(0));
        if (allCollections.size() == 1) {
            return collectionNode;
        }
        GCQLOrNode previousOrNode = null;
        int i = 1;
        while (i < allCollections.size()) {
            GCQLTermNode newColNode = new GCQLTermNode();
            newColNode.setIndex("gDocCollectionID");
            newColNode.setRelation(colRelation);
            newColNode.setTerm((String)allCollections.get(i));
            if (previousOrNode == null) {
                previousOrNode = new GCQLOrNode();
                previousOrNode.left = collectionNode;
                previousOrNode.right = newColNode;
            } else {
                GCQLOrNode newOrNode = new GCQLOrNode();
                newOrNode.right = previousOrNode;
                newOrNode.left = newColNode;
                previousOrNode = newOrNode;
            }
            ++i;
        }
        return previousOrNode;
    }

    protected GCQLNode getGeoQueryPart(ASLSession session, String collectionId) {
        GCQLTermNode geoNode = new GCQLTermNode();
        geoNode.setIndex(this.geoField.getId());
        GCQLRelation geoRel = new GCQLRelation();
        geoRel.setBase("geosearch");
        Modifier inclusionMod = new Modifier("inclusion", "=", "1");
        Modifier collectionMod = new Modifier("colID", "=", collectionId);
        Modifier languageMod = new Modifier("lang", "=", this.languages.get(this.selectedLanguage));
        Modifier rankerMod = new Modifier("ranker", "=", "\"GenericRanker false\"");
        Modifier refinerMod = new Modifier("refiner", "=", "\"TimeSpanRefiner false " + this.geospatialInfo.getStartingDateString() + " " + this.geospatialInfo.getEndingDateString() + "\"");
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        modifiers.add(collectionMod);
        modifiers.add(languageMod);
        modifiers.add(inclusionMod);
        modifiers.add(rankerMod);
        modifiers.add(refinerMod);
        geoRel.setModifiers(modifiers);
        geoNode.setRelation(geoRel);
        String coordinates = new String();
        Point[] points = this.geospatialInfo.getBounds();
        int i = 0;
        while (i < points.length) {
            double x = points[i].getLongitude();
            double y = points[i].getLatitude();
            coordinates = String.valueOf(coordinates) + String.valueOf(x) + " " + String.valueOf(y) + " ";
            ++i;
        }
        coordinates = "\"" + coordinates.substring(0, coordinates.length() - 1) + "\"";
        geoNode.setTerm(coordinates);
        return geoNode;
    }

    protected GCQLNode getGeoCollectionsQueryPart(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> realCollections = this.getSelectedRealCollections(session);
        GCQLRelation colRelation = new GCQLRelation();
        colRelation.setBase("==");
        SearchHelper s_h = new SearchHelper(session);
        GCQLTermNode collectionNode = null;
        int i = 0;
        while (i < realCollections.size()) {
            CollectionInfo colInfo = s_h.findCollectionInfo(realCollections.get(i));
            if (colInfo.isGeospatial()) {
                collectionNode = new GCQLTermNode();
                collectionNode.setIndex("gDocCollectionID");
                collectionNode.setRelation(colRelation);
                collectionNode.setTerm(realCollections.get(i));
                break;
            }
            ++i;
        }
        if (collectionNode == null) {
            return null;
        }
        GCQLOrNode previousOrNode = null;
        while (i < realCollections.size()) {
            CollectionInfo colInfo = s_h.findCollectionInfo(realCollections.get(i));
            if (colInfo.isGeospatial()) {
                GCQLTermNode newColNode = new GCQLTermNode();
                newColNode.setIndex("gDocCollectionID");
                newColNode.setRelation(colRelation);
                newColNode.setTerm(realCollections.get(i));
                if (previousOrNode == null) {
                    previousOrNode = new GCQLOrNode();
                    previousOrNode.left = collectionNode;
                    previousOrNode.right = newColNode;
                } else {
                    GCQLOrNode newOrNode = new GCQLOrNode();
                    newOrNode.right = previousOrNode;
                    newOrNode.left = newColNode;
                    previousOrNode = newOrNode;
                }
            }
            ++i;
        }
        if (previousOrNode == null) {
            return collectionNode;
        }
        return previousOrNode;
    }

    protected GCQLNode getGenericCriterialPart(ASLSession session, List<String> terms) throws QuerySyntaxException {
        String term;
        logger.debug("Inside getGenericCriterialPart - the search type is: " + this.searchType);
        if (terms.size() < 1) {
            throw new QuerySyntaxException("Empty term list given");
        }
        if (terms.size() == 1 && !(term = terms.get(0)).contains("\"") && term.contains(" ")) {
            String[] trms;
            terms.clear();
            String[] stringArray = trms = term.split(" ");
            int n = trms.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                terms.add(t);
                ++n2;
            }
        }
        GCQLRelation fieldRelation = new GCQLRelation();
        fieldRelation.setBase("=");
        GCQLTermNode criterionNode = new GCQLTermNode();
        criterionNode.setIndex(this.ftsId);
        criterionNode.setRelation(fieldRelation);
        criterionNode.setTerm(terms.get(0));
        if (terms.size() == 1) {
            return criterionNode;
        }
        GCQLOrNode previousOrNode = null;
        int i = 1;
        while (i < terms.size()) {
            GCQLTermNode newCriterionNode = new GCQLTermNode();
            newCriterionNode.setIndex(this.ftsId);
            newCriterionNode.setRelation(fieldRelation);
            newCriterionNode.setTerm(terms.get(i));
            if (previousOrNode == null) {
                previousOrNode = new GCQLOrNode();
                previousOrNode.left = criterionNode;
                previousOrNode.right = newCriterionNode;
            } else {
                GCQLOrNode newOrNode = new GCQLOrNode();
                newOrNode.right = previousOrNode;
                newOrNode.left = newCriterionNode;
                previousOrNode = newOrNode;
            }
            this.searchQueryTerms.add(terms.get(i));
            ++i;
        }
        return previousOrNode;
    }

    protected GCQLNode getCriteriaPart(ASLSession session, boolean simple) {
        logger.debug("Inside getCriteriaPart - the search type is: " + this.searchType);
        this.searchQueryTerms.clear();
        if (!simple) {
            if (this.previousCriteria != null && this.previousCriteria.size() != 0) {
                int i = 0;
                while (i < this.previousCriteria.size()) {
                    this.criteria.add(this.previousCriteria.get(i).clone());
                    this.searchQueryTerms.add(this.previousCriteria.get(i).getSearchFieldValue());
                    ++i;
                }
                this.previousCriteria.clear();
                this.operator = Operator.AND;
            } else {
                logger.debug("no previous criteria set");
            }
            if (this.criteria != null && this.criteria.size() != 0) {
                GCQLRelation fieldRelation = new GCQLRelation();
                fieldRelation.setBase("=");
                GCQLTermNode criterionNode = new GCQLTermNode();
                criterionNode.setIndex(this.criteria.get(0).getSearchFieldId());
                criterionNode.setRelation(fieldRelation);
                String sanitized = QuerySanitizer.sanitizeQuery(this.criteria.get(0).getSearchFieldValue());
                sanitized = StringEscapeUtils.unescapeHtml((String)sanitized);
                criterionNode.setTerm("\"" + sanitized + "\"");
                logger.debug("criterionNode.setTerm:\"" + sanitized + "\"");
                this.searchQueryTerms.add(sanitized);
                if (this.criteria.size() == 1) {
                    if (sanitized == null || sanitized.equals("")) {
                        return null;
                    }
                    return criterionNode;
                }
                if (this.operator.equals((Object)Operator.AND)) {
                    GCQLAndNode previousAndNode = null;
                    int i = 1;
                    while (i < this.criteria.size()) {
                        sanitized = QuerySanitizer.sanitizeQuery(this.criteria.get(i).getSearchFieldValue());
                        if ((sanitized = StringEscapeUtils.unescapeHtml((String)sanitized)) != null && !sanitized.equals("")) {
                            GCQLTermNode newCriterionNode = new GCQLTermNode();
                            newCriterionNode.setIndex(this.criteria.get(i).getSearchFieldId());
                            newCriterionNode.setRelation(fieldRelation);
                            sanitized = StringEscapeUtils.unescapeHtml((String)sanitized);
                            newCriterionNode.setTerm(sanitized);
                            this.searchQueryTerms.add(sanitized);
                            if (previousAndNode == null) {
                                previousAndNode = new GCQLAndNode();
                                previousAndNode.left = criterionNode;
                                previousAndNode.right = newCriterionNode;
                            } else {
                                GCQLAndNode newAndNode = new GCQLAndNode();
                                newAndNode.right = previousAndNode;
                                newAndNode.left = newCriterionNode;
                                previousAndNode = newAndNode;
                            }
                        }
                        ++i;
                    }
                    return previousAndNode;
                }
                GCQLOrNode previousOrNode = null;
                int i = 1;
                while (i < this.criteria.size()) {
                    sanitized = QuerySanitizer.sanitizeQuery(this.criteria.get(i).getSearchFieldValue());
                    if ((sanitized = StringEscapeUtils.unescapeHtml((String)sanitized)) != null && !sanitized.equals("")) {
                        GCQLTermNode newCriterionNode = new GCQLTermNode();
                        if (this.criteria.get(i).getSearchFieldName().equals("Any")) {
                            newCriterionNode.setIndex(this.ftsId);
                        } else {
                            newCriterionNode.setIndex(this.criteria.get(i).getSearchFieldId());
                        }
                        newCriterionNode.setRelation(fieldRelation);
                        newCriterionNode.setTerm(sanitized);
                        this.searchQueryTerms.add(sanitized);
                        if (previousOrNode == null) {
                            previousOrNode = new GCQLOrNode();
                            previousOrNode.left = criterionNode;
                            previousOrNode.right = newCriterionNode;
                        } else {
                            GCQLOrNode newOrNode = new GCQLOrNode();
                            newOrNode.right = previousOrNode;
                            newOrNode.left = newCriterionNode;
                            previousOrNode = newOrNode;
                        }
                    }
                    ++i;
                }
                return previousOrNode;
            }
            logger.debug("No current criteria set, will return null");
            return null;
        }
        logger.debug("searchterm__=" + this.searchTerm);
        if (!this.searchTerm.contains(" ") || this.searchTerm.startsWith("\"") && this.searchTerm.endsWith("\"")) {
            GCQLRelation fieldRelation = new GCQLRelation();
            fieldRelation.setBase("=");
            GCQLTermNode criterionNode = new GCQLTermNode();
            logger.debug("The fts id is: " + this.ftsId);
            criterionNode.setIndex(this.ftsId);
            criterionNode.setRelation(fieldRelation);
            this.searchTerm = QuerySanitizer.sanitizeQuery(this.searchTerm);
            this.searchTerm = StringEscapeUtils.unescapeHtml((String)this.searchTerm);
            logger.debug("criterionNode.setTerm():" + this.searchTerm);
            criterionNode.setTerm(this.searchTerm);
            this.searchQueryTerms.add(this.searchTerm);
            return criterionNode;
        }
        String[] searchTerms = this.searchTerm.split("\\s+");
        GCQLRelation fieldRelation = new GCQLRelation();
        fieldRelation.setBase("=");
        GCQLTermNode criterionNode = new GCQLTermNode();
        criterionNode.setIndex(this.ftsId);
        criterionNode.setRelation(fieldRelation);
        logger.debug("criterionNode.setTerm():" + this.searchTerm);
        criterionNode.setTerm(searchTerms[0]);
        logger.debug("searchQueryTerms.add()" + searchTerms[0]);
        this.searchQueryTerms.add(StringEscapeUtils.unescapeHtml((String)QuerySanitizer.sanitizeQuery(searchTerms[0])));
        GCQLOrNode previousOrNode = null;
        int i = 1;
        while (i < searchTerms.length) {
            GCQLTermNode newCriterionNode = new GCQLTermNode();
            newCriterionNode.setIndex(this.ftsId);
            newCriterionNode.setRelation(fieldRelation);
            newCriterionNode.setTerm(searchTerms[i]);
            if (previousOrNode == null) {
                previousOrNode = new GCQLOrNode();
                previousOrNode.left = criterionNode;
                previousOrNode.right = newCriterionNode;
            } else {
                GCQLOrNode newOrNode = new GCQLOrNode();
                newOrNode.right = previousOrNode;
                newOrNode.left = newCriterionNode;
                previousOrNode = newOrNode;
            }
            this.searchQueryTerms.add(searchTerms[i]);
            ++i;
        }
        return previousOrNode;
    }

    protected GCQLNode getQuickCriterionPart(ASLSession session, String keyword) {
        GCQLRelation fieldRelation = new GCQLRelation();
        fieldRelation.setBase("=");
        logger.debug("Quick getting criterion");
        GCQLTermNode criterionNode = new GCQLTermNode();
        String quickField = "";
        try {
            quickField = (String)session.getAttribute("quickFieldId");
            if (quickField == null) {
                logger.debug("Quick got presentation part from registry");
                List alFields = gr.uoa.di.madgik.rr.element.search.Field.getFieldsWithName((boolean)false, (String)"allIndexes");
                if (alFields != null && alFields.size() != 0) {
                    criterionNode.setIndex(((gr.uoa.di.madgik.rr.element.search.Field)alFields.get(0)).getID());
                    session.setAttribute("quickFieldId", (Object)criterionNode.getIndex());
                }
                logger.debug("Quick got it");
            } else {
                criterionNode.setIndex(quickField);
            }
        }
        catch (ResourceRegistryException e) {
            logger.error("Exception:", (Throwable)e);
        }
        criterionNode.setRelation(fieldRelation);
        if (!keyword.contains(" ") || keyword.startsWith("\"") && keyword.endsWith("\"")) {
            criterionNode.setTerm(keyword);
            return criterionNode;
        }
        if (keyword.contains(" ")) {
            String[] searchTerms = keyword.split(" ");
            criterionNode.setTerm(searchTerms[0]);
            GCQLOrNode previousOrNode = null;
            int i = 1;
            while (i < searchTerms.length) {
                GCQLTermNode newCriterionNode = new GCQLTermNode();
                newCriterionNode.setIndex(criterionNode.getIndex());
                newCriterionNode.setRelation(criterionNode.getRelation());
                newCriterionNode.setTerm(searchTerms[i]);
                if (previousOrNode == null) {
                    previousOrNode = new GCQLOrNode();
                    previousOrNode.left = criterionNode;
                    previousOrNode.right = newCriterionNode;
                } else {
                    GCQLOrNode newOrNode = new GCQLOrNode();
                    newOrNode.right = previousOrNode;
                    newOrNode.left = newCriterionNode;
                    previousOrNode = newOrNode;
                }
                ++i;
            }
            return previousOrNode;
        }
        criterionNode.setTerm(keyword);
        return criterionNode;
    }

    protected GCQLNode getBrowseCriteriaPart(ASLSession session) {
        GCQLRelation browseFieldRelation = new GCQLRelation();
        browseFieldRelation.setBase("==");
        GCQLTermNode newCriterionNode = new GCQLTermNode();
        newCriterionNode.setIndex(this.browseBy);
        newCriterionNode.setRelation(browseFieldRelation);
        newCriterionNode.setTerm("\"*\"");
        return newCriterionNode;
    }

    protected GCQLNode getLanguageQueryPart(ASLSession session) {
        GCQLTermNode languageNode = new GCQLTermNode();
        languageNode.setIndex("gDocCollectionLang");
        GCQLRelation languageRelation = new GCQLRelation();
        languageRelation.setBase("==");
        languageNode.setRelation(languageRelation);
        languageNode.setTerm(this.languages.get(this.selectedLanguage));
        return languageNode;
    }

    protected List<String> findPresentableFields(ASLSession session) throws Exception {
        logger.debug("Inside method getPresentableFields()");
        SearchHelper sh = new SearchHelper(session);
        List<String> selectedCollections = this.getSelectedRealCollections(session);
        logger.debug("SelectedCollections.size(): " + selectedCollections.size());
        ArrayList<Object> common = new ArrayList();
        HashMap<String, ArrayList<String>> collectionsPresentableFields = null;
        try {
            collectionsPresentableFields = this.readUserProfile(session);
        }
        catch (ReadingUserProfileException e) {
            logger.debug(e.getMessage());
        }
        if (collectionsPresentableFields != null && collectionsPresentableFields.size() > 0) {
            logger.debug("Going for the comparison to find the common presentables");
            common = ArraysComparison.getCommonFields(collectionsPresentableFields, selectedCollections);
        } else {
            logger.debug("Presentables from user profile is empty. Going for askForAllPresentables()");
            common = this.askForAllCommonPresentables(selectedCollections, sh, session);
        }
        logger.debug("Number of common presentables: " + common.size());
        session.setAttribute("presentationFields", common);
        logger.debug("SessionConstants.sessionDetailedResult was: " + session.getAttribute("sessionDetailedResult"));
        Boolean isDetailedResult = true;
        int n = 0;
        while (n < common.size()) {
            String id = (String)common.get(n);
            String name = QueryHelper.GetFieldNameById((String)id);
            logger.debug("Checking common field name: " + name);
            if (name.trim().equals("S")) {
                session.setAttribute("session_snippet_attr", (Object)id);
                isDetailedResult = false;
            } else if (name.trim().equals("title")) {
                session.setAttribute("session_title_attr", (Object)id);
                isDetailedResult = false;
            }
            ++n;
        }
        session.setAttribute("sessionDetailedResult", (Object)isDetailedResult);
        logger.debug("SessionConstants.sessionDetailedResult now is: " + session.getAttribute("sessionDetailedResult"));
        return common;
    }

    protected ArrayList<String> askForAllCommonPresentables(List<String> selectedCollections, SearchHelper sh, ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        HashMap<String, ArrayList<String>> collectionsPresentableFields = new HashMap<String, ArrayList<String>>();
        ArrayList<String> common = new ArrayList();
        ArrayList<Object> fields = new ArrayList();
        int i = 0;
        while (i < selectedCollections.size()) {
            fields = sh.findCollectionInfo(selectedCollections.get(i)).getPresentationFields();
            ArrayList<String> fieldsID = new ArrayList<String>();
            int f = 0;
            while (f < fields.size()) {
                fieldsID.add(((Field)fields.get(f)).getId());
                ++f;
            }
            collectionsPresentableFields.put(selectedCollections.get(i), fieldsID);
            ++i;
        }
        common = ArraysComparison.getCommonFields(collectionsPresentableFields, selectedCollections);
        return common;
    }

    protected GCQLNode getSortByPart(ASLSession session) {
        GCQLSortNode sortNode = new GCQLSortNode();
        ModifierSet modSet = new ModifierSet(this.sortBy);
        if (this.order == Order.ASC) {
            modSet.addModifier("sort.ascending");
        } else {
            modSet.addModifier("sort.descending ");
        }
        sortNode.addSortIndex(modSet);
        return sortNode;
    }

    protected GCQLNode getGenericSearchPresentationPart(HashMap<CollectionInfo, ArrayList<CollectionInfo>> availableCollections, ASLSession session) {
        logger.debug("Getting presentation part for Generic Search");
        GCQLProjectNode projectNode = new GCQLProjectNode();
        if (this.semanticEnrichment) {
            session.setAttribute("sessionDetailedResult", (Object)true);
            logger.debug("'Return all fields' flag is set for this Generic Search");
            ModifierSet modfSet = new ModifierSet("*");
            projectNode.addProjectIndex(modfSet);
            return projectNode;
        }
        ArrayList<String> fields = new ArrayList<String>();
        String snippetID = null;
        String titleID = null;
        Set<CollectionInfo> collec = availableCollections.keySet();
        for (CollectionInfo col : collec) {
            ArrayList<CollectionInfo> colinfos = availableCollections.get(col);
            block1: for (CollectionInfo colInfo : colinfos) {
                for (Field field : colInfo.getPresentationFields()) {
                    if (field.getName().trim().equalsIgnoreCase("S")) {
                        session.setAttribute("session_snippet_attr", (Object)field.getId());
                        snippetID = field.getId();
                    }
                    if (field.getName().trim().equalsIgnoreCase("title")) {
                        session.setAttribute("session_title_attr", (Object)field.getId());
                        titleID = field.getId();
                    }
                    if (snippetID != null && titleID != null) continue block1;
                }
            }
        }
        if (snippetID != null) {
            fields.add(snippetID);
        }
        if (titleID != null) {
            fields.add(titleID);
        }
        session.setAttribute("sessionDetailedResult", (Object)false);
        session.setAttribute("presentationFields", fields);
        projectNode.addProjectIndex(new ModifierSet(snippetID));
        projectNode.addProjectIndex(new ModifierSet(titleID));
        return projectNode;
    }

    protected GCQLNode getPresentationPart(ASLSession session) {
        GCQLProjectNode projectNode = new GCQLProjectNode();
        if (this.searchType.equals("quickSearch")) {
            logger.debug("It's a QuickSearch");
            ModifierSet modfSet = new ModifierSet("*");
            projectNode.addProjectIndex(modfSet);
            return projectNode;
        }
        ArrayList fields = new ArrayList();
        if (this.searchType.equals("browse")) {
            logger.debug("SearchType: Browse  -- get all available presentation fields");
            fields = (ArrayList)session.getAttribute("presentationFields");
        } else if (!this.semanticEnrichment) {
            String snippet = (String)session.getAttribute("session_snippet_attr");
            String title = (String)session.getAttribute("session_title_attr");
            if (snippet != null) {
                logger.debug("snippet field '" + snippet + "' is available, project this");
                fields.add(snippet);
            }
            if (title != null) {
                logger.debug("title field '" + title + "' is available, project this");
                fields.add(title);
            }
        }
        if (fields.isEmpty()) {
            logger.debug("use all the available presentable fields");
            if (this.selectedPresentationFields.size() == 0) {
                logger.debug("profile presentation fields are empty, getting all the available");
                fields = (ArrayList)session.getAttribute("presentationFields");
            } else {
                logger.debug("using profile presentation fields");
                fields = this.selectedPresentationFields;
                this.selectedPresentationFields.clear();
            }
        }
        ArrayList<String> fieldStrings = new ArrayList<String>();
        logger.debug("Presentation num: " + fields.size());
        for (String field : fields) {
            ModifierSet modfSet = new ModifierSet(field);
            projectNode.addProjectIndex(modfSet);
            fieldStrings.add(field);
        }
        if (this.searchType.equals("browse")) {
            if (!fieldStrings.contains(this.browseBy)) {
                ModifierSet modfSet = new ModifierSet(this.browseBy);
                projectNode.addProjectIndex(modfSet);
                fields.add(this.browseBy);
                session.setAttribute("presentationFields", (Object)fields);
            }
        } else if (this.searchType.equals("advancedSearch")) {
            int i = 0;
            while (i < this.criteria.size()) {
                if (!fieldStrings.contains(this.criteria.get(i).getSearchFieldId())) {
                    ModifierSet modfSet = new ModifierSet(this.criteria.get(i).getSearchFieldId());
                    projectNode.addProjectIndex(modfSet);
                    fields.add(this.criteria.get(i).getSearchFieldId());
                    session.setAttribute("presentationFields", (Object)fields);
                }
                ++i;
            }
        }
        if (fields.size() != 0) {
            return projectNode;
        }
        return null;
    }

    protected GCQLNode getPresentationPartDistinct(ASLSession session) {
        GCQLProjectNode projectNode = new GCQLProjectNode();
        logger.debug("PresentationPart - browse distinct");
        ArrayList<String> fields = new ArrayList<String>();
        logger.debug("PresentationPart browse");
        ModifierSet modfSet = new ModifierSet(this.browseBy);
        modfSet.addModifier("distinct");
        fields.add(this.browseBy);
        projectNode.addProjectIndex(modfSet);
        if (fields.size() != 0) {
            return projectNode;
        }
        return null;
    }

    private HashMap<String, ArrayList<String>> readUserProfile(ASLSession session) throws ReadingUserProfileException {
        HashMap userPresentationFields = null;
        logger.debug("ASL UserProfile is deactivated.");
        try {
            if (userPresentationFields != null) {
                session.setAttribute("collectionsPresentableFields", userPresentationFields);
                logger.debug("size map: " + userPresentationFields.size());
            }
            return userPresentationFields;
        }
        catch (Exception e) {
            throw new ReadingUserProfileException(e);
        }
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        logger.debug("Setting sort by");
        this.sortBy = sortBy;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public ResultSetConsumerI getSearchResults(ASLSession session) {
        return this.searchRSC;
    }

    public List<String> getSelectedCollectionsNames(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> realCollections = this.getSelectedRealCollections(session);
        ArrayList<String> collectionNames = new ArrayList<String>();
        SearchHelper sh = new SearchHelper(session);
        for (String colId : realCollections) {
            CollectionInfo colInf = sh.findCollectionInfo(colId);
            if (colInf == null) continue;
            collectionNames.add(colInf.getName());
        }
        return collectionNames;
    }

    protected String[] findSearchMasterEPRFeather(ASLSession session) {
        logger.debug("Looking for a Search Master epr (using featherweight stack)");
        ScopeProvider.instance.set(session.getScope());
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        long starttime = System.currentTimeMillis();
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'Search'").addCondition("$resource/Profile/ServiceName/text() eq 'SearchSystemService'");
        List searchInstances = client.submit((org.gcube.resources.discovery.client.queries.api.Query)query);
        logger.debug("Found " + searchInstances.size() + " search service instances.");
        ArrayList<String> searchMasters = new ArrayList<String>();
        for (GCoreEndpoint searchInstance : searchInstances) {
            GCoreEndpoint.Profile.Endpoint endpoint;
            if (searchInstance == null || searchInstance.profile() == null || searchInstance.profile().endpointMap() == null || (endpoint = (GCoreEndpoint.Profile.Endpoint)searchInstance.profile().endpointMap().get(ENDPOINT_KEY)) == null || endpoint.uri() == null) continue;
            searchMasters.add(new String(endpoint.uri().toString()));
        }
        String[] epr = new String[searchMasters.size()];
        int i = 0;
        while (i < searchMasters.size()) {
            epr[i] = (String)searchMasters.get(i);
            ++i;
        }
        return epr;
    }

    protected Stream<GenericRecord> submitSearch(ISearchClient searchClient, String query, String searchMasterURI, ASLSession session) throws MalformedURLException, SearchASLException {
        logger.debug("parsing params of URI: " + searchMasterURI);
        logger.info("searchMasterURI: " + searchMasterURI);
        searchClient.setScope(session.getScopeName());
        searchClient.initializeClient(searchMasterURI);
        try {
            logger.debug("CALLING SEARCH WITH QUERY : \t" + query);
            String rsLocator = searchClient.query(query, null, false);
            URI rsURI = null;
            try {
                rsURI = new URI(rsLocator);
            }
            catch (Exception e) {
                throw new SearchASLException("Search returned an empty RS locator, cannot parse it", e);
            }
            Stream records = Streams.convert((URI)rsURI).of(GenericRecord.class).withTimeout(60, TimeUnit.SECONDS);
            if (records == null) {
                logger.debug("Search service returned a null result stream!");
                throw new StreamException("Returned search results stream is null!", null);
            }
            if (records.isClosed()) {
                logger.debug("Search service returned a closed result stream!");
                throw new StreamOpenException("Search results stream returned, is closed!", null);
            }
            return records;
        }
        catch (Exception e) {
            throw new SearchASLException("error while searching", e);
        }
    }

    public ArrayList<String> getSearchQueryTerms() {
        return this.searchQueryTerms;
    }
}

