/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.gcube.application.framework.search.library.util.Point;

public class GeospatialInfo
implements Cloneable {
    String relation;
    protected Date startingDate;
    protected Date endingDate;
    protected Point[] bounds;
    protected String startingDateString;
    protected String endingDateString;

    public GeospatialInfo() {
        this.relation = null;
        this.bounds = null;
        this.endingDate = null;
        this.startingDate = null;
        this.startingDateString = new String();
        this.endingDateString = new String();
    }

    public GeospatialInfo(String relation, Point[] bounds, Date startTime, Date endTime) {
        this.relation = relation;
        this.bounds = bounds;
        this.startingDate = startTime;
        this.endingDate = endTime;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd@hh:mm:ss");
        String tempDate = dateFormat.format(startTime);
        String[] tempMatrix = tempDate.split("@");
        this.startingDateString = String.valueOf(tempMatrix[0]) + "T" + tempMatrix[1];
        tempDate = dateFormat.format(endTime);
        tempMatrix = tempDate.split("@");
        this.endingDateString = String.valueOf(tempMatrix[0]) + "T" + tempMatrix[1];
    }

    public Point[] getBounds() {
        return this.bounds;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setBounds(Point[] bounds) {
        this.bounds = bounds;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd@hh:mm:ss");
        String tempDate = dateFormat.format(startingDate);
        String[] tempMatrix = tempDate.split("@");
        this.startingDateString = String.valueOf(tempMatrix[0]) + "T" + tempMatrix[1];
    }

    public Date getEndingDate() {
        return this.endingDate;
    }

    public void setEndingDate(Date endingDate) {
        this.endingDate = endingDate;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd@hh:mm:ss");
        String tempDate = dateFormat.format(endingDate);
        String[] tempMatrix = tempDate.split("@");
        this.endingDateString = String.valueOf(tempMatrix[0]) + "T" + tempMatrix[1];
    }

    public GeospatialInfo clone() {
        GeospatialInfo g = new GeospatialInfo();
        g.bounds = new Point[this.bounds.length];
        int i = 0;
        while (i < g.bounds.length) {
            g.bounds[i] = this.bounds[i];
            ++i;
        }
        g.endingDate = this.endingDate != null ? (Date)this.endingDate.clone() : null;
        g.startingDate = this.startingDate != null ? (Date)this.startingDate.clone() : null;
        g.relation = this.relation != null ? new String(this.relation) : null;
        this.startingDateString = new String(this.startingDateString);
        this.endingDateString = new String(this.endingDateString);
        return g;
    }

    public String getStartingDateString() {
        return this.startingDateString;
    }

    public String getEndingDateString() {
        return this.endingDateString;
    }
}

