/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.LinkedList;
import org.jgroups.util.FixedSizeBitSet;
import org.jgroups.util.Range;
import org.jgroups.util.Seqno;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqnoRange
extends Seqno {
    final long high;
    final FixedSizeBitSet bits;

    public SeqnoRange(long low, long high) {
        super(low);
        this.high = high;
        if (low > high) {
            throw new IllegalArgumentException("low (" + low + ") must be <= high (" + high + ")");
        }
        int size = (int)(high - low + 1L);
        this.bits = new FixedSizeBitSet(size);
    }

    public long getHigh() {
        return this.high;
    }

    @Override
    public boolean contains(long num) {
        return num >= this.low && num <= this.high;
    }

    @Override
    public boolean get(long num) {
        return this.bits.get(this.getIndex((int)num));
    }

    @Override
    public void set(long num) {
        this.bits.set(this.getIndex((int)num));
    }

    public void set(long ... nums) {
        if (nums != null) {
            for (long num : nums) {
                this.set(num);
            }
        }
    }

    @Override
    public void clear(long num) {
        this.bits.clear(this.getIndex((int)num));
    }

    public void clear(long ... nums) {
        if (nums != null) {
            for (long num : nums) {
                this.clear(num);
            }
        }
    }

    @Override
    public int getNumberOfReceivedMessages() {
        return this.bits.cardinality();
    }

    @Override
    public int getNumberOfMissingMessages() {
        return this.size() - this.getNumberOfReceivedMessages();
    }

    @Override
    public int size() {
        return (int)(this.high - this.low + 1L);
    }

    @Override
    public Collection<Range> getMessagesToRetransmit() {
        return this.getBits(false);
    }

    @Override
    public String toString() {
        return this.low + "-" + this.high;
    }

    @Override
    public String print() {
        return this.low + "-" + this.high + ", set=" + this.printBits(true) + ", cleared=" + this.printBits(false);
    }

    protected int getIndex(int num) {
        if ((long)num < this.low || (long)num > this.high) {
            throw new IllegalArgumentException(num + " is outside the range " + this.toString());
        }
        return (int)((long)num - this.low);
    }

    public String printBits(boolean value) {
        Collection<Range> ranges = this.getBits(value);
        StringBuilder sb = new StringBuilder();
        if (ranges != null && !ranges.isEmpty()) {
            boolean first = true;
            for (Range range : ranges) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                if (range.low == range.high) {
                    sb.append(range.low);
                    continue;
                }
                sb.append(range.low).append("-").append(range.high);
            }
        }
        return sb.toString();
    }

    public Collection<Range> getBits(boolean value) {
        int index = 0;
        int start_range = 0;
        int end_range = 0;
        int size = (int)(this.high - this.low + 1L);
        LinkedList<Range> retval = new LinkedList<Range>();
        while (index < size) {
            int n = start_range = value ? this.bits.nextSetBit(index) : this.bits.nextClearBit(index);
            if (start_range < 0 || start_range >= size) break;
            int n2 = end_range = value ? this.bits.nextClearBit(start_range) : this.bits.nextSetBit(start_range);
            if (end_range < 0 || end_range >= size) {
                retval.add(new Range((long)start_range + this.low, (long)(size - 1) + this.low));
                break;
            }
            retval.add(new Range((long)start_range + this.low, (long)(end_range - 1) + this.low));
            index = end_range;
        }
        return retval;
    }
}

