/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.FragHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="Fragments messages larger than fragmentation size into smaller packets")
public class FRAG
extends Protocol {
    @Property(description="The max number of bytes in a message. Larger messages will be fragmented. Default is 8192 bytes")
    private int frag_size = 8192;
    @Property(description="The max size in bytes for the byte array output buffer")
    private int max_retained_buffer = 70000;
    private final FragmentationList fragment_list = new FragmentationList();
    private int curr_id = 1;
    private final ExposedByteArrayOutputStream bos = new ExposedByteArrayOutputStream(1024);
    private final Vector<Address> members = new Vector(11);
    @ManagedAttribute(description="Number of sent messages")
    long num_sent_msgs = 0L;
    @ManagedAttribute(description="Number of sent fragments")
    long num_sent_frags = 0L;
    @ManagedAttribute(description="Number of received messages")
    long num_received_msgs = 0L;
    @ManagedAttribute(description="Number of received fragments")
    long num_received_frags = 0L;

    public int getFragSize() {
        return this.frag_size;
    }

    public void setFragSize(int s) {
        this.frag_size = s;
    }

    public long getNumberOfSentMessages() {
        return this.num_sent_msgs;
    }

    public long getNumberOfSentFragments() {
        return this.num_sent_frags;
    }

    public long getNumberOfReceivedMessages() {
        return this.num_received_msgs;
    }

    public long getNumberOfReceivedFragments() {
        return this.num_received_frags;
    }

    @Override
    public void init() throws Exception {
        super.init();
        HashMap<String, Integer> info = new HashMap<String, Integer>(1);
        info.put("frag_size", this.frag_size);
        this.up_prot.up(new Event(56, info));
        this.down_prot.down(new Event(56, info));
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_received_frags = 0L;
        this.num_received_msgs = 0L;
        this.num_sent_frags = 0L;
        this.num_sent_msgs = 0L;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                long size = msg.size();
                ++this.num_sent_msgs;
                if (size <= (long)this.frag_size) break;
                if (this.log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder("message size is ");
                    sb.append(size).append(", will fragment (frag_size=").append(this.frag_size).append(')');
                    this.log.trace(sb.toString());
                }
                this.fragment(msg);
                return null;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                Object ret = this.down_prot.down(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((Map)evt.getArg());
                return ret;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FragHeader hdr = (FragHeader)msg.getHeader(this.name);
                if (hdr != null) {
                    this.unfragment(msg, hdr);
                    return null;
                }
                ++this.num_received_msgs;
                break;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                Object ret = this.up_prot.up(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((Map)evt.getArg());
                return ret;
            }
        }
        return this.up_prot.up(evt);
    }

    private void handleViewChange(View view) {
        Vector<Address> new_mbrs = view.getMembers();
        Vector<Address> left_mbrs = Util.determineLeftMembers(this.members, new_mbrs);
        this.members.clear();
        this.members.addAll(new_mbrs);
        for (Address mbr : left_mbrs) {
            this.fragment_list.remove(mbr);
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("[VIEW_CHANGE] removed " + mbr + " from fragmentation table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fragment(Message msg) {
        DataOutputStream out = null;
        Address dest = msg.getDest();
        Address src = msg.getSrc();
        long id = this.curr_id++;
        try {
            byte[][] fragments;
            byte[] buffer;
            ExposedByteArrayOutputStream exposedByteArrayOutputStream = this.bos;
            synchronized (exposedByteArrayOutputStream) {
                this.bos.reset(this.max_retained_buffer);
                out = new DataOutputStream(this.bos);
                msg.writeTo(out);
                out.flush();
                buffer = this.bos.getRawBuffer();
                fragments = Util.fragmentBuffer(buffer, this.frag_size, this.bos.size());
            }
            int num_frags = fragments.length;
            this.num_sent_frags += (long)num_frags;
            if (this.log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("fragmenting packet to ").append(dest != null ? dest.toString() : "<all members>");
                sb.append(" (size=").append(buffer.length).append(") into ").append(num_frags);
                sb.append(" fragment(s) [frag_size=").append(this.frag_size).append(']');
                this.log.trace(sb.toString());
            }
            for (int i = 0; i < num_frags; ++i) {
                Message frag_msg = new Message(dest, src, fragments[i]);
                FragHeader hdr = new FragHeader(id, i, num_frags);
                frag_msg.putHeader(this.name, hdr);
                Event evt = new Event(1, frag_msg);
                this.down_prot.down(evt);
            }
            Util.close(out);
        }
        catch (Exception e) {
            this.log.error("exception occurred trying to fragment message", e);
        }
        finally {
            Util.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unfragment(Message msg, FragHeader hdr) {
        Address sender = msg.getSrc();
        DataInputStream in = null;
        FragmentationTable frag_table = this.fragment_list.get(sender);
        if (frag_table == null) {
            frag_table = new FragmentationTable(sender);
            try {
                this.fragment_list.add(sender, frag_table);
            }
            catch (IllegalArgumentException x) {
                frag_table = this.fragment_list.get(sender);
            }
        }
        ++this.num_received_frags;
        byte[] m = frag_table.add(hdr.id, hdr.frag_id, hdr.num_frags, msg.getBuffer());
        if (m != null) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(m);
                in = new DataInputStream(bis);
                Message assembled_msg = new Message(false);
                assembled_msg.readFrom(in);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("assembled_msg is " + assembled_msg);
                }
                assembled_msg.setSrc(sender);
                ++this.num_received_msgs;
                this.up_prot.up(new Event(1, assembled_msg));
            }
            catch (Exception e) {
                try {
                    this.log.error("failed unfragmenting a message", e);
                }
                catch (Throwable throwable) {
                    Util.close(in);
                    throw throwable;
                }
                Util.close(in);
            }
            Util.close(in);
        }
    }

    void handleConfigEvent(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.frag_size = (Integer)map.get("frag_size");
            if (this.log.isDebugEnabled()) {
                this.log.debug("setting frag_size=" + this.frag_size);
            }
        }
    }

    static class FragmentationTable {
        private final Address sender;
        private final Hashtable<Long, FragEntry> h = new Hashtable(11);

        FragmentationTable(Address sender) {
            this.sender = sender;
        }

        public synchronized byte[] add(long id, int frag_id, int tot_frags, byte[] fragment) {
            byte[] retval = null;
            FragEntry e = this.h.get(new Long(id));
            if (e == null) {
                e = new FragEntry(id, tot_frags);
                this.h.put(new Long(id), e);
            }
            e.set(frag_id, fragment);
            if (e.isComplete()) {
                retval = e.assembleBuffer();
                this.h.remove(new Long(id));
            }
            return retval;
        }

        public void reset() {
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("Fragmentation Table Sender:").append(this.sender).append("\n\t");
            Enumeration<FragEntry> e = this.h.elements();
            while (e.hasMoreElements()) {
                FragEntry entry = e.nextElement();
                int count = 0;
                for (int i = 0; i < entry.fragments.length; ++i) {
                    if (entry.fragments[i] == null) continue;
                    ++count;
                }
                buf.append("Message ID:").append(entry.msg_id).append("\n\t");
                buf.append("Total Frags:").append(entry.tot_frags).append("\n\t");
                buf.append("Frags Received:").append(count).append("\n\n");
            }
            return buf.toString();
        }

        static class FragEntry {
            int tot_frags = 0;
            byte[][] fragments = null;
            int number_of_frags_recvd = 0;
            long msg_id = -1L;

            FragEntry(long msg_id, int tot_frags) {
                this.msg_id = msg_id;
                this.tot_frags = tot_frags;
                this.fragments = new byte[tot_frags][];
                for (int i = 0; i < tot_frags; ++i) {
                    this.fragments[i] = null;
                }
            }

            public void set(int frag_id, byte[] frag) {
                this.fragments[frag_id] = frag;
                ++this.number_of_frags_recvd;
            }

            public boolean isComplete() {
                if (this.number_of_frags_recvd < this.tot_frags) {
                    return false;
                }
                for (int i = 0; i < this.fragments.length; ++i) {
                    if (this.fragments[i] != null) continue;
                    return false;
                }
                return true;
            }

            public byte[] assembleBuffer() {
                return Util.defragmentBuffer(this.fragments);
            }

            public String toString() {
                StringBuilder ret = new StringBuilder();
                ret.append("[tot_frags=").append(this.tot_frags).append(", number_of_frags_recvd=").append(this.number_of_frags_recvd).append(']');
                return ret.toString();
            }

            public int hashCode() {
                return super.hashCode();
            }
        }
    }

    static class FragmentationList {
        private final HashMap<Address, FragmentationTable> frag_tables = new HashMap(11);

        FragmentationList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Address sender, FragmentationTable table) throws IllegalArgumentException {
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                FragmentationTable healthCheck = this.frag_tables.get(sender);
                if (healthCheck != null) {
                    throw new IllegalArgumentException("Sender <" + sender + "> already exists in the fragementation list");
                }
                this.frag_tables.put(sender, table);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FragmentationTable get(Address sender) {
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                return this.frag_tables.get(sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsSender(Address sender) {
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                return this.frag_tables.containsKey(sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Address sender) {
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                boolean result = this.containsSender(sender);
                this.frag_tables.remove(sender);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Address[] getSenders() {
            Address[] result;
            int index = 0;
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                result = new Address[this.frag_tables.size()];
                Iterator<Address> it = this.frag_tables.keySet().iterator();
                while (it.hasNext()) {
                    result[index++] = it.next();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder buf = new StringBuilder("Fragmentation list contains ");
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                buf.append(this.frag_tables.size()).append(" tables\n");
                for (Map.Entry<Address, FragmentationTable> entry : this.frag_tables.entrySet()) {
                    buf.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
            }
            return buf.toString();
        }
    }
}

