/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.gcube.application.framework.contentmanagement.model.CollectionInfo;
import org.gcube.application.framework.core.util.SearchField;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindInfo {
    private static final Logger logger = LoggerFactory.getLogger(FindInfo.class);
    public static final String ALL = "ALL";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";

    public static CollectionInfo findCollectionInfo(String colID, List<CollectionInfo>[] collections) {
        if (collections != null) {
            int counter = 0;
            while (counter < collections.length) {
                int c2 = 0;
                while (c2 < collections[counter].size()) {
                    logger.info("compare: " + collections[counter].get(c2).getId() + " with: " + colID);
                    if (collections[counter].get(c2).getId().equals(colID)) {
                        logger.info("equal!!");
                        return collections[counter].get(c2);
                    }
                    ++c2;
                }
                ++counter;
            }
        } else {
            logger.info("No collections!!");
            return null;
        }
        logger.info("Null!!");
        return null;
    }

    public static CollectionInfo findCollectionInfoFromMetadata(String metadataColID, List<CollectionInfo>[] collections) {
        int counter = 0;
        while (counter < collections.length) {
            int c2 = 1;
            while (c2 < collections[counter].size()) {
                int c3 = 0;
                while (c3 < collections[counter].get(c2).getMetadataSize()) {
                    if (collections[counter].get(c2).getMetadataID(c3).equals(metadataColID)) {
                        return collections[counter].get(c2);
                    }
                    ++c3;
                }
                ++c2;
            }
            ++counter;
        }
        return null;
    }

    public static String getMCOIDFromISID(String MCISID, String scope) throws Exception {
        ScopeProvider.instance.set(scope);
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + MCISID + "'");
        logger.info("The query expression is: << " + query.expression() + " >>");
        List results = null;
        try {
            results = client.submit((Query)query);
        }
        catch (Exception e) {
            logger.debug(e.toString());
        }
        if (results != null && results.size() > 0) {
            return ((GenericResource)results.get(0)).id();
        }
        logger.debug("getMCOIDFromISID() -> Query to IS returned no results !");
        return null;
    }

    public static List<CollectionInfo> searchCollectionInfo(String term, String whereToSearch, List<CollectionInfo>[] collections) {
        term = (term = term.trim().toLowerCase()).startsWith("*") ? term.substring(1) : "(\\s|\\p{Punct})" + term;
        term = term.endsWith("*") ? term.substring(0, term.length() - 1) : String.valueOf(term) + "(\\s|\\p{Punct})";
        term = term.replaceAll("\\x2A", ".*");
        term = term.replaceAll("\\x3F", ".");
        Pattern pattern = Pattern.compile(term);
        boolean name = false;
        boolean descr = false;
        if (whereToSearch.equals(ALL)) {
            name = true;
            descr = true;
        } else if (whereToSearch.equals(NAME)) {
            name = true;
        } else if (whereToSearch.equals(DESCRIPTION)) {
            descr = true;
        }
        ArrayList<CollectionInfo> res = new ArrayList<CollectionInfo>();
        int counter = 0;
        while (counter < collections.length) {
            int c2 = 0;
            while (c2 < collections[counter].size()) {
                if (name && pattern.matcher(" " + collections[counter].get(c2).getName().toLowerCase() + " ").find()) {
                    res.add(collections[counter].get(c2));
                } else if (descr && pattern.matcher(" " + collections[counter].get(c2).getDescription().toLowerCase() + " ").find()) {
                    res.add(collections[counter].get(c2));
                }
                ++c2;
            }
            ++counter;
        }
        return res;
    }

    public static int findCollectionSchema(String schemaName, CollectionInfo collection) {
        int counter = 0;
        while (counter < collection.getMetadataSize()) {
            if (collection.getSchema(counter).equals(schemaName)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public static int findCollectionSchema(String schemaName, String schemaLanguage, CollectionInfo collection) {
        int counter = 0;
        while (counter < collection.getMetadataSize()) {
            if (collection.getSchema(counter).equals(schemaName) && collection.getLanguage(counter).equals(schemaLanguage)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public static int findCriterion(String name, String schemaName, HashMap<String, List<SearchField>> SchemaHashMap) {
        List<SearchField> schemaCriteria = SchemaHashMap.get(schemaName);
        int counter = 0;
        while (counter < schemaCriteria.size()) {
            if (schemaCriteria.get((int)counter).name.equals(name)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public static HashMap<String, String> getCollectionNames(List<CollectionInfo>[] collections) {
        HashMap<String, String> collectionMap = new HashMap<String, String>();
        collectionMap = new HashMap();
        if (collections == null) {
            return collectionMap;
        }
        int i = 0;
        while (i < collections.length) {
            int k = 0;
            while (k < collections[i].size()) {
                int j = 0;
                while (j < collections[i].get(k).getMetadataSize()) {
                    collectionMap.put(collections[i].get(k).getMetadataID(j), collections[i].get(k).getName());
                    ++j;
                }
                collectionMap.put(collections[i].get(k).getId(), collections[i].get(k).getName());
                ++k;
            }
            ++i;
        }
        return collectionMap;
    }
}

