/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.datatransformation.util;

import java.util.ArrayList;
import org.gcube.application.framework.contentmanagement.exceptions.OCRException;
import org.gcube.application.framework.contentmanagement.exceptions.ServiceEPRRetrievalException;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.util.ServiceType;
import org.gcube.application.framework.core.util.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransformationUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataTransformationUtils.class);

    private static DocumentInfos findDocumentInfosFromDocumentURI(ArrayList<DocumentInfos> allDocuments, String documentURI) {
        int i = 0;
        while (i < allDocuments.size()) {
            logger.info("Comparing: " + allDocuments.get(i).getPdfURI() + " with " + documentURI);
            if (allDocuments.get(i).getPdfURI().equals(documentURI)) {
                return allDocuments.get(i);
            }
            ++i;
        }
        return null;
    }

    private static boolean getStatusReport(String report, String sourceId) {
        logger.info("Getting report for document: " + sourceId);
        return !report.contains("<STATUS>FAILED</STATUS>");
    }

    public static ArrayList<String> performOCRtoPDF_HTTPInput(ArrayList<DocumentInfos> documents, String outputCollectionId, ASLSession session) throws ServiceEPRRetrievalException, OCRException {
        return new ArrayList<String>();
    }

    private static String getOCRServiceEPR(ASLSession session) {
        String ocrService = null;
        logger.info("Looking for an OCRService epr");
        try {
            ocrService = ServiceUtils.getEprAddressOfService((String)"Execution", (String)"OCRService", (String)ServiceType.FACTORY.name(), (String)session.getScope());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (ocrService == null || ocrService.isEmpty()) {
            logger.info("The ocrService epr is NULL");
            return null;
        }
        logger.info("The ocrService epr is: " + ocrService);
        return ocrService;
    }
}

