/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.content.impl;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.contentmanagement.content.impl.Collection;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObjectType;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalObject {
    private static final Logger logger = LoggerFactory.getLogger(DigitalObject.class);
    private ASLSession session = null;
    private AccessLogger accessLogger = AccessLogger.getAccessLogger();
    private String colID;
    private TReader treader = null;
    private String objectURI;
    private DigitalObjectType objectType = null;
    private String objectScope;
    private String objectID;
    private String objectContent = null;
    private String HTMLRepresentation = null;
    private String title = null;
    private String mimeType = "XML_URL";
    private String collectionName;
    private String rank;

    public DigitalObject(ASLSession session, String objectURI, String colID) {
        logger.info("The objectURI(1) is: " + objectURI);
        this.objectURI = objectURI;
        this.session = session;
        this.colID = colID;
        logger.info("The collectionID(1) of the object is: " + colID);
        try {
            this.collectionName = Collection.getCollectionNameByID(this.colID);
        }
        catch (ResourceRegistryException e1) {
            logger.error("The Digital Object cannot be created, because of the exception: ", (Throwable)e1);
            return;
        }
        logger.info("The collectionName(1) of the object is: " + this.collectionName);
        if (objectURI != null && objectURI.contains("/tree/")) {
            URI uri = null;
            try {
                uri = new URI(objectURI);
            }
            catch (URISyntaxException e1) {
                logger.error("The Digital Object cannot be created, because of the exception: ", (Throwable)e1);
                return;
            }
            this.objectScope = uri.getQuery().split("=")[1];
            logger.info("The scope(1) of the object is: " + this.objectScope);
            this.objectID = uri.getPath().split("/")[3];
            logger.info("The ID(1) of the object is: " + this.objectID);
        } else {
            this.objectType = DigitalObjectType.Generic;
        }
    }

    public DigitalObject(ASLSession session, String objectURI) {
        logger.info("The objectURI is: " + objectURI);
        this.objectURI = objectURI;
        this.session = session;
        if (objectURI != null && objectURI.contains("/tree/")) {
            URI uri = null;
            try {
                uri = new URI(objectURI);
            }
            catch (URISyntaxException e1) {
                logger.error("The Digital Object cannot be created, because of the exception: ", (Throwable)e1);
                return;
            }
            this.objectScope = uri.getQuery().split("=")[1];
            logger.info("The scope of the object is: " + this.objectScope);
            this.objectID = uri.getPath().split("/")[3];
            logger.info("The ID of the object is: " + this.objectID);
            this.colID = uri.getPath().split("/")[2];
            logger.info("The collectionID of the object is: " + this.colID);
            try {
                this.collectionName = Collection.getCollectionNameByID(this.colID);
            }
            catch (ResourceRegistryException e1) {
                logger.error("The Digital Object cannot be created, because of the exception: ", (Throwable)e1);
                return;
            }
            logger.info("The collectionName of the object is: " + this.collectionName);
        } else {
            this.objectType = DigitalObjectType.Generic;
        }
    }

    public String getURI() {
        return this.objectURI;
    }

    public String getObjectId() {
        return this.objectID;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getCollectionID() {
        return this.colID;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getHTMLrepresentation() {
        return this.HTMLRepresentation;
    }

    public void setHTMLRepresentation(String representation) {
        this.HTMLRepresentation = representation;
    }

    public long getLength() {
        return 0L;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public String getRank() {
        return "";
    }

    public String getContent() throws IllegalStateException, IOException {
        HttpURLConnection connection = null;
        if (this.objectContent != null) {
            logger.info("The content of the object is: " + this.objectContent);
            return this.objectContent;
        }
        URL url = new URL(this.objectURI);
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        InputStream is = connection.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line = null;
        while ((line = rd.readLine()) != null) {
            response.append(String.valueOf(line) + '\r');
        }
        rd.close();
        this.objectContent = response.toString();
        if (connection != null) {
            connection.disconnect();
        }
        return this.objectContent;
    }

    public void setContent(String content) {
        this.objectContent = content;
    }

    public DigitalObjectType getType() {
        if (this.objectType != null) {
            logger.info("The type of the object is: " + (Object)((Object)this.objectType));
            return this.objectType;
        }
        String type = "";
        ScopeProvider.instance.set(this.objectScope);
        XQuery query = ICFactory.queryFor(ServiceInstance.class);
        query.addNamespace("tm", URI.create("http://gcube-system.org/namespaces/data/tm")).addCondition("$resource/Data/gcube:ServiceClass/text() eq 'DataAccess'").addCondition("$resource/Data/gcube:ServiceName/text() eq 'tree-manager-service'").addCondition("$resource/Data/tm:SourceId/text() eq '" + this.colID + "'").addVariable("$type", "$resource/Data/tm:Type").setResult("local-name-from-QName(resolve-QName($type/text(),$type))");
        DiscoveryClient client = ICFactory.client();
        try {
            HashSet props = new HashSet(client.submit((Query)query));
            type = props != null && !props.isEmpty() ? (String)props.iterator().next() : "";
        }
        catch (Exception e) {
            logger.error("It's either not a tree type or a known tree type, setting it to Generic...");
            this.objectType = DigitalObjectType.Generic;
            return this.objectType;
        }
        try {
            if (type != null && type != "") {
                logger.info("Setting the Type of the object to: " + type);
                this.objectType = DigitalObjectType.valueOf(type);
            }
        }
        catch (NullPointerException ex) {
            logger.debug("Type " + type + " is not a known DigitalObjectType, setting it to Generic!");
            this.objectType = DigitalObjectType.Generic;
        }
        catch (IllegalArgumentException ex) {
            logger.debug("Type " + type + " is not a known DigitalObjectType, setting it to Generic!");
            this.objectType = DigitalObjectType.Generic;
        }
        return this.objectType;
    }

    public void setType(String type) {
        logger.debug("Setting objectType: " + type);
        this.objectType = DigitalObjectType.valueOf(type);
    }

    public static DigitalObject createNewDigitalObject(String colID, InputStream content, String objectID, ASLSession session, String mimeType) throws IOException {
        BufferedReader breader = new BufferedReader(new InputStreamReader(content));
        StringBuilder cont = new StringBuilder();
        String inputLine = null;
        while ((inputLine = breader.readLine()) != null) {
            cont.append(inputLine);
        }
        breader.close();
        DigitalObject newObject = new DigitalObject(session, objectID, colID);
        newObject.setMimeType(mimeType);
        newObject.setContent(cont.toString());
        return newObject;
    }

    public InputStream getObject() throws URISyntaxException, IOException {
        InputStream istream = null;
        URL url = new URL(new URI(this.objectURI).toURL().toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        istream = connection.getInputStream();
        return istream;
    }

    public static String getContent(String objectID, String scope) throws URISyntaxException, IOException {
        URL url = new URL(new URI(objectID).toURL().toString());
        HttpURLConnection connection = null;
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        InputStream is = connection.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line = null;
        while ((line = rd.readLine()) != null) {
            response.append(String.valueOf(line) + '\r');
        }
        rd.close();
        if (connection != null) {
            connection.disconnect();
        }
        return response.toString();
    }
}

