/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.MutatableFilter;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.WholeImageFilter;
import com.jhlabs.math.Noise;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import java.util.Random;

public class CellularFilter
extends WholeImageFilter
implements MutatableFilter,
Cloneable,
Serializable {
    protected double scale = 32.0;
    protected double stretch = 1.0;
    protected double angle = 0.0;
    public double amount = 1.0;
    public double turbulence = 1.0;
    public double gain = 0.5;
    public double bias = 0.5;
    public double distancePower = 2.0;
    public boolean useColor = false;
    protected Colormap colormap = new Gradient();
    protected double[] coefficients;
    protected double angleCoefficient;
    protected Random random;
    protected double m00;
    protected double m01;
    protected double m10;
    protected double m11;
    protected Point[] results;
    protected double randomness;
    protected int gridType;
    public static final int RANDOM = 0;
    public static final int SQUARE = 1;
    public static final int HEXAGONAL = 2;
    public static final int OCTAGONAL = 3;
    public static final int TRIANGULAR = 4;

    public CellularFilter() {
        double[] dArray = new double[4];
        dArray[0] = 1.0;
        this.coefficients = dArray;
        this.random = new Random();
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.results = null;
        this.randomness = 0.0;
        this.gridType = 2;
        this.results = new Point[3];
        int n = 0;
        while (n < this.results.length) {
            this.results[n] = new Point();
            ++n;
        }
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setStretch(double d) {
        this.stretch = d;
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setAngle(double d) {
        this.angle = d;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = -d3;
        this.m11 = d2;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setCoefficient(int n, double d) {
        this.coefficients[n] = d;
    }

    public double getCoefficient(int n) {
        return this.coefficients[n];
    }

    public void setAngleCoefficient(double d) {
        this.angleCoefficient = d;
    }

    public double getAngleCoefficient() {
        return this.angleCoefficient;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setRandomness(double d) {
        this.randomness = d;
    }

    public double getRandomness() {
        return this.randomness;
    }

    public void setGridType(int n) {
        this.gridType = n;
    }

    public int getGridType() {
        return this.gridType;
    }

    public void setDistancePower(double d) {
        this.distancePower = d;
    }

    public double getDistancePower() {
        return this.distancePower;
    }

    public void setTurbulence(double d) {
        this.turbulence = d;
    }

    public double getTurbulence() {
        return this.turbulence;
    }

    public void setAmount(double d) {
        this.amount = d;
    }

    public double getAmount() {
        return this.amount;
    }

    private double checkCube(double d, double d2, int n, int n2, Point[] pointArray) {
        int n3;
        this.random.setSeed(571 * n + 23 * n2);
        switch (this.gridType) {
            default: {
                n3 = 4;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 2;
            }
        }
        int n4 = 0;
        while (n4 < n3) {
            Point point;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 1.0;
            switch (this.gridType) {
                case 0: {
                    d3 = this.random.nextDouble();
                    d4 = this.random.nextDouble();
                    break;
                }
                case 1: {
                    d4 = 0.5;
                    d3 = 0.5;
                    if (this.randomness == 0.0) break;
                    d3 += this.randomness * (this.random.nextDouble() - 0.5);
                    d4 += this.randomness * (this.random.nextDouble() - 0.5);
                    break;
                }
                case 2: {
                    if ((n & 1) == 0) {
                        d3 = 0.75;
                        d4 = 0.0;
                    } else {
                        d3 = 0.75;
                        d4 = 0.5;
                    }
                    if (this.randomness == 0.0) break;
                    d3 += this.randomness * Noise.noise2(271.0 * ((double)n + d3), 271.0 * ((double)n2 + d4));
                    d4 += this.randomness * Noise.noise2(271.0 * ((double)n + d3) + 89.0, 271.0 * ((double)n2 + d4) + 137.0);
                    break;
                }
                case 3: {
                    switch (n4) {
                        case 0: {
                            d3 = 0.207;
                            d4 = 0.207;
                            break;
                        }
                        case 1: {
                            d3 = 0.707;
                            d4 = 0.707;
                            d5 = 1.6;
                            break;
                        }
                    }
                    if (this.randomness == 0.0) break;
                    d3 += this.randomness * Noise.noise2(271.0 * ((double)n + d3), 271.0 * ((double)n2 + d4));
                    d4 += this.randomness * Noise.noise2(271.0 * ((double)n + d3) + 89.0, 271.0 * ((double)n2 + d4) + 137.0);
                    break;
                }
                case 4: {
                    if ((n2 & 1) == 0) {
                        if (n4 == 0) {
                            d3 = 0.25;
                            d4 = 0.35;
                        } else {
                            d3 = 0.75;
                            d4 = 0.65;
                        }
                    } else if (n4 == 0) {
                        d3 = 0.75;
                        d4 = 0.35;
                    } else {
                        d3 = 0.25;
                        d4 = 0.65;
                    }
                    if (this.randomness == 0.0) break;
                    d3 += this.randomness * Noise.noise2(271.0 * ((double)n + d3), 271.0 * ((double)n2 + d4));
                    d4 += this.randomness * Noise.noise2(271.0 * ((double)n + d3) + 89.0, 271.0 * ((double)n2 + d4) + 137.0);
                    break;
                }
            }
            double d6 = Math.abs(d - d3);
            double d7 = Math.abs(d2 - d4);
            double d8 = this.distancePower == 1.0 ? d6 + d7 : (this.distancePower == 2.0 ? Math.sqrt(d6 * d6 + d7 * d7) : Math.pow(Math.pow(d6 *= d5, this.distancePower) + Math.pow(d7 *= d5, this.distancePower), 1.0 / this.distancePower));
            if (d8 < pointArray[0].distance) {
                point = pointArray[2];
                pointArray[2] = pointArray[1];
                pointArray[1] = pointArray[0];
                pointArray[0] = point;
                point.distance = d8;
                point.x = (double)n + d3;
                point.y = (double)n2 + d4;
            } else if (d8 < pointArray[1].distance) {
                point = pointArray[2];
                pointArray[2] = pointArray[1];
                pointArray[1] = point;
                point.distance = d8;
                point.x = (double)n + d3;
                point.y = (double)n2 + d4;
            } else if (d8 < pointArray[2].distance) {
                point = pointArray[2];
                point.distance = d8;
                point.x = (double)n + d3;
                point.y = (double)n2 + d4;
            }
            ++n4;
        }
        return pointArray[2].distance;
    }

    protected double distance(double d, double d2) {
        int n = 0;
        while (n < this.results.length) {
            this.results[n].distance = Double.POSITIVE_INFINITY;
            ++n;
        }
        int n2 = (int)d;
        double d3 = d - (double)n2;
        int n3 = (int)d2;
        double d4 = d2 - (double)n3;
        double d5 = this.checkCube(d3, d4, n2, n3, this.results);
        if (d5 > d4) {
            d5 = this.checkCube(d3, d4 + 1.0, n2, n3 - 1, this.results);
        }
        if (d5 > 1.0 - d4) {
            d5 = this.checkCube(d3, d4 - 1.0, n2, n3 + 1, this.results);
        }
        if (d5 > d3) {
            this.checkCube(d3 + 1.0, d4, n2 - 1, n3, this.results);
            if (d5 > d4) {
                d5 = this.checkCube(d3 + 1.0, d4 + 1.0, n2 - 1, n3 - 1, this.results);
            }
            if (d5 > 1.0 - d4) {
                d5 = this.checkCube(d3 + 1.0, d4 - 1.0, n2 - 1, n3 + 1, this.results);
            }
        }
        if (d5 > 1.0 - d3) {
            d5 = this.checkCube(d3 - 1.0, d4, n2 + 1, n3, this.results);
            if (d5 > d4) {
                d5 = this.checkCube(d3 - 1.0, d4 + 1.0, n2 + 1, n3 - 1, this.results);
            }
            if (d5 > 1.0 - d4) {
                d5 = this.checkCube(d3 - 1.0, d4 - 1.0, n2 + 1, n3 + 1, this.results);
            }
        }
        double d6 = 0.0;
        int n4 = 0;
        while (n4 < 3) {
            d6 += this.coefficients[n4] * this.results[n4].distance;
            ++n4;
        }
        if (this.angleCoefficient != 0.0) {
            double d7 = Math.atan2(d2 - this.results[0].y, d - this.results[0].x);
            if (d7 < 0.0) {
                d7 += Math.PI * 2;
            }
            d6 += this.angleCoefficient * (d7 /= Math.PI * 4);
        }
        return d6;
    }

    public double turbulence2(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 1.0;
        while (d5 <= d3) {
            d4 += this.distance(d5 * d, d5 * d2) / d5;
            d5 *= 2.0;
        }
        return d4;
    }

    public int getPixel(int n, int n2, int[] nArray, int n3, int n4) {
        try {
            double d = this.m00 * (double)n + this.m01 * (double)n2;
            double d2 = this.m10 * (double)n + this.m11 * (double)n2;
            d /= this.scale;
            d2 /= this.scale * this.stretch;
            double d3 = this.turbulence == 1.0 ? this.distance(d, d2) : this.turbulence2(d += 1000.0, d2 += 1000.0, this.turbulence);
            d3 *= 2.0;
            d3 *= this.amount;
            int n5 = -16777216;
            if (this.colormap != null) {
                int n6 = this.colormap.getColor(d3);
                if (this.useColor) {
                    int n7 = ImageMath.clamp((int)((this.results[0].x - 1000.0) * this.scale), 0, n3 - 1);
                    int n8 = ImageMath.clamp((int)((this.results[0].y - 1000.0) * this.scale), 0, n4 - 1);
                    n6 = nArray[n8 * n3 + n7];
                    d3 = (this.results[1].distance - this.results[0].distance) / (this.results[1].distance + this.results[0].distance);
                    d3 = ImageMath.smoothStep(this.coefficients[1], this.coefficients[0], d3);
                    n6 = ImageMath.mixColors(d3, -16777216, n6);
                }
                return n6;
            }
            int n9 = PixelUtils.clamp((int)(d3 * 255.0));
            int n10 = n9 << 16;
            int n11 = n9 << 8;
            int n12 = n9;
            return n5 | n10 | n11 | n12;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int n4 = 0;
        int[] nArray = new int[n2 * n3];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n2) {
                nArray[n4++] = this.getPixel(n6, n5, this.inPixels, n2, n3);
                ++n6;
            }
            ++n5;
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public void mutate(int n, ImageFilter imageFilter, boolean bl, boolean bl2) {
        CellularFilter cellularFilter = (CellularFilter)imageFilter;
        this.random.setSeed((int)System.currentTimeMillis());
        if (bl || n == 0) {
            cellularFilter.setGridType(this.getGridType());
            cellularFilter.setRandomness(this.getRandomness());
            cellularFilter.setScale(this.getScale());
            cellularFilter.setAngle(this.getAngle());
            cellularFilter.setStretch(this.getStretch());
            cellularFilter.setAmount(this.getAmount());
            cellularFilter.setTurbulence(this.getTurbulence());
            cellularFilter.setColormap(this.getColormap());
            cellularFilter.setDistancePower(this.getDistancePower());
            cellularFilter.setAngleCoefficient(this.getAngleCoefficient());
            int n2 = 0;
            while (n2 < 4) {
                cellularFilter.setCoefficient(n2, this.getCoefficient(n2));
                ++n2;
            }
        } else {
            cellularFilter.scale = this.mutate(this.scale, 0.9, 5.0, 3.0, 64.0);
            cellularFilter.setAngle(this.mutate(this.angle, 0.6, 1.5707963267948966));
            cellularFilter.stretch = this.mutate(this.stretch, 0.6, 3.0, 1.0, 10.0);
            cellularFilter.amount = this.mutate(n, 0.6, 0.2, 0.0, 1.0);
            cellularFilter.turbulence = this.mutate(this.turbulence, 0.7, 0.5, 1.0, 8.0);
            cellularFilter.distancePower = this.mutate(this.distancePower, 0.5, 0.5, 1.0, 3.0);
            cellularFilter.randomness = this.mutate(this.randomness, 0.9, 0.2, 0.0, 1.0);
            int n3 = 0;
            while (n3 < this.coefficients.length) {
                cellularFilter.coefficients[n3] = this.mutate(this.coefficients[n3], 0.7, 0.2, -1.0, 1.0);
                ++n3;
            }
            if (this.random.nextDouble() >= 0.5) {
                cellularFilter.gridType = this.random.nextInt() % 5;
            }
            cellularFilter.angleCoefficient = this.random.nextDouble() >= 0.5 ? 0.0 : this.mutate(this.angleCoefficient, 0.5, 0.5, -1.0, 1.0);
        }
        if (bl2 || n == 0) {
            cellularFilter.setColormap(this.getColormap());
        } else {
            cellularFilter.setColormap(Gradient.randomGradient());
        }
    }

    private double mutate(double d, double d2, double d3, double d4, double d5) {
        if (this.random.nextDouble() <= d2) {
            return d;
        }
        return ImageMath.clamp(d + d3 * this.random.nextGaussian(), d4, d5);
    }

    private double mutate(double d, double d2, double d3) {
        if (this.random.nextDouble() <= d2) {
            return d;
        }
        return d + d3 * this.random.nextGaussian();
    }

    public Object clone() {
        CellularFilter cellularFilter = (CellularFilter)super.clone();
        cellularFilter.coefficients = (double[])this.coefficients.clone();
        return cellularFilter;
    }

    public String toString() {
        return "Texture/Cellular...";
    }

    public class Point {
        public int index;
        public double x;
        public double y;
        public double cubeX;
        public double cubeY;
        public double distance;
    }
}

