/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.DateUtils;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.MongoInputStream;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.MongoOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMongoClient
extends TransportManager {
    final Logger logger = LoggerFactory.getLogger(DefaultMongoClient.class);
    private String[] server;
    private String user;
    private String password;
    private Mongo mongo;
    private static DefaultMongoClient istance;
    private static final String ROOT_PATH_PATCH_V1 = "/home/null/";
    private static final String ROOT_PATH_PATCH_V2 = "/public/";
    private DB db;

    public DefaultMongoClient(String[] server, String user, String password) {
        try {
            this.server = server;
            this.user = user;
            this.password = password;
            DB db = this.getDB();
            DBCollection coll = db.getCollection("fs.files");
            coll.createIndex((DBObject)new BasicDBObject("filename", (Object)1));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object get(MyFile resource, String serverLocation, Class<? extends Object> type) throws IOException {
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient get method: " + op.toString());
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        GridFSDBFile f = this.retrieveRemoteObject(serverLocation, gfs);
        Object id = null;
        if (f != null) {
            id = f.getId();
            String lock = (String)f.get("lock");
            if (lock == null || lock.isEmpty() || this.isTTLUnlocked(f)) {
                if (f.containsField("lock") && f.get("lock") != null) {
                    f.put("lock", null);
                    f.save();
                }
                this.download(gfs, resource, f, false);
            } else {
                this.checkTTL(f);
            }
        } else {
            this.mongo.close();
            throw new FileNotFoundException("REMOTE FILE NOT FOUND: WRONG PATH OR WRONG OBJECT ID");
        }
        return id;
    }

    private void updateCommonFields(GridFSFile f, MyFile resource) {
        f.put("lastAccess", (Object)DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
        String owner = resource.getOwner();
        f.put("lastUser", (Object)owner);
        String operation = resource.getOperationDefinition().getOperation().toString();
        this.logger.info("set last operation: " + operation);
        f.put("lastOperation", (Object)operation);
        String address = null;
        try {
            address = InetAddress.getLocalHost().toString();
            f.put("callerIP", (Object)address);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
    }

    private GridFSDBFile retrieveRemoteObject(String serverLocation, GridFS gfs) {
        this.logger.info("MongoDB - pathServer: " + serverLocation);
        GridFSDBFile f = null;
        f = gfs.findOne(serverLocation);
        if (f == null) {
            f = this.patchRemoteFilePathVersion1(serverLocation, gfs);
        }
        if (f == null) {
            try {
                BasicDBObject query = new BasicDBObject();
                query.put("_id", (Object)new ObjectId(serverLocation));
                f = gfs.findOne((DBObject)query);
            }
            catch (Exception e) {
                f = null;
            }
        }
        return f;
    }

    private void checkTTL(GridFSDBFile f) throws IllegalAccessError {
        if (f.containsField("timestamp") && f.get("timestamp") != null) {
            long timestamp = (Long)f.get("timestamp");
            long currentTTL = System.currentTimeMillis() - timestamp;
            throw new IllegalAccessError("the file is locked currentTTL: " + currentTTL + "TTL bound " + 180000L);
        }
        this.checkTTL(f);
    }

    private boolean isTTLUnlocked(GridFSDBFile f) {
        if (f.get("timestamp") == null) {
            return true;
        }
        long timestamp = (Long)f.get("timestamp");
        System.out.println("timestamp found: " + timestamp);
        if (timestamp != 0L) {
            long currentTTL = System.currentTimeMillis() - timestamp;
            System.out.println("currentTTL: " + currentTTL + " TTL stabilito: " + 180000L);
            if (180000L < currentTTL) {
                f.put("timestamp", null);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public String lock(MyFile resource, String serverLocation, Class<? extends Object> type) throws IOException {
        GridFSDBFile f;
        OperationDefinition op = resource.getOperationDefinition();
        if (resource.getPathClient() != null && !resource.getPathClient().isEmpty()) {
            resource.setOperation(OperationDefinition.OPERATION.DOWNLOAD);
            this.get(resource, serverLocation, type).toString();
            resource.setOperation(op);
        }
        this.logger.info("MongoClient lock method: " + op.toString());
        String key = null;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        Class<? extends Object> o = type;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + serverLocation);
        }
        if ((f = this.retrieveRemoteObject(serverLocation, gfs)) != null) {
            String lock = (String)f.get("lock");
            if (lock == null || lock.isEmpty() || this.isTTLUnlocked(f)) {
                key = f.getId() + "" + System.currentTimeMillis();
                f.put("lock", (Object)key);
                f.put("timestamp", (Object)System.currentTimeMillis());
                this.updateCommonFields((GridFSFile)f, resource);
                f.save();
            } else {
                this.checkTTL(f);
            }
        } else {
            this.mongo.close();
            throw new FileNotFoundException("REMOTE FILE NOT FOUND: WRONG PATH OR WRONG OBJECT ID");
        }
        return key;
    }

    @Override
    public String put(Object resource, String bucket, String key, boolean replace) throws UnknownHostException {
        GridFSDBFile fold;
        OperationDefinition op = ((MyFile)resource).getOperationDefinition();
        this.logger.info("MongoClient put method: " + op.toString());
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        String dir = ((MyFile)resource).getRemoteDir();
        String name = ((MyFile)resource).getName();
        String path = bucket;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DIR: " + dir + " name: " + name + " fullPath " + path + " bucket: " + bucket);
        }
        if ((fold = gfs.findOne(path)) != null) {
            String oldir = (String)fold.get("dir");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("old dir  found " + oldir);
            }
            if (oldir.equalsIgnoreCase(((MyFile)resource).getRemoteDir())) {
                String lock;
                ObjectId oldId = (ObjectId)fold.getId();
                if (!replace) {
                    return oldId.toString();
                }
                if (fold.containsField("countLink") && fold.get("countLink") != null) {
                    throw new RemoteBackendException("The file cannot be replaced because is linked from another remote file");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("remove id: " + oldId);
                }
                if (!((lock = (String)fold.get("lock")) == null || lock.isEmpty() || this.isTTLUnlocked(fold) || lock.equalsIgnoreCase(key))) {
                    throw new IllegalAccessError("The file is locked");
                }
                this.checkAndRemove(gfs, fold, (MyFile)resource);
            }
        }
        GridFSInputFile f2 = null;
        f2 = this.preparePayload(resource, gfs, 0, bucket, name, dir);
        Object id = f2.getId();
        return id.toString();
    }

    private GridFSInputFile preparePayload(Object resource, GridFS gfs, int count, String bucket, String name, String dir) {
        GridFSInputFile f2 = null;
        try {
            if (((MyFile)resource).getInputStream() != null) {
                f2 = gfs.createFile(((MyFile)resource).getInputStream());
                this.fillInputFile(resource, bucket, name, dir, f2);
                f2.save();
                ((MyFile)resource).getInputStream().close();
                ((MyFile)resource).setInputStream(null);
            } else if (((MyFile)resource).getType() != null && ((MyFile)resource).getType().equals("output")) {
                f2 = gfs.createFile(((MyFile)resource).getName());
                this.fillInputFile(resource, bucket, name, dir, f2);
                ((MyFile)resource).setOutputStream((OutputStream)((Object)new MongoOutputStream(this.mongo, f2.getOutputStream())));
            } else {
                f2 = gfs.createFile(new File(((MyFile)resource).getPathClient()));
                this.fillInputFile(resource, bucket, name, dir, f2);
                f2.save();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Directory: " + dir);
            }
            Object id = f2.getId();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ObjectId: " + id);
            }
            this.buildDirTree(gfs, dir);
            if (((MyFile)resource).getType() == null || !((MyFile)resource).getType().equals("output")) {
                this.mongo.close();
            }
        }
        catch (IOException e1) {
            this.logger.error("Connection error. " + e1.getMessage());
            if (count < 9) {
                this.logger.info(" Retry : #" + ++count);
                this.preparePayload(resource, gfs, count, bucket, name, dir);
            }
            this.logger.error("max number of retry completed ");
            throw new RemoteBackendException(e1);
        }
        return f2;
    }

    private void fillInputFile(Object resource, String bucket, String name, String dir, GridFSInputFile f2) {
        f2.put("filename", (Object)bucket);
        f2.put("type", (Object)"file");
        f2.put("name", (Object)name);
        f2.put("dir", (Object)dir);
        f2.put("owner", (Object)((MyFile)resource).getOwner());
        f2.put("creationTime", (Object)DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
        this.updateCommonFields((GridFSFile)f2, (MyFile)resource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String unlock(Object resource, String bucket, String key, String key4unlock) throws FileNotFoundException, UnknownHostException {
        GridFSDBFile f;
        String id = null;
        OperationDefinition op = ((MyFile)resource).getOperationDefinition();
        this.logger.info("MongoClient unlock method: " + op.toString());
        if (((MyFile)resource).getPathClient() != null && !((MyFile)resource).getPathClient().isEmpty()) {
            ((MyFile)resource).setOperation(OperationDefinition.OPERATION.UPLOAD);
            id = this.put(resource, bucket, key4unlock, true);
            ((MyFile)resource).setOperation(op);
        }
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        String dir = ((MyFile)resource).getRemoteDir();
        String name = ((MyFile)resource).getName();
        String path = bucket;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DIR: " + dir + " name: " + name + " fullPath " + path + " bucket: " + bucket);
        }
        if ((f = this.retrieveRemoteObject(path, gfs)) == null) throw new FileNotFoundException(path);
        String oldir = (String)f.get("dir");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("old dir  found " + oldir);
        }
        if (!oldir.equalsIgnoreCase(((MyFile)resource).getRemoteDir()) && ((MyFile)resource).getRemoteDir() != null) throw new FileNotFoundException(path);
        String lock = (String)f.get("lock");
        if (lock != null && !lock.isEmpty()) {
            String lck = (String)f.get("lock");
            if (!lck.equalsIgnoreCase(key4unlock)) throw new IllegalAccessError("bad key for unlock");
            f.put("lock", null);
            f.put("timestamp", null);
            this.updateCommonFields((GridFSFile)f, (MyFile)resource);
            f.save();
            return id;
        } else {
            this.updateCommonFields((GridFSFile)f, (MyFile)resource);
            f.save();
        }
        return id;
    }

    @Override
    public Map getValues(MyFile resource, String bucket, Class<? extends Object> type) throws UnknownHostException {
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient getValues method: " + op.toString());
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mongo get values of dir: " + bucket);
        }
        HashMap<Object, StorageObject> map = null;
        BasicDBObject query = new BasicDBObject();
        query.put("dir", (Object)bucket);
        List<GridFSDBFile> list = gfs.find((DBObject)query);
        list = this.patchRemoteDirPathVersion1(bucket, gfs, query, list);
        for (GridFSDBFile f : list) {
            if (map == null) {
                map = new HashMap<Object, StorageObject>();
            }
            StorageObject s_obj = null;
            if (f.get("type") == null || f.get("type").toString().equalsIgnoreCase("file")) {
                String creationTime;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("found object: " + f.get("name") + "    type:  " + f.get("type"));
                }
                s_obj = new StorageObject(f.get("name").toString(), "file");
                String owner = (String)f.get("owner");
                if (owner != null) {
                    s_obj.setOwner(owner);
                }
                if ((creationTime = (String)f.get("creationTime")) != null) {
                    s_obj.setCreationTime(creationTime);
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("found directory: " + f.get("name") + "    type:  " + f.get("type"));
                }
                BasicDBObject queryDir = new BasicDBObject();
                queryDir.put("dir", (Object)(f.get("dir").toString() + f.get("name").toString()));
                List listDir = gfs.find((DBObject)queryDir);
                if (listDir != null && listDir.size() > 0) {
                    s_obj = new StorageObject(f.get("name").toString(), "dir");
                } else {
                    BasicDBObject queryFile = new BasicDBObject();
                    queryFile.put("filename", (Object)Pattern.compile(f.get("dir").toString() + "*"));
                    List listFile = gfs.find((DBObject)queryFile);
                    s_obj = listFile != null && listFile.size() > 0 ? new StorageObject(f.get("name").toString(), "dir") : null;
                }
            }
            if (s_obj == null) continue;
            map.put(f.get("name"), s_obj);
        }
        this.mongo.close();
        return map;
    }

    @Override
    public void removeRemoteFile(String bucket, MyFile resource) throws UnknownHostException {
        GridFSDBFile f;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mongo delete bucket: " + bucket);
        }
        if ((f = this.retrieveRemoteObject(bucket, gfs)) != null) {
            this.checkAndRemove(gfs, f, resource);
        } else {
            ObjectId id;
            GridFSDBFile fID;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("File Not Found. Try to delete by ObjectID");
            }
            if (bucket.length() > 23 && (fID = gfs.findOne(id = new ObjectId(bucket))) != null) {
                String dir = (String)fID.get("dir");
                String filename = (String)fID.get("filename");
                this.checkAndRemove(gfs, fID, resource);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("object deleted by ID");
                }
            }
        }
        this.mongo.close();
    }

    private void checkAndRemove(GridFS gfs, GridFSDBFile f, MyFile resource) {
        this.logger.info("check and remove object with id " + f.getId() + " and path: " + f.get("filename"));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("fileFound\n remove file");
        }
        this.updateCommonFields((GridFSFile)f, resource);
        if (f != null && f.containsField("linkCount") && f.get("linkCount") != null) {
            String filename = (String)f.get("filename");
            f.put("onScope", (Object)filename);
            f.put("dir", null);
            f.put("filename", null);
            f.put("name", null);
            f.put("onDeleting", (Object)"true");
            f.save();
        } else if (f.containsField("link") && f.get("link") != null) {
            while (f != null && f.containsField("link") && f.get("link") != null) {
                ObjectId oId;
                String id = (String)f.get("link");
                GridFSDBFile fLink = gfs.find(new ObjectId(id));
                int linkCount = (Integer)fLink.get("linkCount");
                if (--linkCount == 0) {
                    if (fLink.get("name") == null && fLink.get("filename") == null && fLink.get("dir") == null) {
                        ObjectId idF = (ObjectId)f.getId();
                        f.put("onDeleting", (Object)"true");
                        f.save();
                        gfs.remove(idF);
                        if (fLink.containsField("link") && fLink.get("link") != null) {
                            id = (String)fLink.get("link");
                            f = gfs.find(new ObjectId(id));
                        } else {
                            f = null;
                        }
                        ObjectId idLink = (ObjectId)fLink.getId();
                        fLink.put("onDeleting", (Object)"true");
                        fLink.save();
                        gfs.remove(idLink);
                        continue;
                    }
                    fLink.put("linkCount", null);
                    fLink.save();
                    oId = (ObjectId)f.getId();
                    f.put("onDeleting", (Object)"true");
                    f.save();
                    gfs.remove(oId);
                    f = null;
                    continue;
                }
                fLink.put("linkCount", (Object)linkCount);
                fLink.save();
                oId = (ObjectId)f.getId();
                f.put("onDeleting", (Object)"true");
                f.save();
                gfs.remove(oId);
                f = null;
            }
        } else {
            this.logger.debug("");
            ObjectId id = (ObjectId)f.getId();
            f.put("onDeleting", (Object)"true");
            f.save();
            gfs.remove(id);
        }
    }

    @Override
    public void removeDir(String remoteDir, MyFile resource) throws UnknownHostException {
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.add(remoteDir);
        if (remoteDir.contains(ROOT_PATH_PATCH_V1) || remoteDir.contains(ROOT_PATH_PATCH_V2)) {
            if (remoteDir.contains(ROOT_PATH_PATCH_V1)) {
                String remoteDirV1 = remoteDir.replace(ROOT_PATH_PATCH_V1, ROOT_PATH_PATCH_V2);
                dirs.add(remoteDirV1);
            } else {
                String remoteDirV2 = remoteDir.replace(ROOT_PATH_PATCH_V2, ROOT_PATH_PATCH_V1);
                dirs.add(remoteDirV2);
                String remoteDirV2patch = "/" + remoteDirV2;
                dirs.add(remoteDirV2patch);
            }
        }
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        for (String directory : dirs) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Mongo start operation delete bucket: " + directory);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("remove subfolders of folder: " + directory);
            }
            BasicDBObject query = new BasicDBObject();
            String regex = directory + "*";
            query.put("dir", (Object)Pattern.compile(regex));
            this.removeObject(gfs, query, resource);
            query = new BasicDBObject();
            String[] dir = directory.split("/");
            StringBuffer parentDir = new StringBuffer();
            for (int i = 0; i < dir.length - 1; ++i) {
                parentDir.append(dir[i] + "/");
            }
            String name = dir[dir.length - 1];
            query.put("dir", (Object)parentDir.toString());
            query.put("name", (Object)name);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("now remove the folder: " + name + " from folder " + parentDir);
            }
            this.removeObject(gfs, query, resource);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Mongo end operation delete bucket: " + directory);
        }
        this.mongo.close();
    }

    @Override
    public long getSize(String remotePath) throws UnknownHostException {
        GridFSDBFile f;
        long length = -1L;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + remotePath);
        }
        if ((f = this.retrieveRemoteObject(remotePath, gfs)) != null) {
            length = f.getLength();
        }
        this.mongo.close();
        return length;
    }

    @Override
    public long getTTL(String remotePath) throws UnknownHostException {
        GridFSDBFile f;
        long timestamp = -1L;
        long currentTTL = -1L;
        long remainsTTL = -1L;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + remotePath);
        }
        if ((f = this.retrieveRemoteObject(remotePath, gfs)) != null && (timestamp = ((Long)f.get("timestamp")).longValue()) > 0L) {
            currentTTL = System.currentTimeMillis() - timestamp;
            remainsTTL = 180000L - currentTTL;
        }
        this.mongo.close();
        return remainsTTL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long renewTTL(MyFile resource) throws UnknownHostException, IllegalAccessException {
        String lock;
        long ttl = -1L;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        MyFile file = resource;
        String key = file.getLockedKey();
        String remotePath = file.getPathServer();
        GridFSDBFile f = this.retrieveRemoteObject(remotePath, gfs);
        if (f != null && (lock = (String)f.get("lock")) != null && !lock.isEmpty()) {
            String lck = (String)f.get("lock");
            if (!lck.equalsIgnoreCase(key)) throw new IllegalAccessError("bad key for unlock");
            if (f.containsField("countRenew") && f.get("countRenew") != null) {
                int count = (Integer)f.get("countRenew");
                if (count >= 5) throw new IllegalAccessException("The number max of TTL renew reached. The number max is: 5");
                f.put("countRenew", (Object)(count + 1));
            } else {
                f.put("countRenew", (Object)1);
            }
            f.put("timestamp", (Object)System.currentTimeMillis());
            f.save();
            ttl = 180000L;
        }
        this.mongo.close();
        return ttl;
    }

    @Override
    public void initBackend(String[] server) {
        try {
            this.server = server;
            DB db = this.getDB();
            DBCollection coll = db.getCollection("fs.files");
            coll.createIndex((DBObject)new BasicDBObject("filename", (Object)1));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
    }

    private void buildDirTree(GridFS gfs, String dir) {
        String[] dirTree = dir.split("/");
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("/");
        for (int i = 1; i < dirTree.length; ++i) {
            BasicDBObject query = new BasicDBObject();
            query.put("name", (Object)dirTree[i]);
            query.put("dir", (Object)strBuff.toString());
            query.put("type", (Object)"dir");
            GridFSDBFile f = gfs.findOne((DBObject)query);
            if (f == null) {
                byte[] data = new byte[1];
                GridFSInputFile f3 = gfs.createFile(data);
                f3.put("name", (Object)dirTree[i]);
                f3.put("dir", (Object)strBuff.toString());
                f3.put("type", (Object)"dir");
                f3.save();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" Create new  object with name: " + dirTree[i] + " dir: " + strBuff.toString() + " type= dir");
                }
            }
            strBuff.append(dirTree[i] + "/");
        }
    }

    private void download(GridFS gfs, MyFile resource, GridFSDBFile f, boolean isLock) throws IOException {
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient download method: " + op.toString());
        while (f != null && f.containsField("link") && f.get("link") != null) {
            BasicDBObject query = new BasicDBObject();
            query.put("_id", (Object)new ObjectId((String)f.get("link")));
            f = gfs.findOne((DBObject)query);
        }
        this.updateCommonFields((GridFSFile)f, resource);
        f.save();
        if (resource.getPathClient() != null && !resource.getPathClient().isEmpty()) {
            this.writeByPath(resource, f, isLock, 0);
        } else if (resource.getOutputStream() != null) {
            this.writeByOutputStream(resource, f, isLock, 0);
            this.mongo.close();
        }
        if (resource != null && resource.getType() != null && resource.getType().equalsIgnoreCase("input")) {
            this.writeByInputStream(resource, f, isLock, 0);
        }
    }

    private String writeByInputStream(MyFile resource, GridFSDBFile f, boolean isLock, int count) {
        String key = null;
        resource.setInputStream((InputStream)((Object)new MongoInputStream(this.mongo, f.getInputStream())));
        return key;
    }

    private String writeByOutputStream(MyFile resource, GridFSDBFile f, boolean isLock, int count) throws IOException {
        String key = null;
        f.writeTo(resource.getOutputStream());
        resource.setOutputStream(null);
        f.save();
        return key;
    }

    private String writeByPath(MyFile resource, GridFSDBFile f, boolean isLock, int count) throws IOException {
        String key = null;
        try {
            MongoInputStream is = new MongoInputStream(this.mongo, f.getInputStream());
            File file = new File(resource.getPathClient());
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.close();
            is.close();
            resource.setPathClient(null);
        }
        catch (IOException e) {
            this.logger.error("Connection error. " + e.getMessage());
            if (count < 9) {
                this.logger.info(" Retry : #" + ++count);
                this.writeByPath(resource, f, isLock, count);
            }
            this.logger.error("max number of retry completed ");
            throw new RuntimeException(e);
        }
        return key;
    }

    private void removeObject(GridFS gfs, BasicDBObject query, MyFile resource) {
        List list = gfs.find((DBObject)query);
        for (GridFSDBFile f : list) {
            if (f != null) {
                this.checkAndRemove(gfs, f, resource);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("File Not Found");
        }
    }

    private DB getDB() throws UnknownHostException {
        if (this.db != null) {
            try {
                GridFS gfs = new GridFS(this.db);
            }
            catch (Exception e) {
                this.logger.warn("the server now is not a primary ");
                this.db = null;
            }
        }
        if (this.db == null) {
            int i = -1;
            for (String srv : this.server) {
                try {
                    boolean auth;
                    ++i;
                    if (this.mongo != null) {
                        this.mongo.close();
                    }
                    MongoOptions options = new MongoOptions();
                    options.autoConnectRetry = true;
                    options.socketKeepAlive = true;
                    options.maxWaitTime = 240000;
                    options.connectionsPerHost = 35;
                    this.mongo = new Mongo(srv, options);
                    this.logger.debug("Istantiate MongoDB with options: " + this.mongo.getMongoOptions());
                    this.db = this.mongo.getDB("remotefs");
                    if (this.user == null) {
                        this.user = "";
                    }
                    if (this.password == null) {
                        this.password = "";
                    }
                    if (auth = this.db.authenticate(this.user, this.password.toCharArray())) {
                        this.logger.info("mongo is in authenticate mode");
                    } else {
                        this.logger.info("mongo is not in authenticate mode");
                    }
                    GridFS gfs = new GridFS(this.db);
                    String firstServer = this.server[0];
                    this.server[0] = srv;
                    this.server[i] = firstServer;
                    break;
                }
                catch (Exception e) {
                    this.logger.warn("server " + srv + " is not a primary retry ");
                }
            }
        }
        return this.db;
    }

    private GridFSDBFile patchRemoteFilePathVersion1(String serverLocation, GridFS gfs) {
        GridFSDBFile f = null;
        String path = serverLocation;
        String locationV1 = null;
        if (serverLocation.contains(ROOT_PATH_PATCH_V1)) {
            locationV1 = path.replace(ROOT_PATH_PATCH_V1, ROOT_PATH_PATCH_V2);
            f = gfs.findOne(locationV1);
            if (f == null) {
                String locationV1patch = locationV1.substring(1);
                f = gfs.findOne(locationV1patch);
            }
        } else if (serverLocation.contains(ROOT_PATH_PATCH_V2) && (f = gfs.findOne(locationV1 = path.replace(ROOT_PATH_PATCH_V2, ROOT_PATH_PATCH_V1))) == null) {
            String locationV1patch = "/" + locationV1;
            f = gfs.findOne(locationV1patch);
        }
        return f;
    }

    private List<GridFSDBFile> patchRemoteDirPathVersion1(String bucket, GridFS gfs, BasicDBObject query, List<GridFSDBFile> list) {
        List patchList = null;
        if (bucket.contains(ROOT_PATH_PATCH_V1)) {
            String locationV2 = bucket.replace(ROOT_PATH_PATCH_V1, ROOT_PATH_PATCH_V2);
            BasicDBObject queryPatch = new BasicDBObject();
            queryPatch.put("dir", (Object)locationV2);
            patchList = gfs.find((DBObject)queryPatch);
        } else if (bucket.contains(ROOT_PATH_PATCH_V2)) {
            String locationV1 = bucket.replace(ROOT_PATH_PATCH_V2, ROOT_PATH_PATCH_V1);
            BasicDBObject queryPatch = new BasicDBObject();
            queryPatch.put("dir", (Object)locationV1);
            patchList = gfs.find((DBObject)queryPatch);
            String locationV1patch = "/" + locationV1;
            queryPatch = new BasicDBObject();
            queryPatch.put("dir", (Object)locationV1patch);
            List patchList2 = gfs.find((DBObject)queryPatch);
            if (patchList2 != null && !patchList2.isEmpty()) {
                if (patchList != null) {
                    patchList.addAll(patchList2);
                } else {
                    patchList = patchList2;
                }
            }
        }
        if (patchList != null && !patchList.isEmpty()) {
            list.addAll(patchList);
        }
        return list;
    }

    @Override
    public String link(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        GridFSInputFile destinationFile;
        GridFS gfs;
        boolean replace = true;
        String source = sourcePath;
        String destination = destinationPath;
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String destinationId = null;
        String sourceId = null;
        this.logger.debug("link operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            int count;
            DB db = this.getDB();
            gfs = new GridFS(db);
            GridFSDBFile f = gfs.findOne(source);
            if (f != null) {
                count = 1;
                if (f.containsField("linkCount") && f.get("linkCount") != null) {
                    count = (Integer)f.get("linkCount");
                    ++count;
                }
            } else {
                throw new IllegalArgumentException(" source remote file not found at: " + source);
            }
            f.put("linkCount", (Object)count);
            this.updateCommonFields((GridFSFile)f, resource);
            sourceId = f.getId().toString();
            f.save();
            GridFSDBFile fold = gfs.findOne(destinationPath);
            if (fold != null) {
                String oldir = (String)fold.get("dir");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("old dir  found " + oldir);
                }
                if (oldir.equalsIgnoreCase(resource.getRemoteDir())) {
                    String lock;
                    ObjectId oldId = (ObjectId)fold.getId();
                    if (!replace) {
                        return oldId.toString();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("remove id: " + oldId);
                    }
                    if ((lock = (String)fold.get("lock")) != null && !lock.isEmpty() && !this.isTTLUnlocked(fold)) {
                        throw new IllegalAccessError("The file is locked");
                    }
                    gfs.remove(oldId);
                }
            }
            destinationFile = null;
            byte[] data = new byte[1];
            destinationFile = gfs.createFile(data);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Directory: " + dir);
            }
            this.setGenericProperties(resource, destinationPath, dir, destinationFile, name);
            destinationFile.put("link", (Object)sourceId);
            destinationId = destinationFile.getId().toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ObjectId: " + destinationId);
            }
        } else {
            throw new IllegalArgumentException(" invalid argument: source: " + source + " dest: " + destination + " the values must be not null and not empty");
        }
        this.buildDirTree(gfs, dir);
        destinationFile.save();
        this.mongo.close();
        return destinationId.toString();
    }

    @Override
    public String copy(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        String destination = destinationPath;
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String destinationId = null;
        this.logger.debug("copy operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = this.getDB();
            GridFS gfs = new GridFS(db);
            GridFSDBFile f = gfs.findOne(source);
            if (f != null) {
                f = this.retrieveLinkPayload(gfs, f);
                InputStream is = f.getInputStream();
                GridFSDBFile dest = gfs.findOne(destination);
                GridFSInputFile destinationFile = gfs.createFile(is);
                if (dest != null) {
                    this.checkAndRemove(gfs, dest, resource);
                    this.setGenericProperties(resource, destination, dir, destinationFile, destination.substring(destination.lastIndexOf("/") + 1));
                    this.buildDirTree(gfs, dir);
                } else {
                    BasicDBObject query = new BasicDBObject();
                    query.put("dir", (Object)destination);
                    List folder = gfs.find((DBObject)query);
                    if (folder != null && folder.size() > 0) {
                        destination = this.appendFileSeparator(destination);
                        this.setGenericProperties(resource, destination + name, destination, destinationFile, name);
                        this.buildDirTree(gfs, destination);
                    } else if (destination.lastIndexOf("/") == destination.length() - 1) {
                        this.setGenericProperties(resource, destination + name, destination, destinationFile, name);
                        this.buildDirTree(gfs, destination);
                    } else {
                        String newName = destination.substring(destination.lastIndexOf("/") + 1);
                        this.setGenericProperties(resource, destination, dir, destinationFile, newName);
                        this.buildDirTree(gfs, dir);
                    }
                }
                destinationId = destinationFile.getId().toString();
                destinationFile.save();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ObjectId: " + destinationId);
                }
                this.mongo.close();
            } else {
                throw new RemoteBackendException(" the source path is wrong. There isn't a file");
            }
        }
        return destinationId.toString();
    }

    private GridFSDBFile retrieveLinkPayload(GridFS gfs, GridFSDBFile f) {
        while (f.containsField("link") && f.get("link") != null) {
            String id = (String)f.get("link");
            f = gfs.find(new ObjectId(id));
        }
        return f;
    }

    private void setGenericProperties(MyFile resource, String destination, String dir, GridFSInputFile destinationFile, String name) {
        this.updateCommonFields((GridFSFile)destinationFile, resource);
        destinationFile.put("filename", (Object)destination);
        destinationFile.put("type", (Object)"file");
        destinationFile.put("name", (Object)name);
        destinationFile.put("dir", (Object)dir);
        destinationFile.put("owner", (Object)resource.getOwner());
        destinationFile.put("creationTime", (Object)DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
    }

    @Override
    public String move(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        String destination = destinationPath;
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String destinationId = null;
        this.logger.info("move operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        this.logger.info("MOVE OPERATION operation defined: " + (Object)((Object)resource.getOperationDefinition().getOperation()));
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = this.getDB();
            GridFS gfs = new GridFS(db);
            GridFSDBFile f = gfs.findOne(source);
            if (f != null) {
                this.updateCommonFields((GridFSFile)f, resource);
                GridFSDBFile fNewPath = gfs.findOne(destinationPath);
                if (fNewPath != null) {
                    this.checkAndRemove(gfs, fNewPath, resource);
                    f.put("dir", (Object)dir);
                    f.put("filename", (Object)destinationPath);
                    f.put("name", (Object)name);
                    f.put("owner", (Object)resource.getOwner());
                    destinationId = f.getId().toString();
                    this.buildDirTree(gfs, dir);
                    f.save();
                } else {
                    BasicDBObject query = new BasicDBObject();
                    query.put("dir", (Object)destination);
                    List folder = gfs.find((DBObject)query);
                    if (folder != null && folder.size() > 0) {
                        destination = this.appendFileSeparator(destination);
                        this.setGenericMoveProperties(resource, destination + name, destination, name, f);
                        destinationId = f.getId().toString();
                        this.buildDirTree(gfs, destination);
                    } else if (destination.lastIndexOf("/") == destination.length() - 1) {
                        this.setGenericMoveProperties(resource, destination + name, destination, name, f);
                        destinationId = f.getId().toString();
                        this.buildDirTree(gfs, destination);
                    } else {
                        String newName = destination.substring(destination.lastIndexOf("/") + 1);
                        this.setGenericMoveProperties(resource, destination, dir, newName, f);
                        destinationId = f.getId().toString();
                        this.buildDirTree(gfs, dir);
                    }
                    f.save();
                }
                this.mongo.close();
                return destinationId;
            }
            throw new RemoteBackendException(" the source path is wrong. There isn't a file at this path: " + source);
        }
        throw new IllegalArgumentException("parameters not completed, source: " + source + ", destination: " + destination);
    }

    private void setGenericMoveProperties(MyFile resource, String filename, String dir, String name, GridFSDBFile f) {
        f.put("filename", (Object)filename);
        f.put("type", (Object)"file");
        f.put("name", (Object)name);
        f.put("dir", (Object)dir);
        f.put("owner", (Object)resource.getOwner());
    }

    @Override
    public String getName() {
        return "MongoDB";
    }

    @Override
    public List<String> copyDir(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        source = this.appendFileSeparator(source);
        String destination = destinationPath;
        destination = this.appendFileSeparator(destination);
        String parentFolder = this.extractParent(source);
        String destinationId = null;
        ArrayList<String> idList = null;
        this.logger.debug("copyDir operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = this.getDB();
            GridFS gfs = new GridFS(db);
            BasicDBObject query = new BasicDBObject();
            query.put("dir", (Object)new BasicDBObject("$regex", (Object)(source + "*")));
            List folder = gfs.find((DBObject)query);
            if (folder != null) {
                idList = new ArrayList<String>(folder.size());
                for (GridFSDBFile f : folder) {
                    if (!f.get("type").equals("file")) continue;
                    String name = (String)f.get("name");
                    String oldFilename = (String)f.get("filename");
                    String oldDir = (String)f.get("dir");
                    f = this.retrieveLinkPayload(gfs, f);
                    InputStream is = f.getInputStream();
                    int relativePathIndex = source.length();
                    String relativeDirTree = parentFolder + "/" + oldDir.substring(relativePathIndex);
                    String relativePath = parentFolder + "/" + oldFilename.substring(relativePathIndex);
                    String filename = destination + relativePath;
                    String dir = destination + relativeDirTree;
                    GridFSInputFile destinationFile = gfs.createFile(is);
                    destinationFile.put("filename", (Object)filename);
                    destinationFile.put("type", (Object)"file");
                    destinationFile.put("dir", (Object)dir);
                    this.updateCommonFields((GridFSFile)destinationFile, resource);
                    idList.add(destinationFile.getId().toString());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ObjectId: " + destinationId);
                    }
                    this.buildDirTree(gfs, dir);
                    destinationFile.save();
                }
            }
            this.mongo.close();
        }
        return idList;
    }

    @Override
    public List<String> moveDir(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        source = this.appendFileSeparator(source);
        String parentFolder = this.extractParent(source);
        String destination = destinationPath;
        destination = this.appendFileSeparator(destination);
        ArrayList<String> idList = null;
        this.logger.debug("moveDir operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = this.getDB();
            GridFS gfs = new GridFS(db);
            BasicDBObject query = new BasicDBObject();
            query.put("dir", (Object)new BasicDBObject("$regex", (Object)(source + "*")));
            List folder = gfs.find((DBObject)query);
            if (folder != null && folder.size() > 0) {
                Object subTree = null;
                for (GridFSDBFile f : folder) {
                    if (idList == null) {
                        idList = new ArrayList<String>(folder.size());
                    }
                    String name = (String)f.get("name");
                    if (!f.get("type").equals("file")) continue;
                    String oldFilename = (String)f.get("filename");
                    String oldDir = (String)f.get("dir");
                    int relativePathIndex = source.length();
                    String relativeDirTree = parentFolder + "/" + oldDir.substring(relativePathIndex);
                    String relativePath = parentFolder + "/" + oldFilename.substring(relativePathIndex);
                    String filename = destination + relativePath;
                    String dir = destination + relativeDirTree;
                    f.put("filename", (Object)filename);
                    f.put("dir", (Object)dir);
                    this.updateCommonFields((GridFSFile)f, resource);
                    String id = f.getId().toString();
                    idList.add(id);
                    f.save();
                    this.buildDirTree(gfs, dir);
                }
            }
        } else {
            throw new IllegalArgumentException("parameters not completed, source: " + source + ", destination: " + destination);
        }
        this.mongo.close();
        return idList;
    }

    private String extractParent(String source) {
        source = source.substring(0, source.length() - 1);
        String parent = source.substring(source.lastIndexOf("/") + 1);
        this.logger.debug("parent folder extracted: " + parent);
        return parent;
    }

    private String appendFileSeparator(String source) {
        if (source.lastIndexOf("/") != source.length() - 1) {
            source = source + "/";
        }
        return source;
    }

    @Override
    public String getFileProperty(String remotePath, String property) throws UnknownHostException {
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        GridFSDBFile f = this.retrieveRemoteObject(remotePath, gfs);
        if (f != null) {
            String value = (String)f.get(property);
            this.mongo.close();
            return value;
        }
        throw new RemoteBackendException("remote file not found at path: " + remotePath);
    }
}

