/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryEntity;
import org.gcube.contentmanagement.blobstorage.service.impl.AmbiguousResource;
import org.gcube.contentmanagement.blobstorage.service.impl.LocalResource;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResource;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResourceInfo;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResourceSource;
import org.gcube.contentmanagement.blobstorage.service.operation.OperationManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEngine
implements IClient {
    final Logger logger = LoggerFactory.getLogger(ServiceEngine.class);
    public static final String FILE_SEPARATOR = "/";
    public static final int CONNECTION_RETRY_THRESHOLD = 9;
    public String[] server;
    protected OperationManager service;
    protected MyFile file;
    protected String bucket;
    protected String bucketID;
    protected String author;
    protected String owner;
    protected String environment;
    protected String currentOperation;
    protected boolean replaceOption;
    public static final String DEFAULT_SCOPE = "private";
    public static final long TTL = 180000L;
    public static final boolean DEFAULT_CHUNK_OPTION = false;
    public static final int TTL_RENEW = 5;
    protected String publicArea;
    protected String homeArea;
    protected Map<String, String> attributes;
    private String accessType;
    private String serviceName;
    private String ownerGcube;
    private String gcubeScope;
    private String gcubeAccessType;
    private String gcubeMemoryType;
    private String serviceClass;
    private String backendType;
    private String user;
    private String password;

    public ServiceEngine(String[] server) {
        this.server = server;
    }

    public ServiceEngine(String[] server, String environment, String accessType, String owner) {
        this.server = server;
        this.owner = owner;
        this.setEnvironment(environment);
        this.accessType = accessType.equalsIgnoreCase("public") ? accessType : DEFAULT_SCOPE;
        this.setPublicArea(FILE_SEPARATOR + this.getEnvironment() + FILE_SEPARATOR + "public" + FILE_SEPARATOR);
        this.setHomeArea(FILE_SEPARATOR + this.getEnvironment() + FILE_SEPARATOR);
    }

    public ServiceEngine(String[] server, String id, String environment, String scope, String owner) {
        this.server = server;
        this.owner = owner;
        this.setEnvironment(environment);
        this.accessType = scope.equals("public") ? scope : DEFAULT_SCOPE;
        this.setPublicArea(FILE_SEPARATOR + environment);
        this.setHomeArea(FILE_SEPARATOR + environment);
    }

    public String getPublicArea() {
        return this.publicArea;
    }

    public void setPublicArea(String publicArea) {
        this.publicArea = publicArea;
    }

    public String getHomeArea() {
        return this.homeArea;
    }

    public void setHomeArea(String rootPath) {
        this.homeArea = rootPath;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        String newEnv = environment;
        int ind = newEnv.indexOf(47);
        while (ind == 0) {
            environment = newEnv = environment.substring(1);
            ind = newEnv.indexOf(47);
        }
        this.environment = newEnv;
    }

    public String getBucketID() {
        return this.bucketID;
    }

    public void setBucketID(String bucketID) {
        this.bucketID = bucketID;
    }

    @Deprecated
    public IClient bucketName(String bucketName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("bucketName(String) - start");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("bucketName(String) - TerrastoreServiec set bucketName: " + bucketName);
        }
        this.setBucketID(bucketName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("bucketName(String) - end");
        }
        return this;
    }

    @Override
    public LocalResource get() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("download");
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType);
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.DOWNLOAD);
        return new LocalResource(this.file, this);
    }

    @Override
    public LocalResource get(String backendType) {
        this.file = null;
        backendType = this.setBackendType(backendType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("download");
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, backendType);
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.DOWNLOAD);
        return new LocalResource(this.file, this);
    }

    @Override
    public RemoteResourceInfo getSize() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("getSize");
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType);
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.GET_SIZE);
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public RemoteResourceInfo getSize(String backendType) {
        this.file = null;
        backendType = this.setBackendType(backendType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("getSize");
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, backendType);
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.GET_SIZE);
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public LocalResource put(boolean replace) {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        Object bucketName = null;
        this.setCurrentOperation("upload");
        this.setReplaceOption(replace);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), this.backendType);
        Object bucket = null;
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.UPLOAD);
        return new LocalResource(this.file, this);
    }

    @Override
    public RemoteResource remove() {
        this.file = new MyFile();
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeMemoryType(this.getGcubeMemoryType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("remove");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.REMOVE);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType);
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResource remove(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile();
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeMemoryType(this.getGcubeMemoryType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("remove");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.REMOVE);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, backendType);
        return new RemoteResource(this.file, this);
    }

    public MyFile getMyFile() {
        return this.file;
    }

    public void setMyFile(MyFile myFile) {
        this.file = myFile;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Override
    public RemoteResource showDir() {
        this.file = new MyFile();
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeMemoryType(this.getGcubeMemoryType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("showDir");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.SHOW_DIR);
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResource showDir(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile();
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeMemoryType(this.getGcubeMemoryType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("showDir");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.SHOW_DIR);
        return new RemoteResource(this.file, this);
    }

    List addObjectsDirBucket(Map<String, DirectoryEntity> mapDirs) {
        Set<String> dirsKeys = mapDirs.keySet();
        ArrayList<DirectoryEntity> dirs = new ArrayList<DirectoryEntity>(dirsKeys.size());
        for (String key : dirsKeys) {
            key = new BucketCoding().bucketDirDecoding(key, this.getContext());
            this.logger.debug("add " + key);
            dirs.add(mapDirs.get(key));
        }
        return dirs;
    }

    @Override
    public RemoteResource removeDir() {
        this.file = new MyFile();
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeMemoryType(this.getGcubeMemoryType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("removedir");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.REMOVE_DIR);
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResource removeDir(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile();
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeMemoryType(this.getGcubeMemoryType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("removedir");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.REMOVE_DIR);
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResource getUrl() {
        this.file = new MyFile();
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeMemoryType(this.getGcubeMemoryType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("getUrl");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.GET_URL);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType);
        RemoteResource resource = new RemoteResource(this.file, this);
        return resource;
    }

    @Override
    public RemoteResource getUrl(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile();
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeMemoryType(this.getGcubeMemoryType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("getUrl");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.GET_URL);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, backendType);
        RemoteResource resource = new RemoteResource(this.file, this);
        return resource;
    }

    @Deprecated
    public String searchByName(String name) {
        String matched = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Search in the bucket's directory with owner: " + this.owner + " the file named: " + name);
        }
        String rootPath = this.getContext().replaceAll(FILE_SEPARATOR, "_-_");
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        TransportManager tm = tmf.getTransport(this.getBackendType());
        DirectoryBucket dir = new DirectoryBucket(this.server, this.user, this.password, name, this.owner);
        matched = dir.searchInBucket(this.getMyFile(), name, rootPath, tm, this.getHomeArea());
        return matched;
    }

    @Deprecated
    public IClient setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
        return this;
    }

    public String getContext() {
        if (this.isPublic()) {
            return this.getPublicArea();
        }
        return this.getHomeArea();
    }

    public boolean isPublic() {
        if (this.getScope() != null) {
            return this.getScope().equalsIgnoreCase("public");
        }
        return DEFAULT_SCOPE.equalsIgnoreCase("public");
    }

    public String getScope() {
        return this.accessType;
    }

    public void setScope(String scope) {
        if (!(scope.equalsIgnoreCase("public") || scope.equalsIgnoreCase(DEFAULT_SCOPE) || scope.equalsIgnoreCase("group"))) {
            throw new IllegalArgumentException("bad scope usage: public | group | private ");
        }
        this.accessType = scope;
    }

    public String getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(String currentOperation) {
        this.currentOperation = currentOperation;
    }

    public boolean isReplaceOption() {
        return this.replaceOption;
    }

    public void setReplaceOption(boolean replaceOption) {
        this.replaceOption = replaceOption;
    }

    @Override
    public AmbiguousResource lock() {
        this.file = new MyFile(true);
        this.setCurrentOperation("lock");
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType);
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.LOCK);
        return new AmbiguousResource(this.file, this);
    }

    public AmbiguousResource lock(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile(true);
        this.setCurrentOperation("lock");
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, backendType);
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.LOCK);
        return new AmbiguousResource(this.file, this);
    }

    @Override
    public AmbiguousResource unlock(String key) {
        this.file = new MyFile();
        this.file.setLockedKey(key);
        this.setCurrentOperation("unlock");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.UNLOCK);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType);
        return new AmbiguousResource(this.file, this);
    }

    @Override
    public AmbiguousResource unlock(String key, String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile();
        this.file.setLockedKey(key);
        this.setCurrentOperation("unlock");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.UNLOCK);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, backendType);
        return new AmbiguousResource(this.file, this);
    }

    @Override
    public RemoteResourceInfo getTTL() {
        this.file = new MyFile();
        this.setCurrentOperation("getTTL");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.GET_TTL);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType);
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public RemoteResourceInfo getTTL(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile();
        this.setCurrentOperation("getTTL");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.GET_TTL);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, backendType);
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public RemoteResourceInfo renewTTL(String key) {
        this.file = new MyFile();
        this.file.setLockedKey(key);
        this.setCurrentOperation("renewTTL");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.RENEW_TTL);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, this.backendType);
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public RemoteResourceInfo renewTTL(String key, String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = new MyFile();
        this.file.setLockedKey(key);
        this.setCurrentOperation("renewTTL");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.RENEW_TTL);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.file, backendType);
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public RemoteResourceSource linkFile() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("link");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.LINK);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), this.backendType);
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource linkFile(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("link");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.LINK);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType);
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource copyFile() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("copy");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.COPY);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), this.backendType);
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource copyFile(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("copy");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.COPY);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType);
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource moveFile() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("move");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.MOVE);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), this.backendType);
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource moveFile(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("move");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.MOVE);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType);
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource copyDir() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("copy_dir");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.COPY_DIR);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), this.backendType);
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource copyDir(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("copy_dir");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.COPY_DIR);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType);
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource moveDir() {
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("move_dir");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.MOVE_DIR);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), this.backendType);
        return new RemoteResourceSource(this.file, this);
    }

    @Override
    public RemoteResourceSource moveDir(String backendType) {
        backendType = this.setBackendType(backendType);
        this.file = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        this.setCurrentOperation("move_dir");
        this.file = this.setTypeOperation(this.file, OperationDefinition.OPERATION.MOVE_DIR);
        this.service = new OperationManager(this.server, this.user, this.password, this.getCurrentOperation(), this.getMyFile(), backendType);
        return new RemoteResourceSource(this.file, this);
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getOwnerGcube() {
        return this.ownerGcube;
    }

    public void setOwnerGcube(String ownerGcube) {
        this.ownerGcube = ownerGcube;
    }

    public String getGcubeScope() {
        return this.gcubeScope;
    }

    public void setGcubeScope(String gcubeScope) {
        this.gcubeScope = gcubeScope;
    }

    public String getGcubeAccessType() {
        return this.gcubeAccessType;
    }

    public void setGcubeAccessType(String gcubeAccessType) {
        this.gcubeAccessType = gcubeAccessType;
    }

    public String getGcubeMemoryType() {
        return this.gcubeMemoryType;
    }

    public void setGcubeMemoryType(String gcubeMemoryType) {
        this.gcubeMemoryType = gcubeMemoryType;
    }

    private MyFile setTypeOperation(MyFile file, OperationDefinition.OPERATION op) {
        if (file == null) {
            file = new MyFile();
        }
        file.setOperation(op);
        return file;
    }

    public String setBackendType(String backendType) {
        if (backendType != null) {
            this.backendType = backendType;
        }
        return this.backendType;
    }

    public String getBackendType() {
        return this.backendType;
    }

    public String getBackendUser() {
        return this.user;
    }

    public void setBackendUser(String user) {
        if (user != null) {
            this.user = user;
        }
    }

    public String getBackendPassword() {
        return this.password;
    }

    public void setBackendPassword(String password) {
        if (password != null) {
            this.password = password;
        }
    }
}

