/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Request;

import JOscarLib.Flap;
import JOscarLib.Request.Event.RequestListener;
import JOscarLib.Request.Request;
import java.util.ArrayList;
import java.util.TreeMap;

public class RequestKeeper
extends TreeMap {
    private ArrayList freeRequestId = new ArrayList();
    private int requestId = 0;

    public void addRequest(Flap packet, RequestListener listener) {
        if (packet.hasSnac()) {
            if (this.containsRequest(packet.getSnac().getRequestId())) {
                Request request = this.getRequest(packet.getSnac().getRequestId());
                request.addListener(listener);
            } else {
                Request request = new Request(packet, listener);
                this.put(new Integer(packet.getSnac().getRequestId()), request);
            }
        }
    }

    public void addRequest(Request request) {
        if (this.containsRequest(request.getRequestId())) {
            Request existingRequest = this.getRequest(request.getRequestId());
            for (int i = 0; i < request.getNbListeners(); ++i) {
                if (existingRequest.containsListener(request.getRequestListener(i))) continue;
                existingRequest.addListener(request.getRequestListener(i));
            }
        } else {
            this.put(new Integer(request.getRequestId()), request);
        }
    }

    public void removeRequestListener(Flap packet, RequestListener listener) {
        if (packet.hasSnac()) {
            this.removeRequestListener(packet.getSnac().getRequestId(), listener);
        }
    }

    public void removeRequestListener(int requestId, RequestListener listener) {
        if (this.containsKey(new Integer(requestId))) {
            Request request = (Request)this.get(new Integer(requestId));
            request.removeListener(listener);
            this.freeRequestId.add(new Integer(requestId));
            if (request.getNbListeners() == 0) {
                this.remove(new Integer(requestId));
            }
        }
    }

    public boolean containsRequest(int requestId) {
        return this.containsKey(new Integer(requestId));
    }

    public boolean containsRequest(Flap packet) {
        if (packet.hasSnac()) {
            return this.containsRequest(packet.getSnac().getRequestId());
        }
        return false;
    }

    public Request getRequest(int requestId) {
        return (Request)this.get(new Integer(requestId));
    }

    public Request getRequest(Flap packet) {
        return this.getRequest(packet.getSnac().getRequestId());
    }

    public int nextAvailableRequestId() {
        int rId;
        if (this.freeRequestId.size() > 0) {
            rId = (Integer)this.freeRequestId.get(0);
            this.freeRequestId.remove(0);
        } else {
            rId = ++this.requestId;
        }
        return rId;
    }
}

