/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter;

import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerArrayConverter
implements TypeConverter<int[]> {
    public static int[] valueOf(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (value instanceof Number) {
                return new int[]{((Number)value).intValue()};
            }
            try {
                return new int[]{Integer.parseInt(value.toString())};
            }
            catch (NumberFormatException nfex) {
                throw new TypeConversionException(value, (Throwable)nfex);
            }
        }
        if (type == int[].class) {
            return (int[])value;
        }
        if (type == long[].class) {
            long[] values = (long[])value;
            int[] results = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (int)values[i];
            }
            return results;
        }
        if (type == double[].class) {
            double[] values = (double[])value;
            int[] results = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (int)values[i];
            }
            return results;
        }
        if (type == byte[].class) {
            byte[] values = (byte[])value;
            int[] results = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == float[].class) {
            float[] values = (float[])value;
            int[] results = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (int)values[i];
            }
            return results;
        }
        if (type == boolean[].class) {
            boolean[] values = (boolean[])value;
            int[] results = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] ? 1 : 0;
            }
            return results;
        }
        if (type == short[].class) {
            short[] values = (short[])value;
            int[] results = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        Object[] values = (Object[])value;
        int[] results = new int[values.length];
        try {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                results[i] = values[i] instanceof Number ? ((Number)values[i]).intValue() : Integer.parseInt(values[i].toString());
            }
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
        return results;
    }

    @Override
    public int[] convert(Object value) {
        return IntegerArrayConverter.valueOf(value);
    }
}

