/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.filter;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jodd.JoddDefault;
import jodd.io.FastCharArrayWriter;
import jodd.util.CharUtil;

public class CharArrayResponseWrapper
extends HttpServletResponseWrapper {
    protected final FastCharArrayWriter writer = new FastCharArrayWriter();
    protected final String encoding;
    private String contentType = "";

    public CharArrayResponseWrapper(ServletResponse response) {
        this(response, JoddDefault.encoding);
    }

    public CharArrayResponseWrapper(ServletResponse response, String encoding) {
        super((HttpServletResponse)response);
        this.encoding = encoding;
    }

    public PrintWriter getWriter() {
        return new PrintWriter(this.writer);
    }

    public String toString() {
        return this.writer.toString();
    }

    public char[] toCharArray() {
        return this.writer.toCharArray();
    }

    public byte[] toByteArray() throws IOException {
        return CharUtil.toByteArray(this.writer.toCharArray(), this.encoding);
    }

    public void setContentLength(int len) {
        super.setContentLength(len);
    }

    public int getSize() {
        return this.writer.size();
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.contentType = type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void close() {
        this.writer.close();
    }

    public void reset() {
        this.writer.reset();
    }

    public ServletOutputStream getOutputStream() {
        return new ServletOutputStream(){

            public void write(int b) {
                CharArrayResponseWrapper.this.writer.write(b);
            }

            public void write(byte[] b) throws IOException {
                CharArrayResponseWrapper.this.writer.write(CharUtil.toCharArray(b, CharArrayResponseWrapper.this.encoding), 0, b.length);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                CharArrayResponseWrapper.this.writer.write(CharUtil.toCharArray(b, CharArrayResponseWrapper.this.encoding), off, len);
            }
        };
    }
}

