/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

public class HtmlEncoder {
    protected static final char[][] TEXT = new char[64][];
    protected static final char[][] BLOCK = new char[64][];
    private static final String NBSP = "&nbsp;";

    public static String text(Object object) {
        if (object == null) {
            return "";
        }
        return HtmlEncoder.text(object.toString());
    }

    public static String text(String text) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c < '@') {
                buffer.append(TEXT[c]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String block(Object object) {
        if (object == null) {
            return "";
        }
        return HtmlEncoder.block(object.toString());
    }

    public static String block(String text) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        int prev = 0;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c != '\n' || prev != 13) {
                if (c < '@') {
                    buffer.append(BLOCK[c]);
                } else {
                    buffer.append(c);
                }
            }
            prev = c;
        }
        return buffer.toString();
    }

    public static String strict(Object object) {
        if (object == null) {
            return "";
        }
        return HtmlEncoder.strict(object.toString());
    }

    public static String strict(String text) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        int prev = 0;
        boolean prevSpace = false;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                if (prev != 32) {
                    prevSpace = false;
                }
                if (!prevSpace) {
                    buffer.append(' ');
                } else {
                    buffer.append(NBSP);
                }
                prevSpace = !prevSpace;
            } else if (c != '\n' || prev != 13) {
                if (c < '@') {
                    buffer.append(BLOCK[c]);
                } else {
                    buffer.append(c);
                }
            }
            prev = c;
        }
        return buffer.toString();
    }

    static {
        for (int i = 0; i < 64; ++i) {
            HtmlEncoder.TEXT[i] = new char[]{(char)i};
        }
        HtmlEncoder.TEXT[39] = "&#039;".toCharArray();
        HtmlEncoder.TEXT[34] = "&quot;".toCharArray();
        HtmlEncoder.TEXT[38] = "&amp;".toCharArray();
        HtmlEncoder.TEXT[60] = "&lt;".toCharArray();
        HtmlEncoder.TEXT[62] = "&gt;".toCharArray();
        System.arraycopy(TEXT, 0, BLOCK, 0, 64);
        HtmlEncoder.BLOCK[10] = "<br/>".toCharArray();
        HtmlEncoder.BLOCK[13] = "<br/>".toCharArray();
    }
}

