/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.gcubesearchlibrary.parsers;

import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.XMLParsingException;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.CollectionBean;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.FieldBean;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.ObjectInfoBean;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.ResultBean;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.SearchStatusBean;
import gr.uoa.di.madgik.gcubesearchlibrary.utils.FileUtils;
import gr.uoa.di.madgik.gcubesearchlibrary.utils.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLParser {
    public static String parseSignInResponse(String response) {
        String sessionID = null;
        try {
            Document doc = XMLUtils.parseXMLFileToDOM(response);
            XPath xpath = XPathFactory.newInstance().newXPath();
            sessionID = xpath.evaluate("//jsessionid/text()", doc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sessionID;
    }

    public static List<String> parseVREsResponse(String response) {
        ArrayList<String> VREs = new ArrayList<String>();
        try {
            Document doc = XMLUtils.parseXMLFileToDOM(response);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList list = (NodeList)xpath.evaluate("//VRE/text()", doc, XPathConstants.NODESET);
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    VREs.add(XMLUtils.createStringFromDomTree(list.item(i)));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return VREs;
    }

    public static HashMap<String, List<CollectionBean>> parseCollectionsResponse(String response) throws XMLParsingException {
        HashMap<String, List<CollectionBean>> collections = new HashMap<String, List<CollectionBean>>();
        try {
            Document doc = XMLUtils.parseXMLFileToDOM(response);
            NodeList list = doc.getElementsByTagName("CollectionGroup");
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Element collectionGroupNode = (Element)list.item(i);
                    String groupName = collectionGroupNode.getAttribute("name");
                    NodeList colList = collectionGroupNode.getElementsByTagName("Collection");
                    ArrayList<CollectionBean> collectionsList = new ArrayList<CollectionBean>();
                    if (colList != null) {
                        for (int j = 0; j < colList.getLength(); ++j) {
                            Element el;
                            Element collectionNode = (Element)colList.item(j);
                            String collectionName = null;
                            String collectionID = null;
                            NodeList nl = collectionNode.getElementsByTagName("name");
                            if (nl != null && nl.getLength() > 0) {
                                el = (Element)nl.item(0);
                                collectionName = el.getFirstChild().getNodeValue();
                            }
                            if ((nl = collectionNode.getElementsByTagName("colId")) != null && nl.getLength() > 0) {
                                el = (Element)nl.item(0);
                                collectionID = el.getFirstChild().getNodeValue();
                            }
                            collectionsList.add(new CollectionBean(collectionName, collectionID));
                        }
                    }
                    collections.put(groupName, collectionsList);
                }
            }
        }
        catch (Exception e) {
            throw new XMLParsingException(e.getMessage(), e.getCause());
        }
        return collections;
    }

    public static SearchStatusBean parseCollectionInfoResponse(String response) throws XMLParsingException {
        boolean isFullTextSupported = false;
        FieldBean fullTextField = null;
        ArrayList<FieldBean> searchableFields = new ArrayList<FieldBean>();
        try {
            Document doc = XMLUtils.parseXMLFileToDOM(response);
            NodeList list = doc.getElementsByTagName("searchField");
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Element el;
                    Element searchFieldElement = (Element)list.item(i);
                    String name = null;
                    String id = null;
                    NodeList nl = searchFieldElement.getElementsByTagName("name");
                    if (nl != null && nl.getLength() > 0) {
                        el = (Element)nl.item(0);
                        name = el.getFirstChild().getNodeValue();
                    }
                    if ((nl = searchFieldElement.getElementsByTagName("id")) != null && nl.getLength() > 0) {
                        el = (Element)nl.item(0);
                        id = el.getFirstChild().getNodeValue();
                    }
                    FieldBean field = new FieldBean(name, id, false, true);
                    searchableFields.add(field);
                    if (!name.trim().equals("allIndexes")) continue;
                    isFullTextSupported = true;
                    fullTextField = new FieldBean(name, id, false, true);
                }
                SearchStatusBean searchStatus = new SearchStatusBean(isFullTextSupported, fullTextField, searchableFields);
                return searchStatus;
            }
        }
        catch (Exception e) {
            throw new XMLParsingException(e.getMessage(), e.getCause());
        }
        return null;
    }

    public static List<ResultBean> parseSearchResults(String results) throws XMLParsingException {
        ArrayList<ResultBean> resultsRecords = new ArrayList<ResultBean>();
        try {
            Document doc = XMLUtils.parseXMLFileToDOM(results);
            NodeList list = doc.getElementsByTagName("RSRecord");
            if (list != null) {
                List<String> shortRRFields = XMLParser.getShortResultRecordFields();
                List<String> excludedRRFields = XMLParser.getExcludedFromRecordFields();
                for (int i = 0; i < list.getLength(); ++i) {
                    ArrayList<FieldBean> resultRecordFields = new ArrayList<FieldBean>();
                    String objectID = null;
                    String collectionID = null;
                    Element rsRecord = (Element)list.item(i);
                    NodeList fieldsList = rsRecord.getElementsByTagName("field");
                    if (fieldsList != null) {
                        for (int j = 0; j < fieldsList.getLength(); ++j) {
                            Element el;
                            Element fieldNode = (Element)fieldsList.item(j);
                            String name = null;
                            String value = null;
                            boolean includeThisFieldInResult = true;
                            NodeList nl = fieldNode.getElementsByTagName("fieldName");
                            if (nl != null && nl.getLength() > 0) {
                                el = (Element)nl.item(0);
                                name = el.getFirstChild().getNodeValue();
                            }
                            if ((nl = fieldNode.getElementsByTagName("fieldValue")) != null && nl.getLength() > 0) {
                                el = (Element)nl.item(0);
                                if (el.getFirstChild() != null) {
                                    value = el.getFirstChild().getNodeValue();
                                } else {
                                    includeThisFieldInResult = false;
                                }
                            }
                            if (name == null || name.trim().equals("null")) continue;
                            if (name.equals("ObjectID")) {
                                objectID = value;
                                includeThisFieldInResult = false;
                            } else if (name.equals("gDocCollectionID")) {
                                collectionID = value;
                                includeThisFieldInResult = false;
                            } else if (name.equals("S")) {
                                value = StringEscapeUtils.unescapeHtml((String)value);
                            }
                            boolean isPartOfShortRR = false;
                            if (shortRRFields.contains(name)) {
                                isPartOfShortRR = true;
                            }
                            boolean includeFieldInDetailedResult = true;
                            if (excludedRRFields.contains(name)) {
                                includeFieldInDetailedResult = false;
                            }
                            if (!includeThisFieldInResult) continue;
                            FieldBean f = new FieldBean(name, value, isPartOfShortRR, includeFieldInDetailedResult);
                            resultRecordFields.add(f);
                        }
                    }
                    resultsRecords.add(new ResultBean(resultRecordFields, objectID, collectionID));
                }
            }
        }
        catch (Exception e) {
            throw new XMLParsingException(e.getMessage(), e.getCause());
        }
        return resultsRecords;
    }

    public static String parseObjectInfoResponseToGetMime(String response) throws XMLParsingException {
        String mime = null;
        try {
            Document doc = XMLUtils.parseXMLFileToDOM(response);
            NodeList nl = doc.getElementsByTagName("MimeType");
            if (nl != null && nl.getLength() > 0) {
                Element el = (Element)nl.item(0);
                mime = el.getFirstChild().getNodeValue();
            }
        }
        catch (Exception e) {
            throw new XMLParsingException(e.getMessage(), e.getCause());
        }
        return mime;
    }

    public static ObjectInfoBean parseObjectInfoResponseToGetObjectInfo(String response) throws XMLParsingException {
        String mime = null;
        String length = null;
        String name = null;
        String objectID = null;
        try {
            Element el;
            Document doc = XMLUtils.parseXMLFileToDOM(response);
            NodeList nl = doc.getElementsByTagName("MimeType");
            if (nl != null && nl.getLength() > 0) {
                el = (Element)nl.item(0);
                mime = el.getFirstChild().getNodeValue();
            }
            if ((nl = doc.getElementsByTagName("Length")) != null && nl.getLength() > 0) {
                el = (Element)nl.item(0);
                length = el.getFirstChild().getNodeValue();
            }
            if ((nl = doc.getElementsByTagName("Name")) != null && nl.getLength() > 0) {
                el = (Element)nl.item(0);
                name = el.getFirstChild().getNodeValue();
            }
            if ((nl = doc.getElementsByTagName("ObjectId")) != null && nl.getLength() > 0) {
                el = (Element)nl.item(0);
                objectID = el.getFirstChild().getNodeValue();
            }
            ObjectInfoBean objectBean = new ObjectInfoBean(name, objectID, mime, length);
            return objectBean;
        }
        catch (Exception e) {
            throw new XMLParsingException(e.getMessage(), e.getCause());
        }
    }

    private static List<String> getShortResultRecordFields() {
        ArrayList<String> fields = new ArrayList<String>();
        try {
            int count = Integer.parseInt(FileUtils.getPropertyValue("fields.properties", "fieldscount"));
            for (int i = 0; i < count; ++i) {
                fields.add(FileUtils.getPropertyValue("fields.properties", "field." + i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fields;
    }

    private static List<String> getExcludedFromRecordFields() {
        ArrayList<String> fields = new ArrayList<String>();
        try {
            int count = Integer.parseInt(FileUtils.getPropertyValue("fields.properties", "excludedfieldscount"));
            for (int i = 0; i < count; ++i) {
                fields.add(FileUtils.getPropertyValue("fields.properties", "efield." + i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fields;
    }
}

