/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.bridge;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.IRRElement;
import gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.data.DataCollectionDao;
import gr.uoa.di.madgik.rr.element.data.DataLanguage;
import gr.uoa.di.madgik.rr.element.execution.ExecutionServerDao;
import gr.uoa.di.madgik.rr.element.execution.ExecutionServiceDao;
import gr.uoa.di.madgik.rr.element.execution.SearchServiceDao;
import gr.uoa.di.madgik.rr.element.execution.WorkflowServiceDao;
import gr.uoa.di.madgik.rr.element.functionality.Functionality;
import gr.uoa.di.madgik.rr.element.functionality.FunctionalityDao;
import gr.uoa.di.madgik.rr.element.infra.HostingNode;
import gr.uoa.di.madgik.rr.element.infra.HostingNodeDao;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FTIndex;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexService;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSource;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.SruConsumer;
import gr.uoa.di.madgik.rr.element.search.index.SruConsumerDao;
import gr.uoa.di.madgik.rr.element.search.index.SruConsumerService;
import gr.uoa.di.madgik.rr.element.search.index.SruConsumerServiceDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.gcube.execution.rr.bridge.BackendConnector;
import org.gcube.execution.rr.bridge.DataSourceDescription;
import org.gcube.execution.rr.bridge.FieldModel;
import org.gcube.execution.rr.bridge.GCubeRepositoryProvider;
import org.gcube.execution.rr.bridge.scope.ICScopeHelper;
import org.gcube.execution.rr.bridge.scope.ScopeHelper;
import org.gcube.execution.rr.configuration.ConfigurationProviderLoader;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.gcube.rest.commons.helpers.XPathEvaluator;
import org.gcube.rest.commons.resourceawareservice.resources.GeneralResource;
import org.gcube.rest.commons.resourceawareservice.resources.HostNode;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.gcube.rest.commons.resourceawareservice.resources.SerInstance;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BridgeHelper {
    private static final Logger logger = LoggerFactory.getLogger(BridgeHelper.class);
    private static List<String> scopes = null;
    private static List<String> searchSystemScopes = null;
    private static Set<IDaoElement> searchSystemServices = null;
    static ScopeHelper scopeHelper = new ICScopeHelper();
    public static final String ENDPOINT_KEY = "resteasy-servlet";
    private static final String JNDI_NAME = "gcube/data/tm";
    private static final String TREADER_NAME = "gcube/data/tm/reader";
    private static final String SOURCENAME_RPNAME = "Name";
    private static final String SOURCEID_RPNAME = "SourceId";

    public static void initializeIndexTypes() {
        DataSource.clearSubTypes();
        DataSource.addSubType((DataSource.Type)DataSource.Type.FullTextIndex, FTIndex.class, FTIndexDao.class);
        DataSource.addSubType((DataSource.Type)DataSource.Type.OpenSearch, OpenSearchDataSource.class, OpenSearchDataSourceDao.class);
        DataSource.addSubType((DataSource.Type)DataSource.Type.SruConsumer, SruConsumer.class, SruConsumerDao.class);
        DataSourceService.clearSubTypes();
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.OpenSearch, OpenSearchDataSourceService.class, OpenSearchDataSourceServiceDao.class);
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.SruConsumer, SruConsumerService.class, SruConsumerServiceDao.class);
    }

    public static void initializeIndexTypes(Properties config) throws ResourceRegistryException {
        try {
            String value;
            String key;
            String type;
            int i;
            HashSet res;
            int count = Integer.parseInt(config.getProperty("dataSourceSubTypesCount", "0"));
            if (count != 0) {
                DataSource.clearSubTypes();
                res = new HashSet(count);
                for (i = 0; i < count; ++i) {
                    type = config.getProperty("dataSourceSubTypesType." + i);
                    if (type == null) {
                        throw new ResourceRegistryException("Could not read datasource type #" + i);
                    }
                    key = config.getProperty("dataSourceSubTypesKey." + i);
                    if (key == null) {
                        throw new ResourceRegistryException("Could not read datasource class name #" + i);
                    }
                    value = config.getProperty("dataSourceSubTypesValue." + i);
                    if (value == null) {
                        throw new ResourceRegistryException("Could not read datasource dao class name #" + i);
                    }
                    DataSource.addSubType((DataSource.Type)DataSource.Type.valueOf((String)type), Class.forName(key), Class.forName(value));
                    logger.info("Adding DataSource type: " + type + "-" + key + "-" + value);
                }
            }
            if ((count = Integer.parseInt(config.getProperty("dataSourceServiceSubTypesCount", "0"))) != 0) {
                DataSourceService.clearSubTypes();
                res = new HashSet(count);
                for (i = 0; i < count; ++i) {
                    type = config.getProperty("dataSourceServiceSubTypesType." + i);
                    if (type == null) {
                        throw new ResourceRegistryException("Could not read datasource service type #" + i);
                    }
                    key = config.getProperty("dataSourceServiceSubTypesKey." + i);
                    if (key == null) {
                        throw new ResourceRegistryException("Could not read datasource service class name #" + i);
                    }
                    value = config.getProperty("dataSourceServiceSubTypesValue." + i);
                    if (value == null) {
                        throw new ResourceRegistryException("Could not read datasource service dao class name #" + i);
                    }
                    DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.valueOf((String)type), Class.forName(key), Class.forName(value));
                    logger.info("Adding DataSource service type: " + type + "-" + key + "-" + value);
                }
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while initializing datasource types", (Throwable)e);
        }
    }

    public static void retrieveScopes() throws Exception {
        if (BridgeHelper.isClientMode()) {
            BridgeHelper.retrieveScopesOffline();
        } else {
            BridgeHelper.retrieveScopesOnline();
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logScopes = new StringBuilder();
            for (String scope : scopes) {
                logScopes.append(scope.toString());
                logScopes.append(" ");
            }
            logger.info("Scopes: " + logScopes.toString());
        }
        searchSystemServices = BridgeHelper.retrieveSearchService();
        HashSet searchSystemScopeSet = new HashSet();
        for (IDaoElement searchSystemService : searchSystemServices) {
            searchSystemScopeSet.addAll(((SearchServiceDao)searchSystemService).scopes);
        }
        searchSystemScopes = new ArrayList<String>();
        logger.info("searchSystemScopeSet contains : " + searchSystemScopeSet);
        for (String s : searchSystemScopeSet) {
            searchSystemScopes.add(s);
        }
    }

    public static List<String> getFieldModelScopes() throws Exception {
        HashSet<String> fieldScopes = new HashSet<String>();
        for (String scope : searchSystemScopes) {
            if (scopeHelper.isInfraScope(scope).booleanValue()) {
                logger.info(scope + " is infra scope");
                continue;
            }
            if (scopeHelper.isVOScope(scope).booleanValue()) {
                logger.info(scope + " is a VO scope");
            } else if (scopeHelper.isVREScope(scope).booleanValue()) {
                logger.info(scope + " is a VRE scope. Will add : " + scopeHelper.getEnclosingScope(scope));
            }
            if (scopeHelper.isVOScope(scope).booleanValue()) {
                fieldScopes.add(scope);
                continue;
            }
            if (!scopeHelper.isVREScope(scope).booleanValue()) continue;
            fieldScopes.add(scopeHelper.getEnclosingScope(scope));
        }
        ArrayList<String> gCubeScopes = new ArrayList<String>();
        logger.info("#### searchSystemScopes : " + searchSystemScopes);
        logger.info("#### FieldModelScopes   : " + fieldScopes);
        for (String scope : fieldScopes) {
            gCubeScopes.add(scope);
        }
        return gCubeScopes;
    }

    private static void retrieveScopesOnline() throws Exception {
        List<String> tmpScopes = BridgeHelper.getGHNContextScopes();
        logger.info("retrieveScopesOnline : " + tmpScopes);
        ArrayList<String> toKeepScopes = new ArrayList<String>();
        for (String scope : tmpScopes) {
            if (scopeHelper.isInfraScope(scope).booleanValue()) continue;
            toKeepScopes.add(scope);
        }
        logger.info("retrieveScopesOnline after additions : " + toKeepScopes);
        scopes = new ArrayList<String>(toKeepScopes);
    }

    private static void retrieveScopesOffline() throws Exception {
        List<String> scopes = BridgeHelper.getGHNContextStartScopes();
        logger.info("retrieveScopesOffline : " + scopes);
        scopes = BridgeHelper.getScopesOfPublishedVREResources();
        logger.info("retrieveScopesOffline after additions : " + scopes);
        BridgeHelper.scopes = new ArrayList<String>(scopes);
    }

    private static List<String> getScopesOfPublishedVREResources() throws Exception {
        logger.info("Searching for publised VRE resouces");
        ArrayList resources = new ArrayList();
        List<String> scopes = BridgeHelper.getGHNContextStartScopes();
        logger.info("getPublishedVREResources : " + scopes);
        Set<String> voScopes = BridgeHelper.getVOScopes(scopes);
        for (String scope : voScopes) {
            resources.addAll(BackendConnector.newICollector().getGenericResourcesByType("VRE", scope));
        }
        for (Resource resource : resources) {
            String retrievedScope;
            if (resource.getScopes() == null || resource.getScopes().isEmpty() || (retrievedScope = (String)resource.getScopes().get(0)) == null) continue;
            scopes.add(retrievedScope);
        }
        return scopes;
    }

    public static Set<IDaoElement> getElement(Class<?> type) throws Exception {
        if (type.equals(FieldDao.class)) {
            return BridgeHelper.getFields();
        }
        if (type.equals(PresentableDao.class)) {
            return BridgeHelper.getPresentables();
        }
        if (type.equals(SearchableDao.class)) {
            return BridgeHelper.getSearchables();
        }
        if (type.equals(DataCollectionDao.class)) {
            return BridgeHelper.getAllCollections();
        }
        if (type.equals(HostingNodeDao.class)) {
            return BridgeHelper.getHostingNodes();
        }
        if (type.equals(FunctionalityDao.class)) {
            return BridgeHelper.getFunctionality();
        }
        if (type.equals(ExecutionServerDao.class)) {
            return BridgeHelper.getExecutionServer();
        }
        if (type.equals(ExecutionServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(WorkflowServiceDao.class)) {
            return BridgeHelper.getWorkflowService();
        }
        if (type.equals(FieldIndexContainerDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(FTIndexDao.class)) {
            return BridgeHelper.getDataSourceFT();
        }
        if (type.equals(OpenSearchDataSourceDao.class)) {
            return BridgeHelper.getOpenSearchDataSource();
        }
        if (type.equals(SruConsumerDao.class)) {
            return BridgeHelper.getSruConsumerDataSource();
        }
        if (type.equals(FTIndexServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(OpenSearchDataSourceServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(SruConsumerServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(ElementMetadataDao.class)) {
            return BridgeHelper.getElementMetadata();
        }
        if (type.equals(StaticConfigurationDao.class)) {
            return BridgeHelper.getStaticConfiguration();
        }
        throw new ResourceRegistryException("unrecognized element type " + type);
    }

    private static Set<IDaoElement> getDataSourceOpenSearch() throws Exception {
        String className = OpenSearchDataSourceDao.class.getName();
        String serviceClassName = OpenSearchDataSourceServiceDao.class.getName();
        String functionality = "opensearch.index.ft";
        List<String> scopes = BridgeHelper.scopes;
        logger.warn("### getting OPENSEARCH datasources from scopes : " + scopes);
        HashMap<String, DataSourceDao> datasourceItems = new HashMap<String, DataSourceDao>();
        HashMap<String, DataSourceServiceDao> datasourceServiceItems = new HashMap<String, DataSourceServiceDao>();
        HashSet<FieldIndexContainerDao> fieldItems = new HashSet<FieldIndexContainerDao>();
        for (String scope : scopes) {
            logger.info("Searching for opensearch datasources in scope " + scope.toString());
            List resources = BackendConnector.newICollector().getGenericResourcesByType("OpenSearchDataSourceResources", scope);
            logger.info("found  " + resources.size() + "  in scope " + scope.toString());
            for (Resource r : resources) {
                String key = r.getResourceID();
                logger.info("resource key : " + key + " datasourcetimes : " + datasourceItems + " scope : " + scope);
                if (key == null) continue;
                if (datasourceItems.containsKey(key)) {
                    for (String datasourceScope : r.getScopes()) {
                        logger.trace("adding scope : " + datasourceScope);
                        ((DataSourceDao)datasourceItems.get(key)).getScopes().add(datasourceScope);
                        ((DataSourceServiceDao)datasourceServiceItems.get(key)).getScopes().add(datasourceScope);
                    }
                    ((DataSourceDao)datasourceItems.get(key)).getScopes().add(scope.toString());
                    ((DataSourceServiceDao)datasourceServiceItems.get(key)).getScopes().add(scope.toString());
                    continue;
                }
                DataSourceServiceDao ss = (DataSourceServiceDao)Class.forName(serviceClassName).newInstance();
                ss.setID(key);
                ss.setType(DataSource.Type.OpenSearch.toString());
                ss.getDataSources().add(key);
                String hostname = null;
                String endpoint = null;
                String hostingnode = null;
                Node body = r.getBody();
                XPathEvaluator xpath = new XPathEvaluator(body);
                if (xpath.evaluate("//hostname/text()").size() > 0) {
                    hostname = (String)xpath.evaluate("//hostname/text()").get(0);
                    endpoint = BridgeHelper.getOpenSearchServiceEndpoint(scope, hostname);
                    hostingnode = BridgeHelper.getOpenSearchServiceGHNId(scope, hostname);
                }
                HashSet<String> resourceScopes = new HashSet<String>();
                for (String resourceScope : xpath.evaluate("//scope/text()")) {
                    resourceScopes.add(resourceScope);
                }
                logger.info("scopes of datasource : " + resourceScopes);
                logger.info("------- endpoint : " + endpoint);
                ss.setEndpoint(endpoint);
                ss.setFunctionality(functionality);
                ss.setHostingNode(hostingnode);
                ss.getScopes().addAll(resourceScopes);
                ss.getScopes().add(scope);
                ss.setTimestamp(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                datasourceServiceItems.put(ss.getID(), ss);
                DataSourceDao s = (DataSourceDao)Class.forName(className).newInstance();
                s.setID(key);
                s.setType(DataSource.Type.OpenSearch.toString());
                s.setFunctionality(functionality);
                if (s.getBoundDataSourceServices() == null) {
                    s.setBoundDataSourceServices(new HashSet());
                }
                s.getBoundDataSourceServices().add(key);
                s.setTimestamp(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                s.getCapabilities().clear();
                for (String capability : xpath.evaluate("//supportedRelations/text()")) {
                    capability = StringEscapeUtils.unescapeXml((String)capability);
                    logger.info("capability found : " + capability);
                    s.getCapabilities().add(capability);
                }
                s.getScopes().addAll(resourceScopes);
                s.getScopes().add(scope);
                HashSet<String> checkDups = new HashSet<String>();
                for (String f : xpath.evaluate("//fields/text()")) {
                    logger.trace("Custom properties f : " + f);
                    String[] fparts = f.split(":");
                    if (fparts.length == 6 && fparts[2].equals("s")) {
                        fparts[4] = fparts[4] + ":" + fparts[5];
                    }
                    if (fparts.length < 4 || fparts.length > 6 || fparts.length == 6 && !fparts[2].equals("s")) continue;
                    FieldIndexContainerDao fc = new FieldIndexContainerDao();
                    fc.setID(s.getID() + ":" + f);
                    if (checkDups.contains(fc.getID())) {
                        logger.warn("Duplicate field detected: " + fc.getID());
                        continue;
                    }
                    checkDups.add(fc.getID());
                    fc.setCollection(fparts[0]);
                    fc.setLanguage(fparts[1]);
                    fc.setFieldType(fparts[2]);
                    fc.setField(fparts[3]);
                    logger.info("### Field : " + f + " language " + fparts[1] + " collection : " + fparts[0]);
                    if (fparts.length >= 5) {
                        fc.setExpression(fparts[4]);
                    }
                    s.getFields().add(fc.getID());
                    fieldItems.add(fc);
                }
                logger.info("datasource : " + s.getID());
                logger.info("datasource fields : " + s.getFields());
                logger.info("datasource scopes : " + s.getScopes());
                datasourceItems.put(s.getID(), s);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(datasourceItems.values());
        retValue.addAll(datasourceServiceItems.values());
        retValue.addAll(fieldItems);
        return retValue;
    }

    private static Set<IDaoElement> getDataSourceSruConsumer() throws Exception {
        String className = SruConsumerDao.class.getName();
        String serviceClassName = SruConsumerServiceDao.class.getName();
        String functionality = "sruconsumer.consumer";
        List<String> scopes = BridgeHelper.scopes;
        logger.warn("### getting SRU_CONSUMER datasources from scopes : " + scopes);
        HashMap<String, DataSourceDao> datasourceItems = new HashMap<String, DataSourceDao>();
        HashMap<String, DataSourceServiceDao> datasourceServiceItems = new HashMap<String, DataSourceServiceDao>();
        HashSet<FieldIndexContainerDao> fieldItems = new HashSet<FieldIndexContainerDao>();
        for (String scope : scopes) {
            logger.info("Searching for sru consumers datasources in scope " + scope.toString());
            List resources = BackendConnector.newICollector().getGenericResourcesByType("SruConsumerResources", scope);
            logger.info("found  " + resources.size() + "  in scope " + scope.toString());
            for (Resource r : resources) {
                String key = r.getResourceID();
                logger.info("resource key : " + key + " datasourcetimes : " + datasourceItems + " scope : " + scope);
                if (key == null) continue;
                if (datasourceItems.containsKey(key)) {
                    for (String datasourceScope : r.getScopes()) {
                        logger.trace("adding scope : " + datasourceScope);
                        ((DataSourceDao)datasourceItems.get(key)).getScopes().add(datasourceScope);
                        ((DataSourceServiceDao)datasourceServiceItems.get(key)).getScopes().add(datasourceScope);
                    }
                    ((DataSourceDao)datasourceItems.get(key)).getScopes().add(scope.toString());
                    ((DataSourceServiceDao)datasourceServiceItems.get(key)).getScopes().add(scope.toString());
                    continue;
                }
                DataSourceServiceDao ss = (DataSourceServiceDao)Class.forName(serviceClassName).newInstance();
                ss.setID(key);
                ss.setType(DataSource.Type.SruConsumer.toString());
                ss.getDataSources().add(key);
                String hostname = null;
                String endpoint = null;
                String hostingnode = null;
                Node body = r.getBody();
                XPathEvaluator xpath = new XPathEvaluator(body);
                if (xpath.evaluate("//hostname/text()").size() > 0) {
                    hostname = (String)xpath.evaluate("//hostname/text()").get(0);
                    endpoint = BridgeHelper.getSruConsumerServiceEndpoint(scope, hostname);
                    hostingnode = BridgeHelper.getSruConsumerGHNId(scope, hostname);
                }
                HashSet<String> resourceScopes = new HashSet<String>();
                for (String resourceScope : xpath.evaluate("//scope/text()")) {
                    resourceScopes.add(resourceScope);
                }
                logger.info("scopes of datasource : " + resourceScopes);
                logger.info("------- endpoint : " + endpoint);
                ss.setEndpoint(endpoint);
                ss.setFunctionality(functionality);
                ss.setHostingNode(hostingnode);
                ss.getScopes().addAll(resourceScopes);
                ss.getScopes().add(scope);
                ss.setTimestamp(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                datasourceServiceItems.put(ss.getID(), ss);
                DataSourceDao s = (DataSourceDao)Class.forName(className).newInstance();
                s.setID(key);
                s.setType(DataSource.Type.SruConsumer.toString());
                s.setFunctionality(functionality);
                if (s.getBoundDataSourceServices() == null) {
                    s.setBoundDataSourceServices(new HashSet());
                }
                s.getBoundDataSourceServices().add(key);
                s.setTimestamp(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                s.getCapabilities().clear();
                for (String capability : xpath.evaluate("//supportedRelations/text()")) {
                    capability = StringEscapeUtils.unescapeXml((String)capability);
                    logger.info("capability found : " + capability);
                    s.getCapabilities().add(capability);
                }
                s.getScopes().addAll(resourceScopes);
                s.getScopes().add(scope);
                HashSet<String> checkDups = new HashSet<String>();
                for (String f : xpath.evaluate("//fields/text()")) {
                    logger.trace("Custom properties f : " + f);
                    String[] fparts = f.split(":");
                    if (fparts.length == 6 && fparts[2].equals("s")) {
                        fparts[4] = fparts[4] + ":" + fparts[5];
                    }
                    if (fparts.length < 4 || fparts.length > 6 || fparts.length == 6 && !fparts[2].equals("s")) continue;
                    FieldIndexContainerDao fc = new FieldIndexContainerDao();
                    fc.setID(s.getID() + ":" + f);
                    if (checkDups.contains(fc.getID())) {
                        logger.warn("Duplicate field detected: " + fc.getID());
                        continue;
                    }
                    checkDups.add(fc.getID());
                    fc.setCollection(fparts[0]);
                    fc.setLanguage(fparts[1]);
                    fc.setFieldType(fparts[2]);
                    fc.setField(fparts[3]);
                    logger.info("### Field : " + f + " language " + fparts[1] + " collection : " + fparts[0]);
                    if (fparts.length >= 5) {
                        fc.setExpression(fparts[4]);
                    }
                    s.getFields().add(fc.getID());
                    fieldItems.add(fc);
                }
                logger.info("datasource : " + s.getID());
                logger.info("datasource fields : " + s.getFields());
                logger.info("datasource scopes : " + s.getScopes());
                datasourceItems.put(s.getID(), s);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(datasourceItems.values());
        retValue.addAll(datasourceServiceItems.values());
        retValue.addAll(fieldItems);
        return retValue;
    }

    private static Set<IDaoElement> getDataSourceFT() throws Exception {
        String className = FTIndexDao.class.getName();
        String serviceClassName = FTIndexServiceDao.class.getName();
        String functionality = "search.index.ft";
        List<String> scopes = BridgeHelper.scopes;
        logger.warn("### getting datasources from scopes : " + scopes);
        HashMap<String, DataSourceDao> datasourceItems = new HashMap<String, DataSourceDao>();
        HashMap<String, DataSourceServiceDao> datasourceServiceItems = new HashMap<String, DataSourceServiceDao>();
        HashSet<FieldIndexContainerDao> fieldItems = new HashSet<FieldIndexContainerDao>();
        for (String scope : scopes) {
            logger.info("Searching for fulltext indexes in scope " + scope.toString());
            List resources = BackendConnector.newICollector().getGenericResourcesByType("IndexResources", scope);
            logger.info("found  " + resources.size() + "  in scope " + scope.toString());
            for (Resource r : resources) {
                String key = r.getResourceID();
                logger.info("resource key : " + key + " datasourcetimes : " + datasourceItems + " scope : " + scope);
                if (key == null) continue;
                if (datasourceItems.containsKey(key)) {
                    for (String datasourceScope : r.getScopes()) {
                        logger.trace("adding scope : " + datasourceScope);
                        ((DataSourceDao)datasourceItems.get(key)).getScopes().add(datasourceScope);
                        ((DataSourceServiceDao)datasourceServiceItems.get(key)).getScopes().add(datasourceScope);
                    }
                    ((DataSourceDao)datasourceItems.get(key)).getScopes().add(scope.toString());
                    ((DataSourceServiceDao)datasourceServiceItems.get(key)).getScopes().add(scope.toString());
                    continue;
                }
                DataSourceServiceDao ss = (DataSourceServiceDao)Class.forName(serviceClassName).newInstance();
                ss.setID(key);
                ss.setType(DataSource.Type.FullTextIndex.toString());
                ss.getDataSources().add(key);
                String hostname = null;
                String endpoint = null;
                String hostingnode = null;
                Node body = r.getBody();
                XPathEvaluator xpath = new XPathEvaluator(body);
                if (xpath.evaluate("//hostname/text()").size() > 0) {
                    hostname = (String)xpath.evaluate("//hostname/text()").get(0);
                    endpoint = BridgeHelper.getIndexServiceEndpoint(scope, hostname);
                    hostingnode = BridgeHelper.getIndexServiceGHNId(scope, hostname);
                }
                HashSet<String> resourceScopes = new HashSet<String>();
                for (String resourceScope : xpath.evaluate("//scope/text()")) {
                    resourceScopes.add(resourceScope);
                }
                logger.info("scopes of datasource : " + resourceScopes);
                logger.trace("------- endpoint : " + endpoint);
                ss.setEndpoint(endpoint);
                ss.setFunctionality(functionality);
                ss.setHostingNode(hostingnode);
                ss.getScopes().addAll(resourceScopes);
                ss.getScopes().add(scope);
                ss.setTimestamp(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                datasourceServiceItems.put(ss.getID(), ss);
                DataSourceDao s = (DataSourceDao)Class.forName(className).newInstance();
                s.setID(key);
                s.setType(DataSource.Type.FullTextIndex.toString());
                s.setFunctionality(functionality);
                if (s.getBoundDataSourceServices() == null) {
                    s.setBoundDataSourceServices(new HashSet());
                }
                s.getBoundDataSourceServices().add(key);
                s.setTimestamp(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                s.getCapabilities().clear();
                for (String capability : xpath.evaluate("//supportedRelations/text()")) {
                    capability = StringEscapeUtils.unescapeXml((String)capability);
                    logger.debug("capability found : " + capability);
                    s.getCapabilities().add(capability);
                }
                s.getScopes().addAll(resourceScopes);
                s.getScopes().add(scope);
                HashSet<String> checkDups = new HashSet<String>();
                for (String f : xpath.evaluate("//fields/text()")) {
                    logger.trace("Custom properties f : " + f);
                    String[] fparts = f.split(":");
                    if (fparts.length == 6 && fparts[2].equals("s")) {
                        fparts[4] = fparts[4] + ":" + fparts[5];
                    }
                    if (fparts.length < 4 || fparts.length > 6 || fparts.length == 6 && !fparts[2].equals("s")) continue;
                    FieldIndexContainerDao fc = new FieldIndexContainerDao();
                    fc.setID(s.getID() + ":" + f);
                    if (checkDups.contains(fc.getID())) {
                        logger.warn("Duplicate field detected: " + fc.getID());
                        continue;
                    }
                    checkDups.add(fc.getID());
                    fc.setCollection(fparts[0]);
                    fc.setLanguage(fparts[1]);
                    fc.setFieldType(fparts[2]);
                    fc.setField(fparts[3]);
                    logger.debug("### Field : " + f + " language " + fparts[1] + " collection : " + fparts[0]);
                    if (fparts.length >= 5) {
                        fc.setExpression(fparts[4]);
                    }
                    s.getFields().add(fc.getID());
                    fieldItems.add(fc);
                }
                logger.info("datasource : " + s.getID());
                logger.info("datasource fields : " + s.getFields());
                logger.info("datasource scopes : " + s.getScopes());
                datasourceItems.put(s.getID(), s);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(datasourceItems.values());
        retValue.addAll(datasourceServiceItems.values());
        retValue.addAll(fieldItems);
        return retValue;
    }

    private static String getSruConsumerServiceEndpoint(String scope, String hostname) {
        Set insts = BackendConnector.newICollector().discoverRunningInstancesFilteredByEndopointKey("SruConsumerDatasource", "Search", ENDPOINT_KEY, scope);
        logger.info("run instances : " + insts);
        for (RunInstance inst : insts) {
            try {
                if (!((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString().toLowerCase().contains(hostname.toLowerCase())) continue;
                logger.info("found epr for the hostname : " + hostname + " at : " + ((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString());
                return ((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString();
            }
            catch (Exception e) {
                logger.warn("error comparing the uri to the hostname");
            }
        }
        logger.warn("not found epr for the hostname : " + hostname);
        return null;
    }

    private static String getSruConsumerGHNId(String scope, String hostname) {
        Set insts = BackendConnector.newICollector().discoverRunningInstancesFilteredByEndopointKey("SruConsumerDatasource", "Search", ENDPOINT_KEY, scope);
        for (RunInstance inst : insts) {
            try {
                if (!((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString().toLowerCase().contains(hostname.toLowerCase())) continue;
                logger.info("found ghnid for the hostname : " + hostname + " at : " + inst.getProfile().ghn.ghnId);
                return inst.getProfile().ghn.ghnId;
            }
            catch (Exception e) {
                logger.warn("error comparing the uri to the hostname");
            }
        }
        logger.warn("not found ghnid for the hostname : " + hostname);
        return null;
    }

    private static String getOpenSearchServiceEndpoint(String scope, String hostname) {
        Set insts = BackendConnector.newICollector().discoverRunningInstancesFilteredByEndopointKey("OpenSearchDataSource", "Search", ENDPOINT_KEY, scope);
        logger.info("run instances : " + insts);
        for (RunInstance inst : insts) {
            try {
                if (!((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString().toLowerCase().contains(hostname.toLowerCase())) continue;
                logger.info("found epr for the hostname : " + hostname + " at : " + ((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString());
                return ((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString();
            }
            catch (Exception e) {
                logger.warn("error comparing the uri to the hostname");
            }
        }
        logger.warn("not found epr for the hostname : " + hostname);
        return null;
    }

    private static String getOpenSearchServiceGHNId(String scope, String hostname) {
        Set insts = BackendConnector.newICollector().discoverRunningInstancesFilteredByEndopointKey("OpenSearchDataSource", "Search", ENDPOINT_KEY, scope);
        for (RunInstance inst : insts) {
            try {
                if (!((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString().toLowerCase().contains(hostname.toLowerCase())) continue;
                logger.info("found ghnid for the hostname : " + hostname + " at : " + inst.getProfile().ghn.ghnId);
                return inst.getProfile().ghn.ghnId;
            }
            catch (Exception e) {
                logger.warn("error comparing the uri to the hostname");
            }
        }
        logger.warn("not found ghnid for the hostname : " + hostname);
        return null;
    }

    private static String getIndexServiceEndpoint(String scope, String hostname) {
        Set insts = BackendConnector.newICollector().discoverRunningInstancesFilteredByEndopointKey("FullTextIndexNode", "Index", ENDPOINT_KEY, scope);
        for (RunInstance inst : insts) {
            try {
                if (!((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString().toLowerCase().contains(hostname.toLowerCase())) continue;
                logger.info("found epr for the hostname : " + hostname + " at : " + ((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString());
                return ((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString();
            }
            catch (Exception e) {
                logger.warn("error comparing the uri to the hostname");
            }
        }
        logger.warn("not found epr for the hostname : " + hostname);
        return null;
    }

    private static String getIndexServiceGHNId(String scope, String hostname) {
        Set insts = BackendConnector.newICollector().discoverRunningInstancesFilteredByEndopointKey("FullTextIndexNode", "Index", ENDPOINT_KEY, scope);
        for (RunInstance inst : insts) {
            try {
                if (!((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toASCIIString().toLowerCase().contains(hostname.toLowerCase())) continue;
                logger.info("found ghnid for the hostname : " + hostname + " at : " + inst.getProfile().ghn.ghnId);
                return inst.getProfile().ghn.ghnId;
            }
            catch (Exception e) {
                logger.warn("error comparing the uri to the hostname");
            }
        }
        logger.warn("not found ghnid for the hostname : " + hostname);
        return null;
    }

    private static Set<IDaoElement> getFakeFTIndex() throws Exception {
        FieldIndexContainerDao fc;
        String[] fparts;
        HashMap<String, FTIndexDao> datasourceItems = new HashMap<String, FTIndexDao>();
        HashMap<String, FTIndexServiceDao> serviceItems = new HashMap<String, FTIndexServiceDao>();
        HashSet<FieldIndexContainerDao> fieldItems = new HashSet<FieldIndexContainerDao>();
        FTIndexServiceDao ss = new FTIndexServiceDao();
        ss.setID("1283-5c96-f869-172b");
        ss.setFunctionality("search.index.ft");
        ss.setHostingNode("FTIndexGHNOne");
        ss.setEndpoint("http://nowhere1.com/wsrf/index/fulltext");
        ss.getScopes().add("/no/scope/");
        ss.setTimestamp(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
        ss.setType(DataSource.Type.FullTextIndex.toString());
        serviceItems.put(ss.getID(), ss);
        FTIndexDao s = new FTIndexDao();
        s.setID("1283-5c96-f869-172b");
        s.setType(DataSource.Type.FullTextIndex.toString());
        s.setFunctionality("search.index.ft");
        s.getCapabilities().clear();
        s.getCapabilities().add("any");
        s.getFields().clear();
        s.getScopes().add("/no/scope/");
        ArrayList<String> ff = new ArrayList<String>();
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:title");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:title");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:source");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:source");
        for (String f : ff) {
            fparts = f.split(":");
            if (fparts.length != 4) continue;
            fc = new FieldIndexContainerDao();
            fc.setID(s.getID() + ":" + f);
            fc.setCollection(fparts[0]);
            fc.setLanguage(fparts[1]);
            fc.setFieldType(fparts[2]);
            fc.setField(fparts[3]);
            s.getFields().add(fc.getID());
            fieldItems.add(fc);
        }
        datasourceItems.put(s.getID(), s);
        ss = new FTIndexServiceDao();
        ss.setID("768a-8ab8-1281-9812");
        ss.setType(DataSource.Type.FullTextIndex.toString());
        ss.setHostingNode("FTIndexGHNTwo");
        ss.setEndpoint("http://nowhere2.com/wsrf/index/fulltext");
        serviceItems.put(ss.getID(), ss);
        s = new FTIndexDao();
        s.setID("768a-8ab8-1281-9812");
        s.setType(DataSource.Type.FullTextIndex.toString());
        s.setFunctionality("search.index.ft");
        s.getCapabilities().clear();
        s.getCapabilities().add("any");
        s.getFields().clear();
        s.getScopes().add("/no/scope/");
        ff = new ArrayList();
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:type");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:type");
        for (String f : ff) {
            fparts = f.split(":");
            if (fparts.length != 4) continue;
            fc = new FieldIndexContainerDao();
            fc.setID(s.getID() + ":" + f);
            fc.setCollection(fparts[0]);
            fc.setLanguage(fparts[1]);
            fc.setFieldType(fparts[2]);
            fc.setField(fparts[3]);
            s.getFields().add(fc.getID());
            fieldItems.add(fc);
        }
        datasourceItems.put(s.getID(), s);
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(datasourceItems.values());
        retValue.addAll(serviceItems.values());
        retValue.addAll(fieldItems);
        return retValue;
    }

    private static Set<IDaoElement> getOpenSearchDataSource() throws Exception {
        logger.info("getting opensearch datasource");
        return BridgeHelper.getDataSourceOpenSearch();
    }

    private static Set<IDaoElement> getSruConsumerDataSource() throws Exception {
        logger.info("getting sru consumer datasource");
        return BridgeHelper.getDataSourceSruConsumer();
    }

    private static Set<IDaoElement> getWorkflowService() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, WorkflowServiceDao> serviceItems = new HashMap<String, WorkflowServiceDao>();
        for (String scope : scopes) {
            String serviceName = "WorkflowEngineService";
            String serviceClass = "Execution";
            Set insts = BackendConnector.newICollector().discoverRunningInstances(serviceName, serviceClass, scope);
            logger.info("Found " + insts.size() + " workflow services in scope");
            for (RunInstance inst : insts) {
                Map eprs = inst.getProfile().accessPoint.runningInstanceInterfaces;
                if (eprs.size() != 1) continue;
                HashSet<String> instScopes = new HashSet<String>();
                for (String instSc : inst.getScopes()) {
                    instScopes.add(instSc);
                }
                if (serviceItems.containsKey(inst.getId())) {
                    ((WorkflowServiceDao)serviceItems.get(inst.getId())).getScopes().addAll(instScopes);
                    continue;
                }
                WorkflowServiceDao s = new WorkflowServiceDao();
                Map.Entry epr = eprs.entrySet().iterator().next();
                logger.trace("---- WorkflowService uri    : " + ((URI)epr.getValue()).toString());
                logger.trace("---- WorkflowService name   : " + (String)epr.getKey());
                logger.trace("---- WorkflowService string : " + epr.toString());
                s.setEndpoint(((URI)epr.getValue()).toString());
                s.setFunctionality("execution.workflow");
                s.setID(inst.getId());
                s.setHostingNode(inst.getProfile().ghn.ghnId);
                s.getScopes().addAll(new HashSet(instScopes));
                serviceItems.put(s.getID(), s);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(serviceItems.values());
        return retValue;
    }

    private static Set<IDaoElement> getSearchService() {
        return searchSystemServices;
    }

    private static Set<IDaoElement> retrieveSearchService() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, SearchServiceDao> serviceItems = new HashMap<String, SearchServiceDao>();
        for (String scope : scopes) {
            logger.info("Searching for search system services in scope " + scope.toString());
            String serviceName = "SearchSystemService";
            String serviceClass = "Search";
            Set insts = BackendConnector.newICollector().discoverRunningInstancesFilteredByEndopointKey(serviceName, serviceClass, ENDPOINT_KEY, scope);
            logger.info("Found " + insts.size() + " search services in scope");
            for (RunInstance inst : insts) {
                if (inst == null || inst.getProfile().accessPoint.runningInstanceInterfaces == null) continue;
                HashSet<String> instScopes = new HashSet<String>();
                for (String instSc : inst.getScopes()) {
                    instScopes.add(instSc);
                }
                logger.info("Scopes of " + inst.getId() + " : " + instScopes);
                if (serviceItems.containsKey(inst.getId())) {
                    ((SearchServiceDao)serviceItems.get(inst.getId())).getScopes().addAll(instScopes);
                    continue;
                }
                SearchServiceDao s = new SearchServiceDao();
                s.setEndpoint(((URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY)).toString());
                s.setFunctionality("search.orchestrator");
                s.setID(inst.getId());
                s.setHostingNode(inst.getProfile().ghn.ghnId);
                s.getScopes().addAll(new HashSet(instScopes));
                serviceItems.put(s.getID(), s);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(serviceItems.values());
        return retValue;
    }

    private static Set<IDaoElement> getExecutionServer() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, ExecutionServerDao> serverItems = new HashMap<String, ExecutionServerDao>();
        HashMap<String, ExecutionServiceDao> serviceItems = new HashMap<String, ExecutionServiceDao>();
        for (String scope : scopes) {
            logger.info("Searching for execution engine services in scope " + scope.toString());
            String serviceName = "ExecutionEngineService";
            String serviceClass = "Execution";
            Set insts = BackendConnector.newICollector().discoverRunningInstancesFilteredByEndopointKey(serviceName, serviceClass, ENDPOINT_KEY, scope);
            logger.info("Found " + insts.size() + " execution services in scope");
            for (RunInstance inst : insts) {
                try {
                    if (inst == null || inst.getProfile().accessPoint.runningInstanceInterfaces == null) continue;
                    URI epr = (URI)inst.getProfile().accessPoint.runningInstanceInterfaces.get(ENDPOINT_KEY);
                    if (epr == null) {
                        logger.info("running instance : " + inst.getId() + " has no execution engine service epr");
                        continue;
                    }
                    HashSet<String> instScopes = new HashSet<String>();
                    for (String instSc : inst.getScopes()) {
                        instScopes.add(instSc);
                    }
                    logger.info("Scopes of execution engine service with id : " + inst.getId() + " : " + instScopes);
                    if (serviceItems.containsKey(inst.getId())) {
                        ((ExecutionServiceDao)serviceItems.get(inst.getId())).getScopes().addAll(instScopes);
                    } else {
                        ExecutionServiceDao s = new ExecutionServiceDao();
                        s.setEndpoint(epr.toString());
                        s.setFunctionality("execution.execute");
                        s.setID(inst.getId());
                        s.setHostingNode(inst.getProfile().ghn.ghnId);
                        s.getScopes().addAll(new HashSet(instScopes));
                        serviceItems.put(s.getID(), s);
                    }
                    String sd = null;
                    XPathEvaluator xpath = new XPathEvaluator(inst.getProfile().specificData.root);
                    List specificDataList = xpath.evaluate("/");
                    if (specificDataList != null) {
                        Iterator i$ = specificDataList.iterator();
                        while (i$.hasNext()) {
                            String val;
                            sd = val = (String)i$.next();
                        }
                    }
                    if (sd == null || sd.trim().length() == 0) continue;
                    Document doc = XMLUtils.Deserialize((String)sd);
                    List elems = XMLUtils.GetChildElementsWithName((Node)doc.getDocumentElement(), (String)"element");
                    String hostname = null;
                    String port = null;
                    String elemId = null;
                    for (Element el : elems) {
                        elemId = XMLUtils.GetAttribute((Element)el, (String)"id");
                        Element dynElem = XMLUtils.GetChildElementWithName((Node)el, (String)"dynamic");
                        List dynPairs = XMLUtils.GetChildElementsWithName((Node)dynElem, (String)"entry");
                        for (Element pair : dynPairs) {
                            String attrVal;
                            if (!XMLUtils.AttributeExists((Element)pair, (String)"pe2ng.port").booleanValue()) {
                                if (!XMLUtils.AttributeExists((Element)pair, (String)"key").booleanValue()) continue;
                                attrVal = XMLUtils.GetAttribute((Element)pair, (String)"key");
                                if (attrVal != null && attrVal.equals("pe2ng.port")) {
                                    port = XMLUtils.GetChildText((Node)pair);
                                }
                            } else {
                                port = XMLUtils.GetAttribute((Element)pair, (String)"pe2ng.port");
                            }
                            if (!XMLUtils.AttributeExists((Element)pair, (String)"hostname").booleanValue()) {
                                if (!XMLUtils.AttributeExists((Element)pair, (String)"key").booleanValue() || (attrVal = XMLUtils.GetAttribute((Element)pair, (String)"key")) == null || !attrVal.equals("hostname")) continue;
                                hostname = XMLUtils.GetChildText((Node)pair);
                                break;
                            }
                            hostname = XMLUtils.GetAttribute((Element)pair, (String)"hostname");
                            break;
                        }
                        if (port == null || hostname == null) continue;
                        break;
                    }
                    if (port != null) {
                        if (serverItems.containsKey(elemId)) {
                            ((ExecutionServerDao)serverItems.get(elemId)).getScopes().addAll(instScopes);
                        } else {
                            ExecutionServerDao ss = new ExecutionServerDao();
                            ss.setFunctionality("execution.execute");
                            ss.setHostingNode(inst.getProfile().ghn.ghnId);
                            ss.setID(elemId);
                            ss.setHostname(hostname);
                            ss.setPort(port);
                            ss.getScopes().addAll(instScopes);
                            serverItems.put(ss.getID(), ss);
                        }
                    }
                    logger.info("found execution server at : " + hostname + " : " + port);
                }
                catch (Exception e) {
                    logger.warn("Error parsing the running instance : " + inst.getId(), (Throwable)e);
                }
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(serviceItems.values());
        retValue.addAll(serverItems.values());
        logger.info("Found " + serverItems.values().size() + " execution servers");
        return retValue;
    }

    private static Set<IDaoElement> getFunctionality() throws Exception {
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        FunctionalityDao f = new FunctionalityDao();
        f.setName("execution.execute");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("execution.workflow");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.ft");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.fw");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.geo");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.opensearch");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.sruconsumer");
        items.add((IDaoElement)f);
        return items;
    }

    static Set<IDaoElement> getHostingNodes() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, HostingNodeDao> items = new HashMap<String, HostingNodeDao>();
        for (String scope : scopes) {
            logger.info("Searching for hosting nodes in scope " + scope.toString());
            List insts = BackendConnector.newICollector().discoverHostingNodes(scope);
            logger.info("Found " + insts.size() + " nodes in scope");
            for (HostNode node : insts) {
                HashSet<String> nodeScopes = new HashSet<String>();
                for (String instSc : node.getScopes()) {
                    nodeScopes.add(instSc);
                }
                if (items.containsKey(node.getId())) {
                    ((HostingNodeDao)items.get(node.getId())).getScopes().addAll(nodeScopes);
                    continue;
                }
                HostingNodeDao item = new HostingNodeDao();
                item.setID(node.getId());
                item.setScopes(new HashSet(nodeScopes));
                try {
                    item.getPairKeys().add("hn.infrastructure");
                    item.getPairValues().add("hn.infrastructure##delim##" + (String)node.evaluate("/Profile/Infrastructure/text()").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.country");
                    item.getPairValues().add("hn.country##delim##" + (String)node.evaluate("/Profile/Site/Country/text()").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.domain");
                    item.getPairValues().add("hn.domain##delim##" + (String)node.evaluate("/Profile/Site/Domain/text()").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.latitude");
                    item.getPairValues().add("hn.latitude##delim##" + (String)node.evaluate("/Profile/Site/Latitude/text()").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.longitude");
                    item.getPairValues().add("hn.longitude##delim##" + (String)node.evaluate("/Profile/Site/Longitude/text()").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.location");
                    item.getPairValues().add("hn.location##delim##" + (String)node.evaluate("/Profile/Site/Location/text()").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.architecture.platform");
                    item.getPairValues().add("hn.architecture.platform##delim##" + (String)node.evaluate("/Profile/GHNDescription/Architecture/@PlatformType").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.architecture.smp");
                    item.getPairValues().add("hn.architecture.smp##delim##" + (String)node.evaluate("/Profile/GHNDescription/Architecture/@SMPSize").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.architecture.smt");
                    item.getPairValues().add("hn.architecture.smt##delim##" + (String)node.evaluate("/Profile/GHNDescription/Architecture/@SMTSize").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.benchmark.sf00");
                    item.getPairValues().add("hn.benchmark.sf00##delim##" + (String)node.evaluate("/Profile/GHNDescription/Benchmark/@SF00").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.benchmark.si00");
                    item.getPairValues().add("hn.benchmark.si00##delim##" + (String)node.evaluate("/Profile/GHNDescription/Benchmark/@SI00").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_day");
                    item.getPairValues().add("hn.load.one_day##delim##" + (String)node.evaluate("/Profile/GHNDescription/HistoricalLoad/@Last1Day").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_hour");
                    item.getPairValues().add("hn.load.one_hour##delim##" + (String)node.evaluate("/Profile/GHNDescription/HistoricalLoad/@Last1H").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_week");
                    item.getPairValues().add("hn.load.one_week##delim##" + (String)node.evaluate("/Profile/GHNDescription/HistoricalLoad/@Last1Week").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_min");
                    item.getPairValues().add("hn.load.one_min##delim##" + (String)node.evaluate("/Profile/GHNDescription/Load/@Last1Min").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.five_min");
                    item.getPairValues().add("hn.load.five_min##delim##" + (String)node.evaluate("/Profile/GHNDescription/Load/@Last5Min").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.fifteen_min");
                    item.getPairValues().add("hn.load.fifteen_min##delim##" + (String)node.evaluate("/Profile/GHNDescription/Load/@Last15Min").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.disk.size");
                    item.getPairValues().add("hn.disk.size##delim##" + (String)node.evaluate("/Profile/GHNDescription/LocalAvailableSpace/text()").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.physical.available");
                    item.getPairValues().add("hn.memory.physical.available##delim##" + (String)node.evaluate("/Profile/GHNDescription/MainMemory/@RAMAvailable").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.physical.size");
                    item.getPairValues().add("hn.memory.physical.size##delim##" + (String)node.evaluate("/Profile/GHNDescription/MainMemory/@RAMSize").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.virtual.size");
                    item.getPairValues().add("hn.memory.virtual.size##delim##" + (String)node.evaluate("/Profile/GHNDescription/MainMemory/@VirtualSize").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.virtual.available");
                    item.getPairValues().add("hn.memory.virtual.available##delim##" + (String)node.evaluate("/Profile/GHNDescription/MainMemory/@VirtualAvailable").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hostname");
                    item.getPairValues().add("hostname##delim##" + ((String)node.evaluate("/Profile/GHNDescription/Name/text()").get(0)).substring(0, ((String)node.evaluate("/Profile/GHNDescription/Name/text()").get(0)).lastIndexOf(58)));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.port");
                    item.getPairValues().add("hn.port##delim##" + ((String)node.evaluate("/Profile/GHNDescription/Name/text()").get(0)).substring(((String)node.evaluate("/Profile/GHNDescription/Name/text()").get(0)).lastIndexOf(58) + 1));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.hostname");
                    item.getPairValues().add("hn.hostname##delim##" + (String)node.evaluate("/Profile/GHNDescription/Name/text()").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                int count = 0;
                try {
                    for (int i = 1; i <= Integer.parseInt((String)node.evaluate("count(/Profile/GHNDescription/NetworkAdapter)").get(0)); ++i) {
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".inbound.ip");
                            item.getPairValues().add("hn.network.adapter." + count + ".inbound.ip" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/NetworkAdapter[" + i + "]/@InboundIP").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".ip.address");
                            item.getPairValues().add("hn.network.adapter." + count + ".ip.address" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/NetworkAdapter[" + i + "]/@IPAddress").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".mtu");
                            item.getPairValues().add("hn.network.adapter." + count + ".mtu" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/NetworkAdapter[" + i + "]/@MTU").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".name");
                            item.getPairValues().add("hn.network.adapter." + count + ".name" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/NetworkAdapter[" + i + "]/@Name").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".outbound.ip");
                            item.getPairValues().add("hn.network.adapter." + count + ".outbound.ip" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/NetworkAdapter[" + i + "]/@OutboundIP").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ++count;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.os.name");
                    item.getPairValues().add("hn.os.name##delim##" + (String)node.evaluate("/Profile/GHNDescription/OperatingSystem/@Name").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.os.release");
                    item.getPairValues().add("hn.os.release##delim##" + (String)node.evaluate("/Profile/GHNDescription/OperatingSystem/@Release").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.os.version");
                    item.getPairValues().add("hn.os.version##delim##" + (String)node.evaluate("/Profile/GHNDescription/OperatingSystem/@Version").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                count = 0;
                try {
                    long totalBogoMips = 0L;
                    long totalClockSpeed = 0L;
                    for (int i = 1; i <= Integer.parseInt((String)node.evaluate("count(/Profile/GHNDescription/Processor)").get(0)); ++i) {
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".bogomips");
                            item.getPairValues().add("hn.processor." + count + ".bogomips" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@Bogomips").get(0));
                            totalBogoMips = (long)((double)totalBogoMips + Double.valueOf((String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@Bogomips").get(0)));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l1");
                            item.getPairValues().add("hn.processor." + count + ".cache.l1" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@CacheL1").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l1d");
                            item.getPairValues().add("hn.processor." + count + ".cache.l1d" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@CacheL1D").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l1i");
                            item.getPairValues().add("hn.processor." + count + ".cache.l1i" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@CacheL1I").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l2");
                            item.getPairValues().add("hn.processor." + count + ".cache.l2" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@CacheL2").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".clockspeed");
                            item.getPairValues().add("hn.processor." + count + ".clockspeed" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@ClockSpeedMhz").get(0));
                            totalClockSpeed = (long)((double)totalClockSpeed + Double.valueOf((String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@ClockSpeedMhz").get(0)));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".family");
                            item.getPairValues().add("hn.processor." + count + ".clockspeed" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@Family").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".model");
                            item.getPairValues().add("hn.processor." + count + ".model" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@Model").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".model_name");
                            item.getPairValues().add("hn.processor." + count + ".model_name" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@ModelName").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".vendor");
                            item.getPairValues().add("hn.processor." + count + ".vendor" + "##delim##" + (String)node.evaluate("/Profile/GHNDescription/Processor[" + i + "]/@Vendor").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ++count;
                    }
                    item.getPairKeys().add("hn.processor.count");
                    item.getPairValues().add("hn.processor.count##delim##" + Integer.toString(count));
                    item.getPairKeys().add("hn.processor.total_bogomips");
                    item.getPairValues().add("hn.processor.total_bogomips##delim##" + Long.toString(totalBogoMips));
                    item.getPairKeys().add("hn.processor.total_clockspeed");
                    item.getPairValues().add("hn.processor.total_clockspeed##delim##" + Long.toString(totalClockSpeed));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.status");
                    item.getPairValues().add("hn.status##delim##" + (String)node.evaluate("/Profile/GHNDescription/Status/text()").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                count = 0;
                try {
                    item.getPairKeys().add("hn.uptime");
                    item.getPairValues().add("hn.uptime##delim##" + (String)node.evaluate("/Profile/GHNDescription/Uptime/text()").get(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    for (int i = 1; i <= Integer.parseInt((String)node.evaluate("count(/Profile/GHNDescription/NetworkAdapter)").get(0)); ++i) {
                        String identifier = (String)node.evaluate("/Profile/DeployedPackages/Package[" + i + "]/ServiceClass/text()").get(0) + "." + (String)node.evaluate("/Profile/DeployedPackages/Package[" + i + "]/ServiceName/text()").get(0) + "." + (String)node.evaluate("/Profile/DeployedPackages/Package[" + i + "]/PackageName/text()").get(0);
                        try {
                            item.getPairKeys().add("software." + identifier + ".deployed");
                            item.getPairValues().add("software." + identifier + ".deployed" + "##delim##" + "true");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("software." + identifier + ".service_version");
                            item.getPairValues().add("software." + identifier + ".service_version" + "##delim##" + (String)node.evaluate("/Profile/DeployedPackages/Package[" + i + "]/ServiceVersion/text()").get(0));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("software." + identifier + ".package_version");
                            item.getPairValues().add("software." + identifier + ".package_version" + "##delim##" + (String)node.evaluate("/Profile/DeployedPackages/Package[" + i + "]/PackageVersion/text()").get(0));
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    for (int i = 1; i <= Integer.parseInt((String)node.evaluate("count(/Profile/GHNDescription/RunTimeEnv/Variable)").get(0)); ++i) {
                        String key = (String)node.evaluate("/Profile/GHNDescription/RunTimeEnv/Variable[" + i + "]/Key/text()").get(0);
                        String value = (String)node.evaluate("/Profile/GHNDescription/RunTimeEnv/Variable[" + i + "]/Value/text()").get(0);
                        try {
                            item.getPairKeys().add(key);
                            item.getPairValues().add(key + "##delim##" + value);
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                items.put(item.getID(), item);
            }
        }
        logger.info("number of hosting nodes found : " + items.values().size());
        return new HashSet<IDaoElement>(items.values());
    }

    private static Set<IDaoElement> getAllCollections() throws Exception {
        HashSet<IDaoElement> dataCollections = new HashSet<IDaoElement>();
        dataCollections.addAll(BridgeHelper.getDataCollections());
        dataCollections.addAll(BridgeHelper.getTreeCollections());
        return dataCollections;
    }

    private static Set<IDaoElement> getDataCollections() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, DataCollectionDao> hcols = new HashMap<String, DataCollectionDao>();
        for (String scope : scopes) {
            List resources = BackendConnector.newICollector().getGenericResourcesByType("DataSource", scope);
            for (Resource resource : resources) {
                String id = resource.getResourceID();
                logger.info("Found collection with id : " + id);
                if (hcols.containsKey(id)) {
                    ((DataCollectionDao)hcols.get(id)).getScopes().add(scope.toString());
                    continue;
                }
                try {
                    String name = resource.getName();
                    logger.info("collection with id : " + id + " has name : " + name);
                    String description = resource.getDescription();
                    DataSourceDescription datasourceDescription = DataSourceDescription.getCollection(resource);
                    Boolean isUserCollection = datasourceDescription.isUser();
                    Calendar creationTime = datasourceDescription.getCreationTime();
                    String type = datasourceDescription.getType();
                    if (type != null && (type.equalsIgnoreCase("opensearch") || type.equalsIgnoreCase("sru"))) {
                        logger.info("collection with id : " + id + " name : " + name + " is of type : " + type);
                    } else {
                        logger.info("collection with id : " + id + " name : " + name + " is not of type : opensearch");
                        if (type == null) {
                            logger.info("no type given skipping");
                            continue;
                        }
                    }
                    if (!isUserCollection.booleanValue()) continue;
                    DataCollectionDao d = new DataCollectionDao();
                    d.setID(id);
                    d.setDescription(description);
                    d.setCollectionType(type);
                    if (creationTime != null) {
                        d.setCreationTime(Long.toString(creationTime.getTimeInMillis()));
                    }
                    d.setName(name);
                    d.getScopes().add(scope.toString());
                    hcols.put(d.getID(), d);
                    if (d.getDescription() == null || d.getDescription().trim().length() == 0) {
                        d.setDescription(null);
                    }
                    if (d.getName().trim().length() == 0) {
                        d.setName(null);
                    }
                    HashSet<String> toDel = new HashSet<String>();
                    for (String s : d.getScopes()) {
                        if (s.trim().length() != 0) continue;
                        toDel.add(s);
                    }
                    d.getScopes().removeAll(toDel);
                    logger.info("collection with id : " + id + " has name : " + name + " type : " + type);
                }
                catch (Exception e) {
                    logger.warn("problem getting the resource of : " + resource.getResourceID(), (Throwable)e);
                }
            }
        }
        return new HashSet<IDaoElement>(hcols.values());
    }

    public static Set<IDaoElement> getTreeCollections() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, DataCollectionDao> hcols = new HashMap<String, DataCollectionDao>();
        logger.info(" will search for TREE COLLECTIONS in the following scopes");
        for (String scope : scopes) {
            logger.info("### " + scope.toString());
        }
        for (String scope : scopes) {
            logger.info(" searching for TREE COLLECTIONS in scope : " + scope);
            String serviceName = "tree-manager-service";
            String serviceClass = "DataAccess";
            List resources = BackendConnector.newICollector().discoverServiceInstances(serviceName, serviceClass, scope);
            logger.info(" found " + resources.size() + " TREE COLLECTIONS in scope : " + scope);
            for (SerInstance r : resources) {
                try {
                    String endpoint = r.getEndpoint().getPath();
                    if (!endpoint.endsWith(TREADER_NAME)) continue;
                    logger.info("Parsing tree...");
                    XPathEvaluator xpath = new XPathEvaluator(r.getProperties().getCustomProperties());
                    String name = (String)xpath.evaluate("//*[local-name()='Name']/text()").get(0);
                    logger.info("\t name : " + name);
                    xpath = new XPathEvaluator(r.getProperties().getCustomProperties());
                    String id = (String)xpath.evaluate("//*[local-name()='SourceId']/text()").get(0);
                    logger.info("\t id : " + id);
                    logger.info("Parsing tree...OK");
                    String description = null;
                    String creationTime = null;
                    logger.info("Parsed elements from xml : [id = " + id + ", name = " + name + " ] ");
                    if (hcols.containsKey(id)) {
                        ((DataCollectionDao)hcols.get(id)).getScopes().add(scope.toString());
                        logger.info("updated collection of : \n" + ((DataCollectionDao)hcols.get(id)).deepToString());
                        logger.info("+ added collection : " + name + " " + description + " scope : " + scope + " all scopes : " + ((DataCollectionDao)hcols.get(id)).getScopes());
                        continue;
                    }
                    DataCollectionDao d = new DataCollectionDao();
                    d.setID(id);
                    d.setName(name);
                    d.setDescription(description);
                    d.setCreationTime(creationTime);
                    if (d.getDescription() == null || d.getDescription().trim().length() == 0) {
                        d.setDescription(null);
                    }
                    if (d.getName().trim().length() == 0) {
                        d.setName(null);
                    }
                    if (creationTime == null || creationTime.trim().length() == 0) {
                        d.setCreationTime(null);
                    }
                    d.getScopes().add(scope.toString());
                    hcols.put(d.getID(), d);
                    HashSet<String> toDel = new HashSet<String>();
                    for (String s : d.getScopes()) {
                        if (s.trim().length() != 0) continue;
                        toDel.add(s);
                    }
                    d.getScopes().removeAll(toDel);
                    logger.info("added collection : \n" + ((DataCollectionDao)hcols.get(id)).deepToString());
                    logger.info("+ added collection : " + name + " " + description + " scope : " + scope + " all scopes : " + d.getScopes());
                }
                catch (Exception e) {
                    logger.warn("Error while retrieving-parsing the tree manager collection");
                }
            }
        }
        return new HashSet<IDaoElement>(hcols.values());
    }

    private static Set<IDaoElement> getFields() throws Exception {
        logger.info("Searching for fields");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String fieldsResource = FieldModel.getMainResource();
        logger.info("fieldsResource : " + fieldsResource);
        if (fieldsResource == null) {
            return Sets.newHashSet();
        }
        if (fieldsResource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)fieldsResource);
        boolean flatModel = false;
        List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"field");
        if (xmlObjs.size() != 0) {
            flatModel = true;
        } else {
            xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
        }
        if (flatModel) {
            for (Element elem : xmlObjs) {
                FieldDao f = new FieldDao();
                f.fromXML(elem);
                items.add((IDaoElement)f);
            }
        } else {
            Set<String> fieldIds = FieldModel.getFieldIds();
            for (String fieldId : fieldIds) {
                String fieldResource = FieldModel.getFieldResource(fieldId);
                logger.trace("Field read from resource");
                if (fieldResource == null) continue;
                fieldsDOM = XMLUtils.Deserialize((String)fieldResource);
                xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fieldInfo"), (String)"field");
                logger.trace("field has elements : " + xmlObjs.size());
                for (Element elem : xmlObjs) {
                    FieldDao f = new FieldDao();
                    f.fromXML(elem);
                    items.add((IDaoElement)f);
                }
            }
        }
        logger.info("Found " + items.size() + " fields");
        return items;
    }

    private static Set<IDaoElement> getSearchables() throws Exception {
        logger.info("Searching for searchables");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String fieldsResource = FieldModel.getMainResource();
        if (fieldsResource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)fieldsResource);
        boolean flatModel = false;
        List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"searchables"), (String)"searchable");
        if (xmlObjs.size() != 0) {
            flatModel = true;
        } else {
            xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
        }
        if (flatModel) {
            for (Element elem : xmlObjs) {
                SearchableDao f = new SearchableDao();
                f.fromXML(elem);
                items.add((IDaoElement)f);
            }
        } else {
            Set<String> fieldIds = FieldModel.getFieldIds();
            for (String fieldId : fieldIds) {
                String fieldResource = FieldModel.getFieldResource(fieldId);
                if (fieldResource == null) continue;
                fieldsDOM = XMLUtils.Deserialize((String)fieldResource);
                xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"searchables"), (String)"searchable");
                for (Element elem : xmlObjs) {
                    SearchableDao f = new SearchableDao();
                    f.fromXML(elem);
                    items.add((IDaoElement)f);
                }
            }
        }
        logger.info("Found " + items.size() + " searchables");
        return items;
    }

    private static Set<IDaoElement> getPresentables() throws Exception {
        logger.info("Searching for presentables");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String fieldsResource = FieldModel.getMainResource();
        if (fieldsResource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)fieldsResource);
        boolean flatModel = false;
        List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"presentables"), (String)"presentable");
        if (xmlObjs.size() != 0) {
            flatModel = true;
        } else {
            xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
        }
        if (flatModel) {
            for (Element elem : xmlObjs) {
                PresentableDao f = new PresentableDao();
                f.fromXML(elem);
                items.add((IDaoElement)f);
            }
        } else {
            Set<String> fieldIds = FieldModel.getFieldIds();
            for (String fieldId : fieldIds) {
                String fieldResource = FieldModel.getFieldResource(fieldId);
                if (fieldResource == null) continue;
                fieldsDOM = XMLUtils.Deserialize((String)fieldResource);
                xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"presentables"), (String)"presentable");
                for (Element elem : xmlObjs) {
                    PresentableDao f = new PresentableDao();
                    f.fromXML(elem);
                    items.add((IDaoElement)f);
                }
            }
        }
        logger.info("Found " + items.size() + " presentables");
        return items;
    }

    private static Set<IDaoElement> getElementMetadata() throws Exception {
        logger.info("Searching for element metadata");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String resource = null;
        String fieldsResource = null;
        String metadataResource = FieldModel.getMetadataResource();
        resource = metadataResource == null ? (fieldsResource = FieldModel.getMainResource()) : metadataResource;
        if (resource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)resource);
        List xmlObjs = null;
        Element metadataElement = XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"metadata");
        if (metadataElement == null) {
            return items;
        }
        xmlObjs = XMLUtils.GetChildElementsWithName((Node)metadataElement, (String)"elementMetadata");
        for (Element elem : xmlObjs) {
            ElementMetadataDao s = new ElementMetadataDao();
            s.fromXML(elem);
            items.add((IDaoElement)s);
        }
        logger.info("Found " + items.size() + " element metadata");
        return items;
    }

    private static Set<IDaoElement> getStaticConfiguration() throws Exception {
        logger.info("Searching for static configuration");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document staticConfigDOM = null;
        String staticConfigResource = FieldModel.getStaticConfigResource();
        logger.info("static configuration XML retrieved from FieldModel : " + staticConfigResource);
        if (staticConfigResource == null) {
            return items;
        }
        staticConfigDOM = XMLUtils.Deserialize((String)staticConfigResource);
        StaticConfigurationDao item = new StaticConfigurationDao();
        item.fromXML(staticConfigDOM.getDocumentElement());
        items.add((IDaoElement)item);
        logger.info("Found " + items.size() + " static configuration");
        return items;
    }

    public static List<Resource> getPublishedFieldResources() throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName);
    }

    public static List<Resource> getPublishedMetadataResources() throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + "Metadata");
    }

    public static List<Resource> getPublishedStaticConfigResources() throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + "StaticConfig");
    }

    public static List<Resource> getPublishedFieldResourcesForField(String fieldId) throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + fieldId);
    }

    public static List<Resource> getPublishedFieldResources(String resourceName) throws Exception {
        logger.info("Searching for publised field resources in scopes : " + scopes);
        Set<String> scopes = BridgeHelper.getVOScopes(BridgeHelper.scopes);
        logger.info("VO scopes of : " + BridgeHelper.scopes + " are : " + scopes);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String scope : scopes) {
            resources.addAll(BackendConnector.newICollector().getGenericResourcesByTypeAndName(GCubeRepositoryProvider.RRModelGenericResourceName, resourceName, scope));
        }
        return resources;
    }

    public static Set<String> getVOScopes(Collection<String> vreScopes) {
        HashSet<String> voScopes = new HashSet<String>();
        if (vreScopes != null) {
            for (String scope : vreScopes) {
                String voScope = scopeHelper.getVOScope(scope);
                if (voScope == null) continue;
                voScopes.add(voScope);
            }
        }
        return voScopes;
    }

    public static boolean checkIfExists(String resourceName, String resourceType, Set<String> scopes) {
        for (String scope : scopes) {
            List resources = BackendConnector.newICollector().getGenericResourcesByName(resourceName, scope);
            boolean found = false;
            for (Resource resource : resources) {
                if (!resource.getType().equalsIgnoreCase(resourceType) || !resource.getScopes().containsAll(scopes)) continue;
                found = true;
                break;
            }
            if (found) continue;
            logger.info("resource with name : " + resourceName + " does not exist in exactly the following scopes : " + scopes);
            return false;
        }
        return true;
    }

    public static Resource getResourceByNameAndType(String resourceName, String resourceType, Set<String> scopes) {
        for (String scope : scopes) {
            List resources = BackendConnector.newICollector().getGenericResourcesByName(resourceName, scope);
            for (Resource resource : resources) {
                if (!resource.getType().equalsIgnoreCase(resourceType) || !resource.getScopes().containsAll(scopes)) continue;
                return resource;
            }
        }
        return null;
    }

    public static Resource getResourceByID(String resourceID, Set<String> scopes) {
        for (String scope : scopes) {
            List resources = BackendConnector.newICollector().getGenericResourcesByID(resourceID, scope);
            for (Resource resource : resources) {
                if (!resource.getScopes().containsAll(scopes)) continue;
                return resource;
            }
        }
        return null;
    }

    public static void publishFieldResource(Resource resource, boolean isNew, Set<String> nonUpdateVOScopes) throws Exception {
        logger.info("publishing information on IS");
        logger.info("nonUpdateVOScopes : " + nonUpdateVOScopes);
        for (String gcubeScope : BridgeHelper.getFieldModelScopes()) {
            logger.info("will check scope  : " + gcubeScope.toString());
        }
        Set<String> voScopes = BridgeHelper.getVOScopes(BridgeHelper.getFieldModelScopes());
        for (String gcubeScope : voScopes) {
            logger.info("VOScope scope : " + gcubeScope);
            if (nonUpdateVOScopes.contains(gcubeScope)) {
                logger.info("VOScope of scope : " + gcubeScope + " is in nonUpdateVOScopes");
                continue;
            }
            logger.info("trying to use scope : " + gcubeScope.toString());
            if (isNew) {
                logger.info("creating resource with id : " + resource.getResourceID() + " . is new : " + isNew);
                logger.info("creating resource Body : " + resource.getBodyAsString());
                BridgeHelper.updateOrPublish(resource, gcubeScope);
                continue;
            }
            logger.info("updating resource with id : " + resource.getResourceID() + " is new : " + isNew);
            if (resource.getScopes().contains(gcubeScope)) {
                logger.info("scope in resource. updating with id : " + resource.getResourceID() + " is new : " + isNew);
                BridgeHelper.updateOrPublish(resource, gcubeScope);
                continue;
            }
            logger.info("scope not in resource. creating resource with id : " + resource.getResourceID() + ". is new : " + isNew);
            BridgeHelper.updateOrPublish(resource, gcubeScope);
        }
        logger.info("done publishing information on IS");
    }

    public static void updateOrPublish(Resource resource, String scope) {
        ResourcePublisher<GeneralResource> publisher = BackendConnector.newPublisher();
        try {
            System.out.println("resource updating...");
            publisher.updateResource((GeneralResource)resource, resource.getType(), resource.getName(), scope, false, true);
            System.out.println("resource updating...OK");
        }
        catch (Exception e) {
            System.out.println("resource update failed. trying to publish");
            try {
                publisher.publishResource((GeneralResource)resource, resource.getType(), resource.getName(), scope, false, true);
                System.out.println("resource publish OK");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                System.out.println("resource publish failed");
            }
        }
    }

    public static void deleteFieldResource(Resource resource, Set<String> nonUpdateVOScopes) throws Exception {
        logger.info("Deleting information from IS");
        for (String gcubeScope : BridgeHelper.getFieldModelScopes()) {
            logger.info("trying to use scope : " + gcubeScope.toString());
            String VOScope1 = scopeHelper.getVOScope(gcubeScope);
            if (nonUpdateVOScopes.contains(gcubeScope) || nonUpdateVOScopes.contains(VOScope1)) {
                logger.info("VOScope of scope : " + gcubeScope + " is in nonUpdateVOScopes");
                continue;
            }
            ResourcePublisher<GeneralResource> publisher = BackendConnector.newPublisher();
            publisher.deleteResource(resource.getResourceID(), VOScope1);
        }
        logger.info("done deleting information from IS");
    }

    public static String buildFieldDirectorySerialization(Set<IDaoElement> fields) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        buf.append("<fields>\n");
        for (IDaoElement elem : fields) {
            buf.append("<fieldId>");
            buf.append(((FieldDao)elem).getID());
            buf.append("</fieldId>");
        }
        buf.append("</fields>\n");
        buf.append("</root>\n");
        return buf.toString();
    }

    public static String buildFieldSerialization(IDaoElement field, Set<IDaoElement> searchables, Set<IDaoElement> presentables, Set<String> deletedSearchables, Set<String> deletedPresentables) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        buf.append("<fieldInfo>\n");
        buf.append(field.toXML());
        buf.append("</fieldInfo>\n");
        buf.append("<searchables>\n");
        for (String searchableId : ((FieldDao)field).getSearchables()) {
            for (IDaoElement elem : searchables) {
                if (!elem.getID().equals(searchableId) || deletedSearchables.contains(searchableId)) continue;
                buf.append(elem.toXML());
            }
        }
        buf.append("</searchables>\n");
        buf.append("<presentables>\n");
        for (String presentableId : ((FieldDao)field).getPresentables()) {
            for (IDaoElement elem : presentables) {
                if (!elem.getID().equals(presentableId) || deletedPresentables.contains(presentableId)) continue;
                buf.append(elem.toXML());
            }
        }
        buf.append("</presentables>\n");
        buf.append("</root>\n");
        return buf.toString();
    }

    public static Set<IDaoElement> updateFieldList(Set<IDaoElement> fields, Set<IDaoElement> searchables, Set<IDaoElement> presentables, List<String> emptyScopedSearchables, List<String> emptyScoperdPresentables) throws ResourceRegistryException {
        HashSet<IDaoElement> updatedFields = new HashSet<IDaoElement>();
        for (IDaoElement field : fields) {
            if (!BridgeHelper.shouldUpdateField(field, searchables, presentables, emptyScopedSearchables, emptyScoperdPresentables)) continue;
            updatedFields.add(field);
        }
        return updatedFields;
    }

    public static boolean shouldUpdateField(IDaoElement field, Set<IDaoElement> searchables, Set<IDaoElement> presentables, List<String> emptyScopedSearchables, List<String> emptyScoperdPresentables) throws ResourceRegistryException {
        for (String searchableId : ((FieldDao)field).getSearchables()) {
            for (IDaoElement elem : searchables) {
                if (!elem.getID().equals(searchableId) || emptyScopedSearchables.contains(searchableId)) continue;
                return true;
            }
        }
        for (String presentableId : ((FieldDao)field).getPresentables()) {
            for (IDaoElement elem : presentables) {
                if (!elem.getID().equals(presentableId) || emptyScoperdPresentables.contains(presentableId)) continue;
                return true;
            }
        }
        return false;
    }

    public static String updateFieldSerialization(String originalSerialization, IDaoElement field, Set<IDaoElement> searchables, Set<IDaoElement> presentables, boolean updateFields, boolean updateSearchables, boolean updatePresentables, Set<String> deletedSearchables, Set<String> deletedPresentables) throws Exception {
        Document original = null;
        try {
            original = XMLUtils.Deserialize((String)originalSerialization);
        }
        catch (Exception e) {
            logger.error("error in deserializing : " + originalSerialization);
            throw e;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        if (updateFields) {
            if (updateSearchables && updatePresentables) {
                buf.append("<fieldInfo>\n");
                buf.append(field.toXML());
                buf.append("</fieldInfo>\n");
            } else {
                Element originalField = (Element)XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"fieldInfo"), (String)"field").get(0);
                buf.append("<fieldInfo>\n");
                FieldDao updatedDao = new FieldDao();
                Document dbField = XMLUtils.Deserialize((String)field.toXML());
                updatedDao.setID(((FieldDao)field).getID());
                updatedDao.setName(((FieldDao)field).getName());
                updatedDao.setDescription(((FieldDao)field).getDescription());
                HashSet<String> updatedSearchables = new HashSet<String>();
                if (updateSearchables) {
                    List dbSearchables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)dbField.getDocumentElement(), (String)"searchables"), (String)"searchable");
                    for (Element dbSearchable : dbSearchables) {
                        updatedSearchables.add(dbSearchable.getFirstChild().getNodeValue());
                    }
                } else {
                    List originalSearchables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)originalField, (String)"searchables"), (String)"searchable");
                    for (Element originalSearchable : originalSearchables) {
                        updatedSearchables.add(originalSearchable.getFirstChild().getNodeValue());
                    }
                }
                HashSet<String> updatedPresentables = new HashSet<String>();
                if (updatePresentables) {
                    List dbPresentables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)dbField.getDocumentElement(), (String)"presentables"), (String)"presentable");
                    for (Element dbPresentable : dbPresentables) {
                        updatedPresentables.add(dbPresentable.getFirstChild().getNodeValue());
                    }
                } else {
                    List originalPresentables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)originalField, (String)"presentables"), (String)"presentable");
                    for (Element originalPresentable : originalPresentables) {
                        updatedPresentables.add(originalPresentable.getFirstChild().getNodeValue());
                    }
                }
                updatedDao.setSearchables(updatedSearchables);
                updatedDao.setPresentables(updatedPresentables);
                buf.append(updatedDao.toXML());
                buf.append("</fieldInfo>\n");
            }
        } else {
            Element originalFields = XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"fieldInfo");
            buf.append(XMLUtils.Serialize((Node)originalFields, (boolean)true));
        }
        if (updateSearchables) {
            buf.append("<searchables>\n");
            for (String searchableId : ((FieldDao)field).getSearchables()) {
                for (IDaoElement elem : searchables) {
                    if (!elem.getID().equals(searchableId) || deletedSearchables.contains(searchableId)) continue;
                    buf.append(elem.toXML());
                }
            }
            buf.append("</searchables>\n");
        } else {
            Element originalSearchables = XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"searchables");
            buf.append(XMLUtils.Serialize((Node)originalSearchables, (boolean)true));
        }
        if (updatePresentables) {
            buf.append("<presentables>\n");
            for (String presentableId : ((FieldDao)field).getPresentables()) {
                for (IDaoElement elem : presentables) {
                    if (!elem.getID().equals(presentableId) || deletedPresentables.contains(presentableId)) continue;
                    buf.append(elem.toXML());
                }
            }
            buf.append("</presentables>\n");
        } else {
            Element originalPresentables = XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"presentables");
            buf.append(XMLUtils.Serialize((Node)originalPresentables, (boolean)true));
        }
        buf.append("</root>\n");
        return buf.toString();
    }

    public static String buildElementMetadataSerialization(Set<IDaoElement> metadata) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        buf.append("<metadata>\n");
        for (IDaoElement elem : metadata) {
            buf.append(elem.toXML());
        }
        buf.append("</metadata>\n");
        buf.append("</root>\n");
        return buf.toString();
    }

    public static String buildStaticConfigSerialization(IDaoElement staticConfig) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append(staticConfig.toXML());
        return buf.toString();
    }

    public static void prefetchInMemoryItems(Set<Class<?>> itemTypes) throws ResourceRegistryException {
        InMemoryStore.clear();
        HashMap<String, ElementMetadataDao> metadata = new HashMap<String, ElementMetadataDao>();
        Set metadataSet = null;
        try {
            metadataSet = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, ElementMetadataDao.class);
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not retrieve element metadata", (Throwable)e);
        }
        for (IDaoElement m : metadataSet) {
            metadata.put(m.getID(), (ElementMetadataDao)m);
        }
        boolean baseDatasource = false;
        for (Class<?> itemType : itemTypes) {
            if (!itemType.getName().equals(DataSource.class.getName())) continue;
            baseDatasource = true;
            break;
        }
        boolean baseDatasourceService = false;
        for (Class<?> itemType : itemTypes) {
            if (!itemType.getName().equals(DataSourceService.class.getName())) continue;
            baseDatasourceService = true;
            break;
        }
        for (Class<?> itemType : itemTypes) {
            List ds;
            Searchable loaded;
            Set items;
            logger.info("Prefetching element " + itemType.getName());
            if (itemType.getName().equals(DataCollection.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(DataCollection.getAllCollections((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(DataLanguage.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(DataLanguage.getLanguages()));
                continue;
            }
            if (itemType.getName().equals(Functionality.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(Functionality.getAllFunctionalities((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(HostingNode.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(HostingNode.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(Field.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(Field.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(Searchable.class.getName())) {
                items = null;
                try {
                    items = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, SearchableDao.class);
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Could not prefetch searchables", (Throwable)e);
                }
                for (IDaoElement item : items) {
                    loaded = new Searchable();
                    loaded.setID(((SearchableDao)item).getID());
                    loaded.load(false);
                    if (metadata.containsKey(loaded.getField()) && ((ElementMetadataDao)metadata.get(loaded.getField())).getType().equals(ElementMetadata.Type.DeletedField.toString())) continue;
                    if (metadata.get(loaded.getField()) != null) {
                        logger.debug("loaded searchable for field : " + loaded.getField() + " id : " + item.getID() + " type " + ((ElementMetadataDao)metadata.get(loaded.getField())).getType());
                    } else {
                        logger.debug("loaded searchable for field : " + loaded.getField() + " id : " + item.getID() + " is not in metadata");
                    }
                    InMemoryStore.setItem(Searchable.class, (IRRElement)loaded);
                }
                continue;
            }
            if (itemType.getName().equals(Presentable.class.getName())) {
                items = null;
                try {
                    items = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, PresentableDao.class);
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Could not prefetch presentables", (Throwable)e);
                }
                for (IDaoElement item : items) {
                    loaded = new Presentable();
                    loaded.setID(((PresentableDao)item).getID());
                    loaded.load(false);
                    if (metadata.containsKey(loaded.getField()) && ((ElementMetadataDao)metadata.get(loaded.getField())).getType().equals(ElementMetadata.Type.DeletedField.toString())) continue;
                    if (metadata.get(loaded.getField()) != null) {
                        logger.debug("loaded presentable for field : " + loaded.getField() + " id : " + item.getID() + " type " + ((ElementMetadataDao)metadata.get(loaded.getField())).getType());
                    } else {
                        logger.debug("loaded presentable for field : " + loaded.getField() + " id : " + item.getID() + " is not in metadata");
                    }
                    InMemoryStore.setItem(Presentable.class, (IRRElement)loaded);
                }
                continue;
            }
            if (itemType.getName().equals(DataSource.class.getName())) {
                ds = DataSource.getAll((boolean)false);
                for (DataSource d : ds) {
                    InMemoryStore.setItem(d.getClass(), (IRRElement)d);
                }
                continue;
            }
            if (itemType.getName().equals(DataSourceService.class.getName())) {
                ds = DataSourceService.getAll((boolean)false);
                for (DataSource d : ds) {
                    InMemoryStore.setItem(d.getClass(), (IRRElement)d);
                }
                continue;
            }
            if (itemType.getName().equals(FTIndex.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(FTIndex.class, new HashSet(FTIndex.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(FTIndexService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(FTIndexService.class, new HashSet(FTIndexService.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(OpenSearchDataSource.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(OpenSearchDataSource.class, new HashSet(OpenSearchDataSource.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(OpenSearchDataSourceService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(OpenSearchDataSourceService.class, new HashSet(OpenSearchDataSourceService.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(SruConsumer.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(SruConsumer.class, new HashSet(SruConsumer.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(SruConsumerService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(SruConsumerService.class, new HashSet(SruConsumerService.getAll((boolean)false)));
                continue;
            }
            if (!itemType.getName().equals(FieldIndexContainer.class.getName())) continue;
            items = null;
            try {
                items = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, FieldIndexContainerDao.class);
            }
            catch (Exception e) {
                throw new ResourceRegistryException("Could not prefetch datasource field info", (Throwable)e);
            }
            for (IDaoElement item : items) {
                loaded = new FieldIndexContainer();
                loaded.setID(((FieldIndexContainerDao)item).getID());
                loaded.load(false);
                InMemoryStore.setItem(FieldIndexContainer.class, (IRRElement)loaded);
            }
        }
    }

    public static List<String> getGHNContextStartScopes() {
        List<String> scopes = ConfigurationProviderLoader.getProvider().getGHNContextStartScopes();
        logger.info("gHNContextStartScopes : " + scopes);
        return scopes;
    }

    public static List<String> getGHNContextScopes() {
        List<String> scopes = ConfigurationProviderLoader.getProvider().getGHNContextScopes();
        logger.info("gHNContextScopes : " + scopes);
        return scopes;
    }

    public static boolean isClientMode() {
        boolean isClientMode = ConfigurationProviderLoader.getProvider().isClientMode();
        logger.info("isClientMode : " + isClientMode);
        return isClientMode;
    }

    public static void main(String[] args) throws Exception {
        scopes = new ArrayList<String>();
        scopes.add("/gcube/devNext");
        searchSystemScopes = Lists.newArrayList(scopes);
        Resource r2 = BridgeHelper.getResourceByNameAndType("ResourceRegistryModel.StaticConfig2", "ResourceRegistryModel", Sets.newHashSet(scopes));
        XMLConverter.convertToXML((Object)r2);
        BridgeHelper.updateOrPublish(r2, "/gcube/devNext");
        BridgeHelper.updateOrPublish(r2, "/gcube/devsec");
    }
}

