/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class Unlock
extends Operation {
    private String keyUnlock;

    public Unlock(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" UPLOAD " + myFile.getPathClient() + " author: " + myFile.getOwner());
        }
        String objectId = null;
        try {
            objectId = this.put(myFile, this.isChunk, false, false, true);
        }
        catch (Exception e) {
            throw new RemoteBackendException(" Error in unlock operation ", e.getCause());
        }
        return objectId;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String bucketName = null;
        if (remotePath.length() < 23 || remotePath.contains("/")) {
            DirectoryBucket dirBuc = new DirectoryBucket(server, this.user, this.password, remotePath, author);
            bucketName = new BucketCoding().bucketFileCoding(remotePath, author, rootArea);
            Object dirObject = null;
        } else {
            bucketName = remotePath;
        }
        this.bucket = bucketName;
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }
}

