/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Packet.Received;

import JOscarLib.Core.OscarConnection;
import JOscarLib.Integration.Event.IncomingMessageEvent;
import JOscarLib.Integration.Event.IncomingUrlEvent;
import JOscarLib.Integration.Event.MessagingListener;
import JOscarLib.Packet.Received.ReceivedPacket;
import JOscarLib.Packet.Sent.Icq.MessageType2Ack;
import JOscarLib.RawData;
import JOscarLib.Setting.Enum.MessageFlagsEnum;
import JOscarLib.Setting.Enum.MessageTypeEnum;
import JOscarLib.Setting.Enum.StatusModeEnum;
import JOscarLib.Tlv;

public class IncomingMessage__4_7
extends ReceivedPacket {
    private RawData time;
    private RawData msgId;
    private RawData messageChannel;
    private Tlv userIdleTime;
    private RawData ackType;
    private RawData senderTcpVer;
    private RawData msgSeqNum;
    private RawData msgType;
    private RawData msgFlags;
    private RawData foreground;
    private RawData background;
    private String senderID;
    private String message;
    private String url;
    private Tlv senderStatus;
    private Tlv onlineSinceTime;
    private Tlv ackType2;
    private Tlv port;
    private Tlv ip;
    private boolean isRequestAwayMessage = false;
    private boolean isFileAckOrAbortRequest = false;
    private boolean isFileAckOrFileOk = false;

    public IncomingMessage__4_7(byte[] array) {
        super(array, true);
        int position = 0;
        byte[] data = this.getSnac().getDataFieldByteArray();
        this.time = new RawData(data, position, 4);
        this.msgId = new RawData(data, position += 4, 4);
        this.messageChannel = new RawData(data, position += 4, 2);
        position += 2;
        RawData len = new RawData(data[position++]);
        this.senderID = new String(data, position, len.getValue());
        position += len.getValue();
        RawData nbTlv = new RawData(data, position += 2, 2);
        position += 2;
        for (int i = 0; i < nbTlv.getValue(); ++i) {
            Tlv tmpTlv = new Tlv(data, position);
            switch (tmpTlv.getType()) {
                case 6: {
                    this.senderStatus = tmpTlv;
                    break;
                }
                case 15: {
                    this.userIdleTime = tmpTlv;
                    break;
                }
                case 3: {
                    this.onlineSinceTime = tmpTlv;
                }
            }
            position += tmpTlv.getByteArray().length;
        }
        if (this.messageChannel.getValue() == 1) {
            this.parseType1(position, data);
        } else if (this.messageChannel.getValue() == 2) {
            this.parseType2(position, data);
        } else {
            this.parseType4(position, data);
        }
    }

    public void execute(OscarConnection connection) throws Exception {
        if (this.messageChannel.getValue() == 2) {
            connection.sendFlap(new MessageType2Ack(this.time, this.msgId, this.senderID, this.senderTcpVer, this.msgSeqNum, this.msgType, this.msgFlags, connection.getTweaker().getRequestMessage(this.msgType.getValue())));
        }
    }

    public void notifyEvent(OscarConnection connection) {
        if (this.getMessageType().getType() == 1) {
            this.notifyIncomingMessage(connection);
        } else if (this.getMessageType().getType() == 4) {
            this.notifyIncomingUrl(connection);
        }
    }

    private void notifyIncomingMessage(OscarConnection connection) {
        IncomingMessageEvent e = new IncomingMessageEvent(this);
        for (int i = 0; i < connection.getMessagingListeners().size(); ++i) {
            MessagingListener l = (MessagingListener)connection.getMessagingListeners().elementAt(i);
            l.onIncomingMessage(e);
        }
    }

    private void notifyIncomingUrl(OscarConnection connection) {
        IncomingUrlEvent e = new IncomingUrlEvent(this);
        for (int i = 0; i < connection.getMessagingListeners().size(); ++i) {
            MessagingListener l = (MessagingListener)connection.getMessagingListeners().elementAt(i);
            l.onIncomingUrl(e);
        }
    }

    private void parseType1(int position, byte[] data) {
        this.msgType = new RawData(1);
        Tlv tlvCapa = new Tlv(data, position += 4);
        Tlv tlvMsg = new Tlv(data, position += tlvCapa.getLength() + 4);
        int msgLen = tlvMsg.getLength() - 4;
        this.message = new String(data, position += 8, msgLen);
    }

    private void parseType2(int position, byte[] data) {
        this.ackType = new RawData(data, position += 4, 2);
        position += 2;
        if (this.ackType.getValue() != 0) {
            this.isFileAckOrAbortRequest = true;
        } else {
            position += 8;
            this.ackType2 = new Tlv(data, position += 16);
            position += 4 + this.ackType2.getLength();
            if (this.ackType2.getValue() == 2) {
                this.port = new Tlv(data, position);
                this.ip = new Tlv(data, position += 4 + this.port.getValue());
                position += 4 + this.ip.getValue();
                this.isFileAckOrFileOk = true;
            } else {
                this.senderTcpVer = new RawData(data, position += 10, 2);
                position += 2;
                this.msgSeqNum = new RawData(data, position += 23, 2);
                position += 2;
                this.msgType = new RawData(data, position += 16, 1);
                this.msgFlags = new RawData(data, ++position, 1);
                ++position;
                if (this.msgType.getValue() == 1) {
                    this.parseType2Message(position, data);
                } else if (this.msgType.getValue() >= 232 && this.msgType.getValue() <= 236) {
                    this.isRequestAwayMessage = true;
                }
            }
        }
    }

    private void parseType2Message(int position, byte[] data) {
        RawData msgLen = new RawData(data, position += 4, 2);
        msgLen.invertIndianness();
        this.message = new String(data, position += 2, msgLen.getValue() - 1);
        this.foreground = new RawData(data, position += this.message.length(), 4);
        this.background = new RawData(data, position += 4, 4);
        position += 4;
    }

    private void parseType4(int position, byte[] data) {
        position += 4;
        this.msgType = new RawData(data, position += 4, 2);
        this.msgType.invertIndianness();
        RawData msgLen = new RawData(data, position += 2, 2);
        msgLen.invertIndianness();
        position += 2;
        if (this.msgType.getValue() == 1) {
            this.parseType4Message(position, data, msgLen.getValue());
        } else if (this.msgType.getValue() == 4) {
            this.parseType4LinkMessage(position, data, msgLen.getValue());
        }
    }

    private void parseType4Message(int position, byte[] data, int msgLen) {
        this.message = new String(data, position, msgLen - 1);
    }

    private void parseType4LinkMessage(int position, byte[] data, int msgLen) {
        String tmp = new String(data, position, msgLen - 1);
        int divPosition = tmp.indexOf(254);
        this.message = new String(tmp.substring(0, divPosition));
        this.url = new String(tmp.substring(divPosition + 1, tmp.length()));
    }

    public int getMessageId() {
        return this.msgId.getValue();
    }

    public int getMessageChannel() {
        return this.messageChannel.getValue();
    }

    public String getSenderID() {
        return this.senderID;
    }

    public int getSenderTcpVersion() {
        return this.senderTcpVer.getValue();
    }

    public int getMessageSeqNum() {
        return this.msgSeqNum.getValue();
    }

    public String getMessage() {
        return this.message;
    }

    public String getUrl() {
        return this.url;
    }

    public StatusModeEnum getSenderStatus() {
        if (this.senderStatus == null) {
            return new StatusModeEnum(0);
        }
        return new StatusModeEnum(this.senderStatus.getValue());
    }

    public MessageFlagsEnum getMessageFlag() {
        return new MessageFlagsEnum(this.msgFlags.getValue());
    }

    public MessageTypeEnum getMessageType() {
        return new MessageTypeEnum(this.msgType.getValue());
    }

    private boolean getIsRequestAwayMessage() {
        return this.isRequestAwayMessage;
    }

    private boolean getIsFileAckOrAbortRequest() {
        return this.isFileAckOrAbortRequest;
    }

    private boolean getIsFileAckOrFileOk() {
        return this.isFileAckOrFileOk;
    }
}

