/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.shopping.NoSuchCartException;
import com.liferay.portlet.shopping.model.ShoppingCart;
import com.liferay.portlet.shopping.model.ShoppingCartItem;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingCoupon;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.ShoppingItemField;
import com.liferay.portlet.shopping.model.ShoppingItemPrice;
import com.liferay.portlet.shopping.model.ShoppingOrder;
import com.liferay.portlet.shopping.model.ShoppingOrderItem;
import com.liferay.portlet.shopping.model.impl.ShoppingCartImpl;
import com.liferay.portlet.shopping.service.ShoppingCartLocalServiceUtil;
import com.liferay.portlet.shopping.service.ShoppingCategoryLocalServiceUtil;
import com.liferay.portlet.shopping.service.ShoppingOrderItemLocalServiceUtil;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPriceUtil;
import com.liferay.portlet.shopping.util.ShoppingPreferences;
import com.liferay.portlet.shopping.util.comparator.ItemMinQuantityComparator;
import com.liferay.portlet.shopping.util.comparator.ItemNameComparator;
import com.liferay.portlet.shopping.util.comparator.ItemPriceComparator;
import com.liferay.portlet.shopping.util.comparator.ItemSKUComparator;
import com.liferay.portlet.shopping.util.comparator.OrderDateComparator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingUtil {
    public static double calculateActualPrice(ShoppingItem item) {
        return item.getPrice() - ShoppingUtil.calculateDiscountPrice(item);
    }

    public static double calculateActualPrice(ShoppingItem item, int count) throws PortalException, SystemException {
        return ShoppingUtil.calculatePrice(item, count) - ShoppingUtil.calculateDiscountPrice(item, count);
    }

    public static double calculateActualPrice(ShoppingItemPrice itemPrice) {
        return itemPrice.getPrice() - ShoppingUtil.calculateDiscountPrice(itemPrice);
    }

    public static double calculateActualSubtotal(Map<ShoppingCartItem, Integer> items) throws PortalException, SystemException {
        return ShoppingUtil.calculateSubtotal(items) - ShoppingUtil.calculateDiscountSubtotal(items);
    }

    public static double calculateActualSubtotal(List<ShoppingOrderItem> orderItems) {
        double subtotal = 0.0;
        for (ShoppingOrderItem orderItem : orderItems) {
            subtotal += orderItem.getPrice() * (double)orderItem.getQuantity();
        }
        return subtotal;
    }

    public static double calculateAlternativeShipping(Map<ShoppingCartItem, Integer> items, int altShipping) throws PortalException, SystemException {
        double shipping;
        double alternativeShipping = shipping = ShoppingUtil.calculateShipping(items);
        ShoppingPreferences preferences = null;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            ShoppingItem item = cartItem.getItem();
            if (preferences != null) continue;
            ShoppingCategory category = item.getCategory();
            preferences = ShoppingPreferences.getInstance(category.getCompanyId(), category.getGroupId());
            break;
        }
        if (preferences != null && preferences.useAlternativeShipping() && shipping > 0.0) {
            double altShippingDelta = 0.0;
            try {
                altShippingDelta = GetterUtil.getDouble((String)preferences.getAlternativeShipping()[1][altShipping]);
            }
            catch (Exception exception) {
                return alternativeShipping;
            }
            if (altShippingDelta > 0.0) {
                alternativeShipping = shipping * altShippingDelta;
            }
        }
        return alternativeShipping;
    }

    public static double calculateCouponDiscount(Map<ShoppingCartItem, Integer> items, ShoppingCoupon coupon) throws PortalException, SystemException {
        return ShoppingUtil.calculateCouponDiscount(items, null, coupon);
    }

    public static double calculateCouponDiscount(Map<ShoppingCartItem, Integer> items, String stateId, ShoppingCoupon coupon) throws PortalException, SystemException {
        double discount = 0.0;
        if (coupon == null || !coupon.isActive() || !coupon.hasValidDateRange()) {
            return discount;
        }
        String[] categoryIds = StringUtil.split((String)coupon.getLimitCategories());
        String[] skus = StringUtil.split((String)coupon.getLimitSkus());
        if (categoryIds.length > 0 || skus.length > 0) {
            HashSet<String> categoryIdsSet = new HashSet<String>();
            String[] stringArray = categoryIds;
            int n = categoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                String categoryId = stringArray[n2];
                categoryIdsSet.add(categoryId);
                ++n2;
            }
            HashSet<String> skusSet = new HashSet<String>();
            String[] stringArray2 = skus;
            int n3 = skus.length;
            n = 0;
            while (n < n3) {
                String sku = stringArray2[n];
                skusSet.add(sku);
                ++n;
            }
            HashMap<ShoppingCartItem, Integer> newItems = new HashMap<ShoppingCartItem, Integer>();
            for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
                ShoppingCartItem cartItem = entry.getKey();
                Integer count = entry.getValue();
                ShoppingItem item = cartItem.getItem();
                if ((categoryIdsSet.size() <= 0 || !categoryIdsSet.contains(String.valueOf(item.getCategoryId()))) && (skusSet.size() <= 0 || !skusSet.contains(item.getSku()))) continue;
                newItems.put(cartItem, count);
            }
            items = newItems;
        }
        double actualSubtotal = ShoppingUtil.calculateActualSubtotal(items);
        if (coupon.getMinOrder() > 0.0 && coupon.getMinOrder() > actualSubtotal) {
            return discount;
        }
        String type = coupon.getDiscountType();
        if (type.equals("percentage")) {
            discount = actualSubtotal * coupon.getDiscount();
        } else if (type.equals("actual")) {
            discount = coupon.getDiscount();
        } else if (type.equals("free-shipping")) {
            discount = ShoppingUtil.calculateShipping(items);
        } else if (type.equals("tax-free") && stateId != null) {
            discount = ShoppingUtil.calculateTax(items, stateId);
        }
        return discount;
    }

    public static double calculateDiscountPercent(Map<ShoppingCartItem, Integer> items) throws PortalException, SystemException {
        double discount = ShoppingUtil.calculateDiscountSubtotal(items) / ShoppingUtil.calculateSubtotal(items);
        if (Double.isNaN(discount) || Double.isInfinite(discount)) {
            discount = 0.0;
        }
        return discount;
    }

    public static double calculateDiscountPrice(ShoppingItem item) {
        return item.getPrice() * item.getDiscount();
    }

    public static double calculateDiscountPrice(ShoppingItem item, int count) throws PortalException, SystemException {
        ShoppingItemPrice itemPrice = ShoppingUtil._getItemPrice(item, count);
        return itemPrice.getPrice() * itemPrice.getDiscount() * (double)count;
    }

    public static double calculateDiscountPrice(ShoppingItemPrice itemPrice) {
        return itemPrice.getPrice() * itemPrice.getDiscount();
    }

    public static double calculateDiscountSubtotal(Map<ShoppingCartItem, Integer> items) throws PortalException, SystemException {
        double subtotal = 0.0;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            subtotal += ShoppingUtil.calculateDiscountPrice(item, count);
        }
        return subtotal;
    }

    public static double calculateInsurance(Map<ShoppingCartItem, Integer> items) throws PortalException, SystemException {
        double insurance = 0.0;
        double subtotal = 0.0;
        ShoppingPreferences preferences = null;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            if (preferences == null) {
                ShoppingCategory category = item.getCategory();
                preferences = ShoppingPreferences.getInstance(category.getCompanyId(), category.getGroupId());
            }
            ShoppingItemPrice itemPrice = ShoppingUtil._getItemPrice(item, count);
            subtotal += ShoppingUtil.calculateActualPrice(itemPrice) * (double)count.intValue();
        }
        if (preferences != null && subtotal > 0.0) {
            double insuranceRate = 0.0;
            double[] range = ShoppingPreferences.INSURANCE_RANGE;
            int i = 0;
            while (i < range.length - 1) {
                if (subtotal > range[i] && subtotal <= range[i + 1]) {
                    int rangeId = i / 2;
                    if (MathUtil.isOdd((int)i)) {
                        rangeId = (i + 1) / 2;
                    }
                    insuranceRate = GetterUtil.getDouble((String)preferences.getInsurance()[rangeId]);
                }
                ++i;
            }
            String formula = preferences.getInsuranceFormula();
            if (formula.equals("flat")) {
                insurance += insuranceRate;
            } else if (formula.equals("percentage")) {
                insurance += subtotal * insuranceRate;
            }
        }
        return insurance;
    }

    public static double calculatePrice(ShoppingItem item, int count) throws PortalException, SystemException {
        ShoppingItemPrice itemPrice = ShoppingUtil._getItemPrice(item, count);
        return itemPrice.getPrice() * (double)count;
    }

    public static double calculateShipping(Map<ShoppingCartItem, Integer> items) throws PortalException, SystemException {
        double shipping = 0.0;
        double subtotal = 0.0;
        ShoppingPreferences preferences = null;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            if (preferences == null) {
                ShoppingCategory category = item.getCategory();
                preferences = ShoppingPreferences.getInstance(category.getCompanyId(), category.getGroupId());
            }
            if (!item.isRequiresShipping()) continue;
            ShoppingItemPrice itemPrice = ShoppingUtil._getItemPrice(item, count);
            if (itemPrice.isUseShippingFormula()) {
                subtotal += ShoppingUtil.calculateActualPrice(itemPrice) * (double)count.intValue();
                continue;
            }
            shipping += itemPrice.getShipping() * (double)count.intValue();
        }
        if (preferences != null && subtotal > 0.0) {
            double shippingRate = 0.0;
            double[] range = ShoppingPreferences.SHIPPING_RANGE;
            int i = 0;
            while (i < range.length - 1) {
                if (subtotal > range[i] && subtotal <= range[i + 1]) {
                    int rangeId = i / 2;
                    if (MathUtil.isOdd((int)i)) {
                        rangeId = (i + 1) / 2;
                    }
                    shippingRate = GetterUtil.getDouble((String)preferences.getShipping()[rangeId]);
                }
                ++i;
            }
            String formula = preferences.getShippingFormula();
            if (formula.equals("flat")) {
                shipping += shippingRate;
            } else if (formula.equals("percentage")) {
                shipping += subtotal * shippingRate;
            }
        }
        return shipping;
    }

    public static double calculateSubtotal(Map<ShoppingCartItem, Integer> items) throws PortalException, SystemException {
        double subtotal = 0.0;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            subtotal += ShoppingUtil.calculatePrice(item, count);
        }
        return subtotal;
    }

    public static double calculateTax(Map<ShoppingCartItem, Integer> items, String stateId) throws PortalException, SystemException {
        double tax = 0.0;
        ShoppingPreferences preferences = null;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            ShoppingItem item = cartItem.getItem();
            if (preferences != null) continue;
            ShoppingCategory category = item.getCategory();
            preferences = ShoppingPreferences.getInstance(category.getCompanyId(), category.getGroupId());
            break;
        }
        if (preferences != null && preferences.getTaxState().equals(stateId)) {
            double subtotal = 0.0;
            for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
                ShoppingCartItem cartItem = entry.getKey();
                Integer count = entry.getValue();
                ShoppingItem item = cartItem.getItem();
                if (!item.isTaxable()) continue;
                subtotal += ShoppingUtil.calculatePrice(item, count);
            }
            tax = preferences.getTaxRate() * subtotal;
        }
        return tax;
    }

    public static double calculateTotal(Map<ShoppingCartItem, Integer> items, String stateId, ShoppingCoupon coupon, int altShipping, boolean insure) throws PortalException, SystemException {
        double couponDiscount;
        double total;
        double actualSubtotal = ShoppingUtil.calculateActualSubtotal(items);
        double tax = ShoppingUtil.calculateTax(items, stateId);
        double shipping = ShoppingUtil.calculateAlternativeShipping(items, altShipping);
        double insurance = 0.0;
        if (insure) {
            insurance = ShoppingUtil.calculateInsurance(items);
        }
        if ((total = actualSubtotal + tax + shipping + insurance - (couponDiscount = ShoppingUtil.calculateCouponDiscount(items, stateId, coupon))) < 0.0) {
            total = 0.0;
        }
        return total;
    }

    public static double calculateTotal(ShoppingOrder order) throws SystemException {
        List orderItems = ShoppingOrderItemLocalServiceUtil.getOrderItems((long)order.getOrderId());
        double total = ShoppingUtil.calculateActualSubtotal(orderItems) + order.getTax() + order.getShipping() + order.getInsurance() - order.getCouponDiscount();
        if (total < 0.0) {
            total = 0.0;
        }
        return total;
    }

    public static String getBreadcrumbs(long categoryId, PageContext pageContext, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ShoppingCategory category = null;
        try {
            category = ShoppingCategoryLocalServiceUtil.getCategory((long)categoryId);
        }
        catch (Exception exception) {}
        return ShoppingUtil.getBreadcrumbs(category, pageContext, renderRequest, renderResponse);
    }

    public static String getBreadcrumbs(ShoppingCategory category, PageContext pageContext, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        PortletURL categoriesURL = renderResponse.createRenderURL();
        WindowState windowState = renderRequest.getWindowState();
        if (windowState.equals((Object)LiferayWindowState.POP_UP)) {
            categoriesURL.setWindowState(LiferayWindowState.POP_UP);
            categoriesURL.setParameter("struts_action", "/shopping/select_category");
        } else {
            categoriesURL.setParameter("struts_action", "/shopping/view");
            categoriesURL.setParameter("tabs1", "categories");
        }
        String categoriesLink = "<a href=\"" + categoriesURL.toString() + "\">" + LanguageUtil.get((PageContext)pageContext, (String)"categories") + "</a>";
        if (category == null) {
            return "<span class=\"first last\">" + categoriesLink + "</span>";
        }
        String breadcrumbs = "";
        if (category != null) {
            int i = 0;
            while (true) {
                category = category.toEscapedModel();
                PortletURL portletURL = renderResponse.createRenderURL();
                if (windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    portletURL.setWindowState(LiferayWindowState.POP_UP);
                    portletURL.setParameter("struts_action", "/shopping/select_category");
                    portletURL.setParameter("categoryId", String.valueOf(category.getCategoryId()));
                } else {
                    portletURL.setParameter("struts_action", "/shopping/view");
                    portletURL.setParameter("tabs1", "categories");
                    portletURL.setParameter("categoryId", String.valueOf(category.getCategoryId()));
                }
                String categoryLink = "<a href=\"" + portletURL.toString() + "\">" + category.getName() + "</a>";
                breadcrumbs = i == 0 ? "<span class=\"last\">" + categoryLink + "</span>" : String.valueOf(categoryLink) + " &raquo; " + breadcrumbs;
                if (category.isRoot()) break;
                category = ShoppingCategoryLocalServiceUtil.getCategory((long)category.getParentCategoryId());
                ++i;
            }
        }
        breadcrumbs = "<span class=\"first\">" + categoriesLink + " &raquo; </span>" + breadcrumbs;
        return breadcrumbs;
    }

    public static ShoppingCart getCart(ThemeDisplay themeDisplay) {
        ShoppingCartImpl cart = new ShoppingCartImpl();
        cart.setGroupId(themeDisplay.getScopeGroupId());
        cart.setCompanyId(themeDisplay.getCompanyId());
        cart.setUserId(themeDisplay.getUserId());
        cart.setItemIds("");
        cart.setCouponCodes("");
        cart.setAltShipping(0);
        cart.setInsure(false);
        return cart;
    }

    public static ShoppingCart getCart(PortletRequest portletRequest) throws PortalException, SystemException {
        PortletSession portletSession = portletRequest.getPortletSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        String sessionCartId = String.valueOf(ShoppingCart.class.getName()) + themeDisplay.getScopeGroupId();
        if (themeDisplay.isSignedIn()) {
            ShoppingCart cart = (ShoppingCart)portletSession.getAttribute(sessionCartId);
            if (cart != null) {
                portletSession.removeAttribute(sessionCartId);
            }
            if (cart != null && cart.getItemsSize() > 0) {
                cart = ShoppingCartLocalServiceUtil.updateCart((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)cart.getItemIds(), (String)cart.getCouponCodes(), (int)cart.getAltShipping(), (boolean)cart.isInsure());
            } else {
                try {
                    cart = ShoppingCartLocalServiceUtil.getCart((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId());
                }
                catch (NoSuchCartException noSuchCartException) {
                    cart = ShoppingUtil.getCart(themeDisplay);
                    cart = ShoppingCartLocalServiceUtil.updateCart((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)cart.getItemIds(), (String)cart.getCouponCodes(), (int)cart.getAltShipping(), (boolean)cart.isInsure());
                }
            }
            return cart;
        }
        ShoppingCart cart = (ShoppingCart)portletSession.getAttribute(sessionCartId);
        if (cart == null) {
            cart = ShoppingUtil.getCart(themeDisplay);
            portletSession.setAttribute(sessionCartId, (Object)cart);
        }
        return cart;
    }

    public static int getFieldsQuantitiesPos(ShoppingItem item, ShoppingItemField[] itemFields, String[] fieldsArray) {
        HashSet<String> fieldsValues = new HashSet<String>();
        String[] stringArray = fieldsArray;
        int n = fieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fields = stringArray[n2];
            int pos = fields.indexOf("=");
            String fieldValue = fields.substring(pos + 1, fields.length()).trim();
            fieldsValues.add(fieldValue);
            ++n2;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String[]> values = new ArrayList<String[]>();
        int i = 0;
        while (i < itemFields.length) {
            names.add(itemFields[i].getName());
            values.add(StringUtil.split((String)itemFields[i].getValues()));
            ++i;
        }
        int numOfRows = 1;
        for (String[] vArray : values) {
            numOfRows *= vArray.length;
        }
        int rowPos = 0;
        int i2 = 0;
        while (i2 < numOfRows) {
            boolean match = true;
            int j = 0;
            while (j < names.size()) {
                int numOfRepeats = 1;
                int k = j + 1;
                while (k < values.size()) {
                    String[] vArray = (String[])values.get(k);
                    numOfRepeats *= vArray.length;
                    ++k;
                }
                String[] vArray = (String[])values.get(j);
                int arrayPos = i2 / numOfRepeats;
                while (arrayPos >= vArray.length) {
                    arrayPos -= vArray.length;
                }
                if (!fieldsValues.contains(vArray[arrayPos].trim())) {
                    match = false;
                    break;
                }
                ++j;
            }
            if (match) {
                rowPos = i2;
                break;
            }
            ++i2;
        }
        return rowPos;
    }

    public static long getItemId(String itemId) {
        int pos = itemId.indexOf(124);
        if (pos != -1) {
            itemId = itemId.substring(0, pos);
        }
        return GetterUtil.getLong((String)itemId);
    }

    public static String getItemFields(String itemId) {
        int pos = itemId.indexOf(124);
        if (pos == -1) {
            return "";
        }
        return itemId.substring(pos + 1, itemId.length());
    }

    public static OrderByComparator getItemOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        ItemMinQuantityComparator orderByComparator = null;
        if (orderByCol.equals("min-qty")) {
            orderByComparator = new ItemMinQuantityComparator(orderByAsc);
        } else if (orderByCol.equals("name")) {
            orderByComparator = new ItemNameComparator(orderByAsc);
        } else if (orderByCol.equals("price")) {
            orderByComparator = new ItemPriceComparator(orderByAsc);
        } else if (orderByCol.equals("sku")) {
            orderByComparator = new ItemSKUComparator(orderByAsc);
        } else if (orderByCol.equals("order-date")) {
            orderByComparator = new OrderDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static int getMinQuantity(ShoppingItem item) throws PortalException, SystemException {
        int minQuantity = item.getMinQuantity();
        List itemPrices = item.getItemPrices();
        for (ShoppingItemPrice itemPrice : itemPrices) {
            if (minQuantity <= itemPrice.getMinQuantity()) continue;
            minQuantity = itemPrice.getMinQuantity();
        }
        return minQuantity;
    }

    public static String getPayPalNotifyURL(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/shopping/notify";
    }

    public static String getPayPalRedirectURL(ShoppingPreferences preferences, ShoppingOrder order, double total, String returnURL, String notifyURL) {
        String payPalEmailAddress = HttpUtil.encodeURL((String)preferences.getPayPalEmailAddress());
        NumberFormat doubleFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        doubleFormat.setMaximumFractionDigits(2);
        doubleFormat.setMinimumFractionDigits(2);
        String amount = doubleFormat.format(total);
        returnURL = HttpUtil.encodeURL((String)returnURL);
        notifyURL = HttpUtil.encodeURL((String)notifyURL);
        String firstName = HttpUtil.encodeURL((String)order.getBillingFirstName());
        String lastName = HttpUtil.encodeURL((String)order.getBillingLastName());
        String address1 = HttpUtil.encodeURL((String)order.getBillingStreet());
        String city = HttpUtil.encodeURL((String)order.getBillingCity());
        String state = HttpUtil.encodeURL((String)order.getBillingState());
        String zip = HttpUtil.encodeURL((String)order.getBillingZip());
        String currencyCode = preferences.getCurrencyId();
        StringBundler sb = new StringBundler(45);
        sb.append("https://www.paypal.com/cgi-bin/webscr?");
        sb.append("cmd=_xclick&");
        sb.append("business=").append(payPalEmailAddress).append("&");
        sb.append("item_name=").append(order.getNumber()).append("&");
        sb.append("item_number=").append(order.getNumber()).append("&");
        sb.append("invoice=").append(order.getNumber()).append("&");
        sb.append("amount=").append(amount).append("&");
        sb.append("return=").append(returnURL).append("&");
        sb.append("notify_url=").append(notifyURL).append("&");
        sb.append("first_name=").append(firstName).append("&");
        sb.append("last_name=").append(lastName).append("&");
        sb.append("address1=").append(address1).append("&");
        sb.append("city=").append(city).append("&");
        sb.append("state=").append(state).append("&");
        sb.append("zip=").append(zip).append("&");
        sb.append("no_note=1&");
        sb.append("currency_code=").append(currencyCode).append("");
        return sb.toString();
    }

    public static String getPayPalReturnURL(PortletURL portletURL, ShoppingOrder order) {
        portletURL.setParameter("struts_action", "/shopping/checkout");
        portletURL.setParameter("cmd", "view");
        portletURL.setParameter("orderId", String.valueOf(order.getOrderId()));
        return portletURL.toString();
    }

    public static String getPpPaymentStatus(String ppPaymentStatus) {
        if (ppPaymentStatus == null || ppPaymentStatus.length() < 2 || ppPaymentStatus.equals("checkout")) {
            return "LIFERAY_STATUS_CHECKOUT";
        }
        return String.valueOf(Character.toUpperCase(ppPaymentStatus.charAt(0))) + ppPaymentStatus.substring(1, ppPaymentStatus.length());
    }

    public static String getPpPaymentStatus(ShoppingOrder order, PageContext pageContext) {
        String ppPaymentStatus = order.getPpPaymentStatus();
        ppPaymentStatus = ppPaymentStatus.equals("LIFERAY_STATUS_CHECKOUT") ? "checkout" : ppPaymentStatus.toLowerCase();
        return LanguageUtil.get((PageContext)pageContext, (String)ppPaymentStatus);
    }

    public static boolean isInStock(ShoppingItem item) {
        if (!item.isFields()) {
            return item.getStockQuantity() > 0;
        }
        String[] fieldsQuantities = item.getFieldsQuantitiesArray();
        int i = 0;
        while (i < fieldsQuantities.length) {
            if (GetterUtil.getInteger((String)fieldsQuantities[i]) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isInStock(ShoppingItem item, ShoppingItemField[] itemFields, String[] fieldsArray, Integer orderedQuantity) {
        if (!item.isFields()) {
            int stockQuantity = item.getStockQuantity();
            return stockQuantity > 0 && stockQuantity >= orderedQuantity;
        }
        int rowPos = ShoppingUtil.getFieldsQuantitiesPos(item, itemFields, fieldsArray);
        String[] fieldsQuantities = item.getFieldsQuantitiesArray();
        int stockQuantity = GetterUtil.getInteger((String)fieldsQuantities[rowPos]);
        try {
            if (stockQuantity > 0 && stockQuantity >= orderedQuantity) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean meetsMinOrder(ShoppingPreferences preferences, Map<ShoppingCartItem, Integer> items) throws PortalException, SystemException {
        return !(preferences.getMinOrder() > 0.0) || !(ShoppingUtil.calculateSubtotal(items) < preferences.getMinOrder());
    }

    private static ShoppingItemPrice _getItemPrice(ShoppingItem item, int count) throws PortalException, SystemException {
        ShoppingItemPrice itemPrice = null;
        List itemPrices = item.getItemPrices();
        for (ShoppingItemPrice temp : itemPrices) {
            int minQty = temp.getMinQuantity();
            int maxQty = temp.getMaxQuantity();
            if (temp.getStatus() == 0) continue;
            if (count >= minQty && (count <= maxQty || maxQty == 0)) {
                return temp;
            }
            if (count <= maxQty || itemPrice != null && itemPrice.getMaxQuantity() >= maxQty) continue;
            itemPrice = temp;
        }
        if (itemPrice == null) {
            return ShoppingItemPriceUtil.create((long)0L);
        }
        return itemPrice;
    }
}

