/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.CompanyPersistence;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessagePersistence;
import com.liferay.portlet.shopping.NoSuchOrderException;
import com.liferay.portlet.shopping.model.ShoppingOrder;
import com.liferay.portlet.shopping.model.impl.ShoppingOrderImpl;
import com.liferay.portlet.shopping.model.impl.ShoppingOrderModelImpl;
import com.liferay.portlet.shopping.service.persistence.ShoppingCartPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingCategoryPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingCouponPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemFieldPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPricePersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingOrderItemPersistence;
import com.liferay.portlet.shopping.service.persistence.ShoppingOrderPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingOrderPersistenceImpl
extends BasePersistenceImpl<ShoppingOrder>
implements ShoppingOrderPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingOrderImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List";
    public static final FinderPath FINDER_PATH_FIND_BY_GROUPID = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByGroupId", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByGroupId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_NUMBER = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByNumber", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_NUMBER = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByNumber", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_PPTXNID = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByPPTxnId", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_PPTXNID = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByPPTxnId", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_G_U_PPPS = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByG_U_PPPS", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_G_U_PPPS = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByG_U_PPPS", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    @BeanReference(type=ShoppingCartPersistence.class)
    protected ShoppingCartPersistence shoppingCartPersistence;
    @BeanReference(type=ShoppingCategoryPersistence.class)
    protected ShoppingCategoryPersistence shoppingCategoryPersistence;
    @BeanReference(type=ShoppingCouponPersistence.class)
    protected ShoppingCouponPersistence shoppingCouponPersistence;
    @BeanReference(type=ShoppingItemPersistence.class)
    protected ShoppingItemPersistence shoppingItemPersistence;
    @BeanReference(type=ShoppingItemFieldPersistence.class)
    protected ShoppingItemFieldPersistence shoppingItemFieldPersistence;
    @BeanReference(type=ShoppingItemPricePersistence.class)
    protected ShoppingItemPricePersistence shoppingItemPricePersistence;
    @BeanReference(type=ShoppingOrderPersistence.class)
    protected ShoppingOrderPersistence shoppingOrderPersistence;
    @BeanReference(type=ShoppingOrderItemPersistence.class)
    protected ShoppingOrderItemPersistence shoppingOrderItemPersistence;
    @BeanReference(type=CompanyPersistence.class)
    protected CompanyPersistence companyPersistence;
    @BeanReference(type=ResourcePersistence.class)
    protected ResourcePersistence resourcePersistence;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    @BeanReference(type=MBMessagePersistence.class)
    protected MBMessagePersistence mbMessagePersistence;
    private static final String _SQL_SELECT_SHOPPINGORDER = "SELECT shoppingOrder FROM ShoppingOrder shoppingOrder";
    private static final String _SQL_SELECT_SHOPPINGORDER_WHERE = "SELECT shoppingOrder FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _SQL_COUNT_SHOPPINGORDER = "SELECT COUNT(shoppingOrder) FROM ShoppingOrder shoppingOrder";
    private static final String _SQL_COUNT_SHOPPINGORDER_WHERE = "SELECT COUNT(shoppingOrder) FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "shoppingOrder.groupId = ?";
    private static final String _FINDER_COLUMN_NUMBER_NUMBER_1 = "shoppingOrder.number IS NULL";
    private static final String _FINDER_COLUMN_NUMBER_NUMBER_2 = "shoppingOrder.number = ?";
    private static final String _FINDER_COLUMN_NUMBER_NUMBER_3 = "(shoppingOrder.number IS NULL OR shoppingOrder.number = ?)";
    private static final String _FINDER_COLUMN_PPTXNID_PPTXNID_1 = "shoppingOrder.ppTxnId IS NULL";
    private static final String _FINDER_COLUMN_PPTXNID_PPTXNID_2 = "shoppingOrder.ppTxnId = ?";
    private static final String _FINDER_COLUMN_PPTXNID_PPTXNID_3 = "(shoppingOrder.ppTxnId IS NULL OR shoppingOrder.ppTxnId = ?)";
    private static final String _FINDER_COLUMN_G_U_PPPS_GROUPID_2 = "shoppingOrder.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_U_PPPS_USERID_2 = "shoppingOrder.userId = ? AND ";
    private static final String _FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1 = "shoppingOrder.ppPaymentStatus IS NULL";
    private static final String _FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2 = "shoppingOrder.ppPaymentStatus = ?";
    private static final String _FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3 = "(shoppingOrder.ppPaymentStatus IS NULL OR shoppingOrder.ppPaymentStatus = ?)";
    private static final String _FILTER_SQL_SELECT_SHOPPINGORDER_WHERE = "SELECT DISTINCT {shoppingOrder.*} FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {ShoppingOrder.*} FROM (SELECT DISTINCT shoppingOrder.orderId FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN ShoppingOrder ON TEMP_TABLE.orderId = ShoppingOrder.orderId";
    private static final String _FILTER_SQL_COUNT_SHOPPINGORDER_WHERE = "SELECT COUNT(DISTINCT shoppingOrder.orderId) AS COUNT_VALUE FROM ShoppingOrder shoppingOrder WHERE ";
    private static final String _FILTER_COLUMN_PK = "shoppingOrder.orderId";
    private static final String _FILTER_COLUMN_USERID = "shoppingOrder.userId";
    private static final String _FILTER_ENTITY_ALIAS = "shoppingOrder";
    private static final String _FILTER_ENTITY_TABLE = "ShoppingOrder";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingOrder.";
    private static final String _ORDER_BY_ENTITY_TABLE = "ShoppingOrder.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingOrder exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingOrder exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(ShoppingOrderPersistenceImpl.class);

    public void cacheResult(ShoppingOrder shoppingOrder) {
        EntityCacheUtil.putResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()), (Object)shoppingOrder);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])new Object[]{shoppingOrder.getNumber()}, (Object)shoppingOrder);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])new Object[]{shoppingOrder.getPpTxnId()}, (Object)shoppingOrder);
    }

    public void cacheResult(List<ShoppingOrder> shoppingOrders) {
        for (ShoppingOrder shoppingOrder : shoppingOrders) {
            if (EntityCacheUtil.getResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(shoppingOrder);
        }
    }

    public void clearCache() {
        CacheRegistryUtil.clear((String)ShoppingOrderImpl.class.getName());
        EntityCacheUtil.clearCache((String)ShoppingOrderImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public void clearCache(ShoppingOrder shoppingOrder) {
        EntityCacheUtil.removeResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()));
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])new Object[]{shoppingOrder.getNumber()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])new Object[]{shoppingOrder.getPpTxnId()});
    }

    public ShoppingOrder create(long orderId) {
        ShoppingOrderImpl shoppingOrder = new ShoppingOrderImpl();
        shoppingOrder.setNew(true);
        shoppingOrder.setPrimaryKey(orderId);
        return shoppingOrder;
    }

    public ShoppingOrder remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public ShoppingOrder remove(long orderId) throws NoSuchOrderException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrder shoppingOrder = (ShoppingOrder)session.get(ShoppingOrderImpl.class, (Serializable)new Long(orderId));
            if (shoppingOrder == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderId));
                }
                throw new NoSuchOrderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderId);
            }
            ShoppingOrder shoppingOrder2 = (ShoppingOrder)this.remove((BaseModel)shoppingOrder);
            return shoppingOrder2;
        }
        catch (NoSuchOrderException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrder removeImpl(ShoppingOrder shoppingOrder) throws SystemException {
        shoppingOrder = this.toUnwrappedModel(shoppingOrder);
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.delete((Session)session, (BaseModel)shoppingOrder);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        ShoppingOrderModelImpl shoppingOrderModelImpl = (ShoppingOrderModelImpl)shoppingOrder;
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])new Object[]{shoppingOrderModelImpl.getNumber()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])new Object[]{shoppingOrderModelImpl.getPpTxnId()});
        EntityCacheUtil.removeResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()));
        return shoppingOrder;
    }

    public ShoppingOrder updateImpl(ShoppingOrder shoppingOrder, boolean merge) throws SystemException {
        shoppingOrder = this.toUnwrappedModel(shoppingOrder);
        boolean isNew = shoppingOrder.isNew();
        ShoppingOrderModelImpl shoppingOrderModelImpl = (ShoppingOrderModelImpl)shoppingOrder;
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.update((Session)session, (BaseModel)shoppingOrder, (boolean)merge);
                shoppingOrder.setNew(false);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(shoppingOrder.getPrimaryKey()), (Object)shoppingOrder);
        if (!isNew && !Validator.equals((Object)shoppingOrder.getNumber(), (Object)shoppingOrderModelImpl.getOriginalNumber())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])new Object[]{shoppingOrderModelImpl.getOriginalNumber()});
        }
        if (isNew || !Validator.equals((Object)shoppingOrder.getNumber(), (Object)shoppingOrderModelImpl.getOriginalNumber())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])new Object[]{shoppingOrder.getNumber()}, (Object)shoppingOrder);
        }
        if (!isNew && !Validator.equals((Object)shoppingOrder.getPpTxnId(), (Object)shoppingOrderModelImpl.getOriginalPpTxnId())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])new Object[]{shoppingOrderModelImpl.getOriginalPpTxnId()});
        }
        if (isNew || !Validator.equals((Object)shoppingOrder.getPpTxnId(), (Object)shoppingOrderModelImpl.getOriginalPpTxnId())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])new Object[]{shoppingOrder.getPpTxnId()}, (Object)shoppingOrder);
        }
        return shoppingOrder;
    }

    protected ShoppingOrder toUnwrappedModel(ShoppingOrder shoppingOrder) {
        if (shoppingOrder instanceof ShoppingOrderImpl) {
            return shoppingOrder;
        }
        ShoppingOrderImpl shoppingOrderImpl = new ShoppingOrderImpl();
        shoppingOrderImpl.setNew(shoppingOrder.isNew());
        shoppingOrderImpl.setPrimaryKey(shoppingOrder.getPrimaryKey());
        shoppingOrderImpl.setOrderId(shoppingOrder.getOrderId());
        shoppingOrderImpl.setGroupId(shoppingOrder.getGroupId());
        shoppingOrderImpl.setCompanyId(shoppingOrder.getCompanyId());
        shoppingOrderImpl.setUserId(shoppingOrder.getUserId());
        shoppingOrderImpl.setUserName(shoppingOrder.getUserName());
        shoppingOrderImpl.setCreateDate(shoppingOrder.getCreateDate());
        shoppingOrderImpl.setModifiedDate(shoppingOrder.getModifiedDate());
        shoppingOrderImpl.setNumber(shoppingOrder.getNumber());
        shoppingOrderImpl.setTax(shoppingOrder.getTax());
        shoppingOrderImpl.setShipping(shoppingOrder.getShipping());
        shoppingOrderImpl.setAltShipping(shoppingOrder.getAltShipping());
        shoppingOrderImpl.setRequiresShipping(shoppingOrder.isRequiresShipping());
        shoppingOrderImpl.setInsure(shoppingOrder.isInsure());
        shoppingOrderImpl.setInsurance(shoppingOrder.getInsurance());
        shoppingOrderImpl.setCouponCodes(shoppingOrder.getCouponCodes());
        shoppingOrderImpl.setCouponDiscount(shoppingOrder.getCouponDiscount());
        shoppingOrderImpl.setBillingFirstName(shoppingOrder.getBillingFirstName());
        shoppingOrderImpl.setBillingLastName(shoppingOrder.getBillingLastName());
        shoppingOrderImpl.setBillingEmailAddress(shoppingOrder.getBillingEmailAddress());
        shoppingOrderImpl.setBillingCompany(shoppingOrder.getBillingCompany());
        shoppingOrderImpl.setBillingStreet(shoppingOrder.getBillingStreet());
        shoppingOrderImpl.setBillingCity(shoppingOrder.getBillingCity());
        shoppingOrderImpl.setBillingState(shoppingOrder.getBillingState());
        shoppingOrderImpl.setBillingZip(shoppingOrder.getBillingZip());
        shoppingOrderImpl.setBillingCountry(shoppingOrder.getBillingCountry());
        shoppingOrderImpl.setBillingPhone(shoppingOrder.getBillingPhone());
        shoppingOrderImpl.setShipToBilling(shoppingOrder.isShipToBilling());
        shoppingOrderImpl.setShippingFirstName(shoppingOrder.getShippingFirstName());
        shoppingOrderImpl.setShippingLastName(shoppingOrder.getShippingLastName());
        shoppingOrderImpl.setShippingEmailAddress(shoppingOrder.getShippingEmailAddress());
        shoppingOrderImpl.setShippingCompany(shoppingOrder.getShippingCompany());
        shoppingOrderImpl.setShippingStreet(shoppingOrder.getShippingStreet());
        shoppingOrderImpl.setShippingCity(shoppingOrder.getShippingCity());
        shoppingOrderImpl.setShippingState(shoppingOrder.getShippingState());
        shoppingOrderImpl.setShippingZip(shoppingOrder.getShippingZip());
        shoppingOrderImpl.setShippingCountry(shoppingOrder.getShippingCountry());
        shoppingOrderImpl.setShippingPhone(shoppingOrder.getShippingPhone());
        shoppingOrderImpl.setCcName(shoppingOrder.getCcName());
        shoppingOrderImpl.setCcType(shoppingOrder.getCcType());
        shoppingOrderImpl.setCcNumber(shoppingOrder.getCcNumber());
        shoppingOrderImpl.setCcExpMonth(shoppingOrder.getCcExpMonth());
        shoppingOrderImpl.setCcExpYear(shoppingOrder.getCcExpYear());
        shoppingOrderImpl.setCcVerNumber(shoppingOrder.getCcVerNumber());
        shoppingOrderImpl.setComments(shoppingOrder.getComments());
        shoppingOrderImpl.setPpTxnId(shoppingOrder.getPpTxnId());
        shoppingOrderImpl.setPpPaymentStatus(shoppingOrder.getPpPaymentStatus());
        shoppingOrderImpl.setPpPaymentGross(shoppingOrder.getPpPaymentGross());
        shoppingOrderImpl.setPpReceiverEmail(shoppingOrder.getPpReceiverEmail());
        shoppingOrderImpl.setPpPayerEmail(shoppingOrder.getPpPayerEmail());
        shoppingOrderImpl.setSendOrderEmail(shoppingOrder.isSendOrderEmail());
        shoppingOrderImpl.setSendShippingEmail(shoppingOrder.isSendShippingEmail());
        return shoppingOrderImpl;
    }

    public ShoppingOrder findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public ShoppingOrder findByPrimaryKey(long orderId) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.fetchByPrimaryKey(orderId);
        if (shoppingOrder == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderId));
            }
            throw new NoSuchOrderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + orderId);
        }
        return shoppingOrder;
    }

    public ShoppingOrder fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public ShoppingOrder fetchByPrimaryKey(long orderId) throws SystemException {
        ShoppingOrder shoppingOrder = (ShoppingOrder)EntityCacheUtil.getResult((boolean)ShoppingOrderModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderImpl.class, (Serializable)Long.valueOf(orderId), (SessionFactory)this);
        if (shoppingOrder == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    shoppingOrder = (ShoppingOrder)session.get(ShoppingOrderImpl.class, (Serializable)new Long(orderId));
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (shoppingOrder != null) {
                    this.cacheResult(shoppingOrder);
                }
                this.closeSession(session);
            }
        }
        return shoppingOrder;
    }

    public List<ShoppingOrder> findByGroupId(long groupId) throws SystemException {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<ShoppingOrder> findByGroupId(long groupId, int start, int end) throws SystemException {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<ShoppingOrder> findByGroupId(long groupId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY shoppingOrder.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingOrder findByGroupId_First(long groupId, OrderByComparator orderByComparator) throws NoSuchOrderException, SystemException {
        List<ShoppingOrder> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchOrderException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingOrder findByGroupId_Last(long groupId, OrderByComparator orderByComparator) throws NoSuchOrderException, SystemException {
        int count = this.countByGroupId(groupId);
        List<ShoppingOrder> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchOrderException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingOrder[] findByGroupId_PrevAndNext(long orderId, long groupId, OrderByComparator orderByComparator) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.findByPrimaryKey(orderId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrder[] array = new ShoppingOrderImpl[]{this.getByGroupId_PrevAndNext(session, shoppingOrder, groupId, orderByComparator, true), shoppingOrder, this.getByGroupId_PrevAndNext(session, shoppingOrder, groupId, orderByComparator, false)};
            ShoppingOrder[] shoppingOrderArray = array;
            return shoppingOrderArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrder getByGroupId_PrevAndNext(Session session, ShoppingOrder shoppingOrder, long groupId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByFields = orderByComparator.getOrderByFields();
            if (orderByFields.length > 0) {
                query.append(" AND ");
            }
            int i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i;
            }
            query.append(" ORDER BY ");
            i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i;
            }
        } else {
            query.append(" ORDER BY shoppingOrder.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByValues((Object)shoppingOrder);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingOrder)list.get(1);
        }
        return null;
    }

    public List<ShoppingOrder> filterFindByGroupId(long groupId) throws SystemException {
        return this.filterFindByGroupId(groupId, -1, -1, null);
    }

    public List<ShoppingOrder> filterFindByGroupId(long groupId, int start, int end) throws SystemException {
        return this.filterFindByGroupId(groupId, start, end, null);
    }

    public List<ShoppingOrder> filterFindByGroupId(long groupId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId(groupId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingOrder.createDate DESC");
        } else {
            query.append(" ORDER BY ShoppingOrder.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingOrder.class.getName(), (String)_FILTER_COLUMN_PK, (String)_FILTER_COLUMN_USERID, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingOrderImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, ShoppingOrderImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingOrder findByNumber(String number) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.fetchByNumber(number);
        if (shoppingOrder == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("number=");
            msg.append(number);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchOrderException(msg.toString());
        }
        return shoppingOrder;
    }

    public ShoppingOrder fetchByNumber(String number) throws SystemException {
        return this.fetchByNumber(number, true);
    }

    public ShoppingOrder fetchByNumber(String number, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{number};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
            if (number == null) {
                query.append(_FINDER_COLUMN_NUMBER_NUMBER_1);
            } else if (number.equals("")) {
                query.append(_FINDER_COLUMN_NUMBER_NUMBER_3);
            } else {
                query.append(_FINDER_COLUMN_NUMBER_NUMBER_2);
            }
            query.append(" ORDER BY shoppingOrder.createDate DESC");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (number != null) {
                    qPos.add(number);
                }
                List list = q.list();
                result = list;
                ShoppingOrder shoppingOrder = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])finderArgs, (Object)list);
                } else {
                    shoppingOrder = (ShoppingOrder)list.get(0);
                    this.cacheResult(shoppingOrder);
                    if (shoppingOrder.getNumber() == null || !shoppingOrder.getNumber().equals(number)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])finderArgs, (Object)shoppingOrder);
                    }
                }
                ShoppingOrder shoppingOrder2 = shoppingOrder;
                return shoppingOrder2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_NUMBER, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingOrder)result;
    }

    public ShoppingOrder findByPPTxnId(String ppTxnId) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.fetchByPPTxnId(ppTxnId);
        if (shoppingOrder == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("ppTxnId=");
            msg.append(ppTxnId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchOrderException(msg.toString());
        }
        return shoppingOrder;
    }

    public ShoppingOrder fetchByPPTxnId(String ppTxnId) throws SystemException {
        return this.fetchByPPTxnId(ppTxnId, true);
    }

    public ShoppingOrder fetchByPPTxnId(String ppTxnId, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{ppTxnId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
            if (ppTxnId == null) {
                query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_1);
            } else if (ppTxnId.equals("")) {
                query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_3);
            } else {
                query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_2);
            }
            query.append(" ORDER BY shoppingOrder.createDate DESC");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (ppTxnId != null) {
                    qPos.add(ppTxnId);
                }
                List list = q.list();
                result = list;
                ShoppingOrder shoppingOrder = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])finderArgs, (Object)list);
                } else {
                    shoppingOrder = (ShoppingOrder)list.get(0);
                    this.cacheResult(shoppingOrder);
                    if (shoppingOrder.getPpTxnId() == null || !shoppingOrder.getPpTxnId().equals(ppTxnId)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])finderArgs, (Object)shoppingOrder);
                    }
                }
                ShoppingOrder shoppingOrder2 = shoppingOrder;
                return shoppingOrder2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_PPTXNID, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingOrder)result;
    }

    public List<ShoppingOrder> findByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) throws SystemException {
        return this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, -1, -1, null);
    }

    public List<ShoppingOrder> findByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end) throws SystemException {
        return this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, start, end, null);
    }

    public List<ShoppingOrder> findByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, userId, ppPaymentStatus, String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_G_U_PPPS, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
            query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
            query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
            query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
            if (ppPaymentStatus == null) {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1);
            } else if (ppPaymentStatus.equals("")) {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
            } else {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY shoppingOrder.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(userId);
                    if (ppPaymentStatus != null) {
                        qPos.add(ppPaymentStatus);
                    }
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_BY_G_U_PPPS, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_G_U_PPPS, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingOrder findByG_U_PPPS_First(long groupId, long userId, String ppPaymentStatus, OrderByComparator orderByComparator) throws NoSuchOrderException, SystemException {
        List<ShoppingOrder> list = this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, 0, 1, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(8);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", userId=");
            msg.append(userId);
            msg.append(", ppPaymentStatus=");
            msg.append(ppPaymentStatus);
            msg.append("}");
            throw new NoSuchOrderException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingOrder findByG_U_PPPS_Last(long groupId, long userId, String ppPaymentStatus, OrderByComparator orderByComparator) throws NoSuchOrderException, SystemException {
        int count = this.countByG_U_PPPS(groupId, userId, ppPaymentStatus);
        List<ShoppingOrder> list = this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, count - 1, count, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(8);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", userId=");
            msg.append(userId);
            msg.append(", ppPaymentStatus=");
            msg.append(ppPaymentStatus);
            msg.append("}");
            throw new NoSuchOrderException(msg.toString());
        }
        return list.get(0);
    }

    public ShoppingOrder[] findByG_U_PPPS_PrevAndNext(long orderId, long groupId, long userId, String ppPaymentStatus, OrderByComparator orderByComparator) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.findByPrimaryKey(orderId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrder[] array = new ShoppingOrderImpl[]{this.getByG_U_PPPS_PrevAndNext(session, shoppingOrder, groupId, userId, ppPaymentStatus, orderByComparator, true), shoppingOrder, this.getByG_U_PPPS_PrevAndNext(session, shoppingOrder, groupId, userId, ppPaymentStatus, orderByComparator, false)};
            ShoppingOrder[] shoppingOrderArray = array;
            return shoppingOrderArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrder getByG_U_PPPS_PrevAndNext(Session session, ShoppingOrder shoppingOrder, long groupId, long userId, String ppPaymentStatus, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGORDER_WHERE);
        query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
        query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
        if (ppPaymentStatus == null) {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1);
        } else if (ppPaymentStatus.equals("")) {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
        } else {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
        }
        if (orderByComparator != null) {
            String[] orderByFields = orderByComparator.getOrderByFields();
            if (orderByFields.length > 0) {
                query.append(" AND ");
            }
            int i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i;
            }
            query.append(" ORDER BY ");
            i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i;
            }
        } else {
            query.append(" ORDER BY shoppingOrder.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(userId);
        if (ppPaymentStatus != null) {
            qPos.add(ppPaymentStatus);
        }
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByValues((Object)shoppingOrder);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingOrder)list.get(1);
        }
        return null;
    }

    public List<ShoppingOrder> filterFindByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) throws SystemException {
        return this.filterFindByG_U_PPPS(groupId, userId, ppPaymentStatus, -1, -1, null);
    }

    public List<ShoppingOrder> filterFindByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end) throws SystemException {
        return this.filterFindByG_U_PPPS(groupId, userId, ppPaymentStatus, start, end, null);
    }

    public List<ShoppingOrder> filterFindByG_U_PPPS(long groupId, long userId, String ppPaymentStatus, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_U_PPPS(groupId, userId, ppPaymentStatus, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
        query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
        if (ppPaymentStatus == null) {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1);
        } else if (ppPaymentStatus.equals("")) {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
        } else {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGORDER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingOrder.createDate DESC");
        } else {
            query.append(" ORDER BY ShoppingOrder.createDate DESC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingOrder.class.getName(), (String)_FILTER_COLUMN_PK, (String)_FILTER_COLUMN_USERID, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingOrderImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, ShoppingOrderImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(userId);
            if (ppPaymentStatus != null) {
                qPos.add(ppPaymentStatus);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingOrder> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingOrder> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<ShoppingOrder> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_SHOPPINGORDER);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGORDER.concat(" ORDER BY shoppingOrder.createDate DESC");
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (orderByComparator == null) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByGroupId(long groupId) throws SystemException {
        for (ShoppingOrder shoppingOrder : this.findByGroupId(groupId)) {
            this.remove((BaseModel)shoppingOrder);
        }
    }

    public void removeByNumber(String number) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.findByNumber(number);
        this.remove((BaseModel)shoppingOrder);
    }

    public void removeByPPTxnId(String ppTxnId) throws NoSuchOrderException, SystemException {
        ShoppingOrder shoppingOrder = this.findByPPTxnId(ppTxnId);
        this.remove((BaseModel)shoppingOrder);
    }

    public void removeByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) throws SystemException {
        for (ShoppingOrder shoppingOrder : this.findByG_U_PPPS(groupId, userId, ppPaymentStatus)) {
            this.remove((BaseModel)shoppingOrder);
        }
    }

    public void removeAll() throws SystemException {
        for (ShoppingOrder shoppingOrder : this.findAll()) {
            this.remove((BaseModel)shoppingOrder);
        }
    }

    public int countByGroupId(long groupId) throws SystemException {
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByGroupId(long groupId) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByGroupId(groupId);
        }
        StringBundler query = new StringBundler(2);
        query.append(_FILTER_SQL_COUNT_SHOPPINGORDER_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingOrder.class.getName(), (String)_FILTER_COLUMN_PK, (String)_FILTER_COLUMN_USERID, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByNumber(String number) throws SystemException {
        Object[] finderArgs = new Object[]{number};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_NUMBER, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
            if (number == null) {
                query.append(_FINDER_COLUMN_NUMBER_NUMBER_1);
            } else if (number.equals("")) {
                query.append(_FINDER_COLUMN_NUMBER_NUMBER_3);
            } else {
                query.append(_FINDER_COLUMN_NUMBER_NUMBER_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (number != null) {
                        qPos.add(number);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_NUMBER, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByPPTxnId(String ppTxnId) throws SystemException {
        Object[] finderArgs = new Object[]{ppTxnId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_PPTXNID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
            if (ppTxnId == null) {
                query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_1);
            } else if (ppTxnId.equals("")) {
                query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_3);
            } else {
                query.append(_FINDER_COLUMN_PPTXNID_PPTXNID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (ppTxnId != null) {
                        qPos.add(ppTxnId);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_PPTXNID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, userId, ppPaymentStatus};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_G_U_PPPS, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_SHOPPINGORDER_WHERE);
            query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
            query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
            if (ppPaymentStatus == null) {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1);
            } else if (ppPaymentStatus.equals("")) {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
            } else {
                query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(userId);
                    if (ppPaymentStatus != null) {
                        qPos.add(ppPaymentStatus);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_U_PPPS, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByG_U_PPPS(long groupId, long userId, String ppPaymentStatus) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByG_U_PPPS(groupId, userId, ppPaymentStatus);
        }
        StringBundler query = new StringBundler(4);
        query.append(_FILTER_SQL_COUNT_SHOPPINGORDER_WHERE);
        query.append(_FINDER_COLUMN_G_U_PPPS_GROUPID_2);
        query.append(_FINDER_COLUMN_G_U_PPPS_USERID_2);
        if (ppPaymentStatus == null) {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_1);
        } else if (ppPaymentStatus.equals("")) {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_3);
        } else {
            query.append(_FINDER_COLUMN_G_U_PPPS_PPPAYMENTSTATUS_2);
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingOrder.class.getName(), (String)_FILTER_COLUMN_PK, (String)_FILTER_COLUMN_USERID, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(userId);
            if (ppPaymentStatus != null) {
                qPos.add(ppPaymentStatus);
            }
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_SHOPPINGORDER);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.shopping.model.ShoppingOrder")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)ShoppingOrderImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST);
    }
}

