/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.util.PublicRenderParameterConfiguration;
import com.liferay.portlet.portletconfiguration.util.PublicRenderParameterIdentifierComparator;
import com.liferay.portlet.portletconfiguration.util.PublicRenderParameterIdentifierConfigurationComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public class ActionUtil {
    public static void getLayoutPublicRenderParameters(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        HashSet<String> identifiers = new HashSet<String>();
        TreeSet<PublicRenderParameter> publicRenderParameters = new TreeSet<PublicRenderParameter>(new PublicRenderParameterIdentifierComparator());
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        List portlets = layoutTypePortlet.getAllPortlets();
        for (Portlet portlet : portlets) {
            for (PublicRenderParameter publicRenderParameter : portlet.getPublicRenderParameters()) {
                if (identifiers.contains(publicRenderParameter.getIdentifier())) continue;
                identifiers.add(publicRenderParameter.getIdentifier());
                publicRenderParameters.add(publicRenderParameter);
            }
        }
        portletRequest.setAttribute("PUBLIC_RENDER_PARAMETERS", publicRenderParameters);
    }

    public static void getPublicRenderParameterConfigurationList(PortletRequest portletRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portlet.getPortletId());
        ArrayList<PublicRenderParameterConfiguration> publicRenderParameterConfigurations = new ArrayList<PublicRenderParameterConfiguration>();
        for (PublicRenderParameter publicRenderParameter : portlet.getPublicRenderParameters()) {
            String mappingKey = PublicRenderParameterConfiguration.getMappingKey(publicRenderParameter);
            String ignoreKey = PublicRenderParameterConfiguration.getIgnoreKey(publicRenderParameter);
            String mappingValue = null;
            boolean ignoreValue = false;
            if (SessionErrors.isEmpty((PortletRequest)portletRequest)) {
                mappingValue = preferences.getValue(mappingKey, null);
                ignoreValue = GetterUtil.getBoolean((String)preferences.getValue(ignoreKey, null));
            } else {
                mappingValue = ParamUtil.getString((PortletRequest)portletRequest, (String)mappingKey);
                ignoreValue = GetterUtil.getBoolean((String)ParamUtil.getString((PortletRequest)portletRequest, (String)ignoreKey));
            }
            publicRenderParameterConfigurations.add(new PublicRenderParameterConfiguration(publicRenderParameter, mappingValue, ignoreValue));
        }
        Collections.sort(publicRenderParameterConfigurations, new PublicRenderParameterIdentifierConfigurationComparator());
        portletRequest.setAttribute("PUBLIC_RENDER_PARAMETER_CONFIGURATIONS", publicRenderParameterConfigurations);
    }
}

