/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.documentlibrary.DuplicateDirectoryException;
import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CompanyConstants;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.SplitThreadException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageFlag;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.base.MBThreadLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBThreadLocalServiceImpl
extends MBThreadLocalServiceBaseImpl {
    public void deleteThread(long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        this.deleteThread(thread);
    }

    public void deleteThread(MBThread thread) throws PortalException, SystemException {
        MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
        Indexer indexer = IndexerRegistryUtil.getIndexer(MBMessage.class);
        indexer.delete((Object)thread);
        long companyId = rootMessage.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long repositoryId = 0L;
        String dirName = thread.getAttachmentsDir();
        try {
            this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {}
        List messages = this.mbMessagePersistence.findByThreadId(thread.getThreadId());
        for (MBMessage message : messages) {
            this.socialActivityLocalService.deleteActivities(MBMessage.class.getName(), message.getMessageId());
            this.ratingsStatsLocalService.deleteStats(MBMessage.class.getName(), message.getMessageId());
            this.assetEntryLocalService.deleteEntry(MBMessage.class.getName(), message.getMessageId());
            if (!message.isDiscussion()) {
                this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), message.getUserId());
            }
            this.mbMessageFlagPersistence.removeByMessageId(message.getMessageId());
            if (!message.isDiscussion()) {
                this.resourceLocalService.deleteResource(message.getCompanyId(), MBMessage.class.getName(), 4, message.getMessageId());
            }
            this.mbMessagePersistence.remove((BaseModel)message);
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(message.getCompanyId(), message.getGroupId(), message.getWorkflowClassName(), message.getMessageId());
        }
        if (rootMessage.getCategoryId() != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && rootMessage.getCategoryId() != MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
            MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(thread.getCategoryId());
            category.setThreadCount(category.getThreadCount() - 1);
            category.setMessageCount(category.getMessageCount() - messages.size());
            this.mbCategoryPersistence.update((BaseModel)category, false);
        }
        this.mbThreadPersistence.remove((BaseModel)thread);
    }

    public void deleteThreads(long groupId, long categoryId) throws PortalException, SystemException {
        List threads = this.mbThreadPersistence.findByG_C(groupId, categoryId);
        for (MBThread thread : threads) {
            this.deleteThread(thread);
        }
    }

    public int getCategoryThreadsCount(long groupId, long categoryId, int status) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_C(groupId, categoryId);
        }
        return this.mbThreadPersistence.countByG_C_S(groupId, categoryId, status);
    }

    public List<MBThread> getGroupThreads(long groupId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.findByG_NotC(groupId, MBCategoryConstants.DISCUSSION_CATEGORY_ID, start, end);
        }
        return this.mbThreadPersistence.findByG_NotC_S(groupId, MBCategoryConstants.DISCUSSION_CATEGORY_ID, status, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous, int start, int end) throws PortalException, SystemException {
        if (userId <= 0L) {
            if (status == -1) {
                return this.mbThreadPersistence.findByG_NotC(groupId, MBCategoryConstants.DISCUSSION_CATEGORY_ID, start, end);
            }
            return this.mbThreadPersistence.findByG_NotC_S(groupId, MBCategoryConstants.DISCUSSION_CATEGORY_ID, status, start, end);
        }
        if (subscribed) {
            return this.mbThreadFinder.findByS_G_U_C_S(groupId, userId, null, status, start, end);
        }
        List threadIds = null;
        threadIds = includeAnonymous ? this.mbMessageFinder.findByG_U_C_S(groupId, userId, null, status, start, end) : this.mbMessageFinder.findByG_U_C_A_S(groupId, userId, null, false, status, start, end);
        ArrayList<MBThread> threads = new ArrayList<MBThread>(threadIds.size());
        Iterator iterator = threadIds.iterator();
        while (iterator.hasNext()) {
            long threadId = (Long)iterator.next();
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
            threads.add(thread);
        }
        return threads;
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, int start, int end) throws PortalException, SystemException {
        return this.getGroupThreads(groupId, userId, status, subscribed, true, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, int start, int end) throws PortalException, SystemException {
        return this.getGroupThreads(groupId, userId, status, false, start, end);
    }

    public int getGroupThreadsCount(long groupId, int status) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_NotC(groupId, MBCategoryConstants.DISCUSSION_CATEGORY_ID);
        }
        return this.mbThreadPersistence.countByG_NotC_S(groupId, MBCategoryConstants.DISCUSSION_CATEGORY_ID, status);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, status, false);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, status, subscribed, true);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous) throws SystemException {
        if (userId <= 0L) {
            if (status == -1) {
                return this.mbThreadPersistence.countByG_NotC(groupId, MBCategoryConstants.DISCUSSION_CATEGORY_ID);
            }
            return this.mbThreadPersistence.countByG_NotC_S(groupId, MBCategoryConstants.DISCUSSION_CATEGORY_ID, status);
        }
        if (subscribed) {
            return this.mbThreadFinder.countByS_G_U_C_S(groupId, userId, null, status);
        }
        if (includeAnonymous) {
            return this.mbMessageFinder.countByG_U_C_S(groupId, userId, null, status);
        }
        return this.mbMessageFinder.countByG_U_C_A_S(groupId, userId, null, false, status);
    }

    public List<MBThread> getPriorityThreads(long categoryId, double priority) throws PortalException, SystemException {
        return this.getPriorityThreads(categoryId, priority, false);
    }

    public List<MBThread> getPriorityThreads(long categoryId, double priority, boolean inherit) throws PortalException, SystemException {
        if (!inherit) {
            return this.mbThreadPersistence.findByC_P(categoryId, priority);
        }
        ArrayList<MBThread> threads = new ArrayList<MBThread>();
        while (categoryId != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && categoryId != MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
            threads.addAll(0, this.mbThreadPersistence.findByC_P(categoryId, priority));
            MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
            categoryId = category.getParentCategoryId();
        }
        return threads;
    }

    public MBThread getThread(long threadId) throws PortalException, SystemException {
        return this.mbThreadPersistence.findByPrimaryKey(threadId);
    }

    public List<MBThread> getThreads(long groupId, long categoryId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.findByG_C(groupId, categoryId, start, end);
        }
        return this.mbThreadPersistence.findByG_C_S(groupId, categoryId, status, start, end);
    }

    public int getThreadsCount(long groupId, long categoryId, int status) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_C(groupId, categoryId);
        }
        return this.mbThreadPersistence.countByG_C_S(groupId, categoryId, status);
    }

    public MBThread moveThread(long groupId, long categoryId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        long oldCategoryId = thread.getCategoryId();
        MBCategory oldCategory = null;
        if (oldCategoryId != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID) {
            oldCategory = this.mbCategoryPersistence.findByPrimaryKey(oldCategoryId);
        }
        MBCategory category = null;
        if (categoryId != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID) {
            category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        }
        List messages = this.mbMessagePersistence.findByG_C_T(groupId, oldCategoryId, thread.getThreadId());
        for (MBMessage message : messages) {
            message.setCategoryId(categoryId);
            this.mbMessagePersistence.update((BaseModel)message, false);
            if (message.isDiscussion()) continue;
            Indexer indexer = IndexerRegistryUtil.getIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        thread.setCategoryId(categoryId);
        this.mbThreadPersistence.update((BaseModel)thread, false);
        if (oldCategory != null) {
            oldCategory.setThreadCount(oldCategory.getThreadCount() - 1);
            oldCategory.setMessageCount(oldCategory.getMessageCount() - messages.size());
            this.mbCategoryPersistence.update((BaseModel)oldCategory, false);
        }
        if (category != null) {
            category.setThreadCount(category.getThreadCount() + 1);
            category.setMessageCount(category.getMessageCount() + messages.size());
            this.mbCategoryPersistence.update((BaseModel)category, false);
        }
        return thread;
    }

    public MBThread splitThread(long messageId, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        if (message.isRoot()) {
            throw new SplitThreadException();
        }
        MBCategory category = message.getCategory();
        MBThread oldThread = message.getThread();
        MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(oldThread.getRootMessageId());
        String oldAttachmentsDir = message.getAttachmentsDir();
        this.mbMessageFlagLocalService.deleteAnswerFlags(oldThread.getThreadId(), message.getMessageId());
        int count = this.mbMessageFlagPersistence.countByT_F(oldThread.getThreadId(), 3);
        if (count == 1) {
            MBMessageFlag messageFlag = this.mbMessageFlagPersistence.fetchByU_M_F(rootMessage.getUserId(), rootMessage.getMessageId(), 3);
            messageFlag.setFlag(2);
            this.mbMessageFlagPersistence.update((BaseModel)messageFlag, false);
        }
        MBThread thread = this.addThread(message.getCategoryId(), message);
        message.setThreadId(thread.getThreadId());
        message.setRootMessageId(thread.getRootMessageId());
        message.setParentMessageId(0L);
        message.setAttachmentsDir(null);
        this.mbMessagePersistence.update((BaseModel)message, false);
        this.moveAttachmentsFromOldThread(message, oldAttachmentsDir);
        if (!message.isDiscussion()) {
            Indexer indexer = IndexerRegistryUtil.getIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        int messagesMoved = 1;
        thread.setMessageCount(messagesMoved += this.moveChildrenMessages(message, category, oldThread.getThreadId()));
        this.mbThreadPersistence.update((BaseModel)thread, false);
        oldThread.setMessageCount(oldThread.getMessageCount() - messagesMoved);
        this.mbThreadPersistence.update((BaseModel)oldThread, false);
        if (message.getCategoryId() != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && message.getCategoryId() != MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
            category.setThreadCount(category.getThreadCount() + 1);
            this.mbCategoryPersistence.update((BaseModel)category, false);
        }
        return thread;
    }

    public MBThread updateThread(long threadId, int viewCount) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        thread.setViewCount(viewCount);
        this.mbThreadPersistence.update((BaseModel)thread, false);
        return thread;
    }

    protected MBThread addThread(long categoryId, MBMessage message) throws SystemException {
        long threadId = this.counterLocalService.increment();
        MBThread thread = this.mbThreadPersistence.create(threadId);
        thread.setGroupId(message.getGroupId());
        thread.setCategoryId(categoryId);
        thread.setRootMessageId(message.getMessageId());
        thread.setStatus(message.getStatus());
        thread.setStatusByUserId(message.getStatusByUserId());
        thread.setStatusByUserName(message.getStatusByUserName());
        thread.setStatusDate(message.getStatusDate());
        thread.setMessageCount(thread.getMessageCount() + 1);
        if (message.isAnonymous()) {
            thread.setLastPostByUserId(0L);
        } else {
            thread.setLastPostByUserId(message.getUserId());
        }
        thread.setLastPostDate(message.getCreateDate());
        if (message.getPriority() != -1.0) {
            thread.setPriority(message.getPriority());
        }
        this.mbThreadPersistence.update((BaseModel)thread, false);
        return thread;
    }

    protected void moveAttachmentsFromOldThread(MBMessage message, String oldAttachmentsDir) throws PortalException, SystemException {
        String[] fileNames;
        if (!message.getAttachments()) {
            return;
        }
        long companyId = message.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long groupId = 0L;
        long repositoryId = 0L;
        String newAttachmentsDir = message.getAttachmentsDir();
        try {
            this.dlService.addDirectory(companyId, repositoryId, newAttachmentsDir);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        String[] stringArray = fileNames = this.dlService.getFileNames(companyId, repositoryId, oldAttachmentsDir);
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            String name = StringUtil.extractLast((String)fileName, (String)"/");
            byte[] fileBytes = this.dlService.getFile(companyId, repositoryId, fileName);
            this.dlService.addFile(companyId, portletId, groupId, repositoryId, String.valueOf(newAttachmentsDir) + "/" + name, 0L, "", message.getModifiedDate(), new ServiceContext(), fileBytes);
            this.dlService.deleteFile(companyId, portletId, repositoryId, fileName);
            ++n2;
        }
        try {
            this.dlService.deleteDirectory(companyId, portletId, repositoryId, oldAttachmentsDir);
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {}
    }

    protected int moveChildrenMessages(MBMessage parentMessage, MBCategory category, long oldThreadId) throws SystemException, PortalException {
        int messagesMoved = 0;
        List messages = this.mbMessagePersistence.findByT_P(oldThreadId, parentMessage.getMessageId());
        for (MBMessage message : messages) {
            String oldAttachmentsDir = message.getAttachmentsDir();
            message.setCategoryId(parentMessage.getCategoryId());
            message.setThreadId(parentMessage.getThreadId());
            message.setRootMessageId(parentMessage.getRootMessageId());
            message.setAttachmentsDir(null);
            this.mbMessagePersistence.update((BaseModel)message, false);
            this.moveAttachmentsFromOldThread(message, oldAttachmentsDir);
            if (!message.isDiscussion()) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(MBMessage.class);
                indexer.reindex((Object)message);
            }
            ++messagesMoved;
            messagesMoved += this.moveChildrenMessages(message, category, oldThreadId);
        }
        return messagesMoved;
    }
}

