/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFeedLocalServiceUtil;
import com.liferay.portlet.journal.util.JournalRSSUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.io.FeedException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class RSSAction
extends PortletAction {
    private static final String _XML_REQUUEST = "<request><parameters><parameter><name>rss</name><value>true</value></parameter></parameters></request>";
    private static Log _log = LogFactoryUtil.getLog(RSSAction.class);

    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        resourceResponse.setContentType("text/xml; charset=UTF-8");
        OutputStream os = resourceResponse.getPortletOutputStream();
        try {
            os.write(this.getRSS(resourceRequest, resourceResponse));
        }
        finally {
            os.close();
        }
    }

    protected String exportToRSS(ResourceRequest resourceRequest, ResourceResponse resourceResponse, JournalFeed feed, String languageId, Layout layout, ThemeDisplay themeDisplay) throws Exception {
        ResourceURL feedURL = resourceResponse.createResourceURL();
        feedURL.setCacheability("cacheLevelFull");
        feedURL.setParameter("struts_action", "/journal/rss");
        feedURL.setParameter("groupId", String.valueOf(feed.getGroupId()));
        feedURL.setParameter("feedId", String.valueOf(feed.getFeedId()));
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setFeedType(String.valueOf(feed.getFeedType()) + "_" + feed.getFeedVersion());
        syndFeed.setTitle(feed.getName());
        syndFeed.setLink(feedURL.toString());
        syndFeed.setDescription(feed.getDescription());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(entries);
        List<JournalArticle> articles = JournalRSSUtil.getArticles(feed);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Syndicating " + articles.size() + " articles"));
        }
        for (JournalArticle article : articles) {
            String value;
            SyndContentImpl syndContent;
            SyndEntryImpl syndEntry;
            block6: {
                String author = HtmlUtil.escape((String)PortalUtil.getUserName((long)article.getUserId(), (String)article.getUserName()));
                String link = this.getEntryURL(resourceRequest, feed, article, layout, themeDisplay);
                syndEntry = new SyndEntryImpl();
                syndEntry.setAuthor(author);
                syndEntry.setTitle(article.getTitle());
                syndEntry.setLink(link);
                syndEntry.setUri(syndEntry.getLink());
                syndEntry.setPublishedDate(article.getDisplayDate());
                syndEntry.setUpdatedDate(article.getModifiedDate());
                syndContent = new SyndContentImpl();
                value = article.getDescription();
                try {
                    value = this.processContent(feed, article, languageId, themeDisplay, (SyndEntry)syndEntry, (SyndContent)syndContent);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
            syndContent.setType("html");
            syndContent.setValue(value);
            syndEntry.setDescription((SyndContent)syndContent);
            entries.add(syndEntry);
        }
        try {
            return RSSUtil.export((SyndFeed)syndFeed);
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
    }

    protected String getEntryURL(ResourceRequest resourceRequest, JournalFeed feed, JournalArticle article, Layout layout, ThemeDisplay themeDisplay) throws Exception {
        List hitLayoutIds = JournalContentSearchLocalServiceUtil.getLayoutIds((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (String)article.getArticleId());
        if (hitLayoutIds.size() > 0) {
            Long hitLayoutId = (Long)hitLayoutIds.get(0);
            Layout hitLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)hitLayoutId);
            return PortalUtil.getLayoutFriendlyURL((Layout)hitLayout, (ThemeDisplay)themeDisplay);
        }
        long plid = PortalUtil.getPlidFromFriendlyURL((long)feed.getCompanyId(), (String)feed.getTargetLayoutFriendlyUrl());
        String portletId = "56";
        if (Validator.isNotNull((String)feed.getTargetPortletId())) {
            portletId = feed.getTargetPortletId();
        }
        PortletURLImpl entryURL = new PortletURLImpl((PortletRequestImpl)resourceRequest, portletId, plid, "RENDER_PHASE");
        entryURL.setParameter("struts_action", "/journal_content/view");
        entryURL.setParameter("groupId", String.valueOf(article.getGroupId()));
        entryURL.setParameter("articleId", article.getArticleId());
        return entryURL.toString();
    }

    protected byte[] getRSS(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("THEME_DISPLAY");
        JournalFeed feed = null;
        long id = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"id");
        long groupId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"groupId");
        String feedId = ParamUtil.getString((PortletRequest)resourceRequest, (String)"feedId");
        feed = id > 0L ? JournalFeedLocalServiceUtil.getFeed((long)id) : JournalFeedLocalServiceUtil.getFeed((long)groupId, (String)feedId);
        String languageId = LanguageUtil.getLanguageId((PortletRequest)resourceRequest);
        long plid = PortalUtil.getPlidFromFriendlyURL((long)themeDisplay.getCompanyId(), (String)feed.getTargetLayoutFriendlyUrl());
        Layout layout = themeDisplay.getLayout();
        if (plid > 0L) {
            try {
                layout = LayoutLocalServiceUtil.getLayout((long)plid);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
        String rss = this.exportToRSS(resourceRequest, resourceResponse, feed, languageId, layout, themeDisplay);
        return rss.getBytes("UTF-8");
    }

    protected String processContent(JournalFeed feed, JournalArticle article, String languageId, ThemeDisplay themeDisplay, SyndEntry syndEntry, SyndContent syndContent) throws Exception {
        String content = article.getDescription();
        String contentField = feed.getContentField();
        if (contentField.equals("rendered-web-content")) {
            JournalArticleDisplay articleDisplay;
            String rendererTemplateId = article.getTemplateId();
            if (Validator.isNotNull((String)feed.getRendererTemplateId())) {
                rendererTemplateId = feed.getRendererTemplateId();
            }
            if ((articleDisplay = JournalContentUtil.getDisplay((long)feed.getGroupId(), (String)article.getArticleId(), (String)rendererTemplateId, null, (String)languageId, (ThemeDisplay)themeDisplay, (int)1, (String)_XML_REQUUEST)) != null) {
                content = articleDisplay.getContent();
            }
        } else if (!contentField.equals("web-content-description")) {
            Document doc = SAXReaderUtil.read((String)article.getContent());
            XPath xpathSelector = SAXReaderUtil.createXPath((String)("//dynamic-element[@name='" + contentField + "']"));
            List results = xpathSelector.selectNodes((Object)doc);
            if (results.size() == 0) {
                return content;
            }
            Element el = (Element)results.get(0);
            String elType = el.attributeValue("type");
            if (elType.equals("document_library")) {
                String url = el.elementText("dynamic-content");
                url = this.processURL(feed, url, themeDisplay, syndEntry);
            } else if (elType.equals("image") || elType.equals("image_gallery")) {
                String url = el.elementText("dynamic-content");
                url = this.processURL(feed, url, themeDisplay, syndEntry);
                content = String.valueOf(content) + "<br /><br /><img alt='' src='" + themeDisplay.getURLPortal() + url + "' />";
            } else if (elType.equals("text_box")) {
                syndContent.setType("text");
                content = el.elementText("dynamic-content");
            } else {
                content = el.elementText("dynamic-content");
            }
        }
        return content;
    }

    protected String processURL(JournalFeed feed, String url, ThemeDisplay themeDisplay, SyndEntry syndEntry) {
        url = StringUtil.replace((String)url, (String[])new String[]{"@group_id@", "@image_path@", "@main_path@"}, (String[])new String[]{String.valueOf(feed.getGroupId()), themeDisplay.getPathImage(), themeDisplay.getPathMain()});
        List<SyndLink> links = JournalRSSUtil.getDLLinks(themeDisplay.getURLPortal(), url);
        List<SyndEnclosure> enclosures = JournalRSSUtil.getDLEnclosures(themeDisplay.getURLPortal(), url);
        syndEntry.setLinks(links);
        syndEntry.setEnclosures(enclosures);
        return url;
    }
}

