/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GetTemplateAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            String templateId = this.getTemplateId(request);
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            Map<String, String> tokens = JournalUtil.getTokens(groupId, themeDisplay);
            tokens.put("template_id", templateId);
            String languageId = LanguageUtil.getLanguageId((HttpServletRequest)request);
            boolean transform = ParamUtil.get((HttpServletRequest)request, (String)"transform", (boolean)true);
            JournalTemplate template = JournalTemplateLocalServiceUtil.getTemplate((long)groupId, (String)templateId);
            String script = JournalUtil.getTemplateScript(template, tokens, languageId, transform);
            String extension = "vm";
            if (template.getLangType() != null) {
                extension = template.getLangType();
            }
            String fileName = null;
            byte[] bytes = script.getBytes();
            String contentType = "text/plain; charset=UTF-8";
            if (Validator.equals((Object)extension, (Object)"css")) {
                contentType = "text/css; charset=UTF-8";
            } else if (Validator.equals((Object)extension, (Object)"xsl")) {
                contentType = "text/xml; charset=UTF-8";
            }
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, fileName, (byte[])bytes, (String)contentType);
            return null;
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected String getTemplateId(HttpServletRequest request) {
        String templateId = ParamUtil.getString((HttpServletRequest)request, (String)"templateId");
        if (Validator.isNull((String)templateId)) {
            templateId = ParamUtil.getString((HttpServletRequest)request, (String)"template_id");
        }
        return templateId;
    }
}

