/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.action;

import com.liferay.portal.DuplicatePasswordPolicyException;
import com.liferay.portal.NoSuchPasswordPolicyException;
import com.liferay.portal.PasswordPolicyNameException;
import com.liferay.portal.RequiredPasswordPolicyException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.PasswordPolicyServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.enterpriseadmin.action.ActionUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditPasswordPolicyAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updatePasswordPolicy(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deletePasswordPolicy(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.enterprise_admin.error");
            }
            if (e instanceof DuplicatePasswordPolicyException || e instanceof PasswordPolicyNameException || e instanceof NoSuchPasswordPolicyException || e instanceof RequiredPasswordPolicyException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                if (cmd.equals("delete")) {
                    actionResponse.sendRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                }
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getPasswordPolicy((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchPasswordPolicyException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.enterprise_admin.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.enterprise_admin.edit_password_policy"));
    }

    protected void deletePasswordPolicy(ActionRequest actionRequest) throws Exception {
        long passwordPolicyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"passwordPolicyId");
        PasswordPolicyServiceUtil.deletePasswordPolicy((long)passwordPolicyId);
    }

    protected void updatePasswordPolicy(ActionRequest actionRequest) throws Exception {
        long passwordPolicyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"passwordPolicyId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        boolean changeable = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"changeable");
        boolean changeRequired = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"changeRequired");
        long minAge = ParamUtil.getLong((PortletRequest)actionRequest, (String)"minAge");
        boolean checkSyntax = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"checkSyntax");
        boolean allowDictionaryWords = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowDictionaryWords");
        int minAlphanumeric = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minAlphanumeric");
        int minLength = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minLength");
        int minLowerCase = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minLowerCase");
        int minNumbers = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minNumbers");
        int minSymbols = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minSymbols");
        int minUpperCase = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minUpperCase");
        boolean history = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"history");
        int historyCount = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"historyCount");
        boolean expireable = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"expireable");
        long maxAge = ParamUtil.getLong((PortletRequest)actionRequest, (String)"maxAge");
        long warningTime = ParamUtil.getLong((PortletRequest)actionRequest, (String)"warningTime");
        int graceLimit = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"graceLimit");
        boolean lockout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"lockout");
        int maxFailure = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"maxFailure");
        long lockoutDuration = ParamUtil.getLong((PortletRequest)actionRequest, (String)"lockoutDuration");
        long resetFailureCount = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resetFailureCount");
        long resetTicketMaxAge = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resetTicketMaxAge");
        if (passwordPolicyId <= 0L) {
            PasswordPolicyServiceUtil.addPasswordPolicy((String)name, (String)description, (boolean)changeable, (boolean)changeRequired, (long)minAge, (boolean)checkSyntax, (boolean)allowDictionaryWords, (int)minAlphanumeric, (int)minLength, (int)minLowerCase, (int)minNumbers, (int)minSymbols, (int)minUpperCase, (boolean)history, (int)historyCount, (boolean)expireable, (long)maxAge, (long)warningTime, (int)graceLimit, (boolean)lockout, (int)maxFailure, (long)lockoutDuration, (long)resetFailureCount, (long)resetTicketMaxAge);
        } else {
            PasswordPolicyServiceUtil.updatePasswordPolicy((long)passwordPolicyId, (String)name, (String)description, (boolean)changeable, (boolean)changeRequired, (long)minAge, (boolean)checkSyntax, (boolean)allowDictionaryWords, (int)minAlphanumeric, (int)minLength, (int)minLowerCase, (int)minNumbers, (int)minSymbols, (int)minUpperCase, (boolean)history, (int)historyCount, (boolean)expireable, (long)maxAge, (long)warningTime, (int)graceLimit, (boolean)lockout, (int)maxFailure, (long)lockoutDuration, (long)resetFailureCount, (long)resetTicketMaxAge);
        }
    }
}

