/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.util;

import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.calendar.model.CalEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

public class CalUtil {
    public static String getEmailFromAddress(PortletPreferences preferences) {
        String emailFromAddress = PropsUtil.get("calendar.email.from.address");
        return preferences.getValue("email-from-address", emailFromAddress);
    }

    public static String getEmailFromName(PortletPreferences preferences) {
        String emailFromName = PropsUtil.get("calendar.email.from.name");
        return preferences.getValue("email-from-name", emailFromName);
    }

    public static boolean getEmailEventReminderEnabled(PortletPreferences preferences) {
        String emailEventReminderEnabled = preferences.getValue("email-event-reminder-enabled", "");
        if (Validator.isNotNull((String)emailEventReminderEnabled)) {
            return GetterUtil.getBoolean((String)emailEventReminderEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("calendar.email.event.reminder.enabled"));
    }

    public static String getEmailEventReminderBody(PortletPreferences preferences) {
        String emailEventReminderBody = preferences.getValue("email-event-reminder-body", "");
        if (Validator.isNotNull((String)emailEventReminderBody)) {
            return emailEventReminderBody;
        }
        return ContentUtil.get(PropsUtil.get("calendar.email.event.reminder.body"));
    }

    public static String getEmailEventReminderSubject(PortletPreferences preferences) {
        String emailEventReminderSubject = preferences.getValue("email-event-reminder-subject", "");
        if (Validator.isNotNull((String)emailEventReminderSubject)) {
            return emailEventReminderSubject;
        }
        return ContentUtil.get(PropsUtil.get("calendar.email.event.reminder.subject"));
    }

    public static Date getEndTime(CalEvent event) {
        long startTime = event.getStartDate().getTime();
        long endTime = startTime + 3600000L * (long)event.getDurationHour() + 60000L * (long)event.getDurationMinute();
        return new Date(endTime);
    }

    public static boolean isAllDay(CalEvent event, TimeZone timeZone, Locale locale) {
        Calendar cal = null;
        cal = event.getTimeZoneSensitive() ? CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale) : CalendarFactoryUtil.getCalendar();
        cal.setTime(event.getStartDate());
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int millisecond = cal.get(14);
        int dHour = event.getDurationHour();
        int dMinute = event.getDurationMinute();
        return hour == 0 && minute == 0 && second == 0 && millisecond == 0 && dHour == 24 && dMinute == 0;
    }

    public static String toString(Calendar cal) {
        StringBundler sb = new StringBundler(7);
        sb.append(cal.get(1));
        sb.append(".");
        sb.append(cal.get(2));
        sb.append(".");
        sb.append(cal.get(5));
        sb.append(".");
        sb.append(cal.getTimeZone().getRawOffset());
        return sb.toString();
    }
}

