/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.bookmarks.asset.BookmarksEntryAssetRenderer;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.bookmarks.service.permission.BookmarksPermission;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class BookmarksEntryAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = BookmarksEntry.class.getName();
    public static final String TYPE = "bookmark";

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        return new BookmarksEntryAssetRenderer(entry);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        LiferayPortletURL addAssetURL = null;
        if (BookmarksPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_ENTRY")) {
            addAssetURL = liferayPortletResponse.createRenderURL("28");
            addAssetURL.setParameter("struts_action", "/bookmarks/edit_entry");
            addAssetURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
            addAssetURL.setParameter("folderId", String.valueOf(AssetPublisherUtil.getRecentFolderId((PortletRequest)liferayPortletRequest, CLASS_NAME)));
        }
        return addAssetURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return BookmarksEntryPermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/ratings/star_hover.png";
    }
}

