/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.base.AssetTagServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetPermission;
import com.liferay.portlet.asset.service.permission.AssetTagPermission;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetTagServiceImpl
extends AssetTagServiceBaseImpl {
    public AssetTag addTag(String name, String[] tagProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_TAG");
        return this.assetTagLocalService.addTag(this.getUserId(), name, tagProperties, serviceContext);
    }

    public void deleteTag(long tagId) throws PortalException, SystemException {
        AssetTagPermission.check(this.getPermissionChecker(), tagId, "DELETE");
        this.assetTagLocalService.deleteTag(tagId);
    }

    public List<AssetTag> getGroupTags(long groupId) throws PortalException, SystemException {
        return this.filterTags(this.assetTagLocalService.getGroupTags(groupId));
    }

    public AssetTag getTag(long tagId) throws PortalException, SystemException {
        AssetTagPermission.check(this.getPermissionChecker(), tagId, "VIEW");
        return this.assetTagLocalService.getTag(tagId);
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name) throws PortalException, SystemException {
        return this.filterTags(this.assetTagLocalService.getTags(groupId, classNameId, name));
    }

    public List<AssetTag> getTags(String className, long classPK) throws PortalException, SystemException {
        return this.filterTags(this.assetTagLocalService.getTags(className, classPK));
    }

    public void mergeTags(long fromTagId, long toTagId) throws PortalException, SystemException {
        AssetTagPermission.check(this.getPermissionChecker(), fromTagId, "VIEW");
        AssetTagPermission.check(this.getPermissionChecker(), toTagId, "UPDATE");
        this.assetTagLocalService.mergeTags(fromTagId, toTagId);
    }

    public JSONArray search(long groupId, String name, String[] tagProperties, int start, int end) throws SystemException {
        return this.assetTagLocalService.search(groupId, name, tagProperties, start, end);
    }

    public AssetTag updateTag(long tagId, String name, String[] tagProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetTagPermission.check(this.getPermissionChecker(), tagId, "UPDATE");
        return this.assetTagLocalService.updateTag(this.getUserId(), tagId, name, tagProperties, serviceContext);
    }

    protected List<AssetTag> filterTags(List<AssetTag> tags) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        tags = ListUtil.copy(tags);
        Iterator itr = tags.iterator();
        while (itr.hasNext()) {
            AssetTag tag = (AssetTag)itr.next();
            if (AssetTagPermission.contains(permissionChecker, tag, "VIEW")) continue;
            itr.remove();
        }
        return tags;
    }
}

