/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.security.auth.AuthTokenUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.security.Key;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletURLImpl
implements LiferayPortletURL,
PortletURL,
ResourceURL,
Serializable {
    private static Log _log = LogFactoryUtil.getLog(PortletURLImpl.class);
    private boolean _anchor = true;
    private String _cacheability = "cacheLevelPage";
    private boolean _copyCurrentPublicRenderParameters;
    private boolean _copyCurrentRenderParameters;
    private long _doAsGroupId;
    private long _doAsUserId;
    private String _doAsUserLanguageId;
    private boolean _encrypt;
    private boolean _escapeXml = PropsValues.PORTLET_URL_ESCAPE_XML;
    private Layout _layout;
    private String _layoutFriendlyURL;
    private String _lifecycle;
    private String _namespace;
    private Set<String> _parametersIncludedInPath;
    private Map<String, String[]> _params;
    private long _plid;
    private Portlet _portlet;
    private String _portletId;
    private PortletMode _portletMode;
    private PortletRequest _portletRequest;
    private long _refererPlid;
    private Map<String, String[]> _removePublicRenderParameters;
    private HttpServletRequest _request;
    private Map<String, String> _reservedParameters;
    private String _resourceID;
    private boolean _secure;
    private String _toString;
    private WindowState _windowState;
    private boolean _wsrp;

    public PortletURLImpl(HttpServletRequest request, String portletId, long plid, String lifecycle) {
        this._request = request;
        this._portletId = portletId;
        this._plid = plid;
        this._lifecycle = lifecycle;
        this._parametersIncludedInPath = new LinkedHashSet<String>();
        this._params = new LinkedHashMap<String, String[]>();
        this._removePublicRenderParameters = new LinkedHashMap<String, String[]>();
        this._secure = request.isSecure();
        this._wsrp = ParamUtil.getBoolean((HttpServletRequest)request, (String)"wsrp");
        Portlet portlet = this.getPortlet();
        if (portlet != null) {
            PortletApp portletApp = portlet.getPortletApp();
            this._escapeXml = MapUtil.getBoolean((Map)portletApp.getContainerRuntimeOptions(), (String)"javax.portlet.escapeXml", (boolean)PropsValues.PORTLET_URL_ESCAPE_XML);
        }
    }

    public PortletURLImpl(PortletRequestImpl portletRequestImpl, String portletId, long plid, String lifecycle) {
        this(portletRequestImpl.getHttpServletRequest(), portletId, plid, lifecycle);
        this._portletRequest = portletRequestImpl;
    }

    public void addParameterIncludedInPath(String name) {
        this._parametersIncludedInPath.add(name);
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
    }

    public String getCacheability() {
        return this._cacheability;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    public Layout getLayout() {
        block4: {
            if (this._layout == null) {
                try {
                    if (this._plid > 0L) {
                        this._layout = LayoutLocalServiceUtil.getLayout((long)this._plid);
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)("Layout cannot be found for " + this._plid));
                }
            }
        }
        return this._layout;
    }

    public String getLayoutFriendlyURL() {
        return this._layoutFriendlyURL;
    }

    public String getLifecycle() {
        return this._lifecycle;
    }

    public String getNamespace() {
        if (this._namespace == null) {
            this._namespace = PortalUtil.getPortletNamespace((String)this._portletId);
        }
        return this._namespace;
    }

    public String getParameter(String name) {
        String[] values = this._params.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return this._params;
    }

    public Set<String> getParametersIncludedInPath() {
        return this._parametersIncludedInPath;
    }

    public long getPlid() {
        return this._plid;
    }

    public Portlet getPortlet() {
        if (this._portlet == null) {
            try {
                this._portlet = PortletLocalServiceUtil.getPortletById((long)PortalUtil.getCompanyId((HttpServletRequest)this._request), (String)this._portletId);
            }
            catch (SystemException se) {
                _log.error((Object)se.getMessage());
            }
        }
        return this._portlet;
    }

    public String getPortletFriendlyURLPath() {
        FriendlyURLMapper mapper;
        String portletFriendlyURLPath = null;
        Portlet portlet = this.getPortlet();
        if (portlet != null && (mapper = portlet.getFriendlyURLMapperInstance()) != null) {
            portletFriendlyURLPath = mapper.buildPath((LiferayPortletURL)this);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Portlet friendly URL path " + portletFriendlyURLPath));
            }
        }
        return portletFriendlyURLPath;
    }

    public String getPortletId() {
        return this._portletId;
    }

    public PortletMode getPortletMode() {
        return this._portletMode;
    }

    public PortletRequest getPortletRequest() {
        return this._portletRequest;
    }

    public Map<String, String> getReservedParameterMap() {
        ThemeDisplay themeDisplay;
        PortletDisplay portletDisplay;
        if (this._reservedParameters != null) {
            return this._reservedParameters;
        }
        this._reservedParameters = new LinkedHashMap<String, String>();
        this._reservedParameters.put("p_p_id", this._portletId);
        if (this._lifecycle.equals("ACTION_PHASE")) {
            this._reservedParameters.put("p_p_lifecycle", "1");
        } else if (this._lifecycle.equals("RENDER_PHASE")) {
            this._reservedParameters.put("p_p_lifecycle", "0");
        } else if (this._lifecycle.equals("RESOURCE_PHASE")) {
            this._reservedParameters.put("p_p_lifecycle", "2");
        }
        if (this._windowState != null) {
            this._reservedParameters.put("p_p_state", this._windowState.toString());
        }
        if (this._portletMode != null) {
            this._reservedParameters.put("p_p_mode", this._portletMode.toString());
        }
        if (this._resourceID != null) {
            this._reservedParameters.put("p_p_resource_id", this._resourceID);
        }
        if (this._lifecycle.equals("RESOURCE_PHASE")) {
            this._reservedParameters.put("p_p_cacheability", this._cacheability);
        }
        if (Validator.isNotNull((String)(portletDisplay = (themeDisplay = (ThemeDisplay)this._request.getAttribute("THEME_DISPLAY")).getPortletDisplay()).getColumnId())) {
            this._reservedParameters.put("p_p_col_id", portletDisplay.getColumnId());
        }
        if (portletDisplay.getColumnPos() > 0) {
            this._reservedParameters.put("p_p_col_pos", String.valueOf(portletDisplay.getColumnPos()));
        }
        if (portletDisplay.getColumnCount() > 0) {
            this._reservedParameters.put("p_p_col_count", String.valueOf(portletDisplay.getColumnCount()));
        }
        this._reservedParameters = Collections.unmodifiableMap(this._reservedParameters);
        return this._reservedParameters;
    }

    public String getResourceID() {
        return this._resourceID;
    }

    public WindowState getWindowState() {
        return this._windowState;
    }

    public boolean isAnchor() {
        return this._anchor;
    }

    public boolean isCopyCurrentPublicRenderParameters() {
        return this._copyCurrentPublicRenderParameters;
    }

    public boolean isCopyCurrentRenderParameters() {
        return this._copyCurrentRenderParameters;
    }

    public boolean isEncrypt() {
        return this._encrypt;
    }

    public boolean isEscapeXml() {
        return this._escapeXml;
    }

    public boolean isParameterIncludedInPath(String name) {
        return this._parametersIncludedInPath.contains(name);
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void removePublicRenderParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        PublicRenderParameter publicRenderParameter = this._portlet.getPublicRenderParameter(name);
        if (publicRenderParameter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Public parameter " + name + "does not exist"));
            }
            return;
        }
        QName qName = publicRenderParameter.getQName();
        this._removePublicRenderParameters.put(PortletQNameUtil.getRemovePublicRenderParameterName((QName)qName), new String[]{"1"});
    }

    public void setAnchor(boolean anchor) {
        this._anchor = anchor;
        this.clearCache();
    }

    public void setCacheability(String cacheability) {
        ResourceRequest resourceRequest;
        String parentCacheability;
        if (cacheability == null) {
            throw new IllegalArgumentException("Cacheability is null");
        }
        if (!(cacheability.equals("cacheLevelFull") || cacheability.equals("cacheLevelPortlet") || cacheability.equals("cacheLevelPage"))) {
            throw new IllegalArgumentException("Cacheability " + cacheability + " is not " + "cacheLevelFull" + ", " + "cacheLevelPortlet" + ", or " + "cacheLevelPage");
        }
        if (this._portletRequest instanceof ResourceRequest && ((parentCacheability = (resourceRequest = (ResourceRequest)this._portletRequest).getCacheability()).equals("cacheLevelFull") ? !cacheability.equals("cacheLevelFull") : parentCacheability.equals("cacheLevelPortlet") && !cacheability.equals("cacheLevelFull") && !cacheability.equals("cacheLevelPortlet"))) {
            throw new IllegalStateException("Unable to set a weaker cacheability " + cacheability);
        }
        this._cacheability = cacheability;
        this.clearCache();
    }

    public void setCopyCurrentPublicRenderParameters(boolean copyCurrentPublicRenderParameters) {
        this._copyCurrentPublicRenderParameters = copyCurrentPublicRenderParameters;
    }

    public void setCopyCurrentRenderParameters(boolean copyCurrentRenderParameters) {
        this._copyCurrentRenderParameters = copyCurrentRenderParameters;
    }

    public void setDoAsGroupId(long doAsGroupId) {
        this._doAsGroupId = doAsGroupId;
        this.clearCache();
    }

    public void setDoAsUserId(long doAsUserId) {
        this._doAsUserId = doAsUserId;
        this.clearCache();
    }

    public void setDoAsUserLanguageId(String doAsUserLanguageId) {
        this._doAsUserLanguageId = doAsUserLanguageId;
        this.clearCache();
    }

    public void setEncrypt(boolean encrypt) {
        this._encrypt = encrypt;
        this.clearCache();
    }

    public void setEscapeXml(boolean escapeXml) {
        this._escapeXml = escapeXml;
        this.clearCache();
    }

    public void setLifecycle(String lifecycle) {
        this._lifecycle = lifecycle;
        this.clearCache();
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, value, PropsValues.PORTLET_URL_APPEND_PARAMETERS);
    }

    public void setParameter(String name, String value, boolean append) {
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        this.setParameter(name, new String[]{value}, append);
    }

    public void setParameter(String name, String[] values) {
        this.setParameter(name, values, PropsValues.PORTLET_URL_APPEND_PARAMETERS);
    }

    public void setParameter(String name, String[] values, boolean append) {
        if (name == null || values == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (append && this._params.containsKey(name)) {
            Object[] oldValues = this._params.get(name);
            String[] newValues = (String[])ArrayUtil.append((Object[])oldValues, (Object[])values);
            this._params.put(name, newValues);
        } else {
            this._params.put(name, values);
        }
        this.clearCache();
    }

    public void setParameters(Map<String, String[]> params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<String, String[]> newParams = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            try {
                String key = entry.getKey();
                String[] value = entry.getValue();
                if (key == null) {
                    throw new IllegalArgumentException();
                }
                if (value == null) {
                    throw new IllegalArgumentException();
                }
                newParams.put(key, value);
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException(cce);
            }
        }
        this._params = newParams;
        this.clearCache();
    }

    public void setPlid(long plid) {
        this._plid = plid;
        this.clearCache();
    }

    public void setPortletId(String portletId) {
        this._portletId = portletId;
        this.clearCache();
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this._portletRequest != null && !this.getPortlet().hasPortletMode(this._portletRequest.getResponseContentType(), portletMode)) {
            throw new PortletModeException(portletMode.toString(), portletMode);
        }
        this._portletMode = portletMode;
        this.clearCache();
    }

    public void setPortletMode(String portletMode) throws PortletModeException {
        this.setPortletMode(PortletModeFactory.getPortletMode((String)portletMode));
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
    }

    public void setRefererPlid(long refererPlid) {
        this._refererPlid = refererPlid;
        this.clearCache();
    }

    public void setResourceID(String resourceID) {
        this._resourceID = resourceID;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
        this.clearCache();
    }

    public void setWindowState(String windowState) throws WindowStateException {
        this.setWindowState(WindowStateFactory.getWindowState((String)windowState));
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this._portletRequest != null && !this._portletRequest.isWindowStateAllowed(windowState)) {
            throw new WindowStateException(windowState.toString(), windowState);
        }
        if (LiferayWindowState.isWindowStatePreserved((WindowState)this.getWindowState(), (WindowState)windowState)) {
            this._windowState = windowState;
        }
        this.clearCache();
    }

    public String toString() {
        if (this._toString != null) {
            return this._toString;
        }
        this._toString = this._wsrp ? this.generateWSRPToString() : this.generateToString();
        return this._toString;
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, this._escapeXml);
    }

    public void write(Writer writer, boolean escapeXml) throws IOException {
        String toString = this.toString();
        if (escapeXml && !this._escapeXml) {
            toString = HtmlUtil.escape((String)toString);
        }
        writer.write(toString);
    }

    protected void addPortalAuthToken(StringBundler sb, Key key) {
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED || !this._lifecycle.equals("ACTION_PHASE")) {
            return;
        }
        sb.append("p_auth");
        sb.append("=");
        sb.append(this.processValue(key, AuthTokenUtil.getToken((HttpServletRequest)this._request)));
        sb.append("&");
    }

    protected void addPortletAuthToken(StringBundler sb, Key key) {
        if (!PropsValues.PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
            return;
        }
        HttpServletRequest request = PortalUtil.getOriginalServletRequest((HttpServletRequest)this._request);
        String ppauth = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_auth");
        String actualPortletAuthenticationToken = AuthTokenUtil.getToken((HttpServletRequest)this._request, (long)this._plid, (String)this._portletId);
        if (Validator.isNotNull((String)ppauth) && ppauth.equals(actualPortletAuthenticationToken)) {
            sb.append("p_p_auth");
            sb.append("=");
            sb.append(this.processValue(key, ppauth));
            sb.append("&");
            return;
        }
        Portlet portlet = (Portlet)this._request.getAttribute("RENDER_PORTLET");
        if (portlet == null) {
            return;
        }
        if (portlet.getPortletId().equals(this._portletId) || !this._portlet.isAddDefaultResource() || portlet.getPortletId().equals("160")) {
            return;
        }
        sb.append("p_p_auth");
        sb.append("=");
        sb.append(this.processValue(key, actualPortletAuthenticationToken));
        sb.append("&");
    }

    protected void clearCache() {
        this._reservedParameters = null;
        this._toString = null;
    }

    protected String generateToString() {
        String result;
        String name;
        String lastString;
        long refererPlid;
        long doAsGroupId;
        String doAsUserLanguageId;
        Company company;
        StringBundler sb = new StringBundler(32);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("THEME_DISPLAY");
        Portlet portlet = this.getPortlet();
        String portalURL = null;
        portalURL = themeDisplay.isFacebook() ? "http://apps.facebook.com/" + themeDisplay.getFacebookCanvasPageURL() : PortalUtil.getPortalURL((HttpServletRequest)this._request, (boolean)this._secure);
        try {
            Layout layout;
            if (this._layoutFriendlyURL == null && (layout = this.getLayout()) != null) {
                this._layoutFriendlyURL = GetterUtil.getString((String)PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay));
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        Key key = null;
        try {
            if (this._encrypt) {
                company = PortalUtil.getCompany((HttpServletRequest)this._request);
                key = company.getKeyObj();
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        if (Validator.isNull((String)this._layoutFriendlyURL)) {
            sb.append(portalURL);
            sb.append(themeDisplay.getPathMain());
            sb.append("/portal/layout?");
            this.addPortalAuthToken(sb, key);
            sb.append("p_l_id");
            sb.append("=");
            sb.append(this.processValue(key, this._plid));
            sb.append("&");
        } else {
            if (themeDisplay.isFacebook()) {
                sb.append(portalURL);
            } else {
                if (!this._layoutFriendlyURL.startsWith("http://") && !this._layoutFriendlyURL.startsWith("https://")) {
                    sb.append(portalURL);
                }
                sb.append(this._layoutFriendlyURL);
            }
            String friendlyURLPath = this.getPortletFriendlyURLPath();
            if (Validator.isNotNull((String)friendlyURLPath)) {
                if (themeDisplay.isFacebook()) {
                    int pos = friendlyURLPath.indexOf(47, 1);
                    if (pos != -1) {
                        sb.append(friendlyURLPath.substring(pos));
                    } else {
                        sb.append(friendlyURLPath);
                    }
                } else {
                    sb.append("/-");
                    sb.append(friendlyURLPath);
                }
            }
            sb.append("?");
            this.addPortalAuthToken(sb, key);
        }
        this.addPortletAuthToken(sb, key);
        for (Map.Entry<String, String> entry : this.getReservedParameterMap().entrySet()) {
            String name2 = entry.getKey();
            if (this.isParameterIncludedInPath(name2)) continue;
            sb.append(name2);
            sb.append("=");
            sb.append(this.processValue(key, entry.getValue()));
            sb.append("&");
        }
        if (this._doAsUserId > 0L) {
            try {
                company = PortalUtil.getCompany((HttpServletRequest)this._request);
                sb.append("doAsUserId");
                sb.append("=");
                sb.append(this.processValue(company.getKeyObj(), this._doAsUserId));
                sb.append("&");
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        } else {
            String doAsUserId = themeDisplay.getDoAsUserId();
            if (Validator.isNotNull((String)doAsUserId)) {
                sb.append("doAsUserId");
                sb.append("=");
                sb.append(this.processValue(key, doAsUserId));
                sb.append("&");
            }
        }
        if (Validator.isNull((String)(doAsUserLanguageId = this._doAsUserLanguageId))) {
            doAsUserLanguageId = themeDisplay.getDoAsUserLanguageId();
        }
        if (Validator.isNotNull((String)doAsUserLanguageId)) {
            sb.append("doAsUserLanguageId");
            sb.append("=");
            sb.append(this.processValue(key, doAsUserLanguageId));
            sb.append("&");
        }
        if ((doAsGroupId = this._doAsGroupId) <= 0L) {
            doAsGroupId = themeDisplay.getDoAsGroupId();
        }
        if (doAsGroupId > 0L) {
            sb.append("doAsGroupId");
            sb.append("=");
            sb.append(this.processValue(key, doAsGroupId));
            sb.append("&");
        }
        if ((refererPlid = this._refererPlid) <= 0L) {
            refererPlid = themeDisplay.getRefererPlid();
        }
        if (refererPlid > 0L) {
            sb.append("refererPlid");
            sb.append("=");
            sb.append(this.processValue(key, refererPlid));
            sb.append("&");
        }
        Iterator<Map.Entry<String, String[]>> itr = this._removePublicRenderParameters.entrySet().iterator();
        while (itr.hasNext()) {
            lastString = sb.stringAt(sb.index() - 1);
            if (lastString.charAt(lastString.length() - 1) != '&') {
                sb.append("&");
            }
            Map.Entry<String, String[]> entry = itr.next();
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(this.processValue(key, entry.getValue()[0]));
            sb.append("&");
        }
        if (this._copyCurrentRenderParameters) {
            Enumeration enu = this._request.getParameterNames();
            while (enu.hasMoreElements()) {
                name = (String)enu.nextElement();
                Object[] oldValues = this._request.getParameterValues(name);
                Object[] newValues = this._params.get(name);
                if (newValues == null) {
                    this._params.put(name, (String[])oldValues);
                    continue;
                }
                if (this.isBlankValue((String[])newValues)) {
                    this._params.remove(name);
                    continue;
                }
                newValues = (String[])ArrayUtil.append((Object[])newValues, (Object[])oldValues);
                this._params.put(name, (String[])newValues);
            }
        }
        itr = this._params.entrySet().iterator();
        while (itr.hasNext()) {
            PublicRenderParameter publicRenderParameter;
            Map.Entry<String, String[]> entry = itr.next();
            name = entry.getKey();
            Object[] values = entry.getValue();
            String identifier = null;
            if (portlet != null && (publicRenderParameter = portlet.getPublicRenderParameter(name)) != null) {
                Object[] oldValues;
                QName qName = publicRenderParameter.getQName();
                if (this._copyCurrentPublicRenderParameters && (oldValues = this._request.getParameterValues(name)) != null) {
                    values = values == null ? oldValues : (String[])ArrayUtil.append((Object[])values, (Object[])oldValues);
                }
                identifier = name;
                name = PortletQNameUtil.getPublicRenderParameterName((QName)qName);
                PortletQNameUtil.setPublicRenderParameterIdentifier((String)name, (String)identifier);
            }
            int i = 0;
            while (i < values.length) {
                String parameterName = name;
                if (identifier != null) {
                    parameterName = identifier;
                }
                if (!this.isParameterIncludedInPath(parameterName)) {
                    if (!PortalUtil.isReservedParameter((String)name) && !name.startsWith("p_r_p_")) {
                        sb.append(this.getNamespace());
                    }
                    sb.append(name);
                    sb.append("=");
                    sb.append(this.processValue(key, (String)values[i]));
                    if (i + 1 < values.length || itr.hasNext()) {
                        sb.append("&");
                    }
                }
                ++i;
            }
        }
        if (this._encrypt) {
            sb.append("&shuo=1");
        }
        if (PropsValues.PORTLET_URL_ANCHOR_ENABLE && this._anchor && this._windowState != null && !this._windowState.equals((Object)WindowState.MAXIMIZED) && !this._windowState.equals((Object)LiferayWindowState.EXCLUSIVE) && !this._windowState.equals((Object)LiferayWindowState.POP_UP)) {
            lastString = sb.stringAt(sb.index() - 1);
            if (lastString.charAt(lastString.length() - 1) != '&') {
                sb.append("&");
            }
            sb.append("#p_");
            sb.append(this._portletId);
        }
        if ((result = sb.toString()).endsWith("&") || result.endsWith("?")) {
            result = result.substring(0, result.length() - 1);
        }
        if (themeDisplay.isFacebook()) {
            int pos = result.indexOf(63);
            if (pos == -1) {
                if (!result.endsWith("/")) {
                    result = String.valueOf(result) + "/";
                }
            } else {
                String path = result.substring(0, pos);
                if (!result.endsWith("/")) {
                    result = String.valueOf(path) + "/" + result.substring(pos);
                }
            }
        } else if (!CookieKeys.hasSessionId(this._request)) {
            result = PortalUtil.getURLWithSessionId((String)result, (String)this._request.getSession().getId());
        }
        if (this._escapeXml) {
            result = HtmlUtil.escape((String)result);
        }
        return result;
    }

    protected String generateWSRPToString() {
        StringBundler sb = new StringBundler("wsrp_rewrite?");
        Portlet portlet = this.getPortlet();
        Key key = null;
        try {
            if (this._encrypt) {
                Company company = PortalUtil.getCompany((HttpServletRequest)this._request);
                key = company.getKeyObj();
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        sb.append("wsrp-urlType");
        sb.append("=");
        if (this._lifecycle.equals("ACTION_PHASE")) {
            sb.append(this.processValue(key, "blockingAction"));
        } else if (this._lifecycle.equals("RENDER_PHASE")) {
            sb.append(this.processValue(key, "render"));
        } else if (this._lifecycle.equals("RESOURCE_PHASE")) {
            sb.append(this.processValue(key, "resource"));
        }
        sb.append("&");
        if (this._windowState != null) {
            sb.append("wsrp-windowState");
            sb.append("=");
            sb.append(this.processValue(key, "wsrp:" + this._windowState.toString()));
            sb.append("&");
        }
        if (this._portletMode != null) {
            sb.append("wsrp-mode");
            sb.append("=");
            sb.append(this.processValue(key, "wsrp:" + this._portletMode.toString()));
            sb.append("&");
        }
        if (this._resourceID != null) {
            sb.append("wsrp-resourceID");
            sb.append("=");
            sb.append(this.processValue(key, this._resourceID));
            sb.append("&");
        }
        if (this._lifecycle.equals("RESOURCE_PHASE")) {
            sb.append("wsrp-resourceCacheability");
            sb.append("=");
            sb.append(this.processValue(key, this._cacheability));
            sb.append("&");
        }
        if (PropsValues.PORTLET_URL_ANCHOR_ENABLE && this._anchor && this._windowState != null && !this._windowState.equals((Object)WindowState.MAXIMIZED) && !this._windowState.equals((Object)LiferayWindowState.EXCLUSIVE) && !this._windowState.equals((Object)LiferayWindowState.POP_UP)) {
            sb.append("wsrp-fragmentID");
            sb.append("=");
            sb.append("#p_");
            sb.append(this._portletId);
            sb.append("&");
        }
        if (this._copyCurrentRenderParameters) {
            Enumeration enu = this._request.getParameterNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                Object[] oldValues = this._request.getParameterValues(name);
                Object[] newValues = this._params.get(name);
                if (newValues == null) {
                    this._params.put(name, (String[])oldValues);
                    continue;
                }
                if (this.isBlankValue((String[])newValues)) {
                    this._params.remove(name);
                    continue;
                }
                newValues = (String[])ArrayUtil.append((Object[])newValues, (Object[])oldValues);
                this._params.put(name, (String[])newValues);
            }
        }
        StringBundler parameterSb = new StringBundler();
        Iterator<Map.Entry<String, String[]>> itr = this._params.entrySet().iterator();
        while (itr.hasNext()) {
            PublicRenderParameter publicRenderParameter;
            Map.Entry<String, String[]> entry = itr.next();
            String name = entry.getKey();
            Object[] values = entry.getValue();
            String identifier = null;
            if (portlet != null && (publicRenderParameter = portlet.getPublicRenderParameter(name)) != null) {
                Object[] oldValues;
                QName qName = publicRenderParameter.getQName();
                if (this._copyCurrentPublicRenderParameters && (oldValues = this._request.getParameterValues(name)) != null) {
                    values = values == null ? oldValues : (String[])ArrayUtil.append((Object[])values, (Object[])oldValues);
                }
                identifier = name;
                name = PortletQNameUtil.getPublicRenderParameterName((QName)qName);
                PortletQNameUtil.setPublicRenderParameterIdentifier((String)name, (String)identifier);
            }
            int i = 0;
            while (i < values.length) {
                String parameterName = name;
                if (identifier != null) {
                    parameterName = identifier;
                }
                if (!this.isParameterIncludedInPath(parameterName)) {
                    if (!PortalUtil.isReservedParameter((String)name) && !name.startsWith("p_r_p_")) {
                        parameterSb.append(this.getNamespace());
                    }
                    parameterSb.append(name);
                    parameterSb.append("=");
                    parameterSb.append(this.processValue(key, (String)values[i]));
                    if (i + 1 < values.length || itr.hasNext()) {
                        parameterSb.append("&");
                    }
                }
                ++i;
            }
        }
        if (this._encrypt) {
            parameterSb.append("&shuo=1");
        }
        sb.append("wsrp-navigationalState");
        sb.append("=");
        sb.append(HttpUtil.encodeURL((String)parameterSb.toString()));
        sb.append("/wsrp_rewrite");
        return sb.toString();
    }

    protected boolean isBlankValue(String[] value) {
        return value != null && value.length == 1 && value[0].equals("");
    }

    protected String processValue(Key key, int value) {
        return this.processValue(key, String.valueOf(value));
    }

    protected String processValue(Key key, long value) {
        return this.processValue(key, String.valueOf(value));
    }

    protected String processValue(Key key, String value) {
        if (key == null) {
            return HttpUtil.encodeURL((String)value);
        }
        try {
            return HttpUtil.encodeURL((String)Encryptor.encrypt((Key)key, (String)value));
        }
        catch (EncryptorException encryptorException) {
            return value;
        }
    }
}

