/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.Status;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.Lock;
import com.liferay.portal.webdav.methods.Method;
import com.liferay.util.servlet.ServletResponseUtil;
import com.liferay.util.xml.XMLFormatter;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class LockMethodImpl
implements Method {
    private static Log _log = LogFactoryUtil.getLog(LockMethodImpl.class);

    public int process(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            return this.doProcess(webDavRequest);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    protected int doProcess(WebDAVRequest webDavRequest) throws Exception {
        Status status;
        block18: {
            WebDAVStorage storage = webDavRequest.getWebDAVStorage();
            if (!storage.isSupportsClassTwo()) {
                return 405;
            }
            HttpServletRequest request = webDavRequest.getHttpServletRequest();
            HttpServletResponse response = webDavRequest.getHttpServletResponse();
            Lock lock = null;
            status = null;
            String lockUuid = webDavRequest.getLockUuid();
            long timeout = WebDAVUtil.getTimeout((HttpServletRequest)request);
            if (Validator.isNull((String)lockUuid)) {
                String owner = null;
                String xml = new String(FileUtil.getBytes((InputStream)request.getInputStream()));
                if (Validator.isNotNull((String)xml)) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Request XML\n" + XMLFormatter.toString((String)xml)));
                    }
                    SAXReader reader = new SAXReader();
                    Document doc = reader.read((Reader)new UnsyncStringReader(xml));
                    Element root = doc.getRootElement();
                    boolean exclusive = false;
                    List lockscopeEls = root.element("lockscope").elements();
                    for (Element scopeEl : lockscopeEls) {
                        String name = GetterUtil.getString((String)scopeEl.getName());
                        if (!name.equals("exclusive")) continue;
                        exclusive = true;
                    }
                    if (!exclusive) {
                        return 400;
                    }
                    Element ownerEl = root.element("owner");
                    owner = ownerEl.getTextTrim();
                    if (Validator.isNull((String)owner)) {
                        List childEls = ownerEl.elements("href");
                        for (Element childEl : childEls) {
                            owner = "<D:href>" + childEl.getTextTrim() + "</D:href>";
                        }
                    }
                } else {
                    _log.error((Object)"Empty request XML");
                    return 412;
                }
                status = storage.lockResource(webDavRequest, owner, timeout);
                lock = (Lock)status.getObject();
            } else {
                try {
                    lock = storage.refreshResourceLock(webDavRequest, lockUuid, timeout);
                    status = new Status(200);
                }
                catch (WebDAVException wde) {
                    if (wde.getCause() instanceof NoSuchLockException) {
                        return 412;
                    }
                    throw wde;
                }
            }
            if (lock == null) {
                return status.getCode();
            }
            long depth = WebDAVUtil.getDepth((HttpServletRequest)request);
            String xml = this.getResponseXML(lock, depth);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response XML\n" + xml));
            }
            String lockToken = "<opaquelocktoken:" + lock.getUuid() + ">";
            response.setContentType("text/xml; charset=UTF-8");
            response.setHeader("Lock-Token", lockToken);
            response.setStatus(status.getCode());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Returning lock token " + lockToken));
            }
            try {
                ServletResponseUtil.write((HttpServletResponse)response, (String)xml);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block18;
                _log.warn((Throwable)e);
            }
        }
        return status.getCode();
    }

    protected String getResponseXML(Lock lock, long depth) throws Exception {
        StringBundler sb = new StringBundler(20);
        long timeoutSecs = lock.getExpirationTime() / 1000L;
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        sb.append("<D:prop xmlns:D=\"DAV:\">");
        sb.append("<D:lockdiscovery>");
        sb.append("<D:activelock>");
        sb.append("<D:locktype><D:write/></D:locktype>");
        sb.append("<D:lockscope><D:exclusive/></D:lockscope>");
        if (depth < 0L) {
            sb.append("<D:depth>Infinity</D:depth>");
        }
        sb.append("<D:owner>");
        sb.append(lock.getOwner());
        sb.append("</D:owner>");
        sb.append("<D:timeout>Second-");
        sb.append(timeoutSecs);
        sb.append("</D:timeout>");
        sb.append("<D:locktoken><D:href>");
        sb.append("opaquelocktoken:");
        sb.append(lock.getUuid());
        sb.append("</D:href></D:locktoken>");
        sb.append("</D:activelock>");
        sb.append("</D:lockdiscovery>");
        sb.append("</D:prop>");
        return XMLFormatter.toString((String)sb.toString());
    }
}

